/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;
import org.openide.util.enum.EmptyEnumeration;

public class ExtensionList
implements Cloneable,
Serializable {
    private TreeSet list;
    private TreeSet mimeTypes;
    static final long serialVersionUID = 8868581349510386291L;

    public synchronized Object clone() {
        try {
            ExtensionList extensionList = (ExtensionList)super.clone();
            if (this.list != null) {
                extensionList.list = ExtensionList.createExtensionSet();
                extensionList.list.addAll(this.list);
            }
            extensionList.mimeTypes = this.mimeTypes == null ? null : (TreeSet)this.mimeTypes.clone();
            return extensionList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized void addExtension(String string) {
        if (this.list == null) {
            this.list = ExtensionList.createExtensionSet();
        }
        this.list.add(string);
    }

    public void removeExtension(String string) {
        if (this.list != null) {
            this.list.remove(string);
        }
    }

    public synchronized void addMimeType(String string) {
        if (this.mimeTypes == null) {
            this.mimeTypes = new TreeSet();
        }
        this.mimeTypes.add(string);
    }

    public void removeMimeType(String string) {
        if (this.mimeTypes != null) {
            this.mimeTypes.remove(string);
        }
    }

    public boolean isRegistered(String string) {
        if (this.list == null) {
            return false;
        }
        try {
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            return this.list.contains(string2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
    }

    public boolean isRegistered(FileObject fileObject) {
        if (this.list != null && this.list.contains(fileObject.getExt())) {
            return true;
        }
        return this.mimeTypes != null && this.mimeTypes.contains(fileObject.getMIMEType());
    }

    public Enumeration extensions() {
        return ExtensionList.en(this.list);
    }

    public Enumeration mimeTypes() {
        return ExtensionList.en(this.mimeTypes);
    }

    private static Enumeration en(Collection collection) {
        if (collection == null) {
            return EmptyEnumeration.EMPTY;
        }
        Iterator iterator = collection.iterator();
        return Collections.enumeration(collection);
    }

    private static TreeSet createExtensionSet() {
        if (Utilities.isWindows() || Utilities.getOperatingSystem() == 8192) {
            return new TreeSet(String.CASE_INSENSITIVE_ORDER);
        }
        return new TreeSet();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Set set = getField.get("list", null);
        if (set instanceof Map) {
            set = ((Map)((Object)set)).keySet();
        }
        if (set != null) {
            this.list = ExtensionList.createExtensionSet();
            this.list.addAll(set);
        }
        this.mimeTypes = (TreeSet)getField.get("mimeTypes", null);
    }
}

