/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.LoaderTransfer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class DataNode
extends AbstractNode {
    static final long serialVersionUID = -7882925922830244768L;
    private DataObject obj;
    private PropL propL;
    private static boolean showFileExtensions = false;
    private static RequestProcessor.Task refreshNamesIconsTask = null;
    private static Set refreshNameNodes = null;
    private static Set refreshIconNodes = null;
    private static boolean refreshNamesIconsRunning = false;
    private static final Object refreshNameIconLock = "DataNode.refreshNameIconLock";
    static /* synthetic */ Class class$org$openide$loaders$DataNode;
    static /* synthetic */ Class class$org$openide$actions$InstantiateAction;
    static /* synthetic */ Class class$java$lang$String;

    public DataNode(DataObject dataObject, Children children) {
        super(children);
        this.obj = dataObject;
        this.propL = new PropL();
        dataObject.addPropertyChangeListener(WeakListener.propertyChange(this.propL, dataObject));
        super.setName(dataObject.getName());
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        String string;
        FileObject fileObject = this.obj.getPrimaryFile();
        String string2 = null;
        string2 = showFileExtensions || this.obj instanceof DataFolder || this.obj instanceof DefaultDataObject ? ((string = fileObject.getExt()) == null || string.equals("") ? fileObject.getName() : fileObject.getName() + '.' + string) : fileObject.getName();
        if (this.displayFormat != null) {
            this.setDisplayName(this.displayFormat.format(new Object[]{string2}));
        } else {
            this.setDisplayName(string2);
        }
    }

    public DataObject getDataObject() {
        return this.obj;
    }

    public void setName(String string, boolean bl) {
        try {
            if (bl) {
                this.obj.rename(string);
            }
            super.setName(string);
            if (bl) {
                this.updateDisplayName();
            }
        }
        catch (IOException iOException) {
            String string2 = null;
            string2 = iOException.getLocalizedMessage() == null || iOException.getLocalizedMessage().equals(iOException.getMessage()) ? NbBundle.getMessage(class$org$openide$loaders$DataNode == null ? (class$org$openide$loaders$DataNode = DataNode.class$("org.openide.loaders.DataNode")) : class$org$openide$loaders$DataNode, "MSG_renameError", this.getName(), string) : iOException.getLocalizedMessage();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            TopManager.getDefault().getErrorManager().copyAnnotation(illegalArgumentException, iOException);
            TopManager.getDefault().getErrorManager().annotate(illegalArgumentException, 256, null, string2, null, null);
            throw illegalArgumentException;
        }
    }

    public void setName(String string) {
        this.setName(string, true);
    }

    public String getDisplayName() {
        String string = super.getDisplayName();
        try {
            string = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateName(string, this.obj.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return string;
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        try {
            image = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, this.obj.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = super.getOpenedIcon(n);
        try {
            image = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, this.obj.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return image;
    }

    public HelpCtx getHelpCtx() {
        return this.obj.getHelpCtx();
    }

    public boolean canRename() {
        return this.obj.isRenameAllowed();
    }

    public boolean canDestroy() {
        return this.obj.isDeleteAllowed();
    }

    public void destroy() throws IOException {
        if (this.obj.isDeleteAllowed()) {
            this.obj.delete();
        }
        super.destroy();
    }

    public boolean canCopy() {
        return this.obj.isCopyAllowed();
    }

    public boolean canCut() {
        return this.obj.isMoveAllowed();
    }

    protected SystemAction[] createActions() {
        return null;
    }

    public SystemAction[] getActions() {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
        }
        if (this.systemActions != null) {
            return this.systemActions;
        }
        return this.obj.getLoader().getActions();
    }

    public SystemAction getDefaultAction() {
        if (this.obj.isTemplate()) {
            return SystemAction.get(class$org$openide$actions$InstantiateAction == null ? (class$org$openide$actions$InstantiateAction = DataNode.class$("org.openide.actions.InstantiateAction")) : class$org$openide$actions$InstantiateAction);
        }
        SystemAction systemAction = super.getDefaultAction();
        if (systemAction != null) {
            return systemAction;
        }
        SystemAction[] systemActionArray = this.getActions();
        if (systemActionArray != null && systemActionArray.length > 0) {
            return systemActionArray[0];
        }
        return null;
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = this.obj.getCookie(clazz);
        if (cookie != null) {
            return cookie;
        }
        return super.getCookie(clazz);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        Node.Property property = DataNode.createNameProperty(this.obj);
        set.put(property);
        if (!this.getDataObject().getPrimaryFile().isReadOnly()) {
            try {
                property = new PropertySupport.Reflection((Object)this.obj, Boolean.TYPE, "isTemplate", "setTemplate");
                property.setName("template");
                property.setDisplayName(DataObject.getString("PROP_template"));
                property.setShortDescription(DataObject.getString("HINT_template"));
                set.put(property);
            }
            catch (Exception exception) {
                throw new InternalError();
            }
        }
        return sheet;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create(super.clipboardCopy());
        exTransferable.put(LoaderTransfer.transferable(this.getDataObject(), 1));
        return exTransferable;
    }

    public Transferable clipboardCut() throws IOException {
        ExTransferable exTransferable = ExTransferable.create(super.clipboardCut());
        exTransferable.put(LoaderTransfer.transferable(this.getDataObject(), 4));
        return exTransferable;
    }

    static Node.Property createNameProperty(final DataObject dataObject) {
        PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite("name", class$java$lang$String == null ? (class$java$lang$String = DataNode.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_name"), DataObject.getString("HINT_name")){

            public Object getValue() {
                return dataObject.getName();
            }

            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                try {
                    dataObject.rename((String)object);
                }
                catch (IOException iOException) {
                    String string = null;
                    string = iOException.getLocalizedMessage() == null || iOException.getLocalizedMessage().equals(iOException.getMessage()) ? NbBundle.getMessage(class$org$openide$loaders$DataNode == null ? (class$org$openide$loaders$DataNode = DataNode.class$("org.openide.loaders.DataNode")) : class$org$openide$loaders$DataNode, "MSG_renameError", dataObject.getName(), object) : iOException.getLocalizedMessage();
                    TopManager.getDefault().getErrorManager().annotate(iOException, 256, null, string, null, null);
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                return dataObject.isRenameAllowed();
            }
        };
        return readWrite;
    }

    void fireChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if ("children".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
            this.propL.updateStatusListener();
            this.setName(this.obj.getName(), false);
            return;
        }
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            super.setName(this.obj.getName());
            this.updateDisplayName();
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("cookie")) {
            this.fireCookieChange();
        }
        if ("valid".equals(propertyChangeEvent.getPropertyName()) && (object = propertyChangeEvent.getNewValue()) instanceof Boolean && !((Boolean)object).booleanValue()) {
            this.fireNodeDestroyed();
        }
    }

    public Node.Handle getHandle() {
        return new ObjectHandle(this.obj, this.obj.isValid() ? this != this.obj.getNodeDelegate() : true);
    }

    final void fireChangeAccess(boolean bl, boolean bl2) {
        if (bl2) {
            this.fireDisplayNameChange(null, null);
        }
        if (bl) {
            this.fireIconChange();
        }
    }

    public static boolean getShowFileExtensions() {
        return showFileExtensions;
    }

    public static void setShowFileExtensions(boolean bl) {
        boolean bl2 = showFileExtensions != bl;
        showFileExtensions = bl;
        if (bl2) {
            RequestProcessor.postRequest(new Runnable(){

                public void run() {
                    Iterator iterator = DataObjectPool.POOL.getActiveDataObjects();
                    while (iterator.hasNext()) {
                        DataObject dataObject = ((DataObjectPool.Item)iterator.next()).getDataObjectOrNull();
                        if (dataObject == null || !(dataObject.getNodeDelegate() instanceof DataNode)) continue;
                        ((DataNode)dataObject.getNodeDelegate()).updateDisplayName();
                    }
                }
            }, 300, 1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ObjectHandle
    implements Node.Handle {
        private FileObject obj;
        private boolean clone;
        static final long serialVersionUID = 6616060729084681518L;

        public ObjectHandle(DataObject dataObject, boolean bl) {
            this.obj = dataObject.getPrimaryFile();
            this.clone = bl;
        }

        public Node getNode() throws DataObjectNotFoundException {
            Node node = DataObject.find(this.obj).getNodeDelegate();
            return this.clone ? node.cloneNode() : node;
        }
    }

    private class PropL
    implements PropertyChangeListener,
    FileStatusListener,
    Runnable {
        private FileStatusListener weakL;
        private FileSystem previous;

        public PropL() {
            this.updateStatusListener();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataNode.this.fireChange(propertyChangeEvent);
        }

        private void updateStatusListener() {
            if (this.previous != null) {
                this.previous.removeFileStatusListener(this.weakL);
            }
            try {
                this.previous = DataNode.this.obj.getPrimaryFile().getFileSystem();
                if (this.weakL == null) {
                    this.weakL = WeakListener.fileStatus(this, null);
                }
                this.previous.addFileStatusListener(this.weakL);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.previous = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            Object object;
            boolean bl = false;
            Iterator iterator = DataNode.this.obj.files().iterator();
            while (iterator.hasNext()) {
                object = (FileObject)iterator.next();
                if (!fileStatusEvent.hasChanged((FileObject)object)) continue;
                bl = true;
                break;
            }
            if (bl) {
                object = refreshNameIconLock;
                synchronized (object) {
                    boolean bl2 = false;
                    if (fileStatusEvent.isNameChange()) {
                        if (refreshNameNodes == null) {
                            refreshNameNodes = new HashSet();
                        }
                        bl2 |= refreshNameNodes.add(DataNode.this);
                    }
                    if (fileStatusEvent.isIconChange()) {
                        if (refreshIconNodes == null) {
                            refreshIconNodes = new HashSet();
                        }
                        bl2 |= refreshIconNodes.add(DataNode.this);
                    }
                    if (bl2 && !refreshNamesIconsRunning) {
                        refreshNamesIconsRunning = true;
                        if (refreshNamesIconsTask == null) {
                            refreshNamesIconsTask = RequestProcessor.postRequest(this);
                        } else {
                            refreshNamesIconsTask.schedule(0);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DataNode[] dataNodeArray;
            DataNode[] dataNodeArray2;
            Object object = refreshNameIconLock;
            synchronized (object) {
                if (refreshNameNodes != null) {
                    dataNodeArray2 = refreshNameNodes.toArray(new DataNode[refreshNameNodes.size()]);
                    refreshNameNodes.clear();
                } else {
                    dataNodeArray2 = new DataNode[]{};
                }
                if (refreshIconNodes != null) {
                    dataNodeArray = refreshIconNodes.toArray(new DataNode[refreshIconNodes.size()]);
                    refreshIconNodes.clear();
                } else {
                    dataNodeArray = new DataNode[]{};
                }
                refreshNamesIconsRunning = false;
            }
            int n = 0;
            while (n < dataNodeArray2.length) {
                dataNodeArray2[n].fireChangeAccess(false, true);
                ++n;
            }
            int n2 = 0;
            while (n2 < dataNodeArray.length) {
                dataNodeArray[n2].fireChangeAccess(true, false);
                ++n2;
            }
        }
    }
}

