/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakSet;

final class StreamPool {
    private static Map fo2StreamPool = new WeakHashMap();
    private static Map fs2StreamPool = new WeakHashMap();
    private Set iStreams;
    private Set oStreams;
    static /* synthetic */ Class class$org$openide$filesystems$StreamPool;

    private StreamPool() {
    }

    public static synchronized InputStream createInputStream(AbstractFolder abstractFolder, InputStream inputStream) {
        NotifyInputStream notifyInputStream = new NotifyInputStream(abstractFolder, inputStream);
        StreamPool.get(abstractFolder).iStream().add(notifyInputStream);
        StreamPool.get(abstractFolder.getFileSystem()).iStream().add(notifyInputStream);
        return notifyInputStream;
    }

    public static synchronized OutputStream createOutputStream(AbstractFolder abstractFolder, OutputStream outputStream) {
        NotifyOutputStream notifyOutputStream = new NotifyOutputStream(abstractFolder, outputStream);
        StreamPool.get(abstractFolder).oStream().add(notifyOutputStream);
        StreamPool.get(abstractFolder.getFileSystem()).oStream().add(notifyOutputStream);
        return notifyOutputStream;
    }

    public static synchronized StreamPool find(FileObject fileObject) {
        return (StreamPool)fo2StreamPool.get(fileObject);
    }

    public static synchronized StreamPool find(FileSystem fileSystem) {
        return (StreamPool)fs2StreamPool.get(fileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Exception exception) {
        Class clazz = class$org$openide$filesystems$StreamPool == null ? (class$org$openide$filesystems$StreamPool = StreamPool.class$("org.openide.filesystems.StreamPool")) : class$org$openide$filesystems$StreamPool;
        synchronized (clazz) {
            Exception exception2;
            Closeable closeable;
            Iterator iterator;
            if (this.iStreams != null) {
                iterator = this.iStreams.iterator();
                while (iterator.hasNext()) {
                    closeable = (NotifyInputStream)iterator.next();
                    exception2 = ((NotifyInputStream)closeable).getException();
                    if (exception2 == null) continue;
                    ExternalUtil.annotate((Throwable)exception, exception2);
                }
            }
            if (this.oStreams != null) {
                iterator = this.oStreams.iterator();
                while (iterator.hasNext()) {
                    closeable = (NotifyOutputStream)iterator.next();
                    exception2 = ((NotifyOutputStream)closeable).getException();
                    if (exception2 == null) continue;
                    ExternalUtil.annotate((Throwable)exception, exception2);
                }
            }
        }
    }

    public boolean isInputStreamOpen() {
        return this.iStreams != null && !this.iStreams.isEmpty();
    }

    public boolean isOutputStreamOpen() {
        return this.oStreams != null && !this.oStreams.isEmpty();
    }

    private static StreamPool get(FileObject fileObject) {
        StreamPool streamPool = (StreamPool)fo2StreamPool.get(fileObject);
        if (streamPool == null) {
            streamPool = new StreamPool();
            fo2StreamPool.put(fileObject, streamPool);
        }
        return streamPool;
    }

    private static StreamPool get(FileSystem fileSystem) {
        StreamPool streamPool = (StreamPool)fs2StreamPool.get(fileSystem);
        if (streamPool == null) {
            streamPool = new StreamPool();
            fs2StreamPool.put(fileSystem, streamPool);
        }
        return streamPool;
    }

    private Set iStream() {
        if (this.iStreams == null) {
            this.iStreams = new WeakSet();
        }
        return this.iStreams;
    }

    private Set oStream() {
        if (this.oStreams == null) {
            this.oStreams = new WeakSet();
        }
        return this.oStreams;
    }

    private static void closeOutputStream(AbstractFolder abstractFolder, OutputStream outputStream) {
        StreamPool streamPool = StreamPool.find(abstractFolder);
        StreamPool streamPool2 = StreamPool.find(abstractFolder.getFileSystem());
        Set set = streamPool != null ? streamPool.oStreams : null;
        Set set2 = streamPool2 != null ? streamPool2.oStreams : null;
        StreamPool.removeStreams(set2, set, outputStream);
        StreamPool.removeStreamPools(streamPool2, streamPool, abstractFolder);
        abstractFolder.outputStreamClosed();
    }

    private static void closeInputStream(AbstractFolder abstractFolder, InputStream inputStream) {
        StreamPool streamPool = StreamPool.find(abstractFolder);
        StreamPool streamPool2 = StreamPool.find(abstractFolder.getFileSystem());
        Set set = streamPool != null ? streamPool.iStreams : null;
        Set set2 = streamPool2 != null ? streamPool2.iStreams : null;
        StreamPool.removeStreams(set2, set, inputStream);
        StreamPool.removeStreamPools(streamPool2, streamPool, abstractFolder);
    }

    private static synchronized void removeStreams(Set set, Set set2, Object object) {
        if (set2 != null) {
            set2.remove(object);
        }
        if (set != null) {
            set.remove(object);
        }
    }

    private static synchronized void removeStreamPools(StreamPool streamPool, StreamPool streamPool2, AbstractFolder abstractFolder) {
        boolean bl;
        boolean bl2 = streamPool2 == null || streamPool2.iStreams == null || streamPool2.iStreams.isEmpty();
        boolean bl3 = bl = streamPool2 == null || streamPool2.oStreams == null || streamPool2.oStreams.isEmpty();
        if (bl2 && bl) {
            fo2StreamPool.remove(abstractFolder);
        }
        bl2 = streamPool == null || streamPool.iStreams == null || streamPool.iStreams.isEmpty();
        boolean bl4 = bl = streamPool == null || streamPool.oStreams == null || streamPool.oStreams.isEmpty();
        if (bl2 && bl) {
            fs2StreamPool.remove(abstractFolder.getFileSystem());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class NotifyInputStream
    extends FilterInputStream {
        private Exception ex;
        AbstractFolder fo;

        public NotifyInputStream(AbstractFolder abstractFolder, InputStream inputStream) {
            super(inputStream);
            this.fo = abstractFolder;
            this.ex = new Exception();
        }

        public void close() throws IOException {
            if (this.ex != null) {
                this.ex = null;
                super.close();
                StreamPool.closeInputStream(this.fo, this);
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }

    static final class NotifyOutputStream
    extends FilterOutputStream {
        private Exception ex;
        AbstractFolder fo;

        public NotifyOutputStream(AbstractFolder abstractFolder, OutputStream outputStream) {
            super(outputStream);
            this.fo = abstractFolder;
            this.ex = new Exception();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        public void close() throws IOException {
            if (this.ex != null) {
                this.ex = null;
                super.close();
                StreamPool.closeOutputStream(this.fo, this);
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

