/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;

final class FileURL
extends URLConnection {
    public static final String PROTOCOL = "nbfs";
    private static final char SEPARATOR = '/';
    private static URLStreamHandler HANDLER = new URLStreamHandler(){

        public URLConnection openConnection(URL uRL) throws IOException {
            return new FileURL(uRL);
        }
    };
    private FileObject fo;

    private FileURL(URL uRL) {
        super(uRL);
    }

    public static URL encodeFileObject(FileObject fileObject) throws FileStateInvalidException {
        return FileURL.encodeFileObject(fileObject.getFileSystem(), fileObject);
    }

    private static URL encodeFileObject(FileSystem fileSystem, FileObject fileObject) {
        String string = FileURL.encodeFileSystemName(fileSystem.getSystemName());
        String string2 = fileObject.getPackageNameExt('/', '.');
        final String string3 = string + '/' + string2;
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new URL(FileURL.PROTOCOL, null, -1, string3, HANDLER);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            IllegalStateException illegalStateException = new IllegalStateException(privilegedActionException.toString());
            ExternalUtil.annotate((Throwable)illegalStateException, privilegedActionException);
            throw illegalStateException;
        }
    }

    public static FileObject decodeURL(URL uRL) {
        int n;
        if (!uRL.getProtocol().equals(PROTOCOL)) {
            return null;
        }
        String string = uRL.getFile();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf(47)) == -1) {
            return null;
        }
        String string2 = FileURL.decodeFileSystemName(string.substring(0, n));
        string = string.substring(n);
        FileSystem fileSystem = ExternalUtil.getRepository().findFileSystem(string2);
        return fileSystem == null ? null : fileSystem.findResource(string);
    }

    public void connect() throws IOException {
        if (this.fo != null) {
            return;
        }
        this.fo = FileURL.decodeURL(this.url);
        if (this.fo == null) {
            throw new FileNotFoundException("Cannot find: " + this.url);
        }
    }

    public InputStream getInputStream() throws IOException, UnknownServiceException {
        this.connect();
        try {
            if (this.fo.isFolder()) {
                return new FIS(this.fo);
            }
            return this.fo.getInputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ExternalUtil.exception(fileNotFoundException);
            throw fileNotFoundException;
        }
    }

    public OutputStream getOutputStream() throws IOException, UnknownServiceException {
        this.connect();
        if (this.fo.isFolder()) {
            throw new UnknownServiceException();
        }
        FileLock fileLock = this.fo.lock();
        return new LockOS(this.fo.getOutputStream(fileLock), fileLock);
    }

    public int getContentLength() {
        try {
            this.connect();
            return (int)this.fo.getSize();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String getHeaderField(String string) {
        if (string.equalsIgnoreCase("content-type")) {
            try {
                this.connect();
                if (this.fo.isFolder()) {
                    return "text/html";
                }
                return this.fo.getMIMEType();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getHeaderField(string);
    }

    public Permission getPermission() throws IOException {
        if (this.fo != null) {
            File file = FileUtil.toFile(this.fo);
            if (file != null) {
                return new FilePermission(file.toString(), "read");
            }
            try {
                FileSystem fileSystem = this.fo.getFileSystem();
                if (fileSystem instanceof JarFileSystem) {
                    return new FilePermission(((JarFileSystem)fileSystem).getJarFile().toString(), "read");
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return new FilePermission("<<ALL FILES>>", "read");
    }

    static String encodeFileSystemName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case 'Q': {
                    stringBuffer.append("QQ");
                    break;
                }
                case '/': {
                    stringBuffer.append("QB");
                    break;
                }
                case ':': {
                    stringBuffer.append("QC");
                    break;
                }
                case '\\': {
                    stringBuffer.append("QD");
                    break;
                }
                case '#': {
                    stringBuffer.append("QE");
                    break;
                }
                default: {
                    stringBuffer.append(string.charAt(n));
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String decodeFileSystemName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) == 'Q' && n < n2) {
                switch (string.charAt(n++)) {
                    case 'B': {
                        stringBuffer.append('/');
                        break;
                    }
                    case 'C': {
                        stringBuffer.append(':');
                        break;
                    }
                    case 'D': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case 'E': {
                        stringBuffer.append('#');
                        break;
                    }
                    default: {
                        stringBuffer.append('Q');
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static final class FIS
    extends InputStream {
        private StringReader reader;

        public FIS(FileObject fileObject) throws IOException {
            this.reader = new StringReader(this.createDocument(fileObject));
        }

        private String createDocument(FileObject fileObject) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(150);
            StringBuffer stringBuffer2 = new StringBuffer(15);
            FileObject[] fileObjectArray = fileObject.getChildren();
            stringBuffer.append("<HTML>\n");
            stringBuffer.append("<BODY>\n");
            FileObject fileObject2 = fileObject.getParent();
            if (fileObject2 != null) {
                stringBuffer.append("<P>");
                stringBuffer.append("<A HREF=").append("..").append(">").append("..").append("</A>").append("\n");
                stringBuffer.append("</P>");
            }
            int n = 0;
            while (n < fileObjectArray.length) {
                stringBuffer2.setLength(0);
                stringBuffer2.append(fileObjectArray[n].getNameExt());
                String string = stringBuffer2.toString();
                if (fileObjectArray[n].isFolder()) {
                    stringBuffer2.append('/');
                }
                stringBuffer.append("<P>");
                stringBuffer.append("<A HREF=").append(stringBuffer2).append(">").append(string).append("</A>").append("\n");
                stringBuffer.append("</P>");
                ++n;
            }
            stringBuffer.append("</BODY>\n");
            stringBuffer.append("</HTML>\n");
            return stringBuffer.toString();
        }

        public int read() throws IOException {
            return this.reader.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            char[] cArray = new char[n2];
            int n3 = this.reader.read(cArray, 0, n2);
            int n4 = 0;
            while (n4 < n3) {
                byArray[n + n4] = (byte)cArray[n4];
                ++n4;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            return this.reader.skip(l);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public void reset() throws IOException {
            this.reader.reset();
        }

        public boolean markSupported() {
            return false;
        }
    }

    private static class LockOS
    extends BufferedOutputStream {
        private OutputStream fos;
        private FileLock flock;

        public LockOS(OutputStream outputStream, FileLock fileLock) throws IOException {
            super(outputStream);
            this.flock = fileLock;
        }

        public void close() throws IOException {
            this.flock.releaseLock();
            super.close();
        }
    }
}

