/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public abstract class FileSystem
implements Serializable {
    static final long serialVersionUID = -8931487924240189180L;
    public static final String PROP_VALID = "valid";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_SYSTEM_NAME = "systemName";
    public static final String PROP_ROOT = "root";
    public static final String PROP_READ_ONLY = "readOnly";
    static final String PROP_CAPABILITIES = "capabilities";
    private transient boolean valid = false;
    transient boolean assigned = false;
    private FileSystemCapability capability;
    private transient PropertyChangeListener capabilityListener;
    private boolean hidden = false;
    private String systemName = "".intern();
    private transient EventListenerList listenerList;
    private static Object internLock = new Object();
    private static transient ThreadLocal thrLocal = new ThreadLocal();
    private static final Status STATUS_NONE = new Status(){

        public String annotateName(String string, Set set) {
            return string;
        }

        public Image annotateIcon(Image image, int n, Set set) {
            return image;
        }
    };
    static /* synthetic */ Class class$org$openide$filesystems$Repository;
    static /* synthetic */ Class class$org$openide$filesystems$FileStatusListener;
    static /* synthetic */ Class class$java$beans$VetoableChangeListener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$org$openide$filesystems$FileSystem;

    public FileSystem() {
        this.capability = new FileSystemCapability.Bean();
        this.capability.addPropertyChangeListener(this.getCapabilityChangeListener());
    }

    public final boolean isValid() {
        return this.valid;
    }

    final void setValid(boolean bl) {
        if (bl != this.valid) {
            this.valid = bl;
            this.firePropertyChange(PROP_VALID, new Boolean(!bl), new Boolean(bl), Boolean.FALSE);
        }
    }

    public final void setHidden(boolean bl) {
        if (bl != this.hidden) {
            this.hidden = bl;
            this.firePropertyChange(PROP_HIDDEN, new Boolean(!bl), new Boolean(bl));
        }
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    protected boolean isPersistent() {
        return false;
    }

    public abstract String getDisplayName();

    public final String getSystemName() {
        return this.systemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSystemName(String string) throws PropertyVetoException {
        Class clazz = class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = FileSystem.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository;
        synchronized (clazz) {
            if (this.systemName.equals(string)) {
                return;
            }
            this.fireVetoableChange(PROP_SYSTEM_NAME, this.systemName, string);
            String string2 = this.systemName;
            this.systemName = string.intern();
            this.firePropertyChange(PROP_SYSTEM_NAME, string2, this.systemName);
        }
    }

    public final boolean isDefault() {
        return this == ExternalUtil.getRepository().getDefaultFileSystem();
    }

    public abstract boolean isReadOnly();

    public abstract FileObject getRoot();

    public FileObject find(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.equals("")) {
            String string4 = string.replace('.', '/');
            stringBuffer.append(string4);
            stringBuffer.append('/');
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            stringBuffer.append('.');
            stringBuffer.append(string3);
        }
        return this.findResource(stringBuffer.toString());
    }

    public abstract FileObject findResource(String var1);

    public abstract SystemAction[] getActions();

    public SystemAction[] getActions(Set set) {
        return this.getActions();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.capability == null) {
            this.capability = new FileSystemCapability.Bean();
        }
        this.capability.addPropertyChangeListener(this.getCapabilityChangeListener());
    }

    public String toString() {
        return this.getSystemName() + "[" + super.toString() + "]";
    }

    public void prepareEnvironment(Environment environment) throws EnvironmentNotSupportedException {
        throw new EnvironmentNotSupportedException(this);
    }

    public Status getStatus() {
        return STATUS_NONE;
    }

    public final FileSystemCapability getCapability() {
        return this.capability;
    }

    protected final void setCapability(FileSystemCapability fileSystemCapability) {
        if (this.capability != null) {
            this.capability.removePropertyChangeListener(this.getCapabilityChangeListener());
        }
        this.capability = fileSystemCapability;
        if (this.capability != null) {
            this.capability.addPropertyChangeListener(this.getCapabilityChangeListener());
        }
    }

    public final void runAtomicAction(AtomicAction atomicAction) throws IOException {
        this.getEventControl().runAtomicAction(atomicAction);
    }

    void beginAtomicAction(AtomicAction atomicAction) {
        this.getEventControl().beginAtomicAction(atomicAction);
    }

    void beginAtomicAction() {
        this.beginAtomicAction(null);
    }

    void finishAtomicAction() {
        this.getEventControl().finishAtomicAction();
    }

    void dispatchEvent(EventDispatcher eventDispatcher) {
        this.getEventControl().dispatchEvent(eventDispatcher);
    }

    private synchronized PropertyChangeListener getCapabilityChangeListener() {
        if (this.capabilityListener == null) {
            this.capabilityListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FileSystem.this.firePropertyChange(FileSystem.PROP_CAPABILITIES, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            };
        }
        return this.capabilityListener;
    }

    private final EventControl getEventControl() {
        EventControl eventControl = (EventControl)thrLocal.get();
        if (eventControl == null) {
            eventControl = new EventControl();
            thrLocal.set(eventControl);
        }
        return eventControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFileStatusListener(FileStatusListener fileStatusListener) {
        Object object = internLock;
        synchronized (object) {
            if (this.getStatus() == STATUS_NONE) {
                return;
            }
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(class$org$openide$filesystems$FileStatusListener == null ? (class$org$openide$filesystems$FileStatusListener = FileSystem.class$("org.openide.filesystems.FileStatusListener")) : class$org$openide$filesystems$FileStatusListener, fileStatusListener);
        }
    }

    public final void removeFileStatusListener(FileStatusListener fileStatusListener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(class$org$openide$filesystems$FileStatusListener == null ? (class$org$openide$filesystems$FileStatusListener = FileSystem.class$("org.openide.filesystems.FileStatusListener")) : class$org$openide$filesystems$FileStatusListener, fileStatusListener);
    }

    protected final void fireFileStatusChanged(FileStatusEvent fileStatusEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$openide$filesystems$FileStatusListener == null ? FileSystem.class$("org.openide.filesystems.FileStatusListener") : class$org$openide$filesystems$FileStatusListener)) {
                ((FileStatusListener)objectArray[n + 1]).annotationChanged(fileStatusEvent);
            }
            n -= 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        Object object = internLock;
        synchronized (object) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = FileSystem.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener, vetoableChangeListener);
        }
    }

    public final void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = FileSystem.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener, vetoableChangeListener);
    }

    protected final void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.listenerList == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$beans$VetoableChangeListener == null ? FileSystem.class$("java.beans.VetoableChangeListener") : class$java$beans$VetoableChangeListener)) {
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                }
                ((VetoableChangeListener)objectArray[n + 1]).vetoableChange(propertyChangeEvent);
            }
            n -= 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = internLock;
        synchronized (object) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = FileSystem.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = FileSystem.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2, null);
    }

    final void firePropertyChange(String string, Object object, Object object2, Object object3) {
        if (this.listenerList == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$beans$PropertyChangeListener == null ? FileSystem.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) {
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                    propertyChangeEvent.setPropagationId(object3);
                }
                ((PropertyChangeListener)objectArray[n + 1]).propertyChange(propertyChangeEvent);
            }
            n -= 2;
        }
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    static String getString(String string) {
        return NbBundle.getBundle("org.openide.filesystems.Bundle", Locale.getDefault(), (class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = FileSystem.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem).getClassLoader()).getString(string);
    }

    static String getString(String string, Object object) {
        return MessageFormat.format(FileSystem.getString(string), object);
    }

    static String getString(String string, Object object, Object object2) {
        return MessageFormat.format(FileSystem.getString(string), object, object2);
    }

    static String getString(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(FileSystem.getString(string), object, object2, object3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static abstract class EventDispatcher
    implements Runnable {
        EventDispatcher() {
        }

        public final void run() {
            this.dispatch();
        }

        final void dispatch() {
            this.dispatch(false);
        }

        protected abstract void dispatch(boolean var1);

        protected abstract void setAtomicActionLink(EventControl.AtomicActionLink var1);
    }

    public static interface Status {
        public String annotateName(String var1, Set var2);

        public Image annotateIcon(Image var1, int var2, Set var3);
    }

    public static abstract class Environment {
        public void addClassPath(String string) {
        }
    }

    public static interface AtomicAction {
        public void run() throws IOException;
    }
}

