/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerChildren;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Mutex;
import org.openide.util.WeakListener;
import org.openide.util.enum.QueueEnumeration;

final class VisualizerNode
extends EventListenerList
implements NodeListener,
TreeNode,
Runnable {
    private static final VisualizerNode TEMPLATE = new VisualizerNode(0);
    private static final Reference NO_REF = new WeakReference<Object>(null);
    private static WeakHashMap cache = new WeakHashMap();
    public static final VisualizerNode EMPTY = VisualizerNode.getVisualizer(null, Node.EMPTY);
    private static final QP QUEUE = new QP();
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.exceptions");
    Node node;
    private int hashCode;
    private Reference children = NO_REF;
    private VisualizerChildren parent;
    private PropertyChangeListener uiListener;
    public String name;
    public String displayName;
    private static final String UNKNOWN = new String();
    private String shortDescription;
    static final long serialVersionUID = 3726728244698316872L;
    static /* synthetic */ Class class$org$openide$explorer$view$NodeModel;

    public static VisualizerNode getVisualizer(VisualizerChildren visualizerChildren, Node node) {
        VisualizerNode visualizerNode;
        VisualizerNode.TEMPLATE.hashCode = System.identityHashCode(node);
        VisualizerNode.TEMPLATE.node = node;
        Reference reference = (Reference)cache.get(TEMPLATE);
        VisualizerNode visualizerNode2 = visualizerNode = reference == null ? null : (VisualizerNode)reference.get();
        if (visualizerNode == null) {
            visualizerNode = new VisualizerNode(node);
            cache.put(visualizerNode, new WeakReference<VisualizerNode>(visualizerNode));
        }
        if (visualizerChildren != null) {
            visualizerNode.parent = visualizerChildren;
        }
        return visualizerNode;
    }

    private VisualizerNode(int n) {
        this.hashCode = n;
        this.node = null;
    }

    private VisualizerNode(Node node) {
        this.node = node;
        this.hashCode = System.identityHashCode(this.node);
        this.node.addNodeListener(WeakListener.node(this, this.node));
        this.name = this.node.getName();
        this.displayName = this.node.getDisplayName();
        this.shortDescription = UNKNOWN;
    }

    public String getShortDescription() {
        String string = this.shortDescription;
        if (string == UNKNOWN) {
            this.shortDescription = string = this.node.getShortDescription();
        }
        return string;
    }

    public List getChildren() {
        VisualizerChildren visualizerChildren = (VisualizerChildren)this.children.get();
        if (visualizerChildren == null && !this.node.isLeaf()) {
            visualizerChildren = (VisualizerChildren)Children.MUTEX.readAccess(new Mutex.Action(){

                public Object run() {
                    Node[] nodeArray = VisualizerNode.this.node.getChildren().getNodes();
                    VisualizerChildren visualizerChildren = new VisualizerChildren(VisualizerNode.this, nodeArray);
                    VisualizerNode.this.notifyVisualizerChildrenChange(nodeArray.length, visualizerChildren);
                    return visualizerChildren;
                }
            });
        }
        return visualizerChildren == null ? Collections.EMPTY_LIST : visualizerChildren.list;
    }

    public int getIndex(TreeNode treeNode) {
        return this.getChildren().indexOf(treeNode);
    }

    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public TreeNode getChildAt(int n) {
        List list = this.getChildren();
        VisualizerNode visualizerNode = (VisualizerNode)list.get(n);
        if (visualizerNode == null) {
            System.out.println("Children are: ");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                System.out.println("    " + iterator.next());
            }
            throw new IllegalStateException("VisualizerNode.getChildAt() returning null!");
        }
        return visualizerNode;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public Enumeration children() {
        if (debug) {
            List list = this.getChildren();
            if (list.contains(null)) {
                System.out.println("Children are: ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    System.out.println("    " + iterator.next());
                }
                throw new IllegalStateException("VisualizerNode.children() contains null!");
            }
            return Collections.enumeration(list);
        }
        return Collections.enumeration(this.getChildren());
    }

    public boolean isLeaf() {
        return this.node.isLeaf();
    }

    public TreeNode getParent() {
        Node node = this.node.getParentNode();
        return node == null ? null : VisualizerNode.getVisualizer(null, node);
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        VisualizerChildren visualizerChildren = (VisualizerChildren)this.children.get();
        if (visualizerChildren == null) {
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Added(visualizerChildren, nodeMemberEvent.getDelta(), nodeMemberEvent.getDeltaIndices()));
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        VisualizerChildren visualizerChildren = (VisualizerChildren)this.children.get();
        if (visualizerChildren == null) {
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Removed(visualizerChildren, nodeMemberEvent.getDeltaIndices()));
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        VisualizerChildren visualizerChildren = (VisualizerChildren)this.children.get();
        if (visualizerChildren == null) {
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Reordered(visualizerChildren, nodeReorderEvent.getPermutation()));
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("name".equals(string) || "displayName".equals(string) || "shortDescription".equals(string) || "icon".equals(string) || "openedIcon".equals(string)) {
            SwingUtilities.invokeLater(this);
            return;
        }
    }

    public void run() {
        this.name = this.node.getName();
        this.displayName = this.node.getDisplayName();
        this.shortDescription = UNKNOWN;
        VisualizerNode visualizerNode = this;
        while (visualizerNode != null) {
            Object[] objectArray = visualizerNode.getListenerList();
            int n = objectArray.length - 1;
            while (n >= 0) {
                ((NodeModel)objectArray[n]).update(this);
                n -= 2;
            }
            visualizerNode = (VisualizerNode)visualizerNode.getParent();
        }
    }

    void notifyVisualizerChildrenChange(int n, VisualizerChildren visualizerChildren) {
        this.children = n == 0 ? new StrongReference(visualizerChildren) : new WeakReference<VisualizerChildren>(visualizerChildren);
    }

    public synchronized void addNodeModel(NodeModel nodeModel) {
        this.add(class$org$openide$explorer$view$NodeModel == null ? (class$org$openide$explorer$view$NodeModel = VisualizerNode.class$("org.openide.explorer.view.NodeModel")) : class$org$openide$explorer$view$NodeModel, nodeModel);
    }

    public synchronized void removeNodeModel(NodeModel nodeModel) {
        this.remove(class$org$openide$explorer$view$NodeModel == null ? (class$org$openide$explorer$view$NodeModel = VisualizerNode.class$("org.openide.explorer.view.NodeModel")) : class$org$openide$explorer$view$NodeModel, nodeModel);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VisualizerNode)) {
            return false;
        }
        VisualizerNode visualizerNode = (VisualizerNode)object;
        return visualizerNode.node == this.node;
    }

    public String toString() {
        return this.displayName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class QP
    implements Runnable {
        private QueueEnumeration queue = null;

        private QP() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSafe(Runnable runnable) {
            boolean bl = false;
            QP qP = this;
            synchronized (qP) {
                if (this.queue == null) {
                    this.queue = new QueueEnumeration();
                    bl = true;
                }
                this.queue.put(runnable);
            }
            if (bl) {
                Mutex.EVENT.writeAccess(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            QueueEnumeration queueEnumeration;
            QP qP = this;
            synchronized (qP) {
                queueEnumeration = this.queue;
                this.queue = null;
            }
            while (queueEnumeration.hasMoreElements()) {
                Runnable runnable = (Runnable)queueEnumeration.nextElement();
                runnable.run();
            }
        }
    }

    private static final class StrongReference
    extends WeakReference {
        private Object o;

        public StrongReference(Object object) {
            super(null);
            this.o = object;
        }

        public Object get() {
            return this.o;
        }
    }
}

