/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.TooManyListenersException;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

final class TreeViewDragSupport
implements DragSourceListener,
DragGestureListener,
TreeSelectionListener {
    boolean active = false;
    DragGestureRecognizer defaultGesture;
    TreePath[] curSelection;
    TreePath[] oldSelection;
    protected TreeView view;
    protected JTree tree;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    public TreeViewDragSupport(TreeView treeView, JTree jTree) {
        this.view = treeView;
        this.tree = jTree;
        jTree.addTreeSelectionListener(this);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n = dragGestureEvent.getDragAction();
        if ((n & this.view.getAllowedDragActions()) == 0) {
            return;
        }
        Node[] nodeArray = this.obtainNodes(dragGestureEvent);
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < nodeArray.length) {
            if (!DragDropUtilities.checkNodeForAction(nodeArray[n2], n)) {
                return;
            }
            ++n2;
        }
        try {
            Transferable transferable = DragDropUtilities.getNodeTransferable(nodeArray, n);
            dragGestureEvent.startDrag(DragDropUtilities.chooseCursor(n, this.view.isDropTarget(), nodeArray[0]), transferable, this);
            TreeCellEditor treeCellEditor = this.tree.getCellEditor();
            if (treeCellEditor instanceof TreeViewCellEditor) {
                ((TreeViewCellEditor)treeCellEditor).setDnDActive(true);
            }
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = TreeViewDragSupport.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            if (errorManager != null) {
                errorManager.notify(invalidDnDOperationException);
            } else {
                invalidDnDOperationException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = TreeViewDragSupport.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            if (errorManager != null) {
                errorManager.notify(iOException);
            }
            iOException.printStackTrace();
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        TreeCellEditor treeCellEditor = this.tree.getCellEditor();
        if (treeCellEditor instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)treeCellEditor).setDnDActive(false);
        }
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        DragGestureRecognizer dragGestureRecognizer = this.getDefaultGestureRecognizer();
        if (bl) {
            dragGestureRecognizer.setSourceActions(this.view.getAllowedDragActions());
            try {
                dragGestureRecognizer.removeDragGestureListener(this);
                dragGestureRecognizer.addDragGestureListener(this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                throw new IllegalStateException("Too many listeners for drag gesture.");
            }
        } else {
            dragGestureRecognizer.removeDragGestureListener(this);
        }
    }

    DragGestureRecognizer getDefaultGestureRecognizer() {
        if (this.defaultGesture == null) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            this.defaultGesture = dragSource.createDefaultDragGestureRecognizer(this.tree, this.view.getAllowedDragActions(), this);
        }
        return this.defaultGesture;
    }

    Node[] obtainNodes(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return null;
        }
        Node node = DragDropUtilities.secureFindNode(treePath.getLastPathComponent());
        if (node == null) {
            return null;
        }
        if (this.oldSelection != null && this.wasSelected(node)) {
            this.tree.setSelectionPaths(this.oldSelection);
            this.curSelection = null;
        }
        Node[] nodeArray = null;
        if (this.tree.isPathSelected(treePath)) {
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            nodeArray = new Node[treePathArray.length];
            int n = 0;
            while (n < treePathArray.length) {
                nodeArray[n] = DragDropUtilities.secureFindNode(treePathArray[n].getLastPathComponent());
                if (nodeArray[n] == null) {
                    return null;
                }
                ++n;
            }
        } else {
            nodeArray = new Node[]{node};
        }
        return nodeArray;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.tree.getSelectionPaths();
        if (objectArray != null && !Arrays.equals(this.curSelection, objectArray)) {
            this.oldSelection = this.curSelection == null ? objectArray : this.curSelection;
            this.curSelection = objectArray;
        }
    }

    boolean wasSelected(Object object) {
        if (this.oldSelection == null) {
            return false;
        }
        int n = 0;
        while (n < this.oldSelection.length) {
            if (object.equals(this.oldSelection[n].getLastPathComponent())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

