/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.TableSheet;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class TreeTableView
extends BeanTreeView {
    private TableSheet.ControlledTableView controlledTableView;
    private Listener listener;
    private Dimension prefSize;
    private JTable table;

    public TreeTableView() {
        this((NodeTableModel)null);
    }

    public TreeTableView(NodeTableModel nodeTableModel) {
        JScrollPane jScrollPane = new JScrollPane(){

            public boolean isValidateRoot() {
                return false;
            }
        };
        jScrollPane.setViewportView(this.tree);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setBorder(null);
        this.controlledTableView = nodeTableModel == null ? new TableSheet.ControlledTableView(jScrollPane) : new TableSheet.ControlledTableView(jScrollPane, nodeTableModel);
        this.setViewportView(this.controlledTableView.compoundScrollPane());
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        this.setPreferredSize(new Dimension(400, 400));
        this.listener = new Listener();
        this.initializeTreeTable();
    }

    private void initializeTreeTable() {
        this.tree.putClientProperty("JTree.lineStyle", "None");
        TableLikeTreeUI tableLikeTreeUI = new TableLikeTreeUI(this.tree);
        this.tree.setUI(tableLikeTreeUI);
        this.tree.setCellRenderer(tableLikeTreeUI);
        this.tree.setCellEditor(tableLikeTreeUI);
        this.table = this.controlledTableView.getTable();
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.controlledTableView.setProperties(propertyArray);
    }

    public final void setTableAutoResizeMode(int n) {
        this.controlledTableView.setAutoResizeMode(n);
    }

    public final int getTableAutoResizeMode() {
        return this.controlledTableView.getAutoResizeMode();
    }

    public final void setTableColumnPreferredWidth(int n, int n2) {
        this.controlledTableView.setColumnPreferredWidth(n, n2);
    }

    public final int getTableColumnPreferredWidth(int n) {
        return this.controlledTableView.getColumnPreferredWidth(n);
    }

    public final void setTreePreferredWidth(int n) {
        this.controlledTableView.setControllingViewWidth(n);
        Dimension dimension = this.getPreferredSize();
        this.table.setPreferredScrollableViewportSize(new Dimension(dimension.width - n, dimension.height));
    }

    public final int getTreePreferredWidth() {
        return this.controlledTableView.getControllingViewWidth();
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.prefSize = dimension;
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void addNotify() {
        super.addNotify();
        this.tree.addTreeExpansionListener(this.listener);
        this.tree.getModel().addTreeModelListener(this.listener);
        this.tree.addFocusListener(this.listener);
        this.changeTableModel();
        this.updateHeader();
    }

    public void removeNotify() {
        super.removeNotify();
        this.tree.removeTreeExpansionListener(this.listener);
        this.tree.getModel().removeTreeModelListener(this.listener);
        this.tree.removeFocusListener(this.listener);
        this.controlledTableView.setNodes(new Node[0]);
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.table.getTableHeader().addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.table.getTableHeader().removeMouseListener(mouseListener);
    }

    private void delayedFireTableDataChanged() {
        this.listener.requestTableUpdate();
    }

    private void changeTableModel() {
        if (this.tree.getRowBounds(0) != null) {
            this.controlledTableView.setRowHeight(this.tree.getRowBounds((int)0).height);
        }
        Node[] nodeArray = new Node[this.tree.getRowCount()];
        int n = 0;
        while (n < this.tree.getRowCount()) {
            nodeArray[n] = Visualizer.findNode(this.tree.getPathForRow(n).getLastPathComponent());
            ++n;
        }
        this.controlledTableView.setNodes(nodeArray);
    }

    private void updateHeader() {
        Object object = this.tree.getModel().getRoot();
        if (object != null) {
            this.controlledTableView.setHeaderText(Visualizer.findNode(object).getDisplayName());
        }
    }

    private static class TableLikeTreeCellEditor
    extends DefaultTreeCellEditor {
        JPanel panel = new JPanel(new BorderLayout());

        public TableLikeTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Component component = super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
            this.panel.add(component);
            return this.panel;
        }
    }

    private static class TableLikeTreeUI
    extends MetalTreeUI
    implements TreeCellEditor,
    TreeCellRenderer {
        TreeCellEditor treeEditor;
        TreeCellRenderer treeRenderer;
        JPanel rendererPanel;
        JPanel editorPanel;

        public TableLikeTreeUI(JTree jTree) {
            this.treeEditor = jTree.getCellEditor();
            this.treeRenderer = jTree.getCellRenderer();
            this.rendererPanel = new JPanel(new BorderLayout());
            this.rendererPanel.setBorder(new EmptyBorder(0, 0, 1, 0));
            this.rendererPanel.setBackground(jTree.getBackground());
            this.editorPanel = new JPanel(new BorderLayout());
            this.editorPanel.setBorder(new MatteBorder(0, 0, 1, 0, SystemColor.controlLtHighlight));
            this.editorPanel.setOpaque(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
            super.paintRow(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
            Graphics graphics2 = graphics.create(0, rectangle2.y, this.tree.getSize().width, rectangle2.height);
            try {
                Color color = this.tree.getBackground();
                int n2 = 30;
                int n3 = color.getRed() - n2;
                int n4 = color.getGreen() - n2;
                int n5 = color.getBlue() - n2;
                if (n3 < 0) {
                    n3 += 2 * n2;
                }
                if (n4 < 0) {
                    n4 += 2 * n2;
                }
                if (n5 < 0) {
                    n5 += 2 * n2;
                }
                graphics2.setColor(new Color(n3, n4, n5));
                graphics2.drawLine(0, rectangle2.height - 1, this.tree.getSize().width - 1, rectangle2.height - 1);
                Object var17_16 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                graphics2.dispose();
                throw throwable;
            }
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = this.treeRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.rendererPanel.add(component);
            return this.rendererPanel;
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Component component = this.treeEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
            this.editorPanel.add(component);
            return this.editorPanel;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.treeEditor.addCellEditorListener(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.treeEditor.cancelCellEditing();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return this.treeEditor.isCellEditable(eventObject);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.treeEditor.removeCellEditorListener(cellEditorListener);
        }

        public Object getCellEditorValue() {
            return this.treeEditor.getCellEditorValue();
        }

        public boolean stopCellEditing() {
            return this.treeEditor.stopCellEditing();
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return this.treeEditor.shouldSelectCell(eventObject);
        }
    }

    private class Listener
    implements Runnable,
    FocusListener,
    TreeModelListener,
    TreeExpansionListener {
        private boolean tableChanging = false;

        private Listener() {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreeTableView.this.changeTableModel();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreeTableView.this.changeTableModel();
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreeTableView.this.delayedFireTableDataChanged();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreeTableView.this.delayedFireTableDataChanged();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeTableView.this.delayedFireTableDataChanged();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreeTableView.this.delayedFireTableDataChanged();
            TreeTableView.this.updateHeader();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            int n = TreeTableView.this.tree.getLeadSelectionRow();
            TreeTableView.this.table.getSelectionModel().setAnchorSelectionIndex(n);
            TreeTableView.this.table.getColumnModel().getSelectionModel().setAnchorSelectionIndex(0);
        }

        public void requestTableUpdate() {
            if (this.tableChanging) {
                return;
            }
            this.tableChanging = true;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            TreeTableView.this.changeTableModel();
            this.tableChanging = false;
        }
    }
}

