/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.table.AbstractTableModel;
import org.openide.nodes.Node;

public class NodeTableModel
extends AbstractTableModel {
    private Node.Property[] propertyColumns = new Node.Property[0];
    private Node[] nodeRows = new Node[0];
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = NodeTableModel.this.rowForNode((Node)propertyChangeEvent.getSource());
            if (n == -1) {
                return;
            }
            int n2 = NodeTableModel.this.columnForProperty(propertyChangeEvent.getPropertyName());
            if (n2 == -1) {
                NodeTableModel.this.fireTableRowsUpdated(n, n);
            } else {
                NodeTableModel.this.fireTableCellUpdated(n, n2);
            }
        }
    };
    static /* synthetic */ Class class$org$openide$nodes$Node$Property;

    public void setNodes(Node[] nodeArray) {
        int n = 0;
        while (n < this.nodeRows.length) {
            this.nodeRows[n].removePropertyChangeListener(this.pcl);
            ++n;
        }
        this.nodeRows = nodeArray;
        int n2 = 0;
        while (n2 < this.nodeRows.length) {
            this.nodeRows[n2].addPropertyChangeListener(this.pcl);
            ++n2;
        }
        this.fireTableDataChanged();
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.propertyColumns = propertyArray;
        this.fireTableStructureChanged();
    }

    protected Node.Property getPropertyFor(Node node, Node.Property property) {
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        int n = 0;
        while (n < propertySetArray.length) {
            Node.Property[] propertyArray = propertySetArray[n].getProperties();
            int n2 = 0;
            while (n2 < propertyArray.length) {
                if (property.equals(propertyArray[n2])) {
                    return propertyArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    Node nodeForRow(int n) {
        return this.nodeRows[n];
    }

    Node.Property propertyForColumn(int n) {
        return this.propertyColumns[n];
    }

    private int rowForNode(Node node) {
        int n = 0;
        while (n < this.nodeRows.length) {
            if (node.equals(this.nodeRows[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int columnForProperty(String string) {
        int n = 0;
        while (n < this.propertyColumns.length) {
            if (this.propertyColumns[n].getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getRowCount() {
        return this.nodeRows.length;
    }

    public int getColumnCount() {
        return this.propertyColumns.length;
    }

    public Object getValueAt(int n, int n2) {
        return this.getPropertyFor(this.nodeRows[n], this.propertyColumns[n2]);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.getValueAt(n, n2) != null;
    }

    public Class getColumnClass(int n) {
        return class$org$openide$nodes$Node$Property == null ? (class$org$openide$nodes$Node$Property = NodeTableModel.class$("org.openide.nodes.Node$Property")) : class$org$openide$nodes$Node$Property;
    }

    public String getColumnName(int n) {
        return this.propertyColumns[n].getDisplayName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

