/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.NodeRenderer;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

final class ListViewDropSupport
implements DropTargetListener,
Runnable {
    boolean active = false;
    DropTarget dropTarget;
    int lastIndex = -1;
    protected ListView view;
    protected JList list;
    protected NodeRenderer.List cellRenderer;

    public ListViewDropSupport(ListView listView, JList jList) {
        this.view = listView;
        this.list = jList;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.lastIndex = this.indexWithCheck(dropTargetDragEvent);
        if (this.lastIndex < 0) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            NodeRenderer.dragEnter(this.list.getModel().getElementAt(this.lastIndex));
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n = this.indexWithCheck(dropTargetDragEvent);
        if (n < 0) {
            dropTargetDragEvent.rejectDrag();
            if (this.lastIndex >= 0) {
                NodeRenderer.dragExit();
                this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
                this.lastIndex = -1;
            }
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            if (this.lastIndex != n) {
                if (this.lastIndex < 0) {
                    this.lastIndex = n;
                }
                NodeRenderer.dragExit();
                NodeRenderer.dragEnter(this.list.getModel().getElementAt(n));
                this.list.repaint(this.list.getCellBounds(this.lastIndex, n));
                this.lastIndex = n;
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.lastIndex >= 0) {
            NodeRenderer.dragExit();
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        int n;
        Object var3_3;
        block6: {
            block5: {
                int n2 = this.list.locationToIndex(dropTargetDropEvent.getLocation());
                var3_3 = null;
                n = dropTargetDropEvent.getDropAction();
                if (n2 < 0 || (n & this.view.getAllowedDropActions()) == 0) break block5;
                Object e = this.list.getModel().getElementAt(n2);
                var3_3 = e;
                if (e instanceof Node) break block6;
            }
            dropTargetDropEvent.rejectDrop();
            return;
        }
        PasteType[] pasteTypeArray = DragDropUtilities.getPasteTypes(var3_3, dropTargetDropEvent.getTransferable());
        if (pasteTypeArray == null || pasteTypeArray.length <= 0) {
            dropTargetDropEvent.dropComplete(false);
            RequestProcessor.postRequest(this, 500);
            return;
        }
        dropTargetDropEvent.acceptDrop(n);
        if (n != 0x40000000) {
            DragDropUtilities.performDrop(pasteTypeArray[0]);
        }
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        this.getDropTarget().setActive(bl);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    int indexWithCheck(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        block5: {
            block4: {
                int n2 = dropTargetDragEvent.getDropAction();
                if ((n2 & this.view.getAllowedDropActions()) == 0) {
                    return -1;
                }
                n = this.list.locationToIndex(dropTargetDragEvent.getLocation());
                Object var4_4 = null;
                if (n < 0) break block4;
                Object e = this.list.getModel().getElementAt(n);
                var4_4 = e;
                if (e instanceof Node) break block5;
            }
            return -1;
        }
        return n;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.list, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }

    NodeRenderer.List getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = (NodeRenderer.List)this.list.getCellRenderer();
        }
        return this.cellRenderer;
    }
}

