/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.Collection;
import java.util.HashSet;
import org.openide.compiler.ExternalCompiler;
import org.openide.explorer.propertysheet.editors.ErrorExpressionPanel;

public abstract class ExternalCompiler {
    private ExternalCompiler() {
    }

    public static class ErrorExpressionEditor
    extends PropertyEditorSupport {
        private static Collection sharedList = new HashSet(17);
        private Collection list;
        private ExternalCompiler.ErrorExpression value;

        public ErrorExpressionEditor() {
            this(sharedList);
        }

        public ErrorExpressionEditor(Collection collection) {
            this.list = collection;
        }

        public Object getValue() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) {
            ErrorExpressionEditor errorExpressionEditor = this;
            synchronized (errorExpressionEditor) {
                this.value = (ExternalCompiler.ErrorExpression)object;
                this.list.add(object);
            }
            this.firePropertyChange();
        }

        public String getAsText() {
            return this.value.getName();
        }

        public void setAsText(String string) {
            ExternalCompiler.ErrorExpression[] errorExpressionArray = this.getExpressions();
            int n = 0;
            while (n < errorExpressionArray.length) {
                if (string.equals(errorExpressionArray[n].getName())) {
                    this.setValue(errorExpressionArray[n]);
                    break;
                }
                ++n;
            }
        }

        public String getJavaInitializationString() {
            return "new ExternalCompiler.ErrorExpression (" + this.value.getName() + ", " + this.value.getErrorExpression() + ", " + this.value.getFilePos() + ", " + this.value.getLinePos() + ", " + this.value.getColumnPos() + ", " + this.value.getDescriptionPos() + ")";
        }

        public String[] getTags() {
            ExternalCompiler.ErrorExpression[] errorExpressionArray = this.getExpressions();
            String[] stringArray = new String[errorExpressionArray.length];
            int n = 0;
            while (n < errorExpressionArray.length) {
                stringArray[n] = errorExpressionArray[n].getName();
                ++n;
            }
            return stringArray;
        }

        public boolean isPaintable() {
            return false;
        }

        public void paintValue(Graphics graphics, Rectangle rectangle) {
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            return new ErrorExpressionPanel(this);
        }

        synchronized ExternalCompiler.ErrorExpression[] getExpressions() {
            return this.list.toArray(new ExternalCompiler.ErrorExpression[this.list.size()]);
        }

        Collection getExpressionsVector() {
            return this.list;
        }

        static {
            sharedList.add(org.openide.compiler.ExternalCompiler.JAVAC);
            sharedList.add(org.openide.compiler.ExternalCompiler.JIKES);
            sharedList.add(org.openide.compiler.ExternalCompiler.JVC);
        }
    }
}

