/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import org.openide.explorer.propertysheet.PropertyDialogManager;

public final class PropertyEnv {
    public static final String PROP_STATE = "state";
    public static final Object STATE_VALID = "valid";
    public static final Object STATE_NEEDS_VALIDATION = "needs_validation";
    public static final Object STATE_INVALID = "invalid";
    static final String PROP_CHANGE_IMMEDIATE = "changeImmediate";
    private FeatureDescriptor featureDescriptor;
    private Object[] beans;
    private Object state = STATE_VALID;
    private VetoableChangeSupport support;
    private boolean changeImmediate = true;

    PropertyEnv() {
    }

    public Object[] getBeans() {
        return this.beans;
    }

    void setBeans(Object[] objectArray) {
        this.beans = objectArray;
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.featureDescriptor;
    }

    void setFeatureDescriptor(FeatureDescriptor featureDescriptor) {
        Object object;
        this.featureDescriptor = featureDescriptor;
        if (this.featureDescriptor != null && (object = this.featureDescriptor.getValue(PROP_CHANGE_IMMEDIATE)) instanceof Boolean) {
            this.setChangeImmediate((Boolean)object);
        }
    }

    public void setState(Object object) {
        Object object2 = this.state;
        this.state = object;
        try {
            this.getSupport().fireVetoableChange(PROP_STATE, object2, object);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.state = object2;
            PropertyDialogManager.notify(propertyVetoException);
        }
    }

    public Object getState() {
        return this.state;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.getSupport().addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.getSupport().removeVetoableChangeListener(vetoableChangeListener);
    }

    boolean isChangeImmediate() {
        return this.changeImmediate;
    }

    void setChangeImmediate(boolean bl) {
        this.changeImmediate = bl;
    }

    private synchronized VetoableChangeSupport getSupport() {
        if (this.support == null) {
            this.support = new VetoableChangeSupport(this);
        }
        return this.support;
    }
}

