/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class PropertyDialogManager
implements VetoableChangeListener {
    private PropertyChangeListener listener;
    private Object oldValue;
    private PropertyEditor editor;
    private PropertyModel model;
    private Node.Property prop;
    private boolean changed = false;
    private Component component;
    private Window dialog;
    private JButton okButton;
    private Runnable errorPerformer;
    private boolean okButtonState = true;
    private boolean defaultValue = false;
    private boolean isModal = true;
    private String title = null;
    private Object defaultOption;
    private Object[] options;
    private Object envStateBeforeDisplay = null;
    private PropertyEnv env;
    private static ThreadLocal caller = new ThreadLocal();
    private ActionListener actionListener;
    private Object lastValueFromEditor;
    private static final String PROPERTY_DESCRIPTION = "description";
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertyDialogManager;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    public PropertyDialogManager(String string, boolean bl, PropertyEditor propertyEditor, PropertyModel propertyModel, PropertyEnv propertyEnv) {
        this.editor = propertyEditor;
        if (propertyEnv != null) {
            propertyEnv.addVetoableChangeListener(this);
        }
        this.component = propertyEditor.getCustomEditor();
        this.model = propertyModel;
        this.env = propertyEnv;
        this.title = string;
        this.isModal = bl;
        this.actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialogManager.this.doButtonPressed(actionEvent);
            }
        };
        this.createDialog();
        this.initializeListeners();
    }

    public Window getDialog() {
        return this.dialog;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (this.env != null && "state".equals(propertyChangeEvent.getPropertyName())) {
            boolean bl = this.okButtonState = this.env.getState() != PropertyEnv.STATE_INVALID;
            if (this.okButton != null) {
                this.okButton.setEnabled(this.okButtonState);
            }
        }
    }

    private void createDialog() {
        Object object;
        Object object2;
        if (this.component instanceof Window) {
            this.dialog = (Window)this.component;
            this.dialog.pack();
            return;
        }
        boolean bl = false;
        if (this.model instanceof ExPropertyModel && (object2 = ((ExPropertyModel)this.model).getFeatureDescriptor()) instanceof Node.Property) {
            this.prop = (Node.Property)object2;
            bl = !this.prop.canWrite();
            this.defaultValue = this.prop.supportsDefaultValue();
        }
        if (this.editor == null || bl) {
            object2 = new JButton(PropertyDialogManager.getString("CTL_Close"));
            ((JButton)object2).getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Close"));
            this.options = new Object[]{object2};
            this.defaultOption = object2;
        } else {
            this.okButton = new JButton(PropertyDialogManager.getString("CTL_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_OK"));
            object2 = new JButton(PropertyDialogManager.getString("CTL_Cancel"));
            ((JButton)object2).getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Cancel"));
            ((JComponent)object2).setVerifyInputWhenFocusTarget(false);
            ((JButton)object2).setDefaultCapable(false);
            if (this.defaultValue) {
                object = new JButton(PropertyDialogManager.getString("CTL_Default"));
                ((AbstractButton)object).setMnemonic(PropertyDialogManager.getString("CTL_DefaultMnemonic").charAt(0));
                ((JButton)object).getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Default"));
                ((JButton)object).setDefaultCapable(false);
                ((JComponent)object).setVerifyInputWhenFocusTarget(false);
                this.options = new Object[]{object, this.okButton, object2};
            } else {
                this.options = new Object[]{this.okButton, object2};
            }
            this.defaultOption = this.okButton;
        }
        if (this.env != null && this.okButton != null) {
            boolean bl2 = this.okButtonState = this.env.getState() != PropertyEnv.STATE_INVALID;
            if (this.okButton != null) {
                this.okButton.setEnabled(this.okButtonState);
            }
        }
        if (this.env != null) {
            this.envStateBeforeDisplay = this.env.getState();
        }
        try {
            caller.set(this);
            object2 = Class.forName("org.openide.explorer.propertysheet.PropertyDialogManager$CreateDialogInvoker");
            object = (Runnable)((Class)object2).newInstance();
            object.run();
            return;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (this.dialog == null) {
                object2 = new JOptionPane(this.component, -1, 1, null, this.options, this.defaultOption);
                if (this.okButton != null) {
                    this.okButton.addActionListener(this.actionListener);
                }
                this.dialog = ((JOptionPane)object2).createDialog(null, this.title);
            }
            if (this.env != null && (object2 = this.env.getFeatureDescriptor().getValue(PROPERTY_DESCRIPTION)) instanceof String) {
                this.dialog.getAccessibleContext().setAccessibleDescription((String)object2);
            }
            return;
        }
    }

    private void initializeListeners() {
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (PropertyDialogManager.this.editor != null) {
                    PropertyDialogManager.this.cancelValue();
                }
                PropertyDialogManager.this.dialog.dispose();
            }

            public void windowClosed(WindowEvent windowEvent) {
                if (PropertyDialogManager.this.listener != null) {
                    PropertyDialogManager.this.editor.removePropertyChangeListener(PropertyDialogManager.this.listener);
                }
            }
        });
        if (this.editor != null) {
            try {
                this.oldValue = this.model.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastValueFromEditor = this.editor.getValue();
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PropertyDialogManager.this.changed = true;
                    PropertyDialogManager.this.lastValueFromEditor = PropertyDialogManager.this.editor.getValue();
                    if ("propertyValueValid".equals(propertyChangeEvent.getPropertyName()) && PropertyDialogManager.this.okButton != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
                        Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                        PropertyDialogManager.this.okButtonState = bl;
                        if (PropertyDialogManager.this.env != null) {
                            PropertyDialogManager.this.env.setState(PropertyDialogManager.this.okButtonState ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
                        } else {
                            PropertyDialogManager.this.okButton.setEnabled(PropertyDialogManager.this.okButtonState);
                        }
                        if (propertyChangeEvent.getOldValue() instanceof Runnable) {
                            PropertyDialogManager.this.errorPerformer = (Runnable)propertyChangeEvent.getOldValue();
                        } else {
                            PropertyDialogManager.this.errorPerformer = null;
                        }
                    }
                }
            };
            this.editor.addPropertyChangeListener(this.listener);
        }
    }

    private void cancelValue() {
        if (!this.changed || this.component instanceof EnhancedCustomPropertyEditor || this.env != null && !this.env.isChangeImmediate()) {
            if (this.env != null && this.envStateBeforeDisplay != null) {
                this.env.setState(this.envStateBeforeDisplay);
            }
            return;
        }
        try {
            this.model.setValue(this.oldValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doButtonPressed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(PropertyDialogManager.getString("CTL_Cancel"))) {
            this.cancelValue();
        }
        if (string.equals(PropertyDialogManager.getString("CTL_Default")) && this.prop != null) {
            try {
                this.prop.restoreDefaultValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                PropertyPanel.notifyUser(illegalAccessException, this.prop.getDisplayName());
            }
            catch (InvocationTargetException invocationTargetException) {
                PropertyPanel.notifyUser(invocationTargetException, this.prop.getDisplayName());
            }
        }
        if (string.equals(PropertyDialogManager.getString("CTL_OK"))) {
            if (this.env != null && this.env.getState() == PropertyEnv.STATE_NEEDS_VALIDATION) {
                this.env.setState(PropertyEnv.STATE_VALID);
                if (this.env.getState() != PropertyEnv.STATE_VALID) {
                    return;
                }
            }
            if (this.component instanceof EnhancedCustomPropertyEditor) {
                try {
                    Object object = ((EnhancedCustomPropertyEditor)((Object)this.component)).getPropertyValue();
                    this.model.setValue(object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    PropertyPanel.notifyUser(invocationTargetException, this.prop == null ? "" : this.prop.getDisplayName());
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    PropertyDialogManager.notifyUser(illegalStateException);
                    return;
                }
            }
            if (this.env != null && !this.env.isChangeImmediate()) {
                try {
                    this.model.setValue(this.lastValueFromEditor);
                }
                catch (InvocationTargetException invocationTargetException) {
                    PropertyPanel.notifyUser(invocationTargetException, this.prop == null ? "" : this.prop.getDisplayName());
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    PropertyDialogManager.notifyUser(illegalStateException);
                    return;
                }
            }
            if (!this.okButtonState) {
                if (this.errorPerformer != null) {
                    this.errorPerformer.run();
                }
                return;
            }
        }
        this.changed = false;
        this.dialog.dispose();
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$PropertyDialogManager == null ? (class$org$openide$explorer$propertysheet$PropertyDialogManager = PropertyDialogManager.class$("org.openide.explorer.propertysheet.PropertyDialogManager")) : class$org$openide$explorer$propertysheet$PropertyDialogManager).getString(string);
    }

    static void notify(Throwable throwable) {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = PropertyDialogManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        if (errorManager != null) {
            errorManager.notify(throwable);
        } else {
            throwable.printStackTrace();
        }
    }

    static void notify(int n, Throwable throwable) {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = PropertyDialogManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        if (errorManager != null) {
            errorManager.notify(n, throwable);
        } else {
            throwable.printStackTrace();
        }
    }

    private static void notifyUser(Exception exception) {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = PropertyDialogManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        if (errorManager != null) {
            ErrorManager.Annotation[] annotationArray = errorManager.findAnnotations(exception);
            String string = null;
            if (annotationArray != null) {
                int n = 0;
                while (n < annotationArray.length) {
                    String string2 = annotationArray[n].getLocalizedMessage();
                    if (string2 != null) {
                        string = string2;
                        break;
                    }
                    ++n;
                }
            }
            if (string == null) {
                string = exception.getLocalizedMessage();
            }
            if (string != null) {
                Throwable throwable = errorManager.annotate((Throwable)exception, string);
                errorManager.notify(256, throwable);
            } else {
                errorManager.notify(1, exception);
            }
        }
    }

    static Throwable annotate(Throwable throwable, int n, String string, String string2, Throwable throwable2, Date date) {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = PropertyDialogManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        if (errorManager != null) {
            return errorManager.annotate(throwable, n, string, string2, throwable2, date);
        }
        return throwable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class CreateDialogInvoker
    implements Runnable {
        CreateDialogInvoker() {
        }

        public void run() {
            PropertyDialogManager propertyDialogManager = (PropertyDialogManager)caller.get();
            caller.set(null);
            if (propertyDialogManager == null) {
                throw new IllegalStateException("Parameter caller not passed.");
            }
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyDialogManager.component, propertyDialogManager.title, propertyDialogManager.isModal, propertyDialogManager.options, propertyDialogManager.defaultOption, 0, null, propertyDialogManager.actionListener);
            propertyDialogManager.dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        }
    }
}

