/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.IndexedEditorPanel;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.IndexedNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

class IndexedPropertyEditor
implements ExPropertyEditor {
    private Object[] array;
    private PropertyEnv env;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private Node.IndexedProperty indexedProperty = null;
    private IndexedEditorPanel currentEditorPanel;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$IndexedPropertyEditor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (!(featureDescriptor instanceof Node.IndexedProperty)) {
            throw new IllegalStateException("This is not an array: " + featureDescriptor);
        }
        this.indexedProperty = (Node.IndexedProperty)featureDescriptor;
    }

    public void setValue(Object object) {
        if (object == null) {
            this.array = null;
            this.firePropertyChange();
            return;
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException(this.env != null ? "Property which value is not an array " + this.env.getFeatureDescriptor().getName() : "Unknown property - not attached yet.");
        }
        if (object.getClass().getComponentType().isPrimitive()) {
            this.array = Utilities.toObjectArray(object);
        } else {
            this.array = (Object[])Array.newInstance(object.getClass().getComponentType(), ((Object[])object).length);
            System.arraycopy(object, 0, this.array, 0, this.array.length);
        }
        this.firePropertyChange();
    }

    public Object getValue() {
        if (this.array == null) {
            return null;
        }
        if (this.indexedProperty.getElementType().isPrimitive()) {
            return Utilities.toPrimitiveArray(this.array);
        }
        return this.array;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString(int n) {
        if (this.array[n] == null) {
            return "null";
        }
        try {
            this.indexedProperty.getIndexedPropertyEditor().setValue(this.array[n]);
            return this.indexedProperty.getIndexedPropertyEditor().getJavaInitializationString();
        }
        catch (NullPointerException nullPointerException) {
            return "null";
        }
    }

    public String getJavaInitializationString() {
        if (this.array == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("new ");
        stringBuffer.append(this.indexedProperty.getElementType().getName());
        if (this.array.length == 0) {
            stringBuffer.append("[0]");
        } else {
            stringBuffer.append("[] {\n\t");
            int n = 0;
            while (n < this.array.length) {
                try {
                    this.indexedProperty.getIndexedPropertyEditor().setValue(this.array[n]);
                    stringBuffer.append(this.indexedProperty.getIndexedPropertyEditor().getJavaInitializationString());
                }
                catch (NullPointerException nullPointerException) {
                    stringBuffer.append("null");
                }
                if (n != this.array.length - 1) {
                    stringBuffer.append(",\n\t");
                } else {
                    stringBuffer.append("\n");
                }
                ++n;
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public String getAsText() {
        if (this.array == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        PropertyEditor propertyEditor = null;
        if (this.indexedProperty != null) {
            propertyEditor = this.indexedProperty.getIndexedPropertyEditor();
        }
        int n = 0;
        while (n < this.array.length) {
            if (propertyEditor != null) {
                propertyEditor.setValue(this.array[n]);
                stringBuffer.append(propertyEditor.getJavaInitializationString());
            } else {
                stringBuffer.append("null");
            }
            if (n != this.array.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string.equals("null")) {
            this.setValue(null);
            return;
        }
        if (string.equals("[]")) {
            this.setValue(Array.newInstance(this.indexedProperty.getElementType(), 0));
            return;
        }
        int n = string.indexOf(91);
        n = n < 0 || n + 1 >= string.length() ? 0 : ++n;
        int n2 = string.lastIndexOf(93);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n2 < n || n2 > string.length()) {
            return;
        }
        try {
            Object[] objectArray;
            string = string.substring(n, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (stringTokenizer.hasMoreTokens()) {
                objectArray = stringTokenizer.nextToken();
                PropertyEditor propertyEditor = this.indexedProperty.getIndexedPropertyEditor();
                propertyEditor.setAsText(objectArray.trim());
                linkedList.add(propertyEditor.getValue());
            }
            objectArray = linkedList.toArray((Object[])Array.newInstance(this.getConvertedType(), linkedList.size()));
            this.setValue(objectArray);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            PropertyDialogManager.annotate(illegalArgumentException, 256, IndexedPropertyEditor.getString("EXC_ErrorInIndexedSetter"), IndexedPropertyEditor.getString("EXC_ErrorInIndexedSetter"), exception, new Date());
            throw illegalArgumentException;
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.array == null) {
            this.array = (Object[])Array.newInstance(this.getConvertedType(), 0);
            this.firePropertyChange();
        }
        DisplayIndexedNode displayIndexedNode = new DisplayIndexedNode(0);
        Node.Property property = ((Node)displayIndexedNode).getPropertySets()[0].getProperties()[0];
        Node.Property[] propertyArray = new Node.Property[]{property};
        this.currentEditorPanel = new IndexedEditorPanel(this.createRootNode(), propertyArray);
        return this.currentEditorPanel;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    private Node createRootNode() {
        Node[] nodeArray = new DisplayIndexedNode[this.array.length];
        int n = 0;
        while (n < nodeArray.length) {
            nodeArray[n] = new DisplayIndexedNode(n);
            ++n;
        }
        MyIndexedRootNode myIndexedRootNode = new MyIndexedRootNode(nodeArray);
        Index index = (Index)myIndexedRootNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = IndexedPropertyEditor.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        int n2 = 0;
        while (n2 < nodeArray.length) {
            index.addChangeListener(WeakListener.change((ChangeListener)((Object)nodeArray[n2]), index));
            ++n2;
        }
        return myIndexedRootNode;
    }

    private Class getConvertedType() {
        Class clazz = this.indexedProperty.getElementType();
        if (clazz.isPrimitive()) {
            clazz = Utilities.getObjectType(clazz);
        }
        return clazz;
    }

    void firePropertyChange() {
        this.propertySupport.firePropertyChange("value", null, null);
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedPropertyEditor == null ? (class$org$openide$explorer$propertysheet$IndexedPropertyEditor = IndexedPropertyEditor.class$("org.openide.explorer.propertysheet.IndexedPropertyEditor")) : class$org$openide$explorer$propertysheet$IndexedPropertyEditor).getString(string);
    }

    private Object defaultValue() {
        Constable constable = null;
        if (this.indexedProperty.getElementType().isPrimitive()) {
            if (this.getConvertedType().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = IndexedPropertyEditor.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                constable = new Integer(0);
            }
            if (this.getConvertedType().equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = IndexedPropertyEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                constable = Boolean.FALSE;
            }
            if (this.getConvertedType().equals(class$java$lang$Byte == null ? (class$java$lang$Byte = IndexedPropertyEditor.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                constable = new Byte(0);
            }
            if (this.getConvertedType().equals(class$java$lang$Character == null ? (class$java$lang$Character = IndexedPropertyEditor.class$("java.lang.Character")) : class$java$lang$Character)) {
                constable = new Character('\u0000');
            }
            if (this.getConvertedType().equals(class$java$lang$Double == null ? (class$java$lang$Double = IndexedPropertyEditor.class$("java.lang.Double")) : class$java$lang$Double)) {
                constable = new Double(0.0);
            }
            if (this.getConvertedType().equals(class$java$lang$Float == null ? (class$java$lang$Float = IndexedPropertyEditor.class$("java.lang.Float")) : class$java$lang$Float)) {
                constable = new Float(0.0f);
            }
            if (this.getConvertedType().equals(class$java$lang$Long == null ? (class$java$lang$Long = IndexedPropertyEditor.class$("java.lang.Long")) : class$java$lang$Long)) {
                constable = new Long(0L);
            }
            if (this.getConvertedType().equals(class$java$lang$Short == null ? (class$java$lang$Short = IndexedPropertyEditor.class$("java.lang.Short")) : class$java$lang$Short)) {
                constable = new Short(0);
            }
        } else {
            try {
                constable = (Constable)this.getConvertedType().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return constable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Object[] access$102(IndexedPropertyEditor indexedPropertyEditor, Object[] objectArray) {
        indexedPropertyEditor.array = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object access$900(IndexedPropertyEditor indexedPropertyEditor) {
        return indexedPropertyEditor.defaultValue();
    }

    private class MyIndexedRootNode
    extends IndexedNode {
        public MyIndexedRootNode(Node[] nodeArray) {
            this.getChildren().add(nodeArray);
            this.setName("IndexedRoot");
            this.setDisplayName(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedPropertyEditor == null ? (class$org$openide$explorer$propertysheet$IndexedPropertyEditor = IndexedPropertyEditor.class$("org.openide.explorer.propertysheet.IndexedPropertyEditor")) : class$org$openide$explorer$propertysheet$IndexedPropertyEditor).getString("CTL_Index"));
        }

        public NewType[] getNewTypes() {
            NewType newType = new NewType(this){
                private final /* synthetic */ MyIndexedRootNode this$1;
                {
                    this.this$1 = myIndexedRootNode;
                }

                public void create() {
                    Object object;
                    if (IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)) != null) {
                        object = (Object[])Array.newInstance(IndexedPropertyEditor.access$000(MyIndexedRootNode.access$800(this.this$1)), IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)).length + 1);
                        System.arraycopy(IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)), 0, object, 0, IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)).length);
                        IndexedPropertyEditor.access$102(MyIndexedRootNode.access$800(this.this$1), object);
                        IndexedPropertyEditor.access$100((IndexedPropertyEditor)MyIndexedRootNode.access$800((MyIndexedRootNode)this.this$1))[IndexedPropertyEditor.access$100((IndexedPropertyEditor)MyIndexedRootNode.access$800((MyIndexedRootNode)this.this$1)).length - 1] = IndexedPropertyEditor.access$900(MyIndexedRootNode.access$800(this.this$1));
                    } else {
                        IndexedPropertyEditor.access$102(MyIndexedRootNode.access$800(this.this$1), (Object[])Array.newInstance(IndexedPropertyEditor.access$000(MyIndexedRootNode.access$800(this.this$1)), 1));
                        IndexedPropertyEditor.access$100((IndexedPropertyEditor)MyIndexedRootNode.access$800((MyIndexedRootNode)this.this$1))[0] = IndexedPropertyEditor.access$900(MyIndexedRootNode.access$800(this.this$1));
                    }
                    MyIndexedRootNode.access$800(this.this$1).firePropertyChange();
                    object = MyIndexedRootNode.access$800(this.this$1).new DisplayIndexedNode(IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)).length - 1);
                    this.this$1.getChildren().add(new Node[]{object});
                    Index index = (Index)this.this$1.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = IndexedPropertyEditor.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
                    index.addChangeListener(WeakListener.change((ChangeListener)object, index));
                }
            };
            return new NewType[]{newType};
        }

        static /* synthetic */ IndexedPropertyEditor access$800(MyIndexedRootNode myIndexedRootNode) {
            return myIndexedRootNode.IndexedPropertyEditor.this;
        }
    }

    class DisplayIndexedNode
    extends AbstractNode
    implements ChangeListener {
        private int index;

        public DisplayIndexedNode(int n) {
            super(Children.LEAF);
            this.index = n;
            this.setName(Integer.toString(n));
            this.setDisplayName(Integer.toString(n));
        }

        protected SystemAction[] createActions() {
            try {
                return new SystemAction[]{SystemAction.get(Class.forName("org.openide.actions.MoveUpAction")), SystemAction.get(Class.forName("org.openide.actions.MoveDownAction"))};
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set set = sheet.get("properties");
            if (set == null) {
                set = Sheet.createPropertiesSet();
                sheet.put(set);
            }
            set.put(new ValueProp());
            return sheet;
        }

        public void destroy() throws IOException {
            Object[] objectArray = (Object[])Array.newInstance(IndexedPropertyEditor.this.getConvertedType(), IndexedPropertyEditor.this.array.length - 1);
            System.arraycopy(IndexedPropertyEditor.this.array, 0, objectArray, 0, this.index);
            System.arraycopy(IndexedPropertyEditor.this.array, this.index + 1, objectArray, this.index, IndexedPropertyEditor.this.array.length - this.index - 1);
            IndexedPropertyEditor.access$102(IndexedPropertyEditor.this, objectArray);
            IndexedPropertyEditor.this.firePropertyChange();
            if (IndexedPropertyEditor.this.currentEditorPanel != null) {
                IndexedPropertyEditor.this.currentEditorPanel.getExplorerManager().setRootContext(IndexedPropertyEditor.this.createRootNode());
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            Node node = this.getParentNode();
            Index index = (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = IndexedPropertyEditor.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
            if (index != null && (n = index.indexOf(this)) != this.index) {
                if (n > this.index) {
                    Object object = IndexedPropertyEditor.this.array[this.index];
                    ((IndexedPropertyEditor)IndexedPropertyEditor.this).array[this.index] = IndexedPropertyEditor.this.array[n];
                    ((IndexedPropertyEditor)IndexedPropertyEditor.this).array[n] = object;
                }
                this.index = n;
                this.firePropertyChange(null, null, null);
                this.setDisplayName(Integer.toString(this.index));
                IndexedPropertyEditor.this.firePropertyChange();
            }
        }

        private class ValueProp
        extends PropertySupport {
            public ValueProp() {
                super(IndexedPropertyEditor.this.indexedProperty.getName(), IndexedPropertyEditor.this.indexedProperty.getElementType(), IndexedPropertyEditor.this.indexedProperty.getDisplayName(), IndexedPropertyEditor.this.indexedProperty.getShortDescription(), IndexedPropertyEditor.this.indexedProperty.canRead(), IndexedPropertyEditor.this.indexedProperty.canWrite());
            }

            public Object getValue() {
                if (DisplayIndexedNode.this.index < IndexedPropertyEditor.this.array.length) {
                    return IndexedPropertyEditor.this.array[DisplayIndexedNode.this.index];
                }
                return null;
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                Object object2 = IndexedPropertyEditor.this.array[DisplayIndexedNode.this.index];
                ((IndexedPropertyEditor)((DisplayIndexedNode)DisplayIndexedNode.this).IndexedPropertyEditor.this).array[((DisplayIndexedNode)DisplayIndexedNode.this).index] = object;
                DisplayIndexedNode.super.firePropertyChange(this.getName(), object2, object);
                IndexedPropertyEditor.this.firePropertyChange();
            }

            public PropertyEditor getPropertyEditor() {
                return IndexedPropertyEditor.this.indexedProperty.getIndexedPropertyEditor();
            }
        }
    }
}

