/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.util.WeakListener;

public class DefaultPropertyModel
implements ExPropertyModel,
PropertyChangeListener {
    private Object bean;
    private String propertyName;
    private PropertyChangeSupport support;
    private BeanInfo beanInfo;
    private PropertyDescriptor prop;
    private Method readMethod;
    private Method writeMethod;
    private Class propertyTypeClass;
    private boolean donotfire = false;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public DefaultPropertyModel(Object object, String string) throws IllegalArgumentException {
        this.bean = object;
        this.propertyName = string;
        this.support = new PropertyChangeSupport(this);
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DefaultPropertyModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
            method.invoke(object, WeakListener.propertyChange(this, object));
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getName().equals(string)) {
                    this.prop = propertyDescriptorArray[n];
                    this.propertyTypeClass = this.prop.getPropertyType();
                    this.readMethod = this.prop.getReadMethod();
                    this.writeMethod = this.prop.getWriteMethod();
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            PropertyDialogManager.notify(1, exception);
        }
        if (this.prop == null) {
            throw new IllegalArgumentException();
        }
    }

    public Class getPropertyType() {
        return this.propertyTypeClass;
    }

    public Object getValue() throws InvocationTargetException {
        try {
            return this.readMethod == null ? null : this.readMethod.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            PropertyDialogManager.notify(1, illegalAccessException);
            throw new InvocationTargetException(illegalAccessException);
        }
    }

    public void setValue(Object object) throws InvocationTargetException {
        try {
            if (this.writeMethod != null) {
                this.donotfire = true;
                this.writeMethod.invoke(this.bean, object);
                this.donotfire = false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            PropertyDialogManager.notify(1, illegalAccessException);
            throw new InvocationTargetException(illegalAccessException);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.propertyName.equals(propertyChangeEvent.getPropertyName()) && !this.donotfire) {
            this.support.firePropertyChange("value", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public Class getPropertyEditorClass() {
        return this.prop.getPropertyEditorClass();
    }

    public Object[] getBeans() {
        return new Object[]{this.bean};
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.prop;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

