/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.io.SafeException;

public final class ExplorerManager
implements Serializable,
Cloneable {
    static final long serialVersionUID = -4330330689803575792L;
    public static final String PROP_ROOT_CONTEXT = "rootContext";
    public static final String PROP_EXPLORED_CONTEXT = "exploredContext";
    public static final String PROP_SELECTED_NODES = "selectedNodes";
    public static final String PROP_NODE_CHANGE = "nodeChange";
    private transient VetoableChangeSupport vetoableSupport;
    private transient PropertyChangeSupport propertySupport;
    private Node rootContext;
    private Node exploredContext;
    private Node[] selectedNodes;
    private transient Listener listener;
    private transient NodeListener weakListener;
    static RequestProcessor selectionProcessor;
    private static final int SELECTION_SYNC_DELAY = 200;
    private RequestProcessor.Task selectionSyncTask;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$openide$nodes$Node$Handle;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerManager;

    public ExplorerManager() {
        this.init();
    }

    private void init() {
        this.exploredContext = this.rootContext = Node.EMPTY;
        this.selectedNodes = new Node[0];
        this.listener = new Listener();
        this.weakListener = WeakListener.node(this.listener, null);
    }

    public Object clone() {
        ExplorerManager explorerManager = new ExplorerManager();
        explorerManager.rootContext = this.rootContext;
        explorerManager.exploredContext = this.exploredContext;
        explorerManager.selectedNodes = this.selectedNodes;
        return explorerManager;
    }

    public Node[] getSelectedNodes() {
        return this.selectedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSelectedNodes(Node[] nodeArray) throws PropertyVetoException {
        Node[] nodeArray2;
        ExplorerManager explorerManager = this;
        synchronized (explorerManager) {
            Node node;
            if (nodeArray == null) {
                throw new IllegalArgumentException(ExplorerManager.getString("EXC_NodeCannotBeNull"));
            }
            if (Arrays.equals(nodeArray, this.selectedNodes)) {
                return;
            }
            int n = 0;
            while (n < nodeArray.length) {
                if (nodeArray[n] == null) {
                    throw new IllegalArgumentException(ExplorerManager.getString("EXC_NoElementOfNodeSelectionMayBeNull"));
                }
                if (!this.isUnderRoot(nodeArray[n])) {
                    throw new IllegalArgumentException(MessageFormat.format(ExplorerManager.getString("EXC_NodeSelectionCannotContainNodes"), nodeArray[n].getDisplayName(), this.rootContext.getDisplayName()));
                }
                ++n;
            }
            if (nodeArray.length != 0 && this.vetoableSupport != null) {
                this.vetoableSupport.fireVetoableChange(PROP_SELECTED_NODES, this.selectedNodes, nodeArray);
            }
            nodeArray2 = this.selectedNodes;
            LinkedList<Node> linkedList = new LinkedList<Node>();
            List<Node> list = Arrays.asList(nodeArray2);
            int n2 = 0;
            while (n2 < nodeArray.length) {
                linkedList.add(nodeArray[n2]);
                ++n2;
            }
            LinkedList linkedList2 = new LinkedList(linkedList);
            linkedList2.removeAll(list);
            LinkedList<Node> linkedList3 = new LinkedList<Node>(list);
            linkedList3.removeAll(linkedList);
            if (linkedList.size() == nodeArray.length) {
                this.selectedNodes = nodeArray;
            } else {
                this.selectedNodes = new Node[nodeArray.length];
                linkedList.toArray(this.selectedNodes);
            }
            Iterator iterator = linkedList3.iterator();
            while (iterator.hasNext()) {
                node = (Node)iterator.next();
                node.removeNodeListener(this.weakListener);
            }
            iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                node = (Node)iterator.next();
                node.addNodeListener(this.weakListener);
            }
        }
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_SELECTED_NODES, nodeArray2, this.selectedNodes);
        }
    }

    public final Node getExploredContext() {
        return this.exploredContext;
    }

    public final void setExploredContext(Node node) {
        this.setExploredContext(node, new Node[0]);
    }

    public final void setExploredContext(Node node, Node[] nodeArray) {
        if (Utilities.compareObjects(node, this.exploredContext)) {
            this.setSelectedNodes0(nodeArray);
            return;
        }
        if (node != null && !this.isUnderRoot(node)) {
            throw new IllegalArgumentException(MessageFormat.format(ExplorerManager.getString("EXC_ContextMustBeWithinRootContext"), node.getDisplayName(), this.rootContext.getDisplayName()));
        }
        this.setSelectedNodes0(nodeArray);
        Node node2 = this.exploredContext;
        this.exploredContext = node;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_EXPLORED_CONTEXT, node2, this.exploredContext);
        }
    }

    public final void setExploredContextAndSelection(Node node, Node[] nodeArray) throws PropertyVetoException {
        if (Utilities.compareObjects(node, this.exploredContext)) {
            this.setSelectedNodes1(nodeArray);
            return;
        }
        if (node != null && !this.isUnderRoot(node)) {
            throw new IllegalArgumentException(MessageFormat.format(ExplorerManager.getString("EXC_ContextMustBeWithinRootContext"), node.getDisplayName(), this.rootContext.getDisplayName()));
        }
        this.setSelectedNodes1(nodeArray);
        Node node2 = this.exploredContext;
        this.exploredContext = node;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_EXPLORED_CONTEXT, node2, this.exploredContext);
        }
    }

    final void setSelectedNodes0(Node[] nodeArray) {
        block3: {
            try {
                this.setSelectedNodes(nodeArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                if (nodeArray.length != 0) break block3;
                IllegalStateException illegalStateException = new IllegalStateException(ExplorerManager.getString("EXC_MustNotVetoEmptySelection"));
                ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ExplorerManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                if (errorManager != null) {
                    errorManager.annotate((Throwable)illegalStateException, propertyVetoException);
                }
                throw illegalStateException;
            }
        }
    }

    private void setSelectedNodes1(Node[] nodeArray) throws PropertyVetoException {
        try {
            this.setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (nodeArray.length == 0) {
                IllegalStateException illegalStateException = new IllegalStateException(ExplorerManager.getString("EXC_MustNotVetoEmptySelection"));
                ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ExplorerManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                if (errorManager != null) {
                    errorManager.annotate((Throwable)illegalStateException, propertyVetoException);
                }
                throw illegalStateException;
            }
            throw propertyVetoException;
        }
    }

    public final Node getRootContext() {
        return this.rootContext;
    }

    public final void setRootContext(Node node) {
        Node[] nodeArray;
        if (node == null) {
            throw new IllegalArgumentException(ExplorerManager.getString("EXC_CannotHaveNullRootContext"));
        }
        if (this.rootContext.equals(node)) {
            return;
        }
        Node node2 = this.rootContext;
        this.rootContext = node;
        node2.removeNodeListener(this.weakListener);
        this.rootContext.addNodeListener(this.weakListener);
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_ROOT_CONTEXT, node2, this.rootContext);
        }
        if (!this.areUnderTarget(nodeArray = this.getSelectedNodes(), this.rootContext)) {
            nodeArray = new Node[]{};
        }
        this.setExploredContext(this.rootContext, nodeArray);
    }

    private boolean areUnderTarget(Node[] nodeArray, Node node) {
        int n = 0;
        while (n < nodeArray.length) {
            block3: {
                Node node2 = nodeArray[n];
                while (node2 != null) {
                    if (!node2.equals(node)) {
                        node2 = node2.getParentNode();
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertySupport != null) {
            this.propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableSupport == null) {
            this.vetoableSupport = new VetoableChangeSupport(this);
        }
        this.vetoableSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableSupport != null) {
            this.vetoableSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    private boolean isUnderRoot(Node node) {
        while (node != null) {
            if (node.equals(this.rootContext)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        Node.Handle handle = this.rootContext.getHandle();
        putField.put("root", handle);
        putField.put("rootName", this.rootContext.getDisplayName());
        if (handle != null) {
            String[] stringArray = this.exploredContext == null ? null : (this.isUnderRoot(this.exploredContext) ? NodeOp.createPath(this.exploredContext, this.rootContext) : null);
            putField.put("explored", stringArray);
            LinkedList<String[]> linkedList = new LinkedList<String[]>();
            int n = 0;
            while (n < this.selectedNodes.length) {
                if (this.isUnderRoot(this.selectedNodes[n])) {
                    linkedList.add(NodeOp.createPath(this.selectedNodes[n], this.rootContext));
                }
                ++n;
            }
            putField.put("selected", linkedList.toArray());
        }
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        MyValidation myValidation;
        this.init();
        Object object = objectInputStream.readObject();
        if (object != this) {
            this.readObjectOld((Node.Handle)object, objectInputStream);
            return;
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Node.Handle handle = (Node.Handle)getField.get("root", null);
        final String string = (String)getField.get("rootName", null);
        if (handle == null) {
            throw new SafeException(new IOException(NbBundle.getMessage(class$org$openide$explorer$ExplorerManager == null ? (class$org$openide$explorer$ExplorerManager = ExplorerManager.class$("org.openide.explorer.ExplorerManager")) : class$org$openide$explorer$ExplorerManager, "EXC_cannot_deser_null_handle", string)));
        }
        String[] stringArray = (String[])getField.get("explored", null);
        Object[] objectArray = (Object[])getField.get("selected", null);
        List<Object> list = Arrays.asList(objectArray);
        try {
            Node node = handle.getNode();
            if (node == null) {
                throw new IOException("Node.Handle.getNode (for " + string + ") may not return null");
            }
            myValidation = new MyValidation(node, stringArray, list);
        }
        catch (IOException iOException) {
            if (!Utilities.compareObjects(iOException.getMessage(), iOException.getLocalizedMessage())) {
                throw new SafeException(iOException);
            }
            throw new SafeException(iOException){

                public String getLocalizedMessage() {
                    return NbBundle.getMessage(class$org$openide$explorer$ExplorerManager == null ? (class$org$openide$explorer$ExplorerManager = ExplorerManager.class$("org.openide.explorer.ExplorerManager")) : class$org$openide$explorer$ExplorerManager, "EXC_handle_failed", string);
                }
            };
        }
        objectInputStream.registerValidation(myValidation, 10);
    }

    private void readObjectOld(Node.Handle handle, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        if (handle == null) {
            return;
        }
        String[] stringArray = (String[])objectInputStream.readObject();
        String[] stringArray2 = (String[])objectInputStream.readObject();
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        while ((object = (String[])objectInputStream.readObject()) != null) {
            linkedList.add((String[])object);
        }
        object = ExplorerManager.findPath(handle.getNode(), stringArray);
        MyValidation myValidation = new MyValidation((Node)object, stringArray2, linkedList);
        objectInputStream.registerValidation(myValidation, 10);
    }

    public static ExplorerManager find(Component component) {
        do {
            if ((component = component.getParent()) != null) continue;
            return new ExplorerManager();
        } while (!(component instanceof Provider));
        return ((Provider)((Object)component)).getExplorerManager();
    }

    static Node findPath(Node node, String[] stringArray) {
        try {
            return NodeOp.findPath(node, stringArray);
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            return nodeNotFoundException.getClosestNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RequestProcessor getSelectionProcessor() {
        if (selectionProcessor != null) {
            return selectionProcessor;
        }
        Class clazz = class$org$openide$explorer$ExplorerManager == null ? (class$org$openide$explorer$ExplorerManager = ExplorerManager.class$("org.openide.explorer.ExplorerManager")) : class$org$openide$explorer$ExplorerManager;
        synchronized (clazz) {
            block5: {
                if (selectionProcessor == null) break block5;
                RequestProcessor requestProcessor = selectionProcessor;
                return requestProcessor;
            }
            RequestProcessor requestProcessor = selectionProcessor = new RequestProcessor("ExplorerManager-selection");
            return requestProcessor;
        }
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$ExplorerManager == null ? (class$org$openide$explorer$ExplorerManager = ExplorerManager.class$("org.openide.explorer.ExplorerManager")) : class$org$openide$explorer$ExplorerManager).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class.forName("org.openide.util.actions.CallbackSystemAction");
        }
        catch (Exception exception) {
            // empty catch block
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("root", class$org$openide$nodes$Node$Handle == null ? (class$org$openide$nodes$Node$Handle = ExplorerManager.class$("org.openide.nodes.Node$Handle")) : class$org$openide$nodes$Node$Handle), new ObjectStreamField("rootName", class$java$lang$String == null ? (class$java$lang$String = ExplorerManager.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("explored", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ExplorerManager.class$("[Ljava.lang.String;")) : array$Ljava$lang$String), new ObjectStreamField("selected", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = ExplorerManager.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)};
    }

    private final class MyValidation
    implements ObjectInputValidation,
    Runnable {
        Node rootCtx;
        String[] exploredCtx;
        List selNodes;

        public MyValidation(Node node, String[] stringArray, List list) {
            this.rootCtx = node;
            this.exploredCtx = stringArray;
            this.selNodes = list;
        }

        public void validateObject() {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ExplorerManager explorerManager = ExplorerManager.this;
            synchronized (explorerManager) {
                Object[] objectArray;
                ExplorerManager.this.setRootContext(this.rootCtx);
                ListIterator<Node> listIterator = this.selNodes.listIterator();
                while (listIterator.hasNext()) {
                    objectArray = (String[])listIterator.next();
                    listIterator.set(ExplorerManager.findPath(this.rootCtx, (String[])objectArray));
                }
                objectArray = this.selNodes.toArray(new Node[this.selNodes.size()]);
                if (this.exploredCtx != null) {
                    ExplorerManager.this.setExploredContext(ExplorerManager.findPath(this.rootCtx, this.exploredCtx), (Node[])objectArray);
                } else {
                    ExplorerManager.this.setSelectedNodes0((Node[])objectArray);
                }
            }
        }
    }

    private class Listener
    extends NodeAdapter
    implements Runnable {
        Collection removeList = new HashSet();

        Listener() {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            if (nodeEvent.getNode().equals(ExplorerManager.this.getRootContext())) {
                ExplorerManager.this.setRootContext(Node.EMPTY);
            } else {
                this.scheduleRemove(nodeEvent.getNode());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ExplorerManager.this.propertySupport != null) {
                ExplorerManager.this.propertySupport.firePropertyChange(ExplorerManager.PROP_NODE_CHANGE, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleRemove(Node node) {
            ExplorerManager explorerManager = ExplorerManager.this;
            synchronized (explorerManager) {
                if (ExplorerManager.this.selectionSyncTask == null) {
                    ExplorerManager.this.selectionSyncTask = ExplorerManager.getSelectionProcessor().create(this);
                } else {
                    ExplorerManager.this.selectionSyncTask.cancel();
                }
            }
            Listener listener = this;
            synchronized (listener) {
                this.removeList.add(node);
            }
            ExplorerManager.this.selectionSyncTask.schedule(200);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Collection collection;
            Listener listener = this;
            synchronized (listener) {
                collection = this.removeList;
                this.removeList = new HashSet();
            }
            LinkedList<Node> linkedList = new LinkedList<Node>(Arrays.asList(ExplorerManager.this.getSelectedNodes()));
            linkedList.removeAll(collection);
            Node[] nodeArray = new Node[linkedList.size()];
            linkedList.toArray(nodeArray);
            ExplorerManager.this.setSelectedNodes0(nodeArray);
        }
    }

    public static interface Provider {
        public ExplorerManager getExplorerManager();
    }
}

