/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Locale;
import java.util.MissingResourceException;
import org.openide.TopManager;
import org.openide.util.NbBundle;

class NbResourceStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL_BOOT_RESOURCE = "nbresboot";
    public static final String PROTOCOL_SYSTEM_RESOURCE = "nbres";
    public static final String PROTOCOL_CURRENT_RESOURCE = "nbrescurr";
    public static final String PROTOCOL_LOCALIZED_BOOT_RESOURCE = "nbresbootloc";
    public static final String PROTOCOL_LOCALIZED_SYSTEM_RESOURCE = "nbresloc";
    public static final String PROTOCOL_LOCALIZED_CURRENT_RESOURCE = "nbrescurrloc";
    static /* synthetic */ Class class$org$openide$execution$NbResourceStreamHandler;

    NbResourceStreamHandler() {
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        if (uRL.getProtocol().equals(PROTOCOL_BOOT_RESOURCE)) {
            return new Connection(uRL, 0, false);
        }
        if (uRL.getProtocol().equals(PROTOCOL_SYSTEM_RESOURCE)) {
            return new Connection(uRL, 1, false);
        }
        if (uRL.getProtocol().equals(PROTOCOL_CURRENT_RESOURCE)) {
            return new Connection(uRL, 2, false);
        }
        if (uRL.getProtocol().equals(PROTOCOL_LOCALIZED_BOOT_RESOURCE)) {
            return new Connection(uRL, 0, true);
        }
        if (uRL.getProtocol().equals(PROTOCOL_LOCALIZED_SYSTEM_RESOURCE)) {
            return new Connection(uRL, 1, true);
        }
        if (uRL.getProtocol().equals(PROTOCOL_LOCALIZED_CURRENT_RESOURCE)) {
            return new Connection(uRL, 2, true);
        }
        throw new IOException(NbBundle.getMessage(class$org$openide$execution$NbResourceStreamHandler == null ? (class$org$openide$execution$NbResourceStreamHandler = NbResourceStreamHandler.class$("org.openide.execution.NbResourceStreamHandler")) : class$org$openide$execution$NbResourceStreamHandler, "EXC_UnrecognizedProtocol"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Connection
    extends URLConnection {
        private final boolean localized;
        private final int current;
        private URLConnection real;
        private IOException exception = null;

        public Connection(URL uRL, int n, boolean bl) {
            super(uRL);
            this.current = n;
            this.localized = bl;
        }

        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException iOException = this.exception;
                this.exception = null;
                throw iOException;
            }
            if (!this.connected) {
                URL uRL;
                ClassLoader classLoader;
                String string = this.url.getFile();
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                switch (this.current) {
                    case 2: {
                        classLoader = TopManager.getDefault().currentClassLoader();
                        if (classLoader != null) break;
                    }
                    case 1: {
                        classLoader = TopManager.getDefault().systemClassLoader();
                        if (classLoader != null) break;
                    }
                    case 0: {
                        classLoader = (class$org$openide$execution$NbResourceStreamHandler == null ? (class$org$openide$execution$NbResourceStreamHandler = NbResourceStreamHandler.class$("org.openide.execution.NbResourceStreamHandler")) : class$org$openide$execution$NbResourceStreamHandler).getClassLoader();
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                if (this.localized) {
                    String string2;
                    String string3;
                    int n = string.lastIndexOf(46);
                    if (n != -1) {
                        string3 = string.substring(n + 1);
                        string2 = string.substring(0, n).replace('/', '.');
                    } else {
                        string3 = null;
                        string2 = string.replace('/', '.');
                    }
                    try {
                        uRL = NbBundle.getLocalizedFile(string2, string3, Locale.getDefault(), classLoader);
                    }
                    catch (MissingResourceException missingResourceException) {
                        throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException(NbBundle.getMessage(class$org$openide$execution$NbResourceStreamHandler == null ? (class$org$openide$execution$NbResourceStreamHandler = NbResourceStreamHandler.class$("org.openide.execution.NbResourceStreamHandler")) : class$org$openide$execution$NbResourceStreamHandler, "EXC_nbres_cannot_connect", this.url)), missingResourceException);
                    }
                } else {
                    uRL = classLoader.getResource(string);
                    if (uRL == null) {
                        throw new IOException(NbBundle.getMessage(class$org$openide$execution$NbResourceStreamHandler == null ? (class$org$openide$execution$NbResourceStreamHandler = NbResourceStreamHandler.class$("org.openide.execution.NbResourceStreamHandler")) : class$org$openide$execution$NbResourceStreamHandler, "EXC_nbres_cannot_connect", this.url));
                    }
                }
                this.real = uRL.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }

        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        public String getHeaderField(String string) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(string);
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }
    }
}

