/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.openide.TopManager;
import org.openide.awt.AWTTask;
import org.openide.awt.MouseUtils;
import org.openide.awt.Toolbar;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.util.Task;

public final class ToolbarPool
extends JComponent
implements Accessible {
    private static ToolbarPool defaultPool;
    private Folder instance;
    private DataFolder folder;
    private Map toolbars;
    private Map toolbarConfigs;
    private String name = "";
    private Component center;
    private PopupListener listener;
    private AccessibleContext accessibleContext = null;
    public static final String DEFAULT_CONFIGURATION = "Standard";
    static final long serialVersionUID = 3420915387298484008L;
    static /* synthetic */ Class class$org$openide$awt$ToolbarPool;
    static /* synthetic */ Class class$org$openide$awt$ToolbarPool$Configuration;
    static /* synthetic */ Class class$java$awt$Component;

    public static synchronized ToolbarPool getDefault() {
        if (defaultPool == null) {
            defaultPool = new ToolbarPool(TopManager.getDefault().getPlaces().folders().toolbars());
            ToolbarPool.defaultPool.instance.recreate();
        }
        return defaultPool;
    }

    public ToolbarPool(DataFolder dataFolder) {
        this.folder = dataFolder;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 3, 0));
        this.listener = new PopupListener();
        this.toolbars = new TreeMap();
        this.toolbarConfigs = new TreeMap();
        this.instance = new Folder(dataFolder);
        this.getAccessibleContext().setAccessibleName(this.instance.instanceName());
        this.getAccessibleContext().setAccessibleDescription(this.instance.instanceName());
    }

    public final void waitFinished() {
        this.instance.instanceFinished();
    }

    void update(Map map, Map map2) {
        this.toolbars = map;
        this.toolbarConfigs = map2;
        this.setConfiguration(this.name);
    }

    private synchronized void updateDefault() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        Toolbar[] toolbarArray = this.getToolbars();
        int n = 0;
        while (n < toolbarArray.length) {
            jPanel.add(toolbarArray[n]);
            ++n;
        }
        this.name = "";
        this.revalidate(jPanel);
    }

    private synchronized void activate(Configuration configuration) {
        Component component = configuration.activate();
        this.name = configuration.getName();
        this.revalidate(component);
    }

    public void setToolbarsListener(Toolbar.DnDListener dnDListener) {
        Iterator iterator = this.toolbars.values().iterator();
        while (iterator.hasNext()) {
            ((Toolbar)iterator.next()).setDnDListener(dnDListener);
        }
    }

    private void revalidate(Component component) {
        if (component != this.center) {
            if (this.center != null) {
                this.remove(this.center);
                this.center.removeMouseListener(this.listener);
            }
            this.center = component;
            this.add(this.center, "Center");
            this.center.addMouseListener(this.listener);
            Window window = SwingUtilities.windowForComponent(this);
            if (window != null) {
                window.validate();
            }
        }
    }

    public final Toolbar findToolbar(String string) {
        return (Toolbar)this.toolbars.get(string);
    }

    public final String getConfiguration() {
        return this.name;
    }

    public final void setConfiguration(String string) {
        String string2 = this.name;
        if (!this.instance.isFinished()) {
            return;
        }
        Configuration configuration = null;
        if (string != null) {
            configuration = (Configuration)this.toolbarConfigs.get(string);
        }
        if (configuration != null) {
            this.activate(configuration);
        } else if (this.toolbarConfigs.isEmpty()) {
            this.updateDefault();
        } else {
            configuration = (Configuration)this.toolbarConfigs.get(DEFAULT_CONFIGURATION);
            if (configuration == null) {
                configuration = (Configuration)this.toolbarConfigs.values().iterator().next();
            }
            this.activate(configuration);
        }
        this.firePropertyChange("configuration", string2, this.name);
    }

    public final DataFolder getFolder() {
        return this.folder;
    }

    public final synchronized Toolbar[] getToolbars() {
        Toolbar[] toolbarArray = new Toolbar[this.toolbars.size()];
        return this.toolbars.values().toArray(toolbarArray);
    }

    public final synchronized String[] getConfigurations() {
        String[] stringArray = new String[this.toolbarConfigs.size()];
        return this.toolbarConfigs.keySet().toArray(stringArray);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.TOOL_BAR;
                }
            };
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ComponentConfiguration
    extends JPopupMenu
    implements Configuration,
    ActionListener {
        private Component comp;
        static final long serialVersionUID = -409474484612485719L;

        ComponentConfiguration() {
        }

        public ComponentConfiguration(Component component) {
            this.comp = component;
        }

        public Component activate() {
            return this.comp;
        }

        public String getName() {
            return this.comp.getName();
        }

        public JPopupMenu getContextMenu() {
            this.removeAll();
            Iterator<String> iterator = Arrays.asList(ToolbarPool.getDefault().getConfigurations()).iterator();
            ButtonGroup buttonGroup = new ButtonGroup();
            String string = ToolbarPool.getDefault().getConfiguration();
            while (iterator.hasNext()) {
                String string2;
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2, (string2 = iterator.next()).compareTo(string) == 0);
                jRadioButtonMenuItem.addActionListener(this);
                buttonGroup.add(jRadioButtonMenuItem);
                this.add(jRadioButtonMenuItem);
            }
            return this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolbarPool.getDefault().setConfiguration(actionEvent.getActionCommand());
        }
    }

    public static interface Configuration {
        public Component activate();

        public String getName();

        public JPopupMenu getContextMenu();
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        PopupListener() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            Configuration configuration = (Configuration)ToolbarPool.this.toolbarConfigs.get(ToolbarPool.this.name);
            if (configuration != null) {
                JPopupMenu jPopupMenu = configuration.getContextMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class Folder
    extends FolderInstance {
        private WeakHashMap foldersCache = new WeakHashMap(15);
        private ToolbarPool toolbarPool;

        public Folder(DataFolder dataFolder) {
            super(dataFolder);
        }

        public String instanceName() {
            return this.instanceClass().getName();
        }

        public Class instanceClass() {
            return class$org$openide$awt$ToolbarPool == null ? (class$org$openide$awt$ToolbarPool = ToolbarPool.class$("org.openide.awt.ToolbarPool")) : class$org$openide$awt$ToolbarPool;
        }

        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Class clazz;
            if ((class$org$openide$awt$ToolbarPool$Configuration == null ? (class$org$openide$awt$ToolbarPool$Configuration = ToolbarPool.class$("org.openide.awt.ToolbarPool$Configuration")) : class$org$openide$awt$ToolbarPool$Configuration).isAssignableFrom(clazz = instanceCookie.instanceClass())) {
                return instanceCookie;
            }
            if ((class$java$awt$Component == null ? (class$java$awt$Component = ToolbarPool.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(clazz)) {
                return instanceCookie;
            }
            return null;
        }

        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            InstanceCookie instanceCookie = (InstanceCookie)this.foldersCache.get(dataFolder);
            if (instanceCookie == null) {
                instanceCookie = new InstanceSupport.Instance(new Toolbar(dataFolder, true));
                this.foldersCache.put(dataFolder, instanceCookie);
            }
            return instanceCookie;
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            int n = instanceCookieArray.length;
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
            int n2 = 0;
            while (n2 < n) {
                try {
                    String string;
                    Object object;
                    Object object2 = instanceCookieArray[n2].instanceCreate();
                    if (object2 instanceof Toolbar) {
                        object = (Toolbar)object2;
                        ((Component)object).removeMouseListener(ToolbarPool.this.listener);
                        ((Component)object).addMouseListener(ToolbarPool.this.listener);
                        treeMap.put(((Component)object).getName(), object);
                    } else if (object2 instanceof Configuration) {
                        object = (Configuration)object2;
                        string = object.getName();
                        if (string == null) {
                            string = instanceCookieArray[n2].instanceName();
                        }
                        treeMap2.put(string, object);
                    } else if (object2 instanceof Component) {
                        object = (Component)object2;
                        string = ((Component)object).getName();
                        if (string == null) {
                            string = instanceCookieArray[n2].instanceName();
                        }
                        treeMap2.put(string, new ComponentConfiguration((Component)object));
                    }
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException(iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    TopManager.getDefault().notifyException(classNotFoundException);
                }
                ++n2;
            }
            ToolbarPool.this.update(treeMap, treeMap2);
            return ToolbarPool.this;
        }

        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable);
        }
    }
}

