/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.BreakIterator;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Keymap;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NotifyDescriptor {
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_MESSAGE_TYPE = "messageType";
    public static final String PROP_OPTION_TYPE = "optionType";
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_VALUE = "value";
    public static final String PROP_TITLE = "title";
    public static final String PROP_DETAIL = "detail";
    public static final String PROP_VALID = "valid";
    private Object message;
    private int messageType = -1;
    private int optionType;
    private Object[] options;
    private Object[] adOptions;
    private Object value;
    private String title;
    private boolean valid = true;
    private PropertyChangeSupport changeSupport;
    public static final Object YES_OPTION = new Integer(0);
    public static final Object NO_OPTION = new Integer(1);
    public static final Object CANCEL_OPTION = new Integer(2);
    public static final Object OK_OPTION = new Integer(0);
    public static final Object CLOSED_OPTION = new Integer(-1);
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private static final int MAXIMUM_TEXT_WIDTH = 100;
    static /* synthetic */ Class class$org$openide$NotifyDescriptor;

    public NotifyDescriptor(Object object, String string, int n, int n2, Object[] objectArray, Object object2) {
        this.message = object;
        this.messageType = n2;
        this.options = objectArray;
        this.optionType = n;
        this.title = string;
        this.value = object2;
    }

    protected void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getterCalled() {
        if (this.changeSupport != null) {
            return;
        }
        boolean bl = false;
        NotifyDescriptor notifyDescriptor = this;
        synchronized (notifyDescriptor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
                bl = true;
            }
        }
        if (bl) {
            this.initialize();
        }
    }

    public final boolean isValid() {
        this.getterCalled();
        return this.valid;
    }

    public final void setValid(boolean bl) {
        boolean bl2 = this.valid;
        this.valid = bl;
        this.firePropertyChange(PROP_VALID, new Boolean(bl2), new Boolean(bl));
    }

    public void setMessage(Object object) {
        Object object2 = this.message;
        this.message = object;
        this.firePropertyChange(PROP_MESSAGE, object2, object);
    }

    public Object getMessage() {
        this.getterCalled();
        return this.message;
    }

    public void setMessageType(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != -1) {
            throw new IllegalArgumentException("Message type must be one of the following: ERROR_MESSAGE, INFORMATION_MESSAGE, WARNING_MESSAGE, QUESTION_MESSAGE or PLAIN_MESSAGE.");
        }
        int n2 = this.messageType;
        this.messageType = n;
        this.firePropertyChange(PROP_MESSAGE_TYPE, new Integer(n2), new Integer(this.messageType));
    }

    public int getMessageType() {
        this.getterCalled();
        return this.messageType;
    }

    public void setOptionType(int n) {
        if (n != -1 && n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Option type must be one of the following: DEFAULT_OPTION, YES_NO_OPTION, YES_NO_CANCEL_OPTION or OK_CANCEL_OPTION.");
        }
        int n2 = this.optionType;
        this.optionType = n;
        this.firePropertyChange(PROP_OPTION_TYPE, new Integer(n2), new Integer(this.optionType));
    }

    public int getOptionType() {
        this.getterCalled();
        return this.optionType;
    }

    public void setOptions(Object[] objectArray) {
        Object[] objectArray2 = this.options;
        this.options = objectArray;
        this.firePropertyChange(PROP_OPTIONS, objectArray2, objectArray);
    }

    public Object[] getOptions() {
        this.getterCalled();
        if (this.options != null) {
            return (Object[])this.options.clone();
        }
        return this.options;
    }

    public void setAdditionalOptions(Object[] objectArray) {
        Object[] objectArray2 = this.adOptions;
        this.adOptions = objectArray;
        this.firePropertyChange(PROP_OPTIONS, objectArray2, objectArray);
    }

    public Object[] getAdditionalOptions() {
        this.getterCalled();
        if (this.adOptions != null) {
            return (Object[])this.adOptions.clone();
        }
        return null;
    }

    public void setValue(Object object) {
        Object object2 = this.value;
        this.value = object;
        this.firePropertyChange(PROP_VALUE, object2, object);
    }

    public Object getValue() {
        this.getterCalled();
        return this.value;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange(PROP_TITLE, string2, string);
    }

    public String getTitle() {
        this.getterCalled();
        return this.title;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getterCalled();
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected static String getTitleForType(int n) {
        switch (n) {
            case 0: {
                return NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("NTF_ErrorTitle");
            }
            case 2: {
                return NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("NTF_WarningTitle");
            }
            case 3: {
                return NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("NTF_QuestionTitle");
            }
            case 1: {
                return NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("NTF_InformationTitle");
            }
            case -1: {
                return NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("NTF_PlainTitle");
            }
        }
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class InputLine
    extends NotifyDescriptor {
        protected JTextField textField;

        public InputLine(String string, String string2) {
            this(string, string2, 2, -1);
        }

        public InputLine(String string, String string2, int n, int n2) {
            super(null, string2, n, n2, null, null);
            super.setMessage(this.createDesign(string));
        }

        public String getInputText() {
            return this.textField.getText();
        }

        public void setInputText(String string) {
            this.textField.setText(string);
            this.textField.selectAll();
        }

        protected Component createDesign(String string) {
            String string2;
            int n;
            char c = '\u0000';
            JPanel jPanel = new JPanel();
            if (string != null && (n = string.indexOf(38)) >= 0 && n + 1 < string.length()) {
                c = string.charAt(n + 1);
                string2 = string.substring(0, n) + string.substring(n + 1);
            } else {
                string2 = string;
            }
            JLabel jLabel = new JLabel(string2);
            if (string2 != null && string2.length() > 0) {
                jLabel.setDisplayedMnemonic(c == '\u0000' ? string.charAt(0) : c);
            }
            jLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(11, 12, 1, 11));
            jPanel.add("West", jLabel);
            this.textField = new JTextField(25);
            jPanel.add("Center", this.textField);
            jLabel.setLabelFor(this.textField);
            this.textField.setBorder(new CompoundBorder(this.textField.getBorder(), new EmptyBorder(2, 0, 2, 0)));
            this.textField.requestFocus();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            Keymap keymap = this.textField.getKeymap();
            keymap.removeKeyStrokeBinding(keyStroke);
            jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("ACSD_InputField"));
            return jPanel;
        }
    }

    public static final class Exception
    extends Confirmation {
        static final long serialVersionUID = -3387516993124229948L;

        public Exception(Throwable throwable) {
            this(throwable, (Object)throwable.getMessage());
            if (throwable instanceof InvocationTargetException) {
                Throwable throwable2 = ((InvocationTargetException)throwable).getTargetException();
                this.setMessage(throwable2);
                if (this.getMessage() == null || "".equals(this.getMessage())) {
                    String string = throwable2.getMessage();
                    string = Utilities.wrapString(string, 100, BreakIterator.getCharacterInstance(), false);
                    this.setMessage(string);
                }
            }
            if (this.getMessage() == null || "".equals(this.getMessage())) {
                this.setMessage(MessageFormat.format(NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("NTF_ExceptionalException"), throwable.getClass().getName()));
                this.setTitle(NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("NTF_ExceptionalExceptionTitle"));
            }
        }

        public Exception(Throwable throwable, Object object) {
            super(object, -1, 0);
            this.setTitle(NbBundle.getBundle(class$org$openide$NotifyDescriptor == null ? (class$org$openide$NotifyDescriptor = NotifyDescriptor.class$("org.openide.NotifyDescriptor")) : class$org$openide$NotifyDescriptor).getString("NTF_ExceptionTitle"));
        }
    }

    public static class Confirmation
    extends NotifyDescriptor {
        public Confirmation(Object object) {
            this(object, 1);
        }

        public Confirmation(Object object, String string) {
            this(object, string, 1);
        }

        public Confirmation(Object object, int n) {
            this(object, n, 3);
        }

        public Confirmation(Object object, String string, int n) {
            this(object, string, n, 3);
        }

        public Confirmation(Object object, int n, int n2) {
            Object[] objectArray;
            String string = NotifyDescriptor.getTitleForType(n2);
            if (n == -1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = OK_OPTION;
            } else {
                objectArray = null;
            }
            super(object, string, n, n2, objectArray, OK_OPTION);
        }

        public Confirmation(Object object, String string, int n, int n2) {
            Object[] objectArray;
            if (n == -1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = OK_OPTION;
            } else {
                objectArray = null;
            }
            super(object, string, n, n2, objectArray, OK_OPTION);
        }
    }

    public static class Message
    extends NotifyDescriptor {
        public Message(Object object) {
            this(object, 1);
        }

        public Message(Object object, int n) {
            super(object, NotifyDescriptor.getTitleForType(n), -1, n, new Object[]{OK_OPTION}, OK_OPTION);
        }
    }
}

