/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaSyntax
extends Syntax {
    private static final int ISI_WHITESPACE = 2;
    private static final int ISI_LINE_COMMENT = 4;
    private static final int ISI_BLOCK_COMMENT = 5;
    private static final int ISI_STRING = 6;
    private static final int ISI_STRING_A_BSLASH = 7;
    private static final int ISI_CHAR = 8;
    private static final int ISI_CHAR_A_BSLASH = 9;
    private static final int ISI_IDENTIFIER = 10;
    private static final int ISA_SLASH = 11;
    private static final int ISA_EQ = 12;
    private static final int ISA_GT = 13;
    private static final int ISA_GTGT = 14;
    private static final int ISA_GTGTGT = 15;
    private static final int ISA_LT = 16;
    private static final int ISA_LTLT = 17;
    private static final int ISA_PLUS = 18;
    private static final int ISA_MINUS = 19;
    private static final int ISA_STAR = 20;
    private static final int ISA_STAR_I_BLOCK_COMMENT = 21;
    private static final int ISA_PIPE = 22;
    private static final int ISA_PERCENT = 23;
    private static final int ISA_AND = 24;
    private static final int ISA_XOR = 25;
    private static final int ISA_EXCLAMATION = 26;
    private static final int ISA_ZERO = 27;
    private static final int ISI_INT = 28;
    private static final int ISI_OCTAL = 29;
    private static final int ISI_DOUBLE = 30;
    private static final int ISI_DOUBLE_EXP = 31;
    private static final int ISI_HEX = 32;
    private static final int ISA_DOT = 33;

    public JavaSyntax() {
        this.tokenContextPath = JavaTokenContext.contextPath;
    }

    protected TokenID parseToken() {
        while (this.offset < this.stopOffset) {
            char c = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (c) {
                        case '\"': {
                            this.state = 6;
                            break block0;
                        }
                        case '\'': {
                            this.state = 8;
                            break block0;
                        }
                        case '/': {
                            this.state = 11;
                            break block0;
                        }
                        case '=': {
                            this.state = 12;
                            break block0;
                        }
                        case '>': {
                            this.state = 13;
                            break block0;
                        }
                        case '<': {
                            this.state = 16;
                            break block0;
                        }
                        case '+': {
                            this.state = 18;
                            break block0;
                        }
                        case '-': {
                            this.state = 19;
                            break block0;
                        }
                        case '*': {
                            this.state = 20;
                            break block0;
                        }
                        case '|': {
                            this.state = 22;
                            break block0;
                        }
                        case '%': {
                            this.state = 23;
                            break block0;
                        }
                        case '&': {
                            this.state = 24;
                            break block0;
                        }
                        case '^': {
                            this.state = 25;
                            break block0;
                        }
                        case '~': {
                            ++this.offset;
                            return JavaTokenContext.NEG;
                        }
                        case '!': {
                            this.state = 26;
                            break block0;
                        }
                        case '0': {
                            this.state = 27;
                            break block0;
                        }
                        case '.': {
                            this.state = 33;
                            break block0;
                        }
                        case ',': {
                            ++this.offset;
                            return JavaTokenContext.COMMA;
                        }
                        case ';': {
                            ++this.offset;
                            return JavaTokenContext.SEMICOLON;
                        }
                        case ':': {
                            ++this.offset;
                            return JavaTokenContext.COLON;
                        }
                        case '?': {
                            ++this.offset;
                            return JavaTokenContext.QUESTION;
                        }
                        case '(': {
                            ++this.offset;
                            return JavaTokenContext.LPAREN;
                        }
                        case ')': {
                            ++this.offset;
                            return JavaTokenContext.RPAREN;
                        }
                        case '[': {
                            ++this.offset;
                            return JavaTokenContext.LBRACKET;
                        }
                        case ']': {
                            ++this.offset;
                            return JavaTokenContext.RBRACKET;
                        }
                        case '{': {
                            ++this.offset;
                            return JavaTokenContext.LBRACE;
                        }
                        case '}': {
                            ++this.offset;
                            return JavaTokenContext.RBRACE;
                        }
                    }
                    if (Character.isWhitespace(c)) {
                        this.state = 2;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        this.state = 28;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        this.state = 10;
                        break;
                    }
                    ++this.offset;
                    return JavaTokenContext.INVALID_CHAR;
                }
                case 2: {
                    if (Character.isWhitespace(c)) break;
                    this.state = -1;
                    return JavaTokenContext.WHITESPACE;
                }
                case 4: {
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            return JavaTokenContext.LINE_COMMENT;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (c) {
                        case '*': {
                            this.state = 21;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (c) {
                        case '\\': {
                            this.state = 7;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = JavaTokenContext.STRING_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\"': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.STRING_LITERAL;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 6;
                    break;
                }
                case 8: {
                    switch (c) {
                        case '\\': {
                            this.state = 9;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = JavaTokenContext.CHAR_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\'': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.CHAR_LITERAL;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (c) {
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 8;
                    break;
                }
                case 10: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.state = -1;
                    TokenID tokenID = JavaSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return tokenID != null ? tokenID : JavaTokenContext.IDENTIFIER;
                }
                case 11: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.DIV_EQ;
                        }
                        case '/': {
                            this.state = 4;
                            break block0;
                        }
                        case '*': {
                            this.state = 5;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.DIV;
                }
                case 12: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            return JavaTokenContext.EQ_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.EQ;
                }
                case 13: {
                    switch (c) {
                        case '>': {
                            this.state = 14;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return JavaTokenContext.GT_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.GT;
                }
                case 14: {
                    switch (c) {
                        case '>': {
                            this.state = 15;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return JavaTokenContext.RSSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.RSSHIFT;
                }
                case 15: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            return JavaTokenContext.RUSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.RUSHIFT;
                }
                case 16: {
                    switch (c) {
                        case '<': {
                            this.state = 17;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return JavaTokenContext.LT_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.LT;
                }
                case 17: {
                    switch (c) {
                        case '<': {
                            this.state = -1;
                            ++this.offset;
                            return JavaTokenContext.INVALID_OPERATOR;
                        }
                        case '=': {
                            ++this.offset;
                            return JavaTokenContext.LSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.LSHIFT;
                }
                case 18: {
                    switch (c) {
                        case '+': {
                            ++this.offset;
                            return JavaTokenContext.PLUS_PLUS;
                        }
                        case '=': {
                            ++this.offset;
                            return JavaTokenContext.PLUS_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.PLUS;
                }
                case 19: {
                    switch (c) {
                        case '-': {
                            ++this.offset;
                            return JavaTokenContext.MINUS_MINUS;
                        }
                        case '=': {
                            ++this.offset;
                            return JavaTokenContext.MINUS_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.MINUS;
                }
                case 20: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            return JavaTokenContext.MUL_EQ;
                        }
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.INVALID_COMMENT_END;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.MUL;
                }
                case 21: {
                    switch (c) {
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.BLOCK_COMMENT;
                        }
                    }
                    --this.offset;
                    this.state = 5;
                    break;
                }
                case 22: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.OR_EQ;
                        }
                        case '|': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.OR_OR;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.OR;
                }
                case 23: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.MOD_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.MOD;
                }
                case 24: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.AND_EQ;
                        }
                        case '&': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.AND_AND;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.AND;
                }
                case 25: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.XOR_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.XOR;
                }
                case 26: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.NOT_EQ;
                        }
                    }
                    this.state = -1;
                    return JavaTokenContext.NOT;
                }
                case 27: {
                    switch (c) {
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                        case 'X': 
                        case 'x': {
                            this.state = 32;
                            break block0;
                        }
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.LONG_LITERAL;
                        }
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.DOUBLE_LITERAL;
                        }
                        case '8': 
                        case '9': {
                            this.state = -1;
                            ++this.offset;
                            return JavaTokenContext.INVALID_OCTAL_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (Character.isDigit(c)) {
                        this.state = 29;
                        break;
                    }
                    this.state = -1;
                    return JavaTokenContext.INT_LITERAL;
                }
                case 28: {
                    switch (c) {
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.LONG_LITERAL;
                        }
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.DOUBLE_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') break;
                    this.state = -1;
                    return JavaTokenContext.INT_LITERAL;
                }
                case 29: {
                    if (c >= '0' && c <= '7') break;
                    this.state = -1;
                    return JavaTokenContext.OCTAL_LITERAL;
                }
                case 30: {
                    switch (c) {
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.DOUBLE_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9' || c == '.') break;
                    this.state = -1;
                    return JavaTokenContext.DOUBLE_LITERAL;
                }
                case 31: {
                    switch (c) {
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return JavaTokenContext.DOUBLE_LITERAL;
                        }
                    }
                    if (Character.isDigit(c) || c == '-' || c == '+') break;
                    this.state = -1;
                    return JavaTokenContext.DOUBLE_LITERAL;
                }
                case 32: {
                    if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || Character.isDigit(c)) break;
                    this.state = -1;
                    return JavaTokenContext.HEX_LITERAL;
                }
                case 33: {
                    if (Character.isDigit(c)) {
                        this.state = 30;
                        break;
                    }
                    this.state = -1;
                    return JavaTokenContext.DOT;
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 2: {
                    this.state = -1;
                    return JavaTokenContext.WHITESPACE;
                }
                case 10: {
                    this.state = -1;
                    TokenID tokenID = JavaSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return tokenID != null ? tokenID : JavaTokenContext.IDENTIFIER;
                }
                case 4: {
                    return JavaTokenContext.LINE_COMMENT;
                }
                case 5: 
                case 21: {
                    return JavaTokenContext.BLOCK_COMMENT;
                }
                case 6: 
                case 7: {
                    return JavaTokenContext.STRING_LITERAL;
                }
                case 8: 
                case 9: {
                    return JavaTokenContext.CHAR_LITERAL;
                }
                case 27: 
                case 28: {
                    this.state = -1;
                    return JavaTokenContext.INT_LITERAL;
                }
                case 29: {
                    this.state = -1;
                    return JavaTokenContext.OCTAL_LITERAL;
                }
                case 30: 
                case 31: {
                    this.state = -1;
                    return JavaTokenContext.DOUBLE_LITERAL;
                }
                case 32: {
                    this.state = -1;
                    return JavaTokenContext.HEX_LITERAL;
                }
                case 33: {
                    this.state = -1;
                    return JavaTokenContext.DOT;
                }
                case 11: {
                    this.state = -1;
                    return JavaTokenContext.DIV;
                }
                case 12: {
                    this.state = -1;
                    return JavaTokenContext.EQ;
                }
                case 13: {
                    this.state = -1;
                    return JavaTokenContext.GT;
                }
                case 14: {
                    this.state = -1;
                    return JavaTokenContext.RSSHIFT;
                }
                case 15: {
                    this.state = -1;
                    return JavaTokenContext.RUSHIFT;
                }
                case 16: {
                    this.state = -1;
                    return JavaTokenContext.LT;
                }
                case 17: {
                    this.state = -1;
                    return JavaTokenContext.LSHIFT;
                }
                case 18: {
                    this.state = -1;
                    return JavaTokenContext.PLUS;
                }
                case 19: {
                    this.state = -1;
                    return JavaTokenContext.MINUS;
                }
                case 20: {
                    this.state = -1;
                    return JavaTokenContext.MUL;
                }
                case 22: {
                    this.state = -1;
                    return JavaTokenContext.OR;
                }
                case 23: {
                    this.state = -1;
                    return JavaTokenContext.MOD;
                }
                case 24: {
                    this.state = -1;
                    return JavaTokenContext.AND;
                }
                case 25: {
                    this.state = -1;
                    return JavaTokenContext.XOR;
                }
                case 26: {
                    this.state = -1;
                    return JavaTokenContext.NOT;
                }
            }
        }
        switch (this.state) {
            case 2: {
                return JavaTokenContext.WHITESPACE;
            }
        }
        return null;
    }

    public String getStateName(int n) {
        switch (n) {
            case 2: {
                return "ISI_WHITESPACE";
            }
            case 4: {
                return "ISI_LINE_COMMENT";
            }
            case 5: {
                return "ISI_BLOCK_COMMENT";
            }
            case 6: {
                return "ISI_STRING";
            }
            case 7: {
                return "ISI_STRING_A_BSLASH";
            }
            case 8: {
                return "ISI_CHAR";
            }
            case 9: {
                return "ISI_CHAR_A_BSLASH";
            }
            case 10: {
                return "ISI_IDENTIFIER";
            }
            case 11: {
                return "ISA_SLASH";
            }
            case 12: {
                return "ISA_EQ";
            }
            case 13: {
                return "ISA_GT";
            }
            case 14: {
                return "ISA_GTGT";
            }
            case 15: {
                return "ISA_GTGTGT";
            }
            case 16: {
                return "ISA_LT";
            }
            case 17: {
                return "ISA_LTLT";
            }
            case 18: {
                return "ISA_PLUS";
            }
            case 19: {
                return "ISA_MINUS";
            }
            case 20: {
                return "ISA_STAR";
            }
            case 21: {
                return "ISA_STAR_I_BLOCK_COMMENT";
            }
            case 22: {
                return "ISA_PIPE";
            }
            case 23: {
                return "ISA_PERCENT";
            }
            case 24: {
                return "ISA_AND";
            }
            case 25: {
                return "ISA_XOR";
            }
            case 26: {
                return "ISA_EXCLAMATION";
            }
            case 27: {
                return "ISA_ZERO";
            }
            case 28: {
                return "ISI_INT";
            }
            case 29: {
                return "ISI_OCTAL";
            }
            case 30: {
                return "ISI_DOUBLE";
            }
            case 31: {
                return "ISI_DOUBLE_EXP";
            }
            case 32: {
                return "ISI_HEX";
            }
            case 33: {
                return "ISA_DOT";
            }
        }
        return super.getStateName(n);
    }

    public static TokenID matchKeyword(char[] cArray, int n, int n2) {
        if (n2 > 12) {
            return null;
        }
        if (n2 <= 1) {
            return null;
        }
        switch (cArray[n++]) {
            case 'a': {
                return n2 == 8 && cArray[n++] == 'b' && cArray[n++] == 's' && cArray[n++] == 't' && cArray[n++] == 'r' && cArray[n++] == 'a' && cArray[n++] == 'c' && cArray[n++] == 't' ? JavaTokenContext.ABSTRACT : null;
            }
            case 'b': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'o': {
                        return n2 == 7 && cArray[n++] == 'o' && cArray[n++] == 'l' && cArray[n++] == 'e' && cArray[n++] == 'a' && cArray[n++] == 'n' ? JavaTokenContext.BOOLEAN : null;
                    }
                    case 'r': {
                        return n2 == 5 && cArray[n++] == 'e' && cArray[n++] == 'a' && cArray[n++] == 'k' ? JavaTokenContext.BREAK : null;
                    }
                    case 'y': {
                        return n2 == 4 && cArray[n++] == 't' && cArray[n++] == 'e' ? JavaTokenContext.BYTE : null;
                    }
                }
                return null;
            }
            case 'c': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        switch (cArray[n++]) {
                            case 's': {
                                return n2 == 4 && cArray[n++] == 'e' ? JavaTokenContext.CASE : null;
                            }
                            case 't': {
                                return n2 == 5 && cArray[n++] == 'c' && cArray[n++] == 'h' ? JavaTokenContext.CATCH : null;
                            }
                        }
                        return null;
                    }
                    case 'h': {
                        return n2 == 4 && cArray[n++] == 'a' && cArray[n++] == 'r' ? JavaTokenContext.CHAR : null;
                    }
                    case 'l': {
                        return n2 == 5 && cArray[n++] == 'a' && cArray[n++] == 's' && cArray[n++] == 's' ? JavaTokenContext.CLASS : null;
                    }
                    case 'o': {
                        if (n2 <= 4) {
                            return null;
                        }
                        if (cArray[n++] != 'n') {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 's': {
                                return n2 == 5 && cArray[n++] == 't' ? JavaTokenContext.CONST : null;
                            }
                            case 't': {
                                return n2 == 8 && cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'u' && cArray[n++] == 'e' ? JavaTokenContext.CONTINUE : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'd': {
                switch (cArray[n++]) {
                    case 'e': {
                        return n2 == 7 && cArray[n++] == 'f' && cArray[n++] == 'a' && cArray[n++] == 'u' && cArray[n++] == 'l' && cArray[n++] == 't' ? JavaTokenContext.DEFAULT : null;
                    }
                    case 'o': {
                        if (n2 == 2) {
                            return JavaTokenContext.DO;
                        }
                        switch (cArray[n++]) {
                            case 'u': {
                                return n2 == 6 && cArray[n++] == 'b' && cArray[n++] == 'l' && cArray[n++] == 'e' ? JavaTokenContext.DOUBLE : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'e': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'l': {
                        return n2 == 4 && cArray[n++] == 's' && cArray[n++] == 'e' ? JavaTokenContext.ELSE : null;
                    }
                    case 'x': {
                        return n2 == 7 && cArray[n++] == 't' && cArray[n++] == 'e' && cArray[n++] == 'n' && cArray[n++] == 'd' && cArray[n++] == 's' ? JavaTokenContext.EXTENDS : null;
                    }
                }
                return null;
            }
            case 'f': {
                if (n2 <= 2) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        return n2 == 5 && cArray[n++] == 'l' && cArray[n++] == 's' && cArray[n++] == 'e' ? JavaTokenContext.FALSE : null;
                    }
                    case 'i': {
                        if (n2 <= 4) {
                            return null;
                        }
                        if (cArray[n++] != 'n' || cArray[n++] != 'a' || cArray[n++] != 'l') {
                            return null;
                        }
                        if (n2 == 5) {
                            return JavaTokenContext.FINAL;
                        }
                        if (n2 <= 6) {
                            return null;
                        }
                        if (cArray[n++] != 'l' || cArray[n++] != 'y') {
                            return null;
                        }
                        if (n2 == 7) {
                            return JavaTokenContext.FINALLY;
                        }
                        return null;
                    }
                    case 'l': {
                        return n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'a' && cArray[n++] == 't' ? JavaTokenContext.FLOAT : null;
                    }
                    case 'o': {
                        return n2 == 3 && cArray[n++] == 'r' ? JavaTokenContext.FOR : null;
                    }
                }
                return null;
            }
            case 'g': {
                return n2 == 4 && cArray[n++] == 'o' && cArray[n++] == 't' && cArray[n++] == 'o' ? JavaTokenContext.GOTO : null;
            }
            case 'i': {
                switch (cArray[n++]) {
                    case 'f': {
                        return n2 == 2 ? JavaTokenContext.IF : null;
                    }
                    case 'm': {
                        if (n2 <= 5) {
                            return null;
                        }
                        if (cArray[n++] != 'p') {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 'l': {
                                return n2 == 10 && cArray[n++] == 'e' && cArray[n++] == 'm' && cArray[n++] == 'e' && cArray[n++] == 'n' && cArray[n++] == 't' && cArray[n++] == 's' ? JavaTokenContext.IMPLEMENTS : null;
                            }
                            case 'o': {
                                return n2 == 6 && cArray[n++] == 'r' && cArray[n++] == 't' ? JavaTokenContext.IMPORT : null;
                            }
                        }
                        return null;
                    }
                    case 'n': {
                        if (n2 <= 2) {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 's': {
                                return n2 == 10 && cArray[n++] == 't' && cArray[n++] == 'a' && cArray[n++] == 'n' && cArray[n++] == 'c' && cArray[n++] == 'e' && cArray[n++] == 'o' && cArray[n++] == 'f' ? JavaTokenContext.INSTANCEOF : null;
                            }
                            case 't': {
                                if (n2 == 3) {
                                    return JavaTokenContext.INT;
                                }
                                switch (cArray[n++]) {
                                    case 'e': {
                                        return n2 == 9 && cArray[n++] == 'r' && cArray[n++] == 'f' && cArray[n++] == 'a' && cArray[n++] == 'c' && cArray[n++] == 'e' ? JavaTokenContext.INTERFACE : null;
                                    }
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'l': {
                return n2 == 4 && cArray[n++] == 'o' && cArray[n++] == 'n' && cArray[n++] == 'g' ? JavaTokenContext.LONG : null;
            }
            case 'n': {
                if (n2 <= 2) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        return n2 == 6 && cArray[n++] == 't' && cArray[n++] == 'i' && cArray[n++] == 'v' && cArray[n++] == 'e' ? JavaTokenContext.NATIVE : null;
                    }
                    case 'e': {
                        return n2 == 3 && cArray[n++] == 'w' ? JavaTokenContext.NEW : null;
                    }
                    case 'u': {
                        return n2 == 4 && cArray[n++] == 'l' && cArray[n++] == 'l' ? JavaTokenContext.NULL : null;
                    }
                }
                return null;
            }
            case 'p': {
                if (n2 <= 5) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        return n2 == 7 && cArray[n++] == 'c' && cArray[n++] == 'k' && cArray[n++] == 'a' && cArray[n++] == 'g' && cArray[n++] == 'e' ? JavaTokenContext.PACKAGE : null;
                    }
                    case 'r': {
                        if (n2 <= 6) {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 'i': {
                                return n2 == 7 && cArray[n++] == 'v' && cArray[n++] == 'a' && cArray[n++] == 't' && cArray[n++] == 'e' ? JavaTokenContext.PRIVATE : null;
                            }
                            case 'o': {
                                return n2 == 9 && cArray[n++] == 't' && cArray[n++] == 'e' && cArray[n++] == 'c' && cArray[n++] == 't' && cArray[n++] == 'e' && cArray[n++] == 'd' ? JavaTokenContext.PROTECTED : null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        return n2 == 6 && cArray[n++] == 'b' && cArray[n++] == 'l' && cArray[n++] == 'i' && cArray[n++] == 'c' ? JavaTokenContext.PUBLIC : null;
                    }
                }
                return null;
            }
            case 'r': {
                return n2 == 6 && cArray[n++] == 'e' && cArray[n++] == 't' && cArray[n++] == 'u' && cArray[n++] == 'r' && cArray[n++] == 'n' ? JavaTokenContext.RETURN : null;
            }
            case 's': {
                if (n2 <= 4) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'h': {
                        return n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'r' && cArray[n++] == 't' ? JavaTokenContext.SHORT : null;
                    }
                    case 't': {
                        if (n2 <= 5) {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 'a': {
                                return n2 == 6 && cArray[n++] == 't' && cArray[n++] == 'i' && cArray[n++] == 'c' ? JavaTokenContext.STATIC : null;
                            }
                            case 'r': {
                                return n2 == 8 && cArray[n++] == 'i' && cArray[n++] == 'c' && cArray[n++] == 't' && cArray[n++] == 'f' && cArray[n++] == 'p' ? JavaTokenContext.STRICTFP : null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        return n2 == 5 && cArray[n++] == 'p' && cArray[n++] == 'e' && cArray[n++] == 'r' ? JavaTokenContext.SUPER : null;
                    }
                    case 'w': {
                        return n2 == 6 && cArray[n++] == 'i' && cArray[n++] == 't' && cArray[n++] == 'c' && cArray[n++] == 'h' ? JavaTokenContext.SWITCH : null;
                    }
                    case 'y': {
                        return n2 == 12 && cArray[n++] == 'n' && cArray[n++] == 'c' && cArray[n++] == 'h' && cArray[n++] == 'r' && cArray[n++] == 'o' && cArray[n++] == 'n' && cArray[n++] == 'i' && cArray[n++] == 'z' && cArray[n++] == 'e' && cArray[n++] == 'd' ? JavaTokenContext.SYNCHRONIZED : null;
                    }
                }
                return null;
            }
            case 't': {
                if (n2 <= 2) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'h': {
                        if (n2 <= 3) {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 'i': {
                                return n2 == 4 && cArray[n++] == 's' ? JavaTokenContext.THIS : null;
                            }
                            case 'r': {
                                if (n2 <= 4) {
                                    return null;
                                }
                                if (cArray[n++] != 'o' || cArray[n++] != 'w') {
                                    return null;
                                }
                                if (n2 == 5) {
                                    return JavaTokenContext.THROW;
                                }
                                if (cArray[n++] != 's') {
                                    return null;
                                }
                                if (n2 == 6) {
                                    return JavaTokenContext.THROWS;
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'r': {
                        switch (cArray[n++]) {
                            case 'a': {
                                return n2 == 9 && cArray[n++] == 'n' && cArray[n++] == 's' && cArray[n++] == 'i' && cArray[n++] == 'e' && cArray[n++] == 'n' && cArray[n++] == 't' ? JavaTokenContext.TRANSIENT : null;
                            }
                            case 'u': {
                                return n2 == 4 && cArray[n++] == 'e' ? JavaTokenContext.TRUE : null;
                            }
                            case 'y': {
                                return n2 == 3 ? JavaTokenContext.TRY : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'v': {
                if (n2 <= 3) {
                    return null;
                }
                if (cArray[n++] != 'o') {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'i': {
                        return n2 == 4 && cArray[n++] == 'd' ? JavaTokenContext.VOID : null;
                    }
                    case 'l': {
                        return n2 == 8 && cArray[n++] == 'a' && cArray[n++] == 't' && cArray[n++] == 'i' && cArray[n++] == 'l' && cArray[n++] == 'e' ? JavaTokenContext.VOLATILE : null;
                    }
                }
                return null;
            }
            case 'w': {
                return n2 == 5 && cArray[n++] == 'h' && cArray[n++] == 'i' && cArray[n++] == 'l' && cArray[n++] == 'e' ? JavaTokenContext.WHILE : null;
            }
        }
        return null;
    }
}

