/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaFastOpenPanel;

public class JavaFastOpen
implements ActionListener {
    private static final int TIMER_DELAY = 500;
    private JavaFastOpenPanel panel;
    private ListCellRenderer cellRenderer;
    private JList resultList;
    private Dialog dialog;
    private JButton[] buttons;
    private Evaluator evaluator;
    private static final int SET_EXP = 1;
    private static final int POPULATE_LIST = 2;
    private static final int OPEN = 3;
    protected static JavaFastOpen fastOpen = null;

    public void setDialogVisible(boolean bl) {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.dialog.setVisible(bl);
        if (bl) {
            this.requestFocus();
        } else {
            if (this.evaluator != null) {
                this.evaluator.breakLoop();
            }
            this.dialog.dispose();
            fastOpen = null;
        }
    }

    protected void openSource(Object object) {
    }

    public void requestFocus() {
        if (this.dialog == null) {
            return;
        }
        this.dialog.requestFocus();
        this.getPanel().popupNotify();
    }

    protected ListCellRenderer createCellRenderer() {
        JCCellRenderer jCCellRenderer = new JCCellRenderer();
        jCCellRenderer.setClassDisplayFullName(true);
        return jCCellRenderer;
    }

    protected JList createResultList() {
        ListCompletionView listCompletionView = new ListCompletionView(this.getCellRenderer());
        listCompletionView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JavaFastOpen.this.actionPerformed(new ActionEvent(JavaFastOpen.this.getButtons()[0], 0, ""));
                }
            }
        });
        return listCompletionView;
    }

    private JButton[] getButtons() {
        if (this.buttons == null) {
            this.buttons = new JButton[]{new JButton(LocaleSupport.getString("JFO_openSourceButton", "Open Source")), new JButton(LocaleSupport.getString("JFO_closeButton", "Close"))};
            this.buttons[0].setEnabled(false);
            String string = LocaleSupport.getString("JFO_openSourceButtonMnemonic", "O");
            if (string != null && string.length() > 0) {
                this.buttons[0].setMnemonic(string.charAt(0));
            }
            if ((string = LocaleSupport.getString("JFO_closeButtonMnemonic", "C")) != null && string.length() > 0) {
                this.buttons[1].setMnemonic(string.charAt(0));
            }
            this.buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFO_openSourceButton"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFO_closeButton"));
        }
        return this.buttons;
    }

    private Dialog createDialog() {
        String string = LocaleSupport.getString("JFO_title", "Open Java Source");
        Dialog dialog = DialogSupport.createDialog(string, this.getPanel(), false, this.getButtons(), false, 0, 1, this);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JavaFastOpen.this.setDialogVisible(false);
            }
        });
        return dialog;
    }

    private JavaFastOpenPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JavaFastOpenPanel(this);
        }
        return this.panel;
    }

    ListCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = this.createCellRenderer();
        }
        return this.cellRenderer;
    }

    JList getResultList() {
        if (this.resultList == null) {
            this.resultList = this.createResultList();
        }
        return this.resultList;
    }

    private Evaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new Evaluator(0);
            this.evaluator.start();
        }
        return this.evaluator;
    }

    public void setSearchText(String string) {
        this.getPanel().setSearchText(string);
        this.postUpdate();
    }

    void postUpdate() {
        SwingUtilities.invokeLater(new Evaluator(1));
    }

    List evaluate(String string) {
        List list = Collections.EMPTY_LIST;
        if (string != null && string.length() > 0) {
            JCFinder jCFinder = JavaCompletion.getFinder();
            list = jCFinder.findClasses(null, string, false);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JCClass jCClass = (JCClass)iterator.next();
                if (jCClass.getName().indexOf(46) < 0) continue;
                iterator.remove();
            }
        }
        return list;
    }

    void populate(List list) {
        if (list != null && this.getResultList() instanceof ListCompletionView) {
            SwingUtilities.invokeLater(new Evaluator(2, list));
        }
    }

    void scrollDown() {
        int n = this.resultList.getSelectedIndex();
        int n2 = this.resultList.getModel().getSize() - 1;
        if (n == -1 || n == n2) {
            return;
        }
        this.resultList.setSelectedIndex(n + 1);
        Rectangle rectangle = this.resultList.getCellBounds(n + 1, n + 1);
        if (rectangle != null) {
            this.resultList.scrollRectToVisible(rectangle);
        }
    }

    void scrollUp() {
        int n = this.resultList.getSelectedIndex();
        if (n == -1 || n == 0) {
            return;
        }
        this.resultList.setSelectedIndex(n - 1);
        Rectangle rectangle = this.resultList.getCellBounds(n - 1, n - 1);
        if (rectangle != null) {
            this.resultList.scrollRectToVisible(rectangle);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttons[0] || object == this.panel) {
            this.getEvaluator().postOpen();
        } else {
            this.setDialogVisible(false);
        }
    }

    private void open() {
        SwingUtilities.invokeLater(new Evaluator(3));
    }

    private class Evaluator
    extends Thread {
        private int opID;
        private List result;
        private String exp;
        private String lastExp;
        private boolean open;
        private boolean exit;

        Evaluator(int n) {
            this(n, null);
        }

        Evaluator(int n, List list) {
            this.opID = n;
            this.result = list;
        }

        synchronized void setExp(String string) {
            this.exp = string;
        }

        synchronized void postOpen() {
            this.open = true;
        }

        void breakLoop() {
            this.exit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            switch (this.opID) {
                case 1: {
                    String string = JavaFastOpen.this.getPanel().getSearchText();
                    if (((JavaFastOpen)JavaFastOpen.this).getEvaluator().lastExp == null && string.length() > 0) {
                        JavaFastOpen.this.getButtons()[0].setEnabled(true);
                    }
                    JavaFastOpen.this.getEvaluator().setExp(string);
                    return;
                }
                case 2: {
                    ((ListCompletionView)JavaFastOpen.this.getResultList()).setResult(this.result);
                    JavaFastOpen.this.getResultList().setSelectedIndex(0);
                    JavaFastOpen.this.getButtons()[0].setEnabled(this.result.size() > 0);
                    if (JavaFastOpen.this.dialog instanceof JDialog) {
                        JDialog jDialog = (JDialog)JavaFastOpen.this.dialog;
                        jDialog.getRootPane().setDefaultButton(JavaFastOpen.this.getButtons()[0].isEnabled() ? JavaFastOpen.this.getButtons()[0] : null);
                    }
                    return;
                }
                case 3: {
                    int n = JavaFastOpen.this.getResultList().getSelectedIndex();
                    if (n >= 0) {
                        JavaFastOpen.this.openSource(JavaFastOpen.this.getResultList().getModel().getElementAt(n));
                        JavaFastOpen.this.setDialogVisible(false);
                    }
                    return;
                }
            }
            try {
                while (!this.exit) {
                    Object object;
                    if (this.exp != null && !this.exp.equals(this.lastExp)) {
                        this.lastExp = this.exp;
                        if (this.lastExp != null) {
                            object = JavaFastOpen.this.evaluate(this.lastExp);
                            if (this.lastExp == this.exp) {
                                JavaFastOpen.this.populate((List)object);
                            }
                        }
                    }
                    object = this;
                    synchronized (object) {
                        if (this.exp != null && this.exp.equals(this.lastExp) && this.open) {
                            JavaFastOpen.this.open();
                            this.open = false;
                        }
                    }
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

