/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;

public class JCBaseFinder
extends JavaCompletion.AbstractProvider
implements JCFinder {
    static final Comparator CLASS_NAME_COMPARATOR = new DefaultClassNameComparator();
    private static final int PACKAGE_PRE_ALLOC = 1009;
    private static final int CLASS_PRE_ALLOC = 5003;
    protected JCPackage[] allPackages;
    protected JCClass[] allClassesByName;
    protected HashMap allPackagesMap = new HashMap(1009);
    protected HashMap allClassesMap = new HashMap(5003);

    public Iterator getClasses() {
        return new ArrayList<JCClass>(Arrays.asList(this.getAllClasses())).iterator();
    }

    public synchronized boolean append(JCClassProvider jCClassProvider) {
        return super.append(jCClassProvider);
    }

    protected boolean appendClass(JCClass jCClass) {
        if (!this.cheapUpdate(jCClass)) {
            this.invalidate();
        }
        return true;
    }

    public synchronized void reset() {
        this.allClassesMap.clear();
        this.invalidate();
    }

    protected void invalidate() {
        this.allPackagesMap.clear();
        this.allPackages = null;
        this.allClassesByName = null;
    }

    public synchronized JCPackage getExactPackage(String string) {
        if (this.allPackages == null) {
            this.build();
        }
        return (JCPackage)this.allPackagesMap.get(string);
    }

    public synchronized JCClass getExactClass(String string) {
        return (JCClass)this.allClassesMap.get(string);
    }

    protected JCPackage[] getAllPackages() {
        if (this.allPackages == null) {
            this.build();
        }
        return this.allPackages;
    }

    protected JCClass[] getAllClassesByName() {
        if (this.allClassesByName == null) {
            this.build();
        }
        return this.allClassesByName;
    }

    protected JCClass[] getAllClasses() {
        Object[] objectArray = (JCClass[])this.getAllClassesByName().clone();
        Arrays.sort(objectArray);
        return objectArray;
    }

    private boolean cheapUpdate(JCClass jCClass) {
        JCClass jCClass2 = this.allClassesMap.put(jCClass.getFullName(), jCClass);
        if (this.allClassesByName != null && jCClass2 != null) {
            String string = jCClass.getPackageName();
            JCPackage jCPackage = (JCPackage)this.allPackagesMap.get(string);
            if (jCPackage == null) {
                return false;
            }
            Object[] objectArray = jCPackage.getClasses();
            int n = Arrays.binarySearch(objectArray, jCClass);
            if (n < 0) {
                return false;
            }
            objectArray[n] = jCClass;
            n = Arrays.binarySearch(this.allClassesByName, jCClass, CLASS_NAME_COMPARATOR);
            if (n < 0) {
                n = -n - 1;
            }
            String string2 = jCClass.getName();
            while (n >= 0 && n < this.allClassesByName.length) {
                if (!this.allClassesByName[n].getName().startsWith(string2)) break;
                --n;
            }
            ++n;
            boolean bl = false;
            while (n < this.allClassesByName.length) {
                if (jCClass.equals(this.allClassesByName[n])) {
                    this.allClassesByName[n] = jCClass;
                    bl = true;
                    break;
                }
                if (!string2.equals(this.allClassesByName[n].getName())) break;
                ++n;
            }
            return bl;
        }
        return false;
    }

    private void addPackage(JCPackage jCPackage, boolean bl) {
        if (bl || !this.allPackagesMap.containsKey(jCPackage)) {
            this.allPackagesMap.put(jCPackage.getName(), jCPackage);
            String string = jCPackage.getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                this.addPackage(new JavaCompletion.BasePackage(string.substring(0, n)), false);
            }
        }
    }

    protected void build() {
        Object[] objectArray = new JCClass[this.allClassesMap.size()];
        this.allClassesByName = new JCClass[objectArray.length];
        Iterator iterator = this.allClassesMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = (JCClass)iterator.next();
            this.allClassesByName[n] = objectArray[n];
            ++n;
        }
        Arrays.sort(objectArray);
        Arrays.sort(this.allClassesByName, CLASS_NAME_COMPARATOR);
        this.allPackagesMap.clear();
        this.allPackages = JavaCompletion.EMPTY_PACKAGES;
        if (objectArray.length > 0) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            JavaCompletion.BasePackage basePackage = new JavaCompletion.BasePackage(objectArray[0].getPackageName());
            int n2 = 0;
            while (n2 < objectArray.length) {
                object = objectArray[n2].getPackageName();
                if (!((Object)basePackage).equals(object)) {
                    JCClass[] jCClassArray = new JCClass[arrayList.size()];
                    arrayList.toArray(jCClassArray);
                    basePackage.setClasses(jCClassArray);
                    arrayList.clear();
                    this.addPackage(basePackage, true);
                    basePackage = new JavaCompletion.BasePackage((String)object);
                }
                arrayList.add(objectArray[n2]);
                ++n2;
            }
            object = new JCClass[arrayList.size()];
            arrayList.toArray((T[])object);
            basePackage.setClasses((JCClass[])object);
            this.addPackage(basePackage, true);
            this.allPackages = new JCPackage[this.allPackagesMap.size()];
            iterator = this.allPackagesMap.values().iterator();
            n = 0;
            while (iterator.hasNext()) {
                this.allPackages[n] = (JCPackage)iterator.next();
                ++n;
            }
        }
        Arrays.sort(this.allPackages);
    }

    public synchronized List findPackages(String string, boolean bl, boolean bl2) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            object = this.getExactPackage(string);
            if (object != null) {
                arrayList.add(object);
            }
            if (!bl2) {
                return arrayList;
            }
        }
        object = this.getAllPackages();
        JavaCompletion.BasePackage basePackage = new JavaCompletion.BasePackage(string);
        int n = Arrays.binarySearch(object, basePackage);
        int n2 = string.length();
        if (n < 0) {
            n = -n - 1;
        }
        while (n >= 0 && n < ((Object[])object).length) {
            if (!object[n].getName().startsWith(string)) break;
            --n;
        }
        ++n;
        int n3 = basePackage.getDotCount();
        while (n < ((Object[])object).length) {
            String string2 = object[n].getName();
            if (!string2.startsWith(string)) break;
            if (bl ? string2.length() > n2 && string2.charAt(n2) == '.' : bl2 || object[n].getDotCount() == n3) {
                arrayList.add(object[n]);
            }
            ++n;
        }
        return arrayList;
    }

    public synchronized List findClasses(JCPackage jCPackage, String string, boolean bl) {
        ArrayList<JCClass> arrayList = new ArrayList<JCClass>();
        JavaCompletion.SimpleClass simpleClass = new JavaCompletion.SimpleClass(string, "");
        int n = string.length();
        JCClass[] jCClassArray = jCPackage != null ? jCPackage.getClasses() : this.getAllClassesByName();
        int n2 = Arrays.binarySearch(jCClassArray, simpleClass, CLASS_NAME_COMPARATOR);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        while (n2 >= 0 && n2 < jCClassArray.length) {
            if (!jCClassArray[n2].getName().startsWith(string)) break;
            --n2;
        }
        ++n2;
        while (n2 < jCClassArray.length) {
            String string2 = jCClassArray[n2].getName();
            if (!string2.startsWith(string)) break;
            if (!bl || string2.length() == n) {
                arrayList.add(jCClassArray[n2]);
            }
            ++n2;
        }
        return arrayList;
    }

    private List getOuterClasses(JCClass jCClass) {
        JCFinder jCFinder = JavaCompletion.getFinder();
        ArrayList<JCClass> arrayList = new ArrayList<JCClass>();
        arrayList.add(jCClass);
        int n = jCClass.getName().lastIndexOf(46);
        while (n >= 0) {
            int n2 = jCClass.getPackageName().length();
            String string = jCClass.getFullName().substring(0, (n2 > 0 ? n2 + 1 : 0) + n);
            if ((jCClass = jCFinder.getExactClass(string)) == null) break;
            arrayList.add(jCClass);
            n = jCClass.getName().lastIndexOf(46);
        }
        return arrayList;
    }

    public synchronized List findFields(JCClass jCClass, String string, boolean bl, boolean bl2, boolean bl3) {
        JCField[] jCFieldArray;
        int n;
        JCField[] jCFieldArray2;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        List list = this.getClassList(jCClass);
        String string2 = jCClass.getPackageName();
        HashSet hashSet = new HashSet();
        JCClass jCClass2 = jCClass;
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            jCClass = this.getExactClass(((JCClass)list.get(n2)).getFullName());
            if (jCClass != null) {
                hashSet.addAll(JCUtilities.getAllInterfaces(jCClass));
                boolean bl4 = !jCClass.getPackageName().equals(string2);
                jCFieldArray2 = n2 == 0 && bl3 && jCClass.getName().indexOf(46) >= 0 ? this.getOuterClasses(jCClass) : null;
                int n3 = n = jCFieldArray2 != null ? jCFieldArray2.size() - 1 : -1;
                do {
                    if (n >= 0) {
                        jCClass = (JCClass)jCFieldArray2.get(n--);
                    }
                    jCFieldArray = jCClass.getFields();
                    int n4 = 0;
                    while (n4 < jCFieldArray.length) {
                        JCField jCField = jCFieldArray[n4];
                        int n5 = jCField.getModifiers();
                        if (!(bl2 && (n5 & 8) == 0 || n2 > 0 && (n5 & 2) != 0 || bl4 && (n5 & 5) == 0 || n > -1 && (jCClass2.getModifiers() & 8) != 0 && (n5 & 8) == 0 || (bl ? !jCField.getName().equals(string) : !jCField.getName().startsWith(string)))) {
                            treeSet.add(jCField);
                        }
                        ++n4;
                    }
                } while (n >= 0);
            }
            --n2;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            jCClass = this.getExactClass(((JCClass)iterator.next()).getFullName());
            if (jCClass == null) continue;
            jCFieldArray2 = jCClass.getFields();
            n = 0;
            while (n < jCFieldArray2.length) {
                jCFieldArray = jCFieldArray2[n];
                if (!(bl ? !jCFieldArray.getName().equals(string) : !jCFieldArray.getName().startsWith(string))) {
                    treeSet.add(jCFieldArray);
                }
                ++n;
            }
        }
        return new ArrayList(treeSet);
    }

    public synchronized List findMethods(JCClass jCClass, String string, boolean bl, boolean bl2, boolean bl3) {
        TreeSet<JCMethod> treeSet = new TreeSet<JCMethod>();
        List list = this.getClassList(jCClass);
        String string2 = jCClass.getPackageName();
        JCClass jCClass2 = jCClass;
        int n = list.size() - 1;
        while (n >= 0) {
            jCClass = this.getExactClass(((JCClass)list.get(n)).getFullName());
            if (jCClass != null) {
                int n2;
                boolean bl4 = !jCClass.getPackageName().equals(string2);
                List list2 = n == 0 && bl3 && jCClass.getName().indexOf(46) >= 0 ? this.getOuterClasses(jCClass) : null;
                int n3 = n2 = list2 != null ? list2.size() - 1 : -1;
                do {
                    if (n2 >= 0) {
                        jCClass = (JCClass)list2.get(n2--);
                    }
                    JCMethod[] jCMethodArray = jCClass.getMethods();
                    int n4 = 0;
                    while (n4 < jCMethodArray.length) {
                        JCMethod jCMethod = jCMethodArray[n4];
                        int n5 = jCMethod.getModifiers();
                        if (!(bl2 && (n5 & 8) == 0 || n > 0 && (n5 & 2) != 0 || bl4 && (n5 & 5) == 0 || n2 > -1 && (jCClass2.getModifiers() & 8) != 0 && (n5 & 8) == 0 || (!bl ? !jCMethod.getName().startsWith(string) : !jCMethod.getName().equals(string)))) {
                            if (treeSet.contains(jCMethod)) {
                                treeSet.remove(jCMethod);
                            }
                            treeSet.add(jCMethod);
                        }
                        ++n4;
                    }
                } while (n2 >= 0);
            }
            --n;
        }
        return new ArrayList(treeSet);
    }

    private List getClassList(JCClass jCClass) {
        List<JCClass> list;
        JCFinder jCFinder = JavaCompletion.getFinder();
        jCClass = jCFinder.getExactClass(jCClass.getFullName());
        if (jCClass != null) {
            if (jCClass.isInterface()) {
                list = JCUtilities.getAllInterfaces(jCClass);
                list.add(JavaCompletion.OBJECT_CLASS);
            } else {
                list = JCUtilities.getSuperclasses(jCClass);
                if ((jCClass.getModifiers() & 0x400) != 0) {
                    list.addAll(JCUtilities.getAllInterfaces(jCClass));
                }
            }
            list.add(0, jCClass);
        } else {
            list = new ArrayList();
        }
        return list;
    }

    public String dumpClasses() {
        StringBuffer stringBuffer = new StringBuffer(8192);
        JCClass[] jCClassArray = this.getAllClasses();
        int n = 0;
        while (n < jCClassArray.length) {
            stringBuffer.append(JCUtilities.dumpClass(jCClassArray[n]));
            stringBuffer.append("\n\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final class DefaultClassNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            return ((JCClass)object).getName().compareTo(((JCClass)object2).getName());
        }
    }
}

