/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionPane;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;

public class ScrollCompletionPane
extends JScrollPane
implements CompletionPane,
PropertyChangeListener,
SettingsChangeListener {
    private static final Dimension PLUS_SIZE = new Dimension(20, 20);
    private static final int CARET_THRESHOLD = 5;
    private ExtEditorUI extEditorUI;
    private JComponent view;
    private JLabel topLabel;
    private Dimension minSize;
    private Dimension maxSize;
    private FocusListener focusL;
    private ViewMouseListener viewMouseL;
    private Dimension scrollBarSize;
    static /* synthetic */ Class class$org$netbeans$editor$ext$ScrollCompletionPane;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollCompletionPane(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        Dimension dimension = this.getPreferredSize();
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(22);
        this.scrollBarSize = this.getPreferredSize();
        this.scrollBarSize.width -= dimension.width;
        this.scrollBarSize.height -= dimension.height;
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        super.setVisible(false);
        this.installTitleComponent();
        CompletionView completionView = extEditorUI.getCompletion().getView();
        if (completionView instanceof JComponent) {
            this.view = (JComponent)((Object)completionView);
            this.setViewportView(this.view);
        }
        this.getViewport().setMinimumSize(new Dimension(4, 4));
        Settings.addSettingsChangeListener(this);
        this.focusL = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        JTextComponent jTextComponent;
                        if (1.access$000(this.this$1).isVisible() && (jTextComponent = ScrollCompletionPane.access$100(1.access$000(this.this$1)).getComponent()) != null) {
                            Component component;
                            Window window = SwingUtilities.windowForComponent(jTextComponent);
                            Component component2 = component = window == null ? null : window.getFocusOwner();
                            if (component == ScrollCompletionPane.access$200(1.access$000(this.this$1))) {
                                jTextComponent.requestFocus();
                            } else if (component != jTextComponent) {
                                1.access$000(this.this$1).setVisible(false);
                            }
                        }
                    }
                });
            }

            static /* synthetic */ ScrollCompletionPane access$000(1 var0) {
                return var0.ScrollCompletionPane.this;
            }
        };
        this.viewMouseL = new ViewMouseListener();
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = extEditorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, jTextComponent));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
        this.putClientProperty("HelpID", (class$org$netbeans$editor$ext$ScrollCompletionPane == null ? (class$org$netbeans$editor$ext$ScrollCompletionPane = ScrollCompletionPane.class$("org.netbeans.editor.ext.ScrollCompletionPane")) : class$org$netbeans$editor$ext$ScrollCompletionPane).getName());
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (clazz != null) {
            this.minSize = (Dimension)SettingsUtil.getValue(clazz, "completion-pane-min-size", ExtSettingsDefaults.defaultCompletionPaneMinSize);
            this.maxSize = (Dimension)SettingsUtil.getValue(clazz, "completion-pane-max-size", ExtSettingsDefaults.defaultCompletionPaneMaxSize);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            if (propertyChangeEvent.getNewValue() != null) {
                JTextComponent jTextComponent = this.extEditorUI.getComponent();
                this.settingsChange(null);
                if (this.view != null) {
                    BaseKit baseKit = Utilities.getKit(jTextComponent);
                    this.view.registerKeyboardAction(baseKit.getActionByName("completion-hide"), KeyStroke.getKeyStroke(27, 0), 0);
                    this.view.addMouseListener(this.viewMouseL);
                }
                jTextComponent.addFocusListener(this.focusL);
                this.installToRootPane(jTextComponent);
            } else {
                JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                if (this.view != null) {
                    this.view.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
                    this.view.removeMouseListener(this.viewMouseL);
                }
                jTextComponent.removeFocusListener(this.focusL);
                this.removeFromRootPane();
            }
        }
    }

    private void installToRootPane(JTextComponent jTextComponent) {
        JRootPane jRootPane = jTextComponent.getRootPane();
        if (jRootPane != null) {
            jRootPane.getLayeredPane().add(this, JLayeredPane.POPUP_LAYER, 0);
        }
    }

    private void removeFromRootPane() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.getLayeredPane().remove(this);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.checkRootPane();
            this.refresh();
        } else {
            JTextComponent jTextComponent = this.extEditorUI.getComponent();
            if (jTextComponent != null) {
                jTextComponent.requestFocus();
            }
        }
    }

    private void checkRootPane() {
        JTextComponent jTextComponent = this.extEditorUI.getComponent();
        if (jTextComponent != null && jTextComponent.getRootPane() != this.getRootPane()) {
            this.removeFromRootPane();
            this.installToRootPane(jTextComponent);
        }
    }

    public void refresh() {
        if (this.view instanceof JList) {
            JList jList = (JList)this.view;
            jList.ensureIndexIsVisible(jList.getSelectedIndex());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ScrollCompletionPane.this.isShowing()) {
                    Rectangle rectangle = ScrollCompletionPane.this.getPreferredBounds();
                    ScrollCompletionPane.this.setBounds(rectangle);
                    ScrollCompletionPane.this.revalidate();
                }
            }
        });
    }

    public void setTitle(String string) {
        this.topLabel.setText(string);
    }

    protected void installTitleComponent() {
        this.topLabel = new JLabel();
        this.topLabel.setForeground(Color.blue);
        this.topLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.setColumnHeaderView(this.topLabel);
    }

    protected Dimension getTitleComponentPreferredSize() {
        return this.topLabel.getPreferredSize();
    }

    protected Rectangle getPreferredBounds() {
        Rectangle rectangle = null;
        if (this.view != null) {
            JTextComponent jTextComponent = this.extEditorUI.getComponent();
            Rectangle rectangle2 = this.extEditorUI.getExtentBounds();
            Rectangle rectangle3 = (Rectangle)((Object)jTextComponent.getCaret());
            int n = rectangle3.y - 5;
            int n2 = n - rectangle2.y;
            int n3 = rectangle3.y + rectangle3.height + 5;
            int n4 = rectangle2.y + rectangle2.height - n3;
            int n5 = Math.min(rectangle2.width, this.maxSize.width);
            int n6 = Math.min(Math.max(n2, n4), this.maxSize.height);
            Dimension dimension = this.getPreferredSize();
            dimension.width += this.scrollBarSize.width;
            dimension.width = Math.max(Math.max(dimension.width, this.minSize.width), this.getTitleComponentPreferredSize().width);
            if (dimension.width > n5) {
                dimension.width = n5;
                dimension.height += this.scrollBarSize.height;
            }
            dimension.height = Math.min(Math.max(dimension.height, this.minSize.height), n6);
            rectangle = new Rectangle(dimension);
            Point point = new Point();
            point.y = jTextComponent.getParent().getLocationOnScreen().y - jTextComponent.getRootPane().getLocationOnScreen().y - 1;
            point.x = jTextComponent.getParent().getLocationOnScreen().x - jTextComponent.getRootPane().getLocationOnScreen().x - 1;
            rectangle.x = Math.min(rectangle3.x - rectangle2.x + point.x, rectangle2.width - rectangle.width);
            rectangle.y = rectangle.height <= n4 ? n3 - rectangle2.y : n - rectangle.height - rectangle2.y;
            rectangle.y += point.y;
        }
        return rectangle;
    }

    static /* synthetic */ JComponent access$200(ScrollCompletionPane scrollCompletionPane) {
        return scrollCompletionPane.view;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ViewMouseListener
    extends MouseAdapter {
        ViewMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Action action;
            BaseKit baseKit;
            JTextComponent jTextComponent;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (jTextComponent = ScrollCompletionPane.this.extEditorUI.getComponent()) != null && mouseEvent.getClickCount() == 2 && (baseKit = Utilities.getKit(jTextComponent)) != null && (action = baseKit.getActionByName("insert-break")) != null) {
                action.actionPerformed(new ActionEvent(jTextComponent, 1001, ""));
            }
        }
    }
}

