/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.text.Position;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;

class FormatTokenPositionSupport {
    private final FormatWriter formatWriter;
    private SaveSet firstSet;
    private SaveSet lastSet;
    private final HashMap tokens2positionLists = new HashMap();

    FormatTokenPositionSupport(FormatWriter formatWriter) {
        this.formatWriter = formatWriter;
    }

    private ArrayList getPosList(TokenItem tokenItem) {
        ArrayList arrayList = (ArrayList)this.tokens2positionLists.get(tokenItem);
        if (arrayList == null) {
            arrayList = new ArrayList(3);
            this.tokens2positionLists.put(tokenItem, arrayList);
        }
        return arrayList;
    }

    synchronized ExtTokenPosition getTokenPosition(TokenItem tokenItem, int n, Position.Bias bias) {
        ExtTokenPosition extTokenPosition;
        if (tokenItem == null) {
            if (n != 0) {
                throw new IllegalArgumentException("Ending token position has non-zero offset=" + n);
            }
        } else if (n >= tokenItem.getImage().length()) {
            throw new IllegalArgumentException("Offset=" + n + " >= tokenLength=" + tokenItem.getImage().length());
        }
        ArrayList arrayList = this.getPosList(tokenItem);
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            extTokenPosition = (ExtTokenPosition)arrayList.get(n3);
            if (extTokenPosition.getOffset() == n && extTokenPosition.getBias() == bias) {
                return extTokenPosition;
            }
            ++n3;
        }
        extTokenPosition = new ExtTokenPosition(tokenItem, n, bias);
        arrayList.add(extTokenPosition);
        return extTokenPosition;
    }

    synchronized void splitStartTokenPositions(TokenItem tokenItem, int n) {
        TokenItem tokenItem2 = tokenItem.getPrevious();
        if (tokenItem2 != null) {
            tokenItem2 = this.formatWriter.findNonEmptyToken(tokenItem2, true);
        }
        ArrayList arrayList = this.getPosList(tokenItem);
        int n2 = arrayList.size();
        ArrayList arrayList2 = this.getPosList(tokenItem2);
        int n3 = 0;
        while (n3 < n2) {
            ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList.get(n3);
            if (extTokenPosition.offset < n) {
                extTokenPosition.token = tokenItem2;
                arrayList.remove(n3);
                arrayList2.add(extTokenPosition);
                --n3;
                --n2;
            }
            ++n3;
        }
    }

    synchronized void splitEndTokenPositions(TokenItem tokenItem, int n) {
        TokenItem tokenItem2 = tokenItem.getNext();
        if (tokenItem2 != null) {
            tokenItem2 = this.formatWriter.findNonEmptyToken(tokenItem2, false);
        }
        ArrayList arrayList = this.getPosList(tokenItem2);
        ArrayList arrayList2 = this.getPosList(tokenItem);
        int n2 = arrayList2.size();
        int n3 = tokenItem.getImage().length() - n;
        int n4 = 0;
        while (n4 < n2) {
            ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList2.get(n4);
            if (extTokenPosition.offset >= n3) {
                extTokenPosition.token = tokenItem2;
                extTokenPosition.offset -= n3;
                arrayList2.remove(n4);
                arrayList.add(extTokenPosition);
                --n4;
                --n2;
            }
            ++n4;
        }
    }

    synchronized void tokenTextInsert(TokenItem tokenItem, int n, int n2) {
        Object object;
        ArrayList arrayList = this.getPosList(tokenItem);
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            object = (ExtTokenPosition)arrayList.get(n4);
            if (((ExtTokenPosition)object).bias == Position.Bias.Backward ? ((ExtTokenPosition)object).offset > n : ((ExtTokenPosition)object).offset >= n) {
                ((ExtTokenPosition)object).offset += n2;
            }
            ++n4;
        }
        if (tokenItem.getImage().length() == n) {
            object = tokenItem.getNext();
            if (object != null) {
                object = this.formatWriter.findNonEmptyToken((TokenItem)object, false);
            }
            arrayList = this.getPosList((TokenItem)object);
            n3 = arrayList.size();
            int n5 = 0;
            while (n5 < n3) {
                ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList.get(n5);
                if (extTokenPosition.bias == Position.Bias.Backward && extTokenPosition.offset == 0) {
                    extTokenPosition.token = tokenItem;
                    extTokenPosition.offset = n;
                }
                ++n5;
            }
        }
    }

    synchronized void tokenTextRemove(TokenItem tokenItem, int n, int n2) {
        ArrayList arrayList = this.getPosList(tokenItem);
        int n3 = arrayList.size();
        int n4 = tokenItem.getImage().length() - n2;
        ArrayList arrayList2 = this.getPosList(tokenItem.getNext());
        int n5 = 0;
        while (n5 < n3) {
            ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList.get(n5);
            if (extTokenPosition.offset >= n + n2) {
                extTokenPosition.offset -= n2;
            } else if (extTokenPosition.offset >= n) {
                extTokenPosition.offset = n;
            }
            if (extTokenPosition.offset >= n4) {
                extTokenPosition.token = tokenItem.getNext();
                extTokenPosition.offset = 0;
                arrayList.remove(n5);
                arrayList2.add(extTokenPosition);
                --n5;
                --n3;
            }
            ++n5;
        }
    }

    synchronized void tokenRemove(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem.getNext();
        if (tokenItem2 != null) {
            tokenItem2 = this.formatWriter.findNonEmptyToken(tokenItem2, false);
        }
        ArrayList arrayList = this.getPosList(tokenItem2);
        ArrayList arrayList2 = this.getPosList(tokenItem);
        int n = arrayList2.size();
        int n2 = 0;
        while (n2 < n) {
            ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList2.get(n2);
            extTokenPosition.token = tokenItem2;
            extTokenPosition.offset = 0;
            arrayList.add(extTokenPosition);
            ++n2;
        }
        arrayList2.clear();
        this.tokens2positionLists.remove(tokenItem);
    }

    synchronized void tokenInsert(TokenItem tokenItem) {
        if (tokenItem.getImage().length() > 0) {
            ArrayList arrayList = this.getPosList(tokenItem);
            TokenItem tokenItem2 = tokenItem.getNext();
            if (tokenItem2 != null) {
                tokenItem2 = this.formatWriter.findNonEmptyToken(tokenItem2, false);
            }
            ArrayList arrayList2 = this.getPosList(tokenItem2);
            int n = arrayList2.size();
            int n2 = 0;
            while (n2 < n) {
                ExtTokenPosition extTokenPosition = (ExtTokenPosition)arrayList2.get(n2);
                if (extTokenPosition.offset == 0 && extTokenPosition.getBias() == Position.Bias.Backward) {
                    extTokenPosition.token = tokenItem;
                    arrayList2.remove(n2);
                    --n2;
                    --n;
                    arrayList.add(extTokenPosition);
                }
                ++n2;
            }
        }
    }

    synchronized void clearSaveSets() {
        this.firstSet = null;
        this.lastSet = null;
    }

    synchronized void addSaveSet(int n, int n2, int[] nArray, Position.Bias[] biasArray) {
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] < 0 || nArray[n3] > n2) {
                throw new IllegalArgumentException("Invalid save-offset=" + nArray[n3] + " at index=" + n3 + ". Written length is " + n2);
            }
            ++n3;
        }
        SaveSet saveSet = new SaveSet(n, nArray, biasArray);
        if (this.firstSet != null) {
            this.lastSet.next = saveSet;
            this.lastSet = saveSet;
        } else {
            this.firstSet = this.lastSet = saveSet;
        }
    }

    synchronized void createPositions(FormatTokenPosition formatTokenPosition) {
        this.updateSaveOffsets(formatTokenPosition);
        SaveSet saveSet = this.firstSet;
        FormatWriter.FormatTokenItem formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenPosition.getToken();
        boolean bl = formatTokenItem == null;
        while (saveSet != null) {
            int n = saveSet.offsets.length;
            int n2 = 0;
            while (n2 < n) {
                if (bl) {
                    saveSet.positions[n2] = this.getTokenPosition(null, 0, saveSet.biases[n2]);
                } else {
                    int n3 = saveSet.offsets[n2];
                    while (formatTokenItem != null) {
                        if (n3 < formatTokenItem.getSaveOffset()) {
                            formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenItem.getPrevious();
                            continue;
                        }
                        if (n3 > formatTokenItem.getSaveOffset() + formatTokenItem.getImage().length() || formatTokenItem.getImage().length() == 0) {
                            formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenItem.getNext();
                            continue;
                        }
                        saveSet.positions[n2] = this.getTokenPosition(formatTokenItem, n3 - formatTokenItem.getSaveOffset(), saveSet.biases[n2]);
                        break;
                    }
                    if (formatTokenItem == null) {
                        saveSet.positions[n2] = this.getTokenPosition(null, 0, saveSet.biases[n2]);
                        formatTokenItem = (FormatWriter.FormatTokenItem)this.formatWriter.getLastToken();
                    }
                }
                ++n2;
            }
            saveSet = saveSet.next;
        }
    }

    synchronized void updateSaveSets(FormatTokenPosition formatTokenPosition) {
        this.updateSaveOffsets(formatTokenPosition);
        SaveSet saveSet = this.firstSet;
        int n = 0;
        if (formatTokenPosition.getToken() != null) {
            n = ((FormatWriter.FormatTokenItem)this.formatWriter.getLastToken()).getSaveOffset() + this.formatWriter.getLastToken().getImage().length();
        }
        while (saveSet != null) {
            int n2 = saveSet.offsets.length;
            int n3 = 0;
            while (n3 < n2) {
                FormatWriter.FormatTokenItem formatTokenItem = (FormatWriter.FormatTokenItem)saveSet.positions[n3].getToken();
                saveSet.offsets[n3] = formatTokenItem == null ? n : formatTokenItem.getSaveOffset() + saveSet.positions[n3].getOffset();
                ++n3;
            }
        }
    }

    private void updateSaveOffsets(FormatTokenPosition formatTokenPosition) {
        if (this.firstSet != null) {
            FormatWriter.FormatTokenItem formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenPosition.getToken();
            int n = -formatTokenPosition.getOffset();
            while (formatTokenItem != null) {
                formatTokenItem.setSaveOffset(n);
                n += formatTokenItem.getImage().length();
                formatTokenItem = (FormatWriter.FormatTokenItem)formatTokenItem.getNext();
            }
        }
    }

    static class SaveSet {
        SaveSet next;
        int baseOffset;
        int[] offsets;
        Position.Bias[] biases;
        FormatTokenPosition[] positions;

        SaveSet(int n, int[] nArray, Position.Bias[] biasArray) {
            this.baseOffset = n;
            this.offsets = nArray;
            this.biases = biasArray;
        }
    }

    class ExtTokenPosition
    implements FormatTokenPosition {
        TokenItem token;
        int offset;
        Position.Bias bias;

        ExtTokenPosition(TokenItem tokenItem, int n) {
            this(tokenItem, n, Position.Bias.Forward);
        }

        ExtTokenPosition(TokenItem tokenItem, int n, Position.Bias bias) {
            this.token = tokenItem;
            this.offset = n;
            this.bias = bias;
        }

        public TokenItem getToken() {
            return this.token;
        }

        public int getOffset() {
            return this.token != null ? this.offset : 0;
        }

        public Position.Bias getBias() {
            return this.bias;
        }

        public boolean equals(Object object) {
            return this.equals(object, true);
        }

        public boolean equals(Object object, boolean bl) {
            if (object instanceof FormatTokenPosition) {
                FormatTokenPosition formatTokenPosition = (FormatTokenPosition)object;
                return this.token == formatTokenPosition.getToken() && this.offset == formatTokenPosition.getOffset() && (bl || this.bias == formatTokenPosition.getBias());
            }
            return false;
        }

        public String toString() {
            return "<" + this.getToken() + ", " + this.getOffset() + ", " + this.getBias() + ">";
        }
    }
}

