/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.EditorState;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.FindDialogPanel;

public class FindDialogSupport
extends WindowAdapter
implements ActionListener {
    private static final String HISTORY_KEY_BASE = "FindDialogSupport.";
    private static final String BOUNDS_FIND = "FindDialogSupport.bounds-find";
    private static final String BOUNDS_REPLACE = "FindDialogSupport.bounds-replace";
    private Object dialogLock = new Object();
    private boolean isReplaceDialog;
    private JButton[] findButtons;
    private FindPanel findPanel;
    private Dialog findDialog;
    protected Timer incSearchTimer;
    private static final String MNEMONIC_SUFFIX = "-mnemonic";
    private static final String A11Y_PREFIX = "ACSD_";

    public FindDialogSupport() {
        int n = SettingsUtil.getInteger(null, "find-inc-search-delay", 200);
        this.incSearchTimer = new Timer(n, new WeakTimerListener(this));
        this.incSearchTimer.setRepeats(false);
    }

    private JButton[] createFindButtons() {
        JButton[] jButtonArray = new JButton[]{new JButton(LocaleSupport.getString("find-button-find")), new JButton(LocaleSupport.getString("find-button-replace")), new JButton(LocaleSupport.getString("find-button-replace-all")), new JButton(LocaleSupport.getString("find-button-cancel"))};
        jButtonArray[1].setMnemonic(LocaleSupport.getChar("find-button-replace-mnemonic", 'R'));
        jButtonArray[2].setMnemonic(LocaleSupport.getChar("find-button-replace-all-mnemonic", 'A'));
        jButtonArray[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-find"));
        jButtonArray[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-replace"));
        jButtonArray[2].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-replace-all"));
        jButtonArray[3].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-cancel"));
        return jButtonArray;
    }

    private void loadBounds(Dialog dialog, String string) {
        dialog.pack();
        Rectangle rectangle = (Rectangle)EditorState.get(string);
        if (rectangle != null) {
            dialog.setBounds(rectangle);
        } else {
            Dimension dimension = dialog.getPreferredSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = Math.max(0, (dimension2.width - dimension.width) / 2);
            int n2 = Math.max(0, (dimension2.height - dimension.height) / 2);
            dialog.setLocation(n, n2);
        }
    }

    private void saveBounds(Dialog dialog, String string) {
        EditorState.put(string, dialog.getBounds());
    }

    private Dialog createFindDialog(JPanel jPanel, JButton[] jButtonArray, ActionListener actionListener) {
        Dialog dialog = DialogSupport.createDialog(this.isReplaceDialog ? LocaleSupport.getString("replace-title") : LocaleSupport.getString("find-title"), jPanel, false, jButtonArray, true, 0, 3, actionListener);
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFindDialogImpl(boolean bl) {
        Object object = this.dialogLock;
        synchronized (object) {
            if (this.findDialog != null) {
                if (this.isReplaceDialog == bl) {
                    this.findDialog.toFront();
                } else {
                    this.saveBounds(this.findDialog, this.isReplaceDialog ? BOUNDS_REPLACE : BOUNDS_FIND);
                    this.isReplaceDialog = bl;
                    this.findButtons[1].setVisible(bl);
                    this.findButtons[2].setVisible(bl);
                    if (bl) {
                        this.findDialog.setTitle(LocaleSupport.getString("replace-title"));
                        this.findPanel.updateReplace();
                    } else {
                        this.findDialog.setTitle(LocaleSupport.getString("find-title"));
                        this.findPanel.updateFind();
                    }
                    this.loadBounds(this.findDialog, bl ? BOUNDS_REPLACE : BOUNDS_FIND);
                }
            } else {
                this.isReplaceDialog = bl;
                this.findButtons = this.createFindButtons();
                this.findButtons[1].setVisible(bl);
                this.findButtons[2].setVisible(bl);
                this.findPanel = new FindPanel();
                if (bl) {
                    this.findPanel.updateReplace();
                } else {
                    this.findPanel.updateFind();
                }
                this.findDialog = this.createFindDialog(this.findPanel, this.findButtons, this);
                this.loadBounds(this.findDialog, bl ? BOUNDS_REPLACE : BOUNDS_FIND);
                this.findDialog.addWindowListener(this);
            }
        }
        this.findDialog.setVisible(true);
        this.findDialog.requestFocus();
        this.findPanel.updateFocus();
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.incSearchTimer.start();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.incSearchTimer.stop();
        FindSupport.getFindSupport().incSearchReset();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.hideDialog();
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.incSearchTimer.stop();
        FindSupport.getFindSupport().incSearchReset();
        Utilities.returnFocus();
    }

    public void showFindDialog() {
        this.showFindDialogImpl(false);
    }

    public void showReplaceDialog() {
        this.showFindDialogImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideDialog() {
        Object object = this.dialogLock;
        synchronized (object) {
            if (this.findDialog != null) {
                this.saveBounds(this.findDialog, this.isReplaceDialog ? BOUNDS_REPLACE : BOUNDS_FIND);
                this.findDialog.dispose();
                this.findButtons = null;
                this.findPanel = null;
                this.findDialog = null;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton[] jButtonArray = this.findButtons;
        if (jButtonArray == null) {
            return;
        }
        Object object = actionEvent.getSource();
        FindSupport findSupport = FindSupport.getFindSupport();
        if (object == jButtonArray[0]) {
            this.findPanel.updateFindHistory();
            this.findPanel.save();
            if (findSupport.find(null, false)) {
                // empty if block
            }
            if (!this.isReplaceDialog) {
                this.hideDialog();
            }
        } else if (object == jButtonArray[1]) {
            this.findPanel.updateReplaceHistory();
            this.findPanel.save();
            try {
                if (findSupport.replace(null, false)) {
                    findSupport.find(null, false);
                }
            }
            catch (GuardedException guardedException) {
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else if (object == jButtonArray[2]) {
            this.findPanel.updateReplaceHistory();
            this.findPanel.save();
            findSupport.replaceAll(null);
        } else if (object == jButtonArray[3]) {
            this.hideDialog();
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            if (jTextComponent != null) {
                jTextComponent.getCaret().setDot(jTextComponent.getCaret().getDot());
            }
        } else if (object == this.incSearchTimer) {
            findSupport.incSearch(this.findPanel.getFindProps());
        } else {
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            if (jTextComponent != null) {
                jTextComponent.getCaret().setDot(jTextComponent.getCaret().getDot());
            }
        }
    }

    static /* synthetic */ FindPanel access$100(FindDialogSupport findDialogSupport) {
        return findDialogSupport.findPanel;
    }

    public class FindPanel
    extends FindDialogPanel
    implements ItemListener,
    KeyListener,
    ActionListener {
        Map findProps = Collections.synchronizedMap(new HashMap(20));
        Map objToProps = Collections.synchronizedMap(new HashMap(20));
        FindSupport findSupport = FindSupport.getFindSupport();
        static final long serialVersionUID = 917425125419841466L;

        FindPanel() {
            this.objToProps.put(this.findWhat, "find-what");
            this.objToProps.put(this.replaceWith, "find-replace-with");
            this.objToProps.put(this.highlightSearch, "find-highlight-search");
            this.objToProps.put(this.incSearch, "find-inc-search");
            this.objToProps.put(this.matchCase, "find-match-case");
            this.objToProps.put(this.smartCase, "find-smart-case");
            this.objToProps.put(this.wholeWords, "find-whole-words");
            this.objToProps.put(this.regExp, "find-reg-exp");
            this.objToProps.put(this.bwdSearch, "find-backward-search");
            this.objToProps.put(this.wrapSearch, "find-wrap-search");
            this.regExp.setEnabled(false);
            this.regExp.setVisible(false);
            this.load();
            this.findWhat.getEditor().getEditorComponent().addKeyListener(this);
            this.findWhat.addActionListener(this);
            this.replaceWith.getEditor().getEditorComponent().addKeyListener(this);
            this.replaceWith.addActionListener(this);
            this.highlightSearch.addItemListener(this);
            this.incSearch.addItemListener(this);
            this.matchCase.addItemListener(this);
            this.smartCase.addItemListener(this);
            this.wholeWords.addItemListener(this);
            this.regExp.addItemListener(this);
            this.bwdSearch.addItemListener(this);
            this.wrapSearch.addItemListener(this);
        }

        protected Map getFindProps() {
            return this.findProps;
        }

        void putProperty(Object object, Object object2) {
            String string = (String)this.objToProps.get(object);
            if (string != null) {
                this.findProps.put(string, object2);
                FindDialogSupport.this.incSearchTimer.restart();
            }
        }

        Object getProperty(Object object) {
            String string = (String)this.objToProps.get(object);
            return string != null ? this.findProps.get(string) : null;
        }

        boolean getBooleanProperty(Object object) {
            Object object2 = this.getProperty(object);
            return object2 != null ? (Boolean)object2 : false;
        }

        private void changeVisibility(boolean bl) {
            this.replaceWith.setVisible(bl);
            this.replaceWithLabel.setVisible(bl);
        }

        protected void updateFocus() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ FindPanel this$1;
                {
                    this.this$1 = findPanel;
                }

                public void run() {
                    JTextComponent jTextComponent = Utilities.getLastActiveComponent();
                    if (jTextComponent != null) {
                        String string = jTextComponent.getSelectedText();
                        if (string != null) {
                            int n = string.indexOf(10);
                            if (n >= 0) {
                                string = string.substring(0, n);
                            }
                            FindDialogSupport.access$100(FindPanel.access$000(this.this$1)).updateFindWhat(string.trim());
                        } else if (this.this$1.getProperty(this.this$1.findWhat) != null) {
                            this.this$1.findWhat.getEditor().setItem(this.this$1.getProperty(this.this$1.findWhat));
                        }
                    }
                    this.this$1.findWhat.getEditor().getEditorComponent().requestFocus();
                    this.this$1.findWhat.requestFocus();
                    this.this$1.findWhat.getEditor().selectAll();
                }
            });
        }

        protected void updateFind() {
            this.changeVisibility(false);
        }

        protected void updateReplace() {
            this.changeVisibility(true);
        }

        private List getHistory(String string) {
            ArrayList arrayList = (ArrayList)EditorState.get(FindDialogSupport.HISTORY_KEY_BASE + string + "-history");
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            return arrayList;
        }

        private void putHistory(String string, List list) {
            EditorState.put(FindDialogSupport.HISTORY_KEY_BASE + string + "-history", list);
        }

        private void updateHistory(JComboBox jComboBox, String string) {
            Object object = jComboBox.getEditor().getItem();
            List list = this.getHistory(string);
            if (object != null) {
                int n = list.indexOf(object);
                if (n >= 0) {
                    list.remove(n);
                }
                list.add(0, object);
            }
            this.putHistory(string, list);
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
            jComboBox.setModel(defaultComboBoxModel);
        }

        protected void updateFindHistory() {
            this.updateHistory(this.findWhat, "find");
        }

        protected void updateReplaceHistory() {
            this.updateHistory(this.replaceWith, "replace");
        }

        protected void updateFindWhat(String string) {
            this.findWhat.getEditor().setItem(string);
        }

        void load() {
            this.findProps.putAll(this.findSupport.getFindProperties());
            List list = this.getHistory("find");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
            this.findWhat.setModel(defaultComboBoxModel);
            list = this.getHistory("replace");
            defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
            this.replaceWith.setModel(defaultComboBoxModel);
            this.findWhat.getEditor().setItem(this.getProperty(this.findWhat));
            this.replaceWith.getEditor().setItem(this.getProperty(this.replaceWith));
            this.highlightSearch.setSelected(this.getBooleanProperty(this.highlightSearch));
            this.incSearch.setSelected(this.getBooleanProperty(this.incSearch));
            this.matchCase.setSelected(this.getBooleanProperty(this.matchCase));
            this.smartCase.setSelected(this.getBooleanProperty(this.smartCase));
            this.wholeWords.setSelected(this.getBooleanProperty(this.wholeWords));
            this.regExp.setSelected(this.getBooleanProperty(this.regExp));
            this.bwdSearch.setSelected(this.getBooleanProperty(this.bwdSearch));
            this.wrapSearch.setSelected(this.getBooleanProperty(this.wrapSearch));
        }

        void save() {
            this.findSupport.putFindProperties(this.findProps);
        }

        void changeFindWhat() {
            Object object = this.getProperty(this.findWhat);
            Object object2 = this.findWhat.getEditor().getItem();
            if (object == null || !object.equals(object2)) {
                this.putProperty(this.findWhat, object2);
            }
        }

        void changeReplaceWith() {
            Object object = this.getProperty(this.replaceWith);
            Object object2 = this.replaceWith.getEditor().getItem();
            if (object == null || !object.equals(object2)) {
                this.putProperty(this.replaceWith, object2);
            }
        }

        private void postChangeCombos() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ FindPanel this$1;
                {
                    this.this$1 = findPanel;
                }

                public void run() {
                    this.this$1.changeFindWhat();
                    this.this$1.changeReplaceWith();
                    if (this.this$1.regExp.isSelected()) {
                        // empty if block
                    }
                }
            });
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.postChangeCombos();
        }

        public void keyReleased(KeyEvent keyEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ FindPanel this$1;
                {
                    this.this$1 = findPanel;
                }

                public void run() {
                    this.this$1.changeFindWhat();
                    this.this$1.changeReplaceWith();
                }
            });
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                FindDialogSupport.this.actionPerformed(new ActionEvent(FindDialogSupport.this.findButtons[0], 0, null));
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Boolean bl = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
            this.putProperty(itemEvent.getSource(), bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.postChangeCombos();
        }

        static /* synthetic */ FindDialogSupport access$000(FindPanel findPanel) {
            return findPanel.FindDialogSupport.this;
        }
    }
}

