/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.event.ActionEvent;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ToolTipSupport;

public class ExtEditorUI
extends EditorUI {
    private ToolTipSupport toolTipSupport;
    private JPopupMenu popupMenu;
    private Completion completion;
    private boolean noCompletion;

    public ExtEditorUI() {
        this.getToolTipSupport();
        this.getCompletion();
    }

    public ToolTipSupport getToolTipSupport() {
        if (this.toolTipSupport == null) {
            this.toolTipSupport = new ToolTipSupport(this);
        }
        return this.toolTipSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Completion getCompletion() {
        if (this.completion == null) {
            if (this.noCompletion) {
                return null;
            }
            Object object = this.getComponentLock();
            synchronized (object) {
                BaseKit baseKit;
                JTextComponent jTextComponent = this.getComponent();
                if (jTextComponent != null && (baseKit = Utilities.getKit(jTextComponent)) != null && baseKit instanceof ExtKit) {
                    this.completion = ((ExtKit)baseKit).createCompletion(this);
                    if (this.completion == null) {
                        this.noCompletion = true;
                    }
                }
            }
        }
        return this.completion;
    }

    public void showPopupMenu(int n, int n2) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent != null) {
            Object object;
            BaseKit baseKit = Utilities.getKit(jTextComponent);
            if (baseKit != null && (object = baseKit.getActionByName("build-popup-menu")) != null) {
                object.actionPerformed(new ActionEvent(jTextComponent, 0, ""));
            }
            if ((object = this.getPopupMenu()) != null && jTextComponent.isShowing()) {
                ((JPopupMenu)object).show(jTextComponent, n, n2);
            }
        }
    }

    public void hidePopupMenu() {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (jPopupMenu != null) {
            jPopupMenu.setVisible(false);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
    }
}

