/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;

public class ExtCaret
extends BaseCaret {
    public static final String HIGHLIGHT_ROW_LAYER_NAME = "highlight-row-layer";
    public static final int HIGHLIGHT_ROW_LAYER_VISIBILITY = 1600;
    public static final String HIGHLIGHT_BRACE_LAYER_NAME = "highlight-brace-layer";
    public static final int HIGHLIGHT_BRACE_LAYER_VISIBILITY = 11000;
    boolean highlightRow;
    boolean highlightBrace;
    Coloring highlightRowColoring;
    Coloring highlightBraceColoring;
    MarkFactory.DrawMark highlightRowMark;
    MarkFactory.DrawMark highlightBraceStartMark;
    MarkFactory.DrawMark highlightBraceEndMark;
    private Timer braceTimer;
    private ActionListener braceTimerListener;
    private boolean matchBraceUpdateSync;
    boolean braceMarksValid;
    boolean simpleMatchBrace;
    private boolean popupMenuEnabled;
    static final long serialVersionUID = -4292670043122577690L;

    protected void modelChanged(BaseDocument baseDocument, BaseDocument baseDocument2) {
        this.braceMarksValid = false;
        if (this.highlightRowMark != null) {
            try {
                this.highlightRowMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            this.highlightRowMark = null;
        }
        if (this.highlightBraceStartMark != null) {
            try {
                this.highlightBraceStartMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            this.highlightBraceStartMark = null;
        }
        if (this.highlightBraceEndMark != null) {
            try {
                this.highlightBraceEndMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            this.highlightBraceEndMark = null;
        }
        super.modelChanged(baseDocument, baseDocument2);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        super.settingsChange(settingsChangeEvent);
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            Class clazz = Utilities.getKitClass(jTextComponent);
            this.highlightRowColoring = editorUI.getColoring("highlight-caret-row");
            this.highlightBraceColoring = editorUI.getColoring("highlight-match-brace");
            boolean bl = this.highlightRow;
            this.highlightRow = SettingsUtil.getBoolean(clazz, "highlight-caret-row", ExtSettingsDefaults.defaultHighlightCaretRow);
            if (bl && !this.highlightRow && this.highlightRowMark != null) {
                try {
                    this.highlightRowMark.remove();
                }
                catch (InvalidMarkException invalidMarkException) {
                    // empty catch block
                }
                this.highlightRowMark = null;
            }
            this.highlightBrace = SettingsUtil.getBoolean(clazz, "highlight-match-brace", ExtSettingsDefaults.defaultHighlightMatchBrace);
            int n = SettingsUtil.getInteger(clazz, "highlight-match-brace-delay", ExtSettingsDefaults.defaultHighlightMatchBraceDelay);
            if (this.highlightBrace) {
                if (n > 0) {
                    final JTextComponent jTextComponent2 = this.component;
                    this.braceTimer = new Timer(n, null);
                    this.braceTimerListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    BaseDocument baseDocument;
                                    if (1.access$000(this.this$1) != null && (baseDocument = Utilities.getDocument(1.access$000(this.this$1))) != null) {
                                        baseDocument.readLock();
                                        try {
                                            1.access$100(this.this$1).updateMatchBrace();
                                            Object var3_2 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var3_3 = null;
                                            baseDocument.readUnlock();
                                            throw throwable;
                                        }
                                        baseDocument.readUnlock();
                                        {
                                        }
                                    }
                                }
                            });
                        }

                        static /* synthetic */ JTextComponent access$000(1 var0) {
                            return var0.jTextComponent2;
                        }

                        static /* synthetic */ ExtCaret access$100(1 var0) {
                            return var0.ExtCaret.this;
                        }
                    };
                    this.braceTimer.addActionListener(new WeakTimerListener(this.braceTimerListener));
                    this.braceTimer.setRepeats(false);
                } else {
                    this.braceTimer = null;
                }
            }
            this.simpleMatchBrace = SettingsUtil.getBoolean(clazz, "caret-simple-match-brace", ExtSettingsDefaults.defaultCaretSimpleMatchBrace);
            this.popupMenuEnabled = SettingsUtil.getBoolean(clazz, "popup-menu-enabled", true);
        }
    }

    public void install(JTextComponent jTextComponent) {
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        editorUI.addLayer(new HighlightRowLayer(), 1600);
        editorUI.addLayer(new HighlightBraceLayer(), 11000);
        super.install(jTextComponent);
    }

    public void deinstall(JTextComponent jTextComponent) {
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        editorUI.removeLayer(HIGHLIGHT_ROW_LAYER_NAME);
        editorUI.removeLayer(HIGHLIGHT_BRACE_LAYER_NAME);
        super.deinstall(jTextComponent);
    }

    protected void updateMatchBrace() {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null && this.highlightBrace) {
            try {
                int[] nArray;
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = this.getDot();
                boolean bl = false;
                if (n > 0 && (nArray = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).findMatchingBlock(n - 1, this.simpleMatchBrace)) != null) {
                    if (this.highlightBraceStartMark != null) {
                        int n2 = this.highlightBraceStartMark.getOffset();
                        int n3 = this.highlightBraceEndMark.getOffset();
                        if (n2 != nArray[0] || n3 != nArray[1]) {
                            editorUI.repaintBlock(n2, n3);
                            Utilities.moveMark(baseDocument, this.highlightBraceStartMark, nArray[0]);
                            Utilities.moveMark(baseDocument, this.highlightBraceEndMark, nArray[1]);
                            editorUI.repaintBlock(nArray[0], nArray[1]);
                        } else if (!this.braceMarksValid) {
                            editorUI.repaintBlock(nArray[0], nArray[1]);
                        }
                    } else {
                        this.highlightBraceStartMark = new MarkFactory.DrawMark(HIGHLIGHT_BRACE_LAYER_NAME, editorUI);
                        this.highlightBraceEndMark = new MarkFactory.DrawMark(HIGHLIGHT_BRACE_LAYER_NAME, editorUI);
                        this.highlightBraceStartMark.setActivateLayer(true);
                        Utilities.insertMark(baseDocument, this.highlightBraceStartMark, nArray[0]);
                        Utilities.insertMark(baseDocument, this.highlightBraceEndMark, nArray[1]);
                        editorUI.repaintBlock(nArray[0], nArray[1]);
                    }
                    this.braceMarksValid = true;
                    bl = true;
                }
                if (!bl && this.braceMarksValid) {
                    this.braceMarksValid = false;
                    editorUI.repaintBlock(this.highlightBraceStartMark.getOffset(), this.highlightBraceEndMark.getOffset());
                }
            }
            catch (BadLocationException badLocationException) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    badLocationException.printStackTrace();
                }
                this.highlightBrace = false;
            }
            catch (InvalidMarkException invalidMarkException) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    invalidMarkException.printStackTrace();
                }
                this.highlightBrace = false;
            }
        }
    }

    protected void update(Rectangle rectangle, int n) {
        JTextComponent jTextComponent;
        if (this.highlightRow && (jTextComponent = this.component) != null) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n2 = this.getDot();
            try {
                int n3 = Utilities.getRowStart(baseDocument, n2);
                if (this.highlightRowMark != null) {
                    int n4 = this.highlightRowMark.getOffset();
                    if (n3 != n4) {
                        editorUI.repaintOffset(n4);
                        Utilities.moveMark(baseDocument, this.highlightRowMark, n3);
                        editorUI.repaintOffset(n3);
                    }
                } else {
                    this.highlightRowMark = new MarkFactory.DrawMark(HIGHLIGHT_ROW_LAYER_NAME, editorUI);
                    this.highlightRowMark.setActivateLayer(true);
                    Utilities.insertMark(baseDocument, this.highlightRowMark, n3);
                    editorUI.repaintOffset(n3);
                }
            }
            catch (BadLocationException badLocationException) {
                this.highlightRow = false;
            }
            catch (InvalidMarkException invalidMarkException) {
                this.highlightRow = false;
            }
        }
        if (this.highlightBrace) {
            if (this.matchBraceUpdateSync || this.braceTimer == null) {
                this.updateMatchBrace();
                this.matchBraceUpdateSync = false;
            } else {
                this.braceTimer.restart();
            }
        }
        super.update(rectangle, n);
    }

    public void requestMatchBraceUpdateSync() {
        this.matchBraceUpdateSync = true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Completion completion = ExtUtilities.getCompletion(this.component);
        if (completion != null && completion.isPaneVisible()) {
            completion.setPaneVisible(false);
        }
        super.mousePressed(mouseEvent);
    }

    private static boolean isRightMouseButton(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return (n & 0x10) == 0 && (n & 0xC) != 0;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            if (ExtCaret.isRightMouseButton(mouseEvent) && this.popupMenuEnabled) {
                ExtUtilities.getExtEditorUI(jTextComponent).showPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            } else {
                super.mouseReleased(mouseEvent);
            }
        }
    }

    class HighlightBraceLayer
    extends DrawLayer.AbstractLayer {
        public HighlightBraceLayer() {
            super(ExtCaret.HIGHLIGHT_BRACE_LAYER_NAME);
        }

        public void init(DrawContext drawContext) {
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl = false;
            if (drawMark != null && ExtCaret.this.braceMarksValid) {
                bl = drawMark.getActivateLayer();
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (ExtCaret.this.highlightBraceColoring != null) {
                ExtCaret.this.highlightBraceColoring.apply(drawContext);
                Font font = drawContext.getFont();
                if (!font.isBold()) {
                    drawContext.setFont(font.deriveFont(font.getStyle() | 1));
                }
            }
        }
    }

    class HighlightRowLayer
    extends DrawLayerFactory.ColorLineLayer {
        public HighlightRowLayer() {
            super(ExtCaret.HIGHLIGHT_ROW_LAYER_NAME);
        }

        protected Coloring getColoring(DrawContext drawContext) {
            return ExtCaret.this.highlightRowColoring;
        }
    }
}

