/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;

public class TokenContext {
    private static final TokenContext[] EMPTY_CHILDREN = new TokenContext[0];
    private final String namePrefix;
    private final TokenContext[] children;
    private final HashMap pathCache = new HashMap(37);
    private final ArrayList tokenIDList = new ArrayList();
    private final ArrayList tokenCategoryList = new ArrayList();
    private TokenID[] tokenIDs;
    private TokenCategory[] tokenCategories;
    private TokenContextPath contextPath;
    private TokenContextPath[] allContextPaths;
    private TokenContextPath[] lastContextPathPair;
    static /* synthetic */ Class class$org$netbeans$editor$TokenID;

    public TokenContext(String string) {
        this(string, EMPTY_CHILDREN);
    }

    public TokenContext(String string, TokenContext[] tokenContextArray) {
        if (string == null) {
            throw new IllegalArgumentException("Name prefix must be non-null.");
        }
        this.namePrefix = string.intern();
        this.children = tokenContextArray != null ? tokenContextArray : EMPTY_CHILDREN;
        this.contextPath = TokenContextPath.get(new TokenContext[]{this});
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public TokenContext[] getChildren() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTokenID(TokenID tokenID) {
        ArrayList arrayList = this.tokenIDList;
        synchronized (arrayList) {
            this.tokenIDList.add(tokenID);
            this.tokenIDs = null;
            TokenCategory tokenCategory = tokenID.getCategory();
            if (tokenCategory != null && this.tokenCategoryList.indexOf(tokenCategory) < 0) {
                this.tokenCategoryList.add(tokenCategory);
                this.tokenCategories = null;
            }
        }
    }

    protected void addDeclaredTokenIDs() throws IllegalAccessException, SecurityException {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            int n2 = 24;
            if ((fieldArray[n].getModifiers() & n2) == n2 && (class$org$netbeans$editor$TokenID == null ? TokenContext.class$("org.netbeans.editor.TokenID") : class$org$netbeans$editor$TokenID).isAssignableFrom(fieldArray[n].getType())) {
                this.addTokenID((TokenID)fieldArray[n].get(null));
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenID[] getTokenIDs() {
        if (this.tokenIDs == null) {
            ArrayList arrayList = this.tokenIDList;
            synchronized (arrayList) {
                this.tokenIDs = this.tokenIDList.toArray(new TokenID[this.tokenIDList.size()]);
            }
        }
        return this.tokenIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenCategory[] getTokenCategories() {
        if (this.tokenCategories == null) {
            ArrayList arrayList = this.tokenCategoryList;
            synchronized (arrayList) {
                this.tokenCategories = this.tokenCategoryList.toArray(new TokenCategory[this.tokenCategoryList.size()]);
            }
        }
        return this.tokenCategories;
    }

    public TokenContextPath getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenContextPath getContextPath(TokenContextPath tokenContextPath) {
        if (tokenContextPath == null) {
            return this.contextPath;
        }
        TokenContextPath[] tokenContextPathArray = this.lastContextPathPair;
        if (tokenContextPathArray == null || tokenContextPathArray[0] != tokenContextPath) {
            HashMap hashMap = this.pathCache;
            synchronized (hashMap) {
                tokenContextPathArray = (TokenContextPath[])this.pathCache.get(tokenContextPath);
                if (tokenContextPathArray == null) {
                    TokenContext[] tokenContextArray = tokenContextPath.getContexts();
                    TokenContext[] tokenContextArray2 = new TokenContext[tokenContextArray.length + 1];
                    System.arraycopy(tokenContextArray, 0, tokenContextArray2, 0, tokenContextArray.length);
                    tokenContextArray2[tokenContextArray.length] = this;
                    TokenContextPath tokenContextPath2 = TokenContextPath.get(tokenContextArray2);
                    tokenContextPathArray = new TokenContextPath[]{tokenContextPath, tokenContextPath2};
                    this.pathCache.put(tokenContextPath, tokenContextPathArray);
                }
                this.lastContextPathPair = tokenContextPathArray;
            }
        }
        return tokenContextPathArray[1];
    }

    public TokenContextPath[] getAllContextPaths() {
        if (this.allContextPaths == null) {
            ArrayList<TokenContextPath> arrayList = new ArrayList<TokenContextPath>();
            arrayList.add(this.getContextPath());
            int n = 0;
            while (n < this.children.length) {
                TokenContextPath[] tokenContextPathArray = this.children[n].getAllContextPaths();
                int n2 = 0;
                while (n2 < tokenContextPathArray.length) {
                    arrayList.add(this.getContextPath(tokenContextPathArray[n2]));
                    ++n2;
                }
                ++n;
            }
            this.allContextPaths = new TokenContextPath[arrayList.size()];
            arrayList.toArray(this.allContextPaths);
        }
        return this.allContextPaths;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

