/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.HashMap;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Finder;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSeg;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.TokenProcessor;

public class SyntaxSupport {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int MATCH_ARRAY_CACHE_SIZE = 3;
    private HashMap supMap;
    private BaseDocument doc;
    protected boolean tokenNumericIDsValid;
    private int[] tokenBlocks = EMPTY_INT_ARRAY;
    private TokenID[][] lastTokenIDArrays = new TokenID[3][];
    private boolean[][] lastMatchArrays = new boolean[3][];

    public SyntaxSupport(BaseDocument baseDocument) {
        this.doc = baseDocument;
    }

    public final BaseDocument getDocument() {
        return this.doc;
    }

    public synchronized SyntaxSupport get(Class clazz) {
        SyntaxSupport syntaxSupport;
        if (this.supMap == null) {
            this.supMap = new HashMap(11);
        }
        if ((syntaxSupport = (SyntaxSupport)this.supMap.get(clazz)) == null) {
            syntaxSupport = this.createSyntaxSupport(clazz);
            this.supMap.put(clazz, syntaxSupport);
        }
        return syntaxSupport;
    }

    protected SyntaxSupport createSyntaxSupport(Class clazz) {
        if (clazz.isInstance(this)) {
            return this;
        }
        return null;
    }

    private boolean[] getMatchArray(TokenID[] tokenIDArray) {
        boolean[] blArray = null;
        int n = 0;
        while (n < 3) {
            if (tokenIDArray == this.lastTokenIDArrays[n]) {
                blArray = this.lastMatchArrays[n];
                break;
            }
            ++n;
        }
        if (blArray == null) {
            int n2;
            int n3 = -1;
            if (tokenIDArray != null) {
                n2 = 0;
                while (n2 < tokenIDArray.length) {
                    if (tokenIDArray[n2].getNumericID() > n3) {
                        n3 = tokenIDArray[n2].getNumericID();
                    }
                    ++n2;
                }
            }
            blArray = new boolean[n3 + 1];
            n2 = 0;
            while (n2 < tokenIDArray.length) {
                blArray[tokenIDArray[n2].getNumericID()] = true;
                ++n2;
            }
        }
        if (n > 0) {
            n = Math.min(n, 2);
            System.arraycopy(this.lastTokenIDArrays, 0, this.lastTokenIDArrays, 1, n);
            System.arraycopy(this.lastMatchArrays, 0, this.lastMatchArrays, 1, n);
            this.lastTokenIDArrays[0] = tokenIDArray;
            this.lastMatchArrays[0] = blArray;
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] getTokenBlocks(int n, int n2, TokenID[] tokenIDArray) throws BadLocationException {
        int[] nArray;
        this.doc.readLock();
        try {
            boolean[] blArray = this.tokenNumericIDsValid ? this.getMatchArray(tokenIDArray) : null;
            int n3 = 0;
            if (n > n2) {
                int n4 = n;
                n = n2;
                n2 = n4;
            }
            SyntaxSeg.Slot slot = SyntaxSeg.getFreeSlot();
            Syntax syntax = this.doc.getFreeSyntax();
            try {
                this.doc.op.prepareSyntax(slot, syntax, this.doc.op.getLeftSyntaxMark(n), n, n2 - n, true);
                int n5 = syntax.getPreScan();
                int n6 = n - n5;
                int n7 = -1;
                boolean bl = true;
                while (bl) {
                    boolean bl2;
                    TokenID tokenID = syntax.nextToken();
                    if (tokenID == null) {
                        bl = false;
                        continue;
                    }
                    boolean bl3 = bl2 = tokenID != null;
                    if (bl2) {
                        int n8;
                        if (blArray != null) {
                            n8 = tokenID.getNumericID();
                            bl2 = n8 < blArray.length && blArray[n8];
                        } else {
                            bl2 = false;
                            n8 = 0;
                            while (n8 < tokenIDArray.length) {
                                if (tokenID == tokenIDArray[n8]) {
                                    bl2 = true;
                                    break;
                                }
                                ++n8;
                            }
                        }
                    }
                    if (bl2) {
                        if (n7 < 0) {
                            n7 = Math.max(n6, n);
                        }
                    } else if (n7 >= 0) {
                        this.tokenBlocks = this.addTokenBlock(this.tokenBlocks, n3, n7, n6);
                        n3 += 2;
                        n7 = -1;
                    }
                    n6 += syntax.getTokenLength();
                }
                if (n7 >= 0) {
                    this.tokenBlocks = this.addTokenBlock(this.tokenBlocks, n3, n7, n2);
                    n3 += 2;
                }
                Object var16_18 = null;
                this.doc.releaseSyntax(syntax);
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                this.doc.releaseSyntax(syntax);
                SyntaxSeg.releaseSlot(slot);
                throw throwable;
            }
            SyntaxSeg.releaseSlot(slot);
            int[] nArray2 = new int[n3];
            System.arraycopy(this.tokenBlocks, 0, nArray2, 0, n3);
            nArray = nArray2;
            Object var18_21 = null;
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            this.doc.readUnlock();
            throw throwable;
        }
        this.doc.readUnlock();
        return nArray;
    }

    private int[] addTokenBlock(int[] nArray, int n, int n2, int n3) {
        if (nArray.length < n + 2) {
            int[] nArray2 = new int[Math.max(2, nArray.length * 2)];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        nArray[n++] = n2;
        nArray[n] = n3;
        return nArray;
    }

    public int findInsideBlocks(Finder finder, int n, int n2, int[] nArray) throws BadLocationException {
        boolean bl;
        boolean bl2 = bl = n <= n2;
        if (bl) {
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = this.doc.find(finder, nArray[n3], nArray[n3 + 1]);
                if (n4 >= 0) {
                    return n4;
                }
                n3 += 2;
            }
        } else {
            int n5 = nArray.length - 2;
            while (n5 >= 0) {
                int n6 = this.doc.find(finder, nArray[n5 + 1], nArray[n5]);
                if (n6 >= 0) {
                    return n6;
                }
                n5 -= 2;
            }
        }
        return -1;
    }

    public int findOutsideBlocks(Finder finder, int n, int n2, int[] nArray) throws BadLocationException {
        boolean bl;
        boolean bl2 = bl = n <= n2;
        if (bl) {
            int n3 = this.doc.find(finder, n, nArray.length > 0 ? nArray[0] : n2);
            if (n3 >= 0) {
                return n3;
            }
            int n4 = 2;
            while (n4 <= nArray.length) {
                n3 = this.doc.find(finder, nArray[n4 - 1], n4 >= nArray.length ? n2 : nArray[n4]);
                if (n3 >= 0) {
                    return n3;
                }
                n4 += 2;
            }
        } else {
            int n5 = this.doc.find(finder, n, nArray.length > 0 ? nArray[nArray.length - 1] : n2);
            if (n5 >= 0) {
                return n5;
            }
            int n6 = nArray.length - 2;
            while (n6 >= 0) {
                n5 = this.doc.find(finder, nArray[n6], n6 == 0 ? n2 : nArray[n6 - 1]);
                if (n5 >= 0) {
                    return n5;
                }
                n6 -= 2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initSyntax(Syntax syntax, int n, int n2, boolean bl, boolean bl2) throws BadLocationException {
        block3: {
            SyntaxSeg.Slot slot = null;
            this.doc.readLock();
            try {
                slot = SyntaxSeg.getFreeSlot();
                int n3 = this.doc.getLength();
                this.doc.op.prepareSyntax(slot, syntax, this.doc.op.getLeftSyntaxMark(n), n, 0, bl, bl2);
                int n4 = syntax.getPreScan();
                char[] cArray = this.doc.getChars(n - n4, n2 - n + n4);
                boolean bl3 = bl2 ? false : bl || n2 == n3;
                syntax.relocate(cArray, n4, n2 - n, bl3, n2);
                Object var12_11 = null;
                if (slot == null) break block3;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (slot != null) {
                    SyntaxSeg.releaseSlot(slot);
                }
                this.doc.readUnlock();
                throw throwable;
            }
            SyntaxSeg.releaseSlot(slot);
        }
        this.doc.readUnlock();
    }

    public boolean isIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!this.doc.isIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tokenizeText(TokenProcessor tokenProcessor, int n, int n2, boolean bl) throws BadLocationException {
        block9: {
            SyntaxSeg.Slot slot = null;
            Syntax syntax = null;
            this.doc.readLock();
            try {
                slot = SyntaxSeg.getFreeSlot();
                syntax = this.doc.getFreeSyntax();
                int n3 = this.doc.getLength();
                this.doc.op.prepareSyntax(slot, syntax, this.doc.op.getLeftSyntaxMark(n), n, n2 - n, bl);
                int n4 = syntax.getPreScan();
                tokenProcessor.nextBuffer(slot.array, syntax.getOffset(), n2 - n, n, n4, syntax.lastBuffer);
                int n5 = n - syntax.getOffset();
                boolean bl2 = true;
                while (true) {
                    int n6;
                    int n7;
                    if (!bl2) {
                        Object var16_15 = null;
                        if (syntax != null) {
                            this.doc.releaseSyntax(syntax);
                        }
                        if (slot == null) break block9;
                        break;
                    }
                    TokenID tokenID = syntax.nextToken();
                    TokenContextPath tokenContextPath = syntax.getTokenContextPath();
                    if (tokenID == null) {
                        n7 = tokenProcessor.eot(syntax.tokenOffset);
                        if ((n7 = Math.min(n7, n3 - n2)) == 0) {
                            bl2 = false;
                            continue;
                        }
                        n4 = syntax.getPreScan();
                        slot.load(this.doc, n2 - n4, n4 + n7);
                        n6 = bl || n2 + n7 >= n3 ? 1 : 0;
                        syntax.relocate(slot.array, slot.offset + n4, n7, n6 != 0, n2 + n7);
                        tokenProcessor.nextBuffer(slot.array, syntax.getOffset(), n7, n2, n4, n6 != 0);
                        n5 = n2 - syntax.getOffset();
                        n2 += n7;
                        continue;
                    }
                    n7 = syntax.getTokenLength();
                    n6 = syntax.getTokenOffset();
                    if (n5 + n6 + n7 <= n || tokenProcessor.token(tokenID, tokenContextPath, n6, n7)) continue;
                    bl2 = false;
                }
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                if (syntax != null) {
                    this.doc.releaseSyntax(syntax);
                }
                if (slot != null) {
                    SyntaxSeg.releaseSlot(slot);
                }
                this.doc.readUnlock();
                throw throwable;
            }
            SyntaxSeg.releaseSlot(slot);
        }
        this.doc.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenizeText(TokenProcessor tokenProcessor, String string) {
        Syntax syntax = null;
        try {
            syntax = this.doc.getFreeSyntax();
            char[] cArray = string.toCharArray();
            syntax.load(null, cArray, 0, cArray.length, true, -1);
            boolean bl = true;
            while (bl) {
                TokenID tokenID = syntax.nextToken();
                TokenContextPath tokenContextPath = syntax.getTokenContextPath();
                if (tokenID == null) {
                    tokenProcessor.eot(syntax.tokenOffset);
                    bl = false;
                    continue;
                }
                if (tokenProcessor.token(tokenID, tokenContextPath, syntax.getTokenOffset(), syntax.getTokenLength())) continue;
                bl = false;
            }
            Object var9_8 = null;
            if (syntax != null) {
                this.doc.releaseSyntax(syntax);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (syntax != null) {
                this.doc.releaseSyntax(syntax);
            }
            throw throwable;
        }
    }

    public TokenItem getTokenChain(int n) throws BadLocationException {
        if (this.doc.getLength() <= n) {
            return null;
        }
        return null;
    }
}

