/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.KeySequenceInputPanel;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;

public class MacroSavePanel
extends JPanel {
    private Vector bindings = new Vector();
    private Class kitClass;
    private JLabel nameLabel;
    private JTextField nameField;
    private JScrollPane bindingScrollPane;
    private JPanel macroPanel;
    private JButton addButton;
    private JList bindingList;
    private JPanel bindingPanel;
    private JLabel macroLabel;
    private JTextField macroField;
    private JLabel bindingLabel;
    private JButton removeButton;

    public MacroSavePanel(Class clazz) {
        this.kitClass = clazz;
        this.initComponents();
        this.nameLabel.setDisplayedMnemonic(LocaleSupport.getString("MSP_Name_Mnemonic").charAt(0));
        this.macroLabel.setDisplayedMnemonic(LocaleSupport.getString("MSP_Macro_Mnemonic").charAt(0));
        this.bindingLabel.setDisplayedMnemonic(LocaleSupport.getString("MSP_Keys_Mnemonic").charAt(0));
        this.nameField.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MSP_Name"));
        this.macroField.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MSP_Macro"));
        this.bindingList.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MSP_Keys"));
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString("MDS_Title"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MSP"));
        this.setMaximumSize(new Dimension(400, 200));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.getMaximumSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    private void initComponents() {
        this.macroPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.macroLabel = new JLabel();
        this.nameField = new JTextField();
        this.macroField = new JTextField();
        this.bindingPanel = new JPanel();
        this.bindingLabel = new JLabel();
        this.bindingScrollPane = new JScrollPane();
        this.bindingList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.macroPanel.setLayout(new GridBagLayout());
        this.nameLabel.setText(LocaleSupport.getString("MSP_Name", "Name"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagConstraints.anchor = 17;
        this.macroPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.macroLabel.setText(LocaleSupport.getString("MSP_Macro", "Macro"));
        this.macroLabel.setLabelFor(this.macroField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        gridBagConstraints.anchor = 17;
        this.macroPanel.add((Component)this.macroLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.macroPanel.add((Component)this.nameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.macroPanel.add((Component)this.macroField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.macroPanel, gridBagConstraints);
        this.bindingPanel.setLayout(new GridBagLayout());
        this.bindingLabel.setText(LocaleSupport.getString("MSP_Keys", "Keybindings:"));
        this.bindingLabel.setLabelFor(this.bindingList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.bindingPanel.add((Component)this.bindingLabel, gridBagConstraints);
        this.bindingList.setCellRenderer(new KeySequenceCellRenderer());
        this.bindingScrollPane.setViewportView(this.bindingList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.bindingPanel.add((Component)this.bindingScrollPane, gridBagConstraints);
        this.addButton.setToolTipText(LocaleSupport.getString("MSP_AddToolTip", "Add a keybinding for this macro."));
        this.addButton.setMnemonic(LocaleSupport.getString("MSP_Add_Mnemonic").charAt(0));
        this.addButton.setText(LocaleSupport.getString("MSP_Add", "Add..."));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroSavePanel.this.addBindingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 18;
        this.bindingPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setToolTipText(LocaleSupport.getString("MSP_RemoveToolTip", "Remove a keybinding from this macro."));
        this.removeButton.setMnemonic(LocaleSupport.getString("MSP_Remove_Mnemonic").charAt(0));
        this.removeButton.setText(LocaleSupport.getString("MSP_Remove", "Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroSavePanel.this.removeBindingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.bindingPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bindingPanel, gridBagConstraints);
    }

    private void removeBindingActionPerformed(ActionEvent actionEvent) {
        int n = this.bindingList.getSelectedIndex();
        if (n >= 0) {
            this.bindings.remove(n);
            this.bindingList.setListData(this.bindings);
        }
        if (this.bindingList.getModel().getSize() <= 0) {
            this.removeButton.setEnabled(false);
        } else {
            this.bindingList.setSelectedIndex(0);
        }
    }

    private void addBindingActionPerformed(ActionEvent actionEvent) {
        KeyStroke[] keyStrokeArray = new KeySequenceRequester().getKeySequence();
        if (keyStrokeArray != null) {
            this.bindings.add(keyStrokeArray);
            this.bindingList.setListData(this.bindings);
            this.bindingList.setSelectedIndex(0);
            this.removeButton.setEnabled(true);
        }
    }

    public String getName() {
        return this.nameField.getText();
    }

    public void setName(String string) {
        this.nameField.setText(string);
    }

    public String getBody() {
        return this.macroField.getText();
    }

    public void setBody(String string) {
        this.macroField.setText(string);
    }

    public List getKeySequences() {
        return new ArrayList(this.bindings);
    }

    public void setKeySequences(List list) {
        this.bindings = new Vector(list);
        this.bindingList.setListData(this.bindings);
    }

    public void popupNotify() {
        this.nameField.requestFocus();
    }

    class KeySequenceRequester {
        KeySequenceInputPanel panel;
        Dialog dial;
        JButton[] buttons = new JButton[]{new JButton(LocaleSupport.getString("MSP_ok")), new JButton(LocaleSupport.getString("MSP_clear")), new JButton(LocaleSupport.getString("MSP_cancel"))};
        KeyStroke[] retVal = null;

        KeySequenceRequester() {
            this.buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MSP_ok"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MSP_clear"));
            this.buttons[2].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MSP_cancel"));
            this.buttons[1].setMnemonic(LocaleSupport.getString("MSP_clear_Mnemonic").charAt(0));
            this.buttons[0].setEnabled(false);
            this.panel = new KeySequenceInputPanel();
            this.panel.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ KeySequenceRequester this$1;
                {
                    this.this$1 = keySequenceRequester;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (KeySequenceInputPanel.PROP_KEYSEQUENCE != propertyChangeEvent.getPropertyName()) {
                        return;
                    }
                    KeyStroke[] keyStrokeArray = this.this$1.panel.getKeySequence();
                    String string = this.this$1.isAlreadyBounded(keyStrokeArray);
                    if (string == null) {
                        string = this.this$1.getCollisionString(keyStrokeArray);
                    }
                    this.this$1.buttons[0].setEnabled(keyStrokeArray.length > 0 && string == null);
                    this.this$1.panel.setInfoText(string == null ? "" : string);
                }
            });
            this.dial = DialogSupport.createDialog(LocaleSupport.getString("MSP_AddTitle"), this.panel, true, this.buttons, false, -1, 2, new ActionListener(this){
                private final /* synthetic */ KeySequenceRequester this$1;
                {
                    this.this$1 = keySequenceRequester;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.buttons[1]) {
                        this.this$1.panel.clear();
                        this.this$1.panel.requestFocus();
                    } else if (actionEvent.getSource() == this.this$1.buttons[0]) {
                        this.this$1.retVal = this.this$1.panel.getKeySequence();
                        this.this$1.dial.dispose();
                    } else if (actionEvent.getSource() == this.this$1.buttons[2]) {
                        this.this$1.retVal = null;
                        this.this$1.dial.dispose();
                    }
                }
            });
        }

        KeyStroke[] getKeySequence() {
            this.dial.pack();
            this.panel.requestFocus();
            this.dial.show();
            return this.retVal;
        }

        String isAlreadyBounded(KeyStroke[] keyStrokeArray) {
            if (keyStrokeArray.length == 0) {
                return null;
            }
            Iterator iterator = MacroSavePanel.this.bindings.iterator();
            while (iterator.hasNext()) {
                if (!this.isOverlapingSequence((KeyStroke[])iterator.next(), keyStrokeArray)) continue;
                return LocaleSupport.getString("MSP_Collision");
            }
            return null;
        }

        String getCollisionString(KeyStroke[] keyStrokeArray) {
            if (keyStrokeArray.length == 0) {
                return null;
            }
            Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(MacroSavePanel.this.kitClass, "key-bindings");
            int n = 0;
            while (n < kitAndValueArray.length) {
                Iterator iterator = ((List)kitAndValueArray[n].value).iterator();
                while (iterator.hasNext()) {
                    MultiKeyBinding multiKeyBinding = (MultiKeyBinding)iterator.next();
                    KeyStroke[] keyStrokeArray2 = multiKeyBinding.keys;
                    if (keyStrokeArray2 == null && multiKeyBinding.key != null) {
                        keyStrokeArray2 = new KeyStroke[]{multiKeyBinding.key};
                    }
                    if (keyStrokeArray2 == null || !this.isOverlapingSequence(keyStrokeArray2, keyStrokeArray)) continue;
                    Object[] objectArray = new Object[]{Utilities.keySequenceToString(keyStrokeArray2), multiKeyBinding.actionName};
                    return MessageFormat.format(LocaleSupport.getString("MSP_FMT_Collision"), objectArray);
                }
                ++n;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        private boolean isOverlapingSequence(KeyStroke[] var1_1, KeyStroke[] var2_2) {
            var3_3 = Math.min(var1_1.length, var2_2.length);
            if (var3_3 != 0) ** GOTO lbl6
            return false;
lbl-1000:
            // 1 sources

            {
                if (var1_1[var3_3].equals(var2_2[var3_3])) continue;
                return false;
lbl6:
                // 2 sources

                ** while (var3_3-- > 0)
            }
lbl7:
            // 1 sources

            return true;
        }
    }

    private class KeySequenceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public KeySequenceCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(Utilities.keySequenceToString((KeyStroke[])object));
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }
}

