/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseElement;
import org.netbeans.editor.BaseView;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.LeafElement;
import org.netbeans.editor.Utilities;

public class LeafView
extends BaseView {
    protected int mainHeight;
    ModelToViewDG modelToViewDG = new ModelToViewDG();
    ViewToModelDG viewToModelDG = new ViewToModelDG();

    public LeafView(Element element) {
        super(element);
    }

    protected int getPaintAreas(Graphics graphics, int n, int n2) {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = n + n2;
        int n4 = this.getStartY();
        if (this.insets != null) {
            int n5 = n4 + this.insets.top;
            if (n3 <= n5) {
                return 1;
            }
            int n6 = n5 + this.mainHeight;
            if (n3 <= n6) {
                if (n <= n5) {
                    return 3;
                }
                return 2;
            }
            if (n <= n5) {
                return 7;
            }
            if (n <= n6) {
                return 6;
            }
            if (n <= n6 + this.insets.bottom) {
                return 4;
            }
            return 0;
        }
        if (n3 <= n4 || n >= n4 + this.getHeight()) {
            return 0;
        }
        return 2;
    }

    protected void paintAreas(Graphics graphics, int n, int n2, int n3) {
        if ((n3 & 2) == 2) {
            EditorUI editorUI = this.getEditorUI();
            int n4 = Math.max(n, 0);
            int n5 = this.getPosFromY(n4);
            if (n2 > 0) {
                BaseDocument baseDocument = (BaseDocument)this.getDocument();
                try {
                    int n6 = baseDocument.op.getEOL(this.getPosFromY(n + n2 - 1));
                    int n7 = this.getYFromPos(n5);
                    DrawEngine.getDrawEngine().draw(new DrawGraphics.GraphicsDG(graphics), editorUI, n5, n6, this.getBaseX(n7), n7, Integer.MAX_VALUE);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public int getHeight() {
        if (this.insets != null) {
            return this.insets.top + this.mainHeight + this.insets.bottom;
        }
        return this.mainHeight;
    }

    public void updateMainHeight() {
        LeafElement leafElement = (LeafElement)this.getElement();
        try {
            int n = leafElement.getEndMark().getLine() - leafElement.getStartMark().getLine() + 1;
            this.mainHeight = n * this.getEditorUI().getLineHeight();
        }
        catch (InvalidMarkException invalidMarkException) {
            this.mainHeight = 0;
        }
    }

    protected int getPosFromY(int n) {
        int n2;
        block5: {
            n2 = n - this.getStartY() - (this.insets != null ? this.insets.top : 0);
            if (n2 < 0) {
                return this.getStartOffset();
            }
            if (n2 >= this.mainHeight) {
                return this.getEndOffset();
            }
            int n3 = 0;
            try {
                n3 = ((BaseElement)this.getElement()).getStartMark().getLine();
            }
            catch (InvalidMarkException invalidMarkException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block5;
                invalidMarkException.printStackTrace();
            }
        }
        int n4 = this.getStartOffset();
        int n5 = Utilities.getRowStartFromLineOffset((BaseDocument)this.getDocument(), n3 += n2 / this.getEditorUI().getLineHeight());
        if (n5 == -1) {
            n5 = n4;
        }
        return Math.max(n5, n4);
    }

    public int getBaseX(int n) {
        return this.getEditorUI().getTextMargin().left + (this.insets != null ? this.insets.left : 0);
    }

    public final int getViewCount() {
        return 0;
    }

    public final View getView(int n) {
        return null;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        if (biasArray != null) {
            biasArray[0] = Position.Bias.Forward;
        }
        switch (n2) {
            case 1: {
                try {
                    BaseDocument baseDocument = (BaseDocument)this.getDocument();
                    int n3 = baseDocument.op.getVisColFromPos(n);
                    n = baseDocument.op.getOffsetFromVisCol(n3, baseDocument.op.getBOLRelLine(n, -1));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return n;
            }
            case 5: {
                try {
                    BaseDocument baseDocument = (BaseDocument)this.getDocument();
                    int n4 = baseDocument.op.getVisColFromPos(n);
                    n = baseDocument.op.getOffsetFromVisCol(n4, baseDocument.op.getBOLRelLine(n, 1));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return n;
            }
            case 7: {
                return n == -1 ? this.getStartOffset() : n - 1;
            }
            case 3: {
                return n == -1 ? this.getEndOffset() : n + 1;
            }
        }
        throw new IllegalArgumentException("Bad direction: " + n2);
    }

    protected int getYFromPos(int n) throws BadLocationException {
        int n2;
        block2: {
            n2 = 0;
            try {
                n2 = ((BaseDocument)this.getDocument()).op.getLine(n) - ((BaseElement)this.getElement()).getStartMark().getLine();
            }
            catch (InvalidMarkException invalidMarkException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                invalidMarkException.printStackTrace();
            }
        }
        return this.getStartY() + (this.insets != null ? this.insets.top : 0) + n2 * this.getEditorUI().getLineHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Rectangle rectangle;
        block5: {
            EditorUI editorUI = this.getEditorUI();
            rectangle = new Rectangle();
            BaseDocument baseDocument = (BaseDocument)this.getDocument();
            rectangle.y = this.getYFromPos(n);
            try {
                ModelToViewDG modelToViewDG = this.modelToViewDG;
                synchronized (modelToViewDG) {
                    this.modelToViewDG.r = rectangle;
                    int n2 = baseDocument.op.getBOL(n);
                    int n3 = baseDocument.op.getEOL(n);
                    DrawEngine.getDrawEngine().draw(this.modelToViewDG, editorUI, n2, n3, this.getBaseX(rectangle.y), rectangle.y, n);
                    this.modelToViewDG.r = null;
                }
            }
            catch (BadLocationException badLocationException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block5;
                badLocationException.printStackTrace();
            }
        }
        return rectangle;
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle = (Rectangle)this.modelToView(n, shape, bias);
        Rectangle rectangle2 = (Rectangle)this.modelToView(n2, shape, bias2);
        if (rectangle.y != rectangle2.y) {
            rectangle.x = this.getComponent().getX();
            rectangle.width = this.getComponent().getWidth();
        }
        rectangle.add(rectangle2);
        return rectangle;
    }

    public void modelToViewDG(int n, DrawGraphics drawGraphics) throws BadLocationException {
        EditorUI editorUI = this.getEditorUI();
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        int n2 = this.getYFromPos(n);
        DrawEngine.getDrawEngine().draw(drawGraphics, editorUI, baseDocument.op.getBOL(n), baseDocument.op.getEOL(n), this.getBaseX(n2), n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        int n;
        int n2 = (int)f;
        int n3 = (int)f2;
        if (biasArray != null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n3 < (n = this.getStartY() + (this.insets != null ? this.insets.top : 0))) {
            return -1;
        }
        if (n3 > n + this.mainHeight) {
            return this.getEndOffset();
        }
        int n4 = this.getPosFromY(n3);
        EditorUI editorUI = this.getEditorUI();
        try {
            int n5 = ((BaseDocument)this.getDocument()).op.getEOL(n4);
            ViewToModelDG viewToModelDG = this.viewToModelDG;
            synchronized (viewToModelDG) {
                this.viewToModelDG.setTargetX(n2);
                this.viewToModelDG.setEOLOffset(n5);
                DrawEngine.getDrawEngine().draw(this.viewToModelDG, editorUI, n4, n5, this.getBaseX(n3), 0, -1);
                n4 = this.viewToModelDG.getOffset();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n4;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        block8: {
            if (documentEvent.getLength() == 0) {
                this.updateMainHeight();
            } else {
                try {
                    BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
                    EditorUI editorUI = this.getEditorUI();
                    int n = this.getYFromPos(documentEvent.getOffset());
                    int n2 = editorUI.getLineHeight();
                    if (baseDocumentEvent.getLFCount() > 0) {
                        int n3 = baseDocumentEvent.getLFCount() * n2;
                        this.mainHeight += n3;
                        editorUI.repaint(n);
                    } else {
                        int n4 = this.getYFromPos(baseDocumentEvent.getSyntaxUpdateOffset());
                        if (baseDocumentEvent.getSyntaxUpdateOffset() == documentEvent.getDocument().getLength()) {
                            n4 += n2;
                        }
                        if (this.getComponent().isShowing()) {
                            editorUI.repaint(n, Math.max(n2, n4 - n));
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block8;
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        block6: {
            try {
                BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
                EditorUI editorUI = this.getEditorUI();
                int n = this.getYFromPos(documentEvent.getOffset());
                int n2 = editorUI.getLineHeight();
                if (baseDocumentEvent.getLFCount() > 0) {
                    int n3 = baseDocumentEvent.getLFCount() * n2;
                    this.mainHeight -= n3;
                    editorUI.repaint(n);
                } else {
                    int n4 = this.getYFromPos(baseDocumentEvent.getSyntaxUpdateOffset());
                    if (baseDocumentEvent.getSyntaxUpdateOffset() == documentEvent.getDocument().getLength()) {
                        n4 += n2;
                    }
                    if (this.getComponent().isShowing()) {
                        editorUI.repaint(n, Math.max(n2, n4 - n));
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block6;
                badLocationException.printStackTrace();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        block3: {
            try {
                if (this.getComponent().isShowing()) {
                    this.getEditorUI().repaintBlock(documentEvent.getOffset(), documentEvent.getOffset() + documentEvent.getLength());
                }
            }
            catch (BadLocationException badLocationException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                badLocationException.printStackTrace();
            }
        }
    }

    protected int getViewStartY(BaseView baseView, int n) {
        return 0;
    }

    static final class ViewToModelDG
    extends DrawGraphics.SimpleDG {
        int targetX;
        int offset;
        int eolOffset;

        ViewToModelDG() {
        }

        void setTargetX(int n) {
            this.targetX = n;
        }

        void setEOLOffset(int n) {
            this.eolOffset = n;
            this.offset = n;
        }

        int getOffset() {
            return this.offset;
        }

        public boolean targetOffsetReached(int n, char c, int n2, int n3, DrawContext drawContext) {
            if (n <= this.eolOffset) {
                if (n2 + n3 < this.targetX) {
                    this.offset = n;
                    return true;
                }
                this.offset = n;
                if (this.targetX > n2 + n3 / 2) {
                    BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
                    if (c != '\n' && baseDocument != null && n < baseDocument.getLength()) {
                        ++this.offset;
                    }
                }
                return false;
            }
            return false;
        }
    }

    static final class ModelToViewDG
    extends DrawGraphics.SimpleDG {
        Rectangle r;

        ModelToViewDG() {
        }

        public boolean targetOffsetReached(int n, char c, int n2, int n3, DrawContext drawContext) {
            this.r.x = n2;
            this.r.y = this.getY();
            this.r.width = n3;
            this.r.height = this.getLineHeight();
            return false;
        }
    }
}

