/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerList;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.GlyphGutter;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WordMatch;

public class EditorUI
implements ChangeListener,
PropertyChangeListener,
SettingsChangeListener {
    public static final String OVERWRITE_MODE_PROPERTY = "overwriteMode";
    public static final String COMPONENT_PROPERTY = "component";
    public static final int SCROLL_DEFAULT = 0;
    public static final int SCROLL_MOVE = 1;
    public static final int SCROLL_SMALLEST = 2;
    public static final int SCROLL_FIND = 3;
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    private static final Dimension NULL_DIMENSION = new Dimension(0, 0);
    private static final int STYLE_CNT = 4;
    private static final boolean debugUpdateLineHeight = Boolean.getBoolean("netbeans.debug.editor.updateLineHeight");
    private static final HashMap sharedColoringMaps = new HashMap(57);
    private static final SettingsChangeListener clearingListener = new SettingsChangeListener(){

        public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
            sharedColoringMaps.clear();
        }
    };
    private JTextComponent component;
    private JComponent extComponent;
    PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private BaseDocument printDoc;
    private DrawLayerList drawLayerList = new DrawLayerList();
    private Map coloringMap;
    private int lineHeight = 1;
    private float lineHeightCorrection = 1.0f;
    private int lineAscent;
    int defaultSpaceWidth = 1;
    private boolean fontsInited;
    boolean highlightSearch;
    boolean lineNumberEnabled;
    boolean lineNumberVisibleSetting;
    boolean lineNumberVisible;
    int lineNumberWidth;
    int lineNumberDigitWidth;
    int lineNumberMaxDigitCount;
    Insets lineNumberMargin;
    Rectangle virtualSize = new Rectangle();
    int textLeftMarginWidth;
    Insets textMargin = NULL_INSETS;
    Insets scrollJumpInsets;
    Insets scrollFindInsets;
    boolean virtualSizeUpdated;
    private PropertyChangeListener settingsListener;
    Hashtable props = new Hashtable(11);
    boolean textLimitLineVisible;
    Color textLimitLineColor;
    int textLimitWidth;
    private Rectangle lastExtentBounds = new Rectangle();
    private Dimension componentSizeIncrement = new Dimension();
    private Abbrev abbrev;
    private WordMatch wordMatch;
    private Object componentLock;
    StatusBar statusBar;
    private FocusAdapter focusL;
    Map renderingHints;
    private GlyphGutter glyphGutter = null;
    private boolean disableLineNumbers = true;
    private JPanel glyphCorner;
    static /* synthetic */ Class class$org$netbeans$editor$Settings;
    static /* synthetic */ Class class$javax$swing$JViewport;

    public EditorUI() {
        Settings.addSettingsChangeListener(this);
        this.focusL = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Registry.activate(EditorUI.this.getComponent());
            }
        };
    }

    public EditorUI(BaseDocument baseDocument) {
        this.printDoc = baseDocument;
        this.settingsChange(null);
        this.setLineNumberEnabled(true);
        this.updateLineNumberWidth(0);
        this.drawLayerList.add(baseDocument.getDrawLayerList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map getSharedColoringMap(Class clazz) {
        Class clazz2 = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = EditorUI.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz2) {
            Map map = (Map)sharedColoringMaps.get(clazz);
            if (map == null) {
                map = SettingsUtil.getColoringMap(clazz, false, true);
                if (map.get("default") == null) {
                    map.put("default", SettingsDefaults.defaultColoring);
                }
                sharedColoringMaps.put(clazz, map);
            }
            Map map2 = map;
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installUI(JTextComponent jTextComponent) {
        Object object = this.getComponentLock();
        synchronized (object) {
            BaseDocument baseDocument;
            this.component = jTextComponent;
            this.putProperty(COMPONENT_PROPERTY, jTextComponent);
            this.component.addPropertyChangeListener(this);
            this.component.addFocusListener(this.focusL);
            Caret caret = this.component.getCaret();
            if (caret != null) {
                caret.addChangeListener(this);
            }
            if ((baseDocument = this.getDocument()) != null) {
                this.modelChanged(null, baseDocument);
            }
        }
        this.settingsChange(null);
        this.getDefaultColoring().apply(this.component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallUI(JTextComponent jTextComponent) {
        Object object = this.getComponentLock();
        synchronized (object) {
            Object object2;
            if (this.component != null) {
                object2 = this.component.getCaret();
                if (object2 != null) {
                    object2.removeChangeListener(this);
                }
                this.component.removePropertyChangeListener(this);
                this.component.removeFocusListener(this.focusL);
            }
            if ((object2 = this.getDocument()) != null) {
                this.modelChanged((BaseDocument)object2, null);
            }
            this.component = null;
            this.putProperty(COMPONENT_PROPERTY, null);
            FontMetricsCache.clear();
        }
    }

    public Object getComponentLock() {
        if (this.componentLock == null) {
            this.componentLock = new ComponentLock();
        }
        return this.componentLock;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        BaseDocument baseDocument;
        String string;
        if (this.component != null && Utilities.getKit(this.component) == null) {
            return;
        }
        Class clazz = this.getKitClass();
        String string2 = string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        if (string == null || "line-number-visible".equals(string) || "print-line-number-visible".equals(string)) {
            this.lineNumberVisibleSetting = SettingsUtil.getBoolean(clazz, this.component != null ? "line-number-visible" : "print-line-number-visible", this.component != null ? SettingsDefaults.defaultLineNumberVisible : SettingsDefaults.defaultPrintLineNumberVisible);
            boolean bl = this.lineNumberVisible = this.lineNumberEnabled && this.lineNumberVisibleSetting;
            if (this.component == null) {
                this.disableLineNumbers = false;
            }
            if (this.disableLineNumbers) {
                this.lineNumberVisible = false;
            }
        }
        if ((baseDocument = this.getDocument()) != null) {
            Object object;
            if (string == null || "line-number-margin".equals(string)) {
                object = Settings.getValue(clazz, "line-number-margin");
                Insets insets = this.lineNumberMargin = object instanceof Insets ? (Insets)object : NULL_INSETS;
            }
            if (string == null || "text-left-margin-width".equals(string)) {
                this.textLeftMarginWidth = SettingsUtil.getInteger(clazz, "text-left-margin-width", SettingsDefaults.defaultTextLeftMarginWidth);
            }
            if (string == null || "line-height-correction".equals(string)) {
                object = Settings.getValue(clazz, "line-height-correction");
                if (!(object instanceof Float) || ((Float)object).floatValue() < 0.0f) {
                    object = SettingsDefaults.defaultLineHeightCorrection;
                }
                this.lineHeightCorrection = ((Float)object).floatValue();
            }
            if (string == null || "text-limit-line-visible".equals(string)) {
                this.textLimitLineVisible = SettingsUtil.getBoolean(clazz, "text-limit-line-visible", SettingsDefaults.defaultTextLimitLineVisible);
            }
            if (string == null || "text-limit-line-color".equals(string)) {
                object = Settings.getValue(clazz, "text-limit-line-color");
                Color color = this.textLimitLineColor = object instanceof Color ? (Color)object : SettingsDefaults.defaultTextLimitLineColor;
            }
            if (string == null || "text-limit-width".equals(string)) {
                this.textLimitWidth = SettingsUtil.getPositiveInteger(clazz, "text-limit-width", SettingsDefaults.defaultTextLimitWidth);
            }
            if (this.component != null) {
                if (string == null || "scroll-jump-insets".equals(string)) {
                    object = Settings.getValue(clazz, "scroll-jump-insets");
                    Insets insets = this.scrollJumpInsets = object instanceof Insets ? (Insets)object : NULL_INSETS;
                }
                if (string == null || "scroll-find-insets".equals(string)) {
                    object = Settings.getValue(clazz, "scroll-find-insets");
                    Insets insets = this.scrollFindInsets = object instanceof Insets ? (Insets)object : NULL_INSETS;
                }
                if (string == null || "component-size-increment".equals(string)) {
                    object = Settings.getValue(clazz, "component-size-increment");
                    Dimension dimension = this.componentSizeIncrement = object instanceof Dimension ? (Dimension)object : NULL_DIMENSION;
                }
                if (string == null || "rendering-hints".equals(string)) {
                    object = Settings.getValue(clazz, "rendering-hints");
                    Map map = this.renderingHints = object instanceof Map ? (Map)object : null;
                }
                if (string == null || "caret-color-insert-mode".equals(string) || "caret-color-overwrite-mode".equals(string)) {
                    Color color;
                    object = (Boolean)this.getProperty(OVERWRITE_MODE_PROPERTY);
                    if (object == null || !((Boolean)object).booleanValue()) {
                        Object object2 = Settings.getValue(clazz, "caret-color-insert-mode");
                        color = object2 instanceof Color ? (Color)object2 : SettingsDefaults.defaultCaretColorInsertMode;
                    } else {
                        Object object3 = Settings.getValue(clazz, "caret-color-overwrite-mode");
                        Color color2 = color = object3 instanceof Color ? (Color)object3 : SettingsDefaults.defaultCaretColorOvwerwriteMode;
                    }
                    if (color != null) {
                        this.component.setCaretColor(color);
                    }
                }
                this.component.setKeymap(Utilities.getKit(this.component).getKeymap());
                if (SwingUtilities.isEventDispatchThread()) {
                    object = (BaseTextUI)this.component.getUI();
                    ((BaseTextUI)object).updateHeight();
                    this.component.repaint();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (EditorUI.this.component != null) {
                                BaseTextUI baseTextUI = (BaseTextUI)EditorUI.this.component.getUI();
                                baseTextUI.updateHeight();
                                EditorUI.this.component.repaint();
                            }
                        }
                    });
                }
            }
        }
        this.coloringMap = null;
        this.fontsInited = false;
    }

    public void stateChanged(final ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BaseKit baseKit;
                if (EditorUI.this.component != null && (baseKit = Utilities.getKit(EditorUI.this.component)) != null) {
                    boolean bl = ((Caret)changeEvent.getSource()).isSelectionVisible();
                    Action action = baseKit.getActionByName("cut-to-clipboard");
                    if (action != null) {
                        action.setEnabled(bl);
                    }
                    if ((action = baseKit.getActionByName("copy-to-clipboard")) != null) {
                        action.setEnabled(bl);
                    }
                    if ((action = baseKit.getActionByName("remove-selection")) != null) {
                        action.setEnabled(bl);
                    }
                }
            }
        });
    }

    protected void modelChanged(BaseDocument baseDocument, BaseDocument baseDocument2) {
        if (baseDocument != null) {
            this.drawLayerList.remove(baseDocument.getDrawLayerList());
        }
        if (baseDocument2 != null) {
            this.settingsChange(null);
            this.drawLayerList.add(baseDocument2.getDrawLayerList());
        }
        if (baseDocument != null) {
            baseDocument.getBookmarks().removeAll();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string)) {
            BaseDocument baseDocument = propertyChangeEvent.getOldValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getOldValue() : null;
            BaseDocument baseDocument2 = propertyChangeEvent.getNewValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getNewValue() : null;
            this.modelChanged(baseDocument, baseDocument2);
        } else if ("margin".equals(string)) {
            this.updateTextMargin();
        } else if ("caret".equals(string)) {
            if (propertyChangeEvent.getOldValue() instanceof Caret) {
                ((Caret)propertyChangeEvent.getOldValue()).removeChangeListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof Caret) {
                ((Caret)propertyChangeEvent.getNewValue()).addChangeListener(this);
            }
        } else if ("enabled".equals(string) && !this.component.isEnabled()) {
            this.component.getCaret().setVisible(false);
        }
    }

    protected Map createColoringMap() {
        Map map;
        if (this.component != null) {
            map = EditorUI.getSharedColoringMap(this.getKitClass());
        } else {
            map = SettingsUtil.getColoringMap(this.getKitClass(), this.component == null, true);
            if (map.get("default") == null) {
                map.put("default", SettingsDefaults.defaultColoring);
            }
        }
        return map;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getLineAscent() {
        return this.lineAscent;
    }

    public Map getColoringMap() {
        if (this.coloringMap == null) {
            this.coloringMap = this.createColoringMap();
        }
        return this.coloringMap;
    }

    public Coloring getDefaultColoring() {
        return (Coloring)this.getColoringMap().get("default");
    }

    public Coloring getColoring(String string) {
        return (Coloring)this.getColoringMap().get(string);
    }

    private void updateLineHeight(Graphics graphics) {
        if (debugUpdateLineHeight) {
            System.err.println("EditorUI.updateLineHeight(): Computing lineHeight ...");
        }
        Map map = this.getColoringMap();
        Iterator iterator = map.entrySet().iterator();
        int n = 1;
        int n2 = 0;
        while (iterator.hasNext()) {
            FontMetrics fontMetrics;
            Font font;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Coloring coloring = (Coloring)entry.getValue();
            if (coloring == null || (font = coloring.getFont()) == null || (coloring.getFontMode() & 4) == 0 || (fontMetrics = graphics.getFontMetrics(font)) == null) continue;
            if (debugUpdateLineHeight) {
                if (n < fontMetrics.getHeight()) {
                    System.err.println("Updating maxHeight from " + n + " to " + fontMetrics.getHeight() + ", coloringName=" + string + ", font=" + font);
                }
                if (n < fontMetrics.getHeight()) {
                    System.err.println("Updating maxAscent from " + n2 + " to " + fontMetrics.getAscent() + ", coloringName=" + string + ", font=" + font);
                }
            }
            n = Math.max(n, fontMetrics.getHeight());
            n2 = Math.max(n2, fontMetrics.getAscent());
        }
        this.lineHeight = (int)((float)n * this.lineHeightCorrection);
        this.lineAscent = (int)((float)n2 * this.lineHeightCorrection);
    }

    boolean isFontsInited() {
        return this.fontsInited;
    }

    protected void update(Graphics graphics) {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Object object2;
        Class clazz = Utilities.getKitClass(this.component);
        if (clazz != null) {
            object2 = Settings.getValue(clazz, "margin");
            serializable2 = object2 instanceof Insets ? (Insets)object2 : null;
            this.component.setMargin((Insets)serializable2);
        }
        this.getDefaultColoring().apply(this.component);
        if (this.renderingHints != null) {
            ((Graphics2D)graphics).setRenderingHints(this.renderingHints);
        }
        object2 = this.getDefaultColoring();
        serializable2 = (Coloring)this.getColoringMap().get("line-number");
        if (serializable2 != null) {
            object = ((Coloring)serializable2).getFont();
            if (object == null) {
                object = ((Coloring)object2).getFont();
            }
            serializable = graphics.getFontMetrics((Font)object);
            int n = 1;
            char[] cArray = new char[1];
            int n2 = 0;
            while (n2 <= 9) {
                cArray[0] = (char)(48 + n2);
                n = Math.max(n, ((FontMetrics)serializable).charsWidth(cArray, 0, 1));
                ++n2;
            }
            this.lineNumberDigitWidth = n;
        }
        this.updateLineHeight(graphics);
        object = FontMetricsCache.getInfo(this.getDefaultColoring().getFont());
        this.defaultSpaceWidth = object.getSpaceWidth(graphics);
        if (this.component != null) {
            ((BaseTextUI)this.component.getUI()).updateHeight();
            this.updateLineNumberWidth(0);
            this.checkLineLimit();
        }
        try {
            serializable = this.getParentViewport();
            if (serializable != null) {
                Method method = (class$javax$swing$JViewport == null ? (class$javax$swing$JViewport = EditorUI.class$("javax.swing.JViewport")) : class$javax$swing$JViewport).getDeclaredMethod("setScrollMode", Integer.TYPE);
                method.invoke((Object)serializable, new Integer(0));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fontsInited = true;
        if (this.isGlyphGutterVisible()) {
            this.glyphGutter.update();
            this.updateScrollPaneCornerColor();
        }
        this.updateVirtualHeight(0);
    }

    public final JTextComponent getComponent() {
        return this.component;
    }

    public final BaseDocument getDocument() {
        return this.component != null ? Utilities.getDocument(this.component) : this.printDoc;
    }

    private Class getKitClass() {
        return this.component != null ? Utilities.getKitClass(this.component) : (this.printDoc != null ? this.printDoc.getKitClass() : null);
    }

    public Object getProperty(Object object) {
        return this.props.get(object);
    }

    public void putProperty(Object object, Object object2) {
        Object object3 = object2 != null ? this.props.put(object, object2) : this.props.remove(object);
        this.firePropertyChange(object.toString(), object3, object2);
    }

    public JComponent getExtComponent() {
        if (this.extComponent == null && this.component != null) {
            this.setLineNumberEnabled(true);
            this.extComponent = new JPanel(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.component);
            jScrollPane.getViewport().setMinimumSize(new Dimension(4, 4));
            this.glyphGutter = new GlyphGutter(this);
            jScrollPane.setRowHeaderView(this.glyphGutter);
            this.glyphCorner = new JPanel();
            this.updateScrollPaneCornerColor();
            jScrollPane.setCorner("LOWER_LEFT_CORNER", this.glyphCorner);
            this.extComponent.add(jScrollPane);
            this.extComponent.add((Component)this.getStatusBar().getPanel(), "South");
        }
        return this.extComponent;
    }

    public boolean hasExtComponent() {
        return this.extComponent != null;
    }

    public Abbrev getAbbrev() {
        if (this.abbrev == null) {
            this.abbrev = new Abbrev(this, true, true);
        }
        return this.abbrev;
    }

    public WordMatch getWordMatch() {
        if (this.wordMatch == null) {
            this.wordMatch = new WordMatch(this);
        }
        return this.wordMatch;
    }

    public StatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new StatusBar(this);
        }
        return this.statusBar;
    }

    final DrawLayerList getDrawLayerList() {
        return this.drawLayerList;
    }

    public DrawLayer findLayer(String string) {
        return this.drawLayerList.findLayer(string);
    }

    public boolean addLayer(DrawLayer drawLayer, int n) {
        return this.drawLayerList.add(drawLayer, n);
    }

    public DrawLayer removeLayer(String string) {
        return this.drawLayerList.remove(string);
    }

    public void repaint(int n) {
        this.repaint(n, this.component.getHeight());
    }

    public void repaint(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = Math.max(this.component.getWidth(), 0);
        n = Math.max(n, 0);
        this.component.repaint(0, n, n3, n2);
    }

    public void repaintOffset(int n) throws BadLocationException {
        this.repaintBlock(n, n);
    }

    public void repaintBlock(int n, int n2) throws BadLocationException {
        block3: {
            int n3;
            BaseTextUI baseTextUI = (BaseTextUI)this.component.getUI();
            if (n > n2) {
                n3 = n;
                n = n2;
                n2 = n3;
            }
            try {
                n3 = baseTextUI.getYFromPos(n);
                int n4 = baseTextUI.getYFromPos(n2);
                this.repaint(n3, n4 - n3 + this.lineHeight);
            }
            catch (BadLocationException badLocationException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                badLocationException.printStackTrace();
            }
        }
    }

    private JViewport getParentViewport() {
        Container container = this.component.getParent();
        return container instanceof JViewport ? (JViewport)container : null;
    }

    public static Frame getParentFrame(Component component) {
        do {
            if (!((component = component.getParent()) instanceof Frame)) continue;
            return (Frame)component;
        } while (component != null);
        return null;
    }

    public boolean updateVirtualWidth(int n) {
        boolean bl = false;
        if (n > this.virtualSize.width) {
            int n2 = this.componentSizeIncrement.width;
            n2 = n2 < 0 ? this.lastExtentBounds.width * -n2 / 100 : n2 * this.defaultSpaceWidth;
            this.virtualSize.width = n + n2;
            this.virtualSizeUpdated = true;
            bl = true;
        }
        return bl;
    }

    public boolean updateVirtualHeight(int n) {
        boolean bl = false;
        this.updateLineNumberWidth(0);
        if (n > 0) {
            if (n > this.virtualSize.height) {
                int n2 = this.componentSizeIncrement.height;
                n2 = n2 < 0 ? this.lastExtentBounds.height * -n2 / 100 : n2 * this.lineHeight;
                this.virtualSize.height = n + n2;
                this.virtualSizeUpdated = true;
                bl = true;
            }
            if (n < this.virtualSize.height - this.lastExtentBounds.height) {
                this.virtualSize.height = n;
                this.virtualSizeUpdated = true;
                bl = true;
            }
        } else {
            n = (int)this.component.getUI().getRootView(this.component).getPreferredSpan(1);
            if (n != this.virtualSize.height) {
                this.virtualSize.height = n;
                this.virtualSizeUpdated = true;
                bl = true;
            }
        }
        return bl;
    }

    public boolean isLineNumberEnabled() {
        return this.lineNumberEnabled;
    }

    public void setLineNumberEnabled(boolean bl) {
        this.lineNumberEnabled = bl;
        boolean bl2 = this.lineNumberVisible = bl && this.lineNumberVisibleSetting;
        if (this.disableLineNumbers) {
            this.lineNumberVisible = false;
        }
    }

    public void updateLineNumberWidth(int n) {
        int n2 = this.lineNumberWidth;
        if (this.lineNumberVisible) {
            try {
                if (n <= 0) {
                    BaseDocument baseDocument = this.getDocument();
                    int n3 = Utilities.getLineOffset(baseDocument, baseDocument.getLength()) + 1;
                    n = Integer.toString(n3).length();
                }
                if (n > this.lineNumberMaxDigitCount) {
                    this.lineNumberMaxDigitCount = n;
                }
            }
            catch (BadLocationException badLocationException) {
                this.lineNumberMaxDigitCount = 1;
            }
            this.lineNumberWidth = this.lineNumberMaxDigitCount * this.lineNumberDigitWidth;
            if (this.lineNumberMargin != null) {
                this.lineNumberWidth += this.lineNumberMargin.left + this.lineNumberMargin.right;
            }
        } else {
            this.lineNumberWidth = 0;
        }
        this.updateTextMargin();
        if (n2 != this.lineNumberWidth && this.component != null) {
            this.component.repaint();
        }
    }

    void checkLineLimit() {
        FontMetrics fontMetrics;
        Integer n;
        BaseDocument baseDocument = this.getDocument();
        if (baseDocument != null && (n = (Integer)baseDocument.getProperty("line-limit")) != null && this.component != null && (fontMetrics = this.component.getFontMetrics(this.getDefaultColoring().getFont())) != null) {
            int n2 = fontMetrics.stringWidth("A");
            this.updateVirtualWidth(n2 * n + this.lineNumberWidth);
        }
    }

    public void updateTextMargin() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorUI.this.updateTextMargin();
                }
            });
        }
        Insets insets = this.textMargin;
        Insets insets2 = this.component != null ? this.component.getMargin() : null;
        int n = this.lineNumberWidth + this.textLeftMarginWidth;
        this.textMargin = insets2 != null ? new Insets(insets2.top, insets2.left + n, insets2.bottom, insets2.right) : new Insets(0, n, 0, 0);
        if (insets.top != this.textMargin.top || insets.bottom != this.textMargin.bottom) {
            ((BaseTextUI)this.component.getUI()).invalidateStartY();
        }
    }

    public Rectangle getExtentBounds() {
        return this.getExtentBounds(null);
    }

    public Rectangle getExtentBounds(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (this.component != null) {
            JViewport jViewport = this.getParentViewport();
            if (jViewport != null) {
                Point point = jViewport.getViewPosition();
                rectangle.width = jViewport.getWidth();
                rectangle.height = jViewport.getHeight();
                rectangle.x = point.x;
                rectangle.y = point.y;
            } else {
                rectangle.setBounds(this.component.getVisibleRect());
            }
        }
        return rectangle;
    }

    public Insets getTextMargin() {
        return this.textMargin;
    }

    public void scrollRectToVisible(final Rectangle rectangle, final int n) {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                EditorUI.this.scrollRectToVisibleFragile(rectangle, n);
            }
        });
    }

    boolean scrollRectToVisibleFragile(Rectangle rectangle, int n) {
        Insets insets = this.getTextMargin();
        Rectangle rectangle2 = this.getExtentBounds();
        rectangle = new Rectangle(rectangle);
        rectangle.x -= insets.left;
        rectangle.y -= insets.top;
        rectangle2.width -= insets.left + insets.right;
        rectangle2.height -= insets.top + insets.bottom;
        return this.scrollRectToVisibleImpl(rectangle, n, rectangle2);
    }

    private boolean scrollRectToVisibleImpl(Rectangle rectangle, int n, Rectangle rectangle2) {
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return false;
        }
        if (n == 3) {
            int n2 = this.scrollFindInsets.left < 0 ? -rectangle2.width * this.scrollFindInsets.left / 100 : this.scrollFindInsets.left * this.defaultSpaceWidth;
            int n3 = Math.max(rectangle.x - n2, 0);
            n2 = this.scrollFindInsets.right < 0 ? -rectangle2.width * this.scrollFindInsets.right / 100 : this.scrollFindInsets.right * this.defaultSpaceWidth;
            rectangle.width += rectangle.x - n3 + n2;
            rectangle.x = n3;
            n2 = this.scrollFindInsets.top < 0 ? -rectangle2.height * this.scrollFindInsets.top / 100 : this.scrollFindInsets.top * this.lineHeight;
            int n4 = Math.max(rectangle.y - n2, 0);
            n2 = this.scrollFindInsets.bottom < 0 ? -rectangle2.height * this.scrollFindInsets.bottom / 100 : this.scrollFindInsets.bottom * this.lineHeight;
            rectangle.height += rectangle.y - n4 + n2;
            rectangle.y = n4;
            return this.scrollRectToVisibleImpl(rectangle, 2, rectangle2);
        }
        if (rectangle.x + rectangle.width > this.virtualSize.width) {
            rectangle.x = this.virtualSize.width - rectangle.width;
            if (rectangle.x < 0) {
                rectangle.x = 0;
                rectangle.width = this.virtualSize.width;
            }
            return this.scrollRectToVisibleImpl(rectangle, n, rectangle2);
        }
        if (rectangle.y + rectangle.height > this.virtualSize.height) {
            rectangle.y = this.virtualSize.height - rectangle.height;
            if (rectangle.y < 0) {
                rectangle.y = 0;
                rectangle.height = this.virtualSize.height;
            }
            return this.scrollRectToVisibleImpl(rectangle, n, rectangle2);
        }
        if (rectangle.width > rectangle2.width || rectangle.height > rectangle2.height) {
            Rectangle rectangle3 = new Rectangle((Rectangle)((Object)this.component.getCaret()));
            if (rectangle3.x >= rectangle.x && rectangle3.x + rectangle3.width <= rectangle.x + rectangle.width && rectangle3.y >= rectangle.y && rectangle3.y + rectangle3.height <= rectangle.y + rectangle.height) {
                int n5 = rectangle.width - rectangle2.width;
                int n6 = rectangle.height - rectangle2.height;
                if (n5 > 0) {
                    rectangle.x -= n5 * (rectangle3.x - rectangle.x) / rectangle.width;
                }
                if (n6 > 0) {
                    rectangle.y -= n6 * (rectangle3.y - rectangle.y) / rectangle.height;
                }
            }
            rectangle.height = rectangle2.height;
            rectangle.width = rectangle2.width;
            return this.scrollRectToVisibleImpl(rectangle, n, rectangle2);
        }
        int n7 = rectangle2.x;
        int n8 = rectangle2.y;
        boolean bl = false;
        if (rectangle.x < rectangle2.x) {
            bl = true;
            switch (n) {
                case 1: {
                    n7 = this.scrollJumpInsets.left < 0 ? rectangle2.width * -this.scrollJumpInsets.left / 100 : this.scrollJumpInsets.left * this.defaultSpaceWidth;
                    n7 = Math.min(n7, rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width));
                    n7 = Math.max(rectangle.x - n7, 0);
                    break;
                }
                default: {
                    n7 = rectangle.x;
                }
            }
            this.updateVirtualWidth(n7 + rectangle2.width);
        } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            bl = true;
            switch (n) {
                case 2: {
                    n7 = rectangle.x + rectangle.width - rectangle2.width;
                    break;
                }
                default: {
                    n7 = this.scrollJumpInsets.right < 0 ? rectangle2.width * -this.scrollJumpInsets.right / 100 : this.scrollJumpInsets.right * this.defaultSpaceWidth;
                    n7 = Math.min(n7, rectangle2.width - rectangle.width);
                    n7 = rectangle.x + rectangle.width + n7 - rectangle2.width;
                }
            }
            this.updateVirtualWidth(n7 + rectangle2.width);
        }
        if (rectangle.y < rectangle2.y) {
            bl = true;
            switch (n) {
                case 1: {
                    n8 = rectangle.y;
                    n8 -= this.scrollJumpInsets.top < 0 ? rectangle2.height * -this.scrollJumpInsets.top / 100 : this.scrollJumpInsets.top * this.lineHeight;
                    break;
                }
                case 2: {
                    n8 = rectangle.y;
                    break;
                }
                default: {
                    n8 = rectangle.y - (rectangle2.height - rectangle.height) / 2;
                }
            }
            n8 = Math.max(n8, 0);
        } else if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            bl = true;
            switch (n) {
                case 1: {
                    n8 = rectangle.y + rectangle.height - rectangle2.height;
                    n8 += this.scrollJumpInsets.bottom < 0 ? rectangle2.height * -this.scrollJumpInsets.bottom / 100 : this.scrollJumpInsets.bottom * this.lineHeight;
                    break;
                }
                case 2: {
                    n8 = rectangle.y + rectangle.height - rectangle2.height;
                    break;
                }
                default: {
                    n8 = rectangle.y - (rectangle2.height - rectangle.height) / 2;
                }
            }
            n8 = Math.max(n8, 0);
        }
        if (bl) {
            this.setExtentPosition(n7, n8);
        }
        return bl;
    }

    void setExtentPosition(int n, int n2) {
        JViewport jViewport = this.getParentViewport();
        if (jViewport != null) {
            Point point = new Point(Math.max(n, 0), Math.max(n2, 0));
            jViewport.setViewPosition(point);
        }
    }

    public void adjustWindow(int n) {
        final Rectangle rectangle = this.getExtentBounds();
        if (this.component != null && this.component.getCaret() instanceof Rectangle) {
            Rectangle rectangle2 = (Rectangle)((Object)this.component.getCaret());
            rectangle.y = rectangle2.y - n * rectangle.height / 100 + n * this.lineHeight / 100;
            Utilities.runInEventDispatchThread(new Runnable(){

                public void run() {
                    EditorUI.this.scrollRectToVisible(rectangle, 2);
                }
            });
        }
    }

    public void adjustCaret(int n) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            Rectangle rectangle = this.getExtentBounds();
            rectangle.y += n * rectangle.height / 100 - n * this.lineHeight / 100;
            try {
                int n2 = ((BaseTextUI)jTextComponent.getUI()).getPosFromY(rectangle.y);
                if (n2 >= 0) {
                    this.caretSetDot(n2, null, 2);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void caretSetDot(int n, Rectangle rectangle, int n2) {
        if (this.component != null) {
            Caret caret = this.component.getCaret();
            if (caret instanceof BaseCaret) {
                ((BaseCaret)caret).setDot(n, rectangle, n2);
            } else {
                caret.setDot(n);
            }
        }
    }

    public void caretMoveDot(int n, Rectangle rectangle, int n2) {
        if (this.component != null) {
            Caret caret = this.component.getCaret();
            if (caret instanceof BaseCaret) {
                ((BaseCaret)caret).moveDot(n, rectangle, n2);
            } else {
                caret.moveDot(n);
            }
        }
    }

    protected void paint(Graphics graphics) {
        if (this.component != null) {
            if (!this.fontsInited && graphics != null) {
                this.update(graphics);
                this.getExtentBounds(this.lastExtentBounds);
            }
            ((BaseTextUI)this.component.getUI()).paintRegion(graphics);
        }
    }

    public Insets getLineNumberMargin() {
        return this.lineNumberMargin;
    }

    public int getLineNumberDigitWidth() {
        return this.lineNumberDigitWidth;
    }

    public boolean isGlyphGutterVisible() {
        return this.glyphGutter != null;
    }

    protected void updateScrollPaneCornerColor() {
        Coloring coloring = (Coloring)this.getColoringMap().get("line-number");
        Coloring coloring2 = this.getDefaultColoring();
        Color color = coloring.getBackColor() != null ? coloring.getBackColor() : coloring2.getBackColor();
        this.glyphCorner.setBackground(color);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Settings.addSettingsChangeListener(clearingListener);
    }

    static class ComponentLock {
        ComponentLock() {
        }
    }
}

