/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Map;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;

final class DocMarks {
    private static final Mark[] EMPTY = new Mark[0];
    private Mark[] marks = EMPTY;
    private int marksLengthM1 = -1;
    private int gapStart;
    private int gapEnd;
    private int dataGapStart;
    private int dataGapEnd = 0x3FFFFFFF;
    private int dataGapLineCount = 0x3FFFFFFF;
    int unusedMarksCount;
    Mark startMark = new Mark(true);

    DocMarks() {
        this.insert(this.startMark);
    }

    synchronized int getMarksCount() {
        return this.marks.length - (this.gapEnd - this.gapStart);
    }

    synchronized void insert(Mark mark) {
        int n = mark.offset;
        boolean bl = mark.backwardBias;
        int n2 = this.findInsertIndex(n, bl);
        if (this.gapStart == this.gapEnd) {
            this.increaseAndMoveGap(1, n2);
            n2 = this.gapStart;
        } else if (n2 != this.gapStart) {
            this.moveGap(n2);
            n2 = this.gapStart;
        }
        if (n > this.dataGapStart || n == this.dataGapStart && !bl) {
            mark.offset += this.dataGapEnd - this.dataGapStart;
            mark.line += this.dataGapLineCount;
        }
        this.marks[this.gapStart++] = mark;
        mark.valid = true;
    }

    synchronized void dispose(Mark mark) {
        mark.valid = false;
        ++this.unusedMarksCount;
        if (this.unusedMarksCount > Math.max(5, this.marks.length - (this.gapEnd - this.gapStart))) {
            this.removeDisposedMarks();
        }
    }

    synchronized void remove(Mark mark) {
        int n = this.findIndex(mark);
        if (n < 0) {
            throw new IllegalStateException("Invalid mark " + mark);
        }
        if (n == this.gapEnd) {
            this.marks[this.gapEnd++] = null;
        } else if (n == this.gapStart - 1) {
            this.marks[--this.gapStart] = null;
        } else {
            this.moveGap(n + 1);
            this.marks[--this.gapStart] = null;
        }
        mark.valid = false;
    }

    private void moveGap(int n) {
        if (n <= this.gapStart) {
            int n2 = this.gapStart - n;
            this.gapEnd -= n2;
            System.arraycopy(this.marks, n, this.marks, this.gapEnd, n2);
            this.gapStart = n;
        } else {
            int n3 = n - this.gapEnd;
            System.arraycopy(this.marks, this.gapEnd, this.marks, this.gapStart, n3);
            this.gapStart += n3;
            this.gapEnd += n3;
        }
    }

    private void increaseAndMoveGap(int n, int n2) {
        int n3 = this.marks.length * 3 / 2 + n;
        Mark[] markArray = new Mark[n3];
        this.marksLengthM1 = n3 - 1;
        if (n2 <= this.gapStart) {
            int n4 = this.marks.length - this.gapEnd;
            if (n4 > 0) {
                System.arraycopy(this.marks, this.gapEnd, markArray, n3 -= n4, n4);
            }
            if ((n4 = this.gapStart - n2) > 0) {
                System.arraycopy(this.marks, n2, markArray, n3 -= n4, n4);
            }
            if (n2 > 0) {
                System.arraycopy(this.marks, 0, markArray, 0, n2);
            }
            this.gapStart = n2;
            this.gapEnd = n3;
        } else {
            int n5;
            if (this.gapStart > 0) {
                System.arraycopy(this.marks, 0, markArray, 0, this.gapStart);
            }
            if ((n5 = n2 - this.gapEnd) > 0) {
                System.arraycopy(this.marks, this.gapEnd, markArray, this.gapStart, n5);
                this.gapStart += n5;
            }
            if ((n5 = this.marks.length - n2) > 0) {
                System.arraycopy(this.marks, n2, markArray, n3 -= n5, n5);
            }
            this.gapEnd = n3;
            n2 += markArray.length - this.marks.length;
        }
        this.marks = markArray;
    }

    synchronized void update(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n3 < 0) {
            n -= n3;
        }
        int n7 = this.dataGapEnd - this.dataGapStart;
        if (this.dataGapStart < n) {
            n6 = this.findInsertIndex(this.dataGapStart, true);
            n5 = n + n7;
            int n8 = n6 <= this.gapStart ? this.gapStart - 1 : this.marksLengthM1;
            while (true) {
                if (n6 <= n8) {
                    Mark mark = this.marks[n6];
                    if (mark.offset > n5 || mark.offset == n5 && !mark.backwardBias) {
                        n8 = this.marksLengthM1;
                    } else {
                        mark.offset -= n7;
                        mark.line -= this.dataGapLineCount;
                        ++n6;
                        continue;
                    }
                }
                if (n8 >= this.marksLengthM1) break;
                n8 = this.marksLengthM1;
                n6 = this.gapEnd;
            }
            this.dataGapEnd += n - this.dataGapStart;
            this.dataGapStart = n;
        } else if (this.dataGapStart > n) {
            n6 = this.findInsertIndex(this.dataGapStart, true);
            n5 = n6 >= this.gapEnd ? this.gapEnd : 0;
            while (true) {
                if (n6 > n5) {
                    Mark mark = this.marks[--n6];
                    if (mark.offset < n || mark.offset == n && mark.backwardBias) {
                        n5 = 0;
                        ++n6;
                    } else {
                        mark.offset += n7;
                        mark.line += this.dataGapLineCount;
                        continue;
                    }
                }
                if (n5 <= 0 || this.gapStart <= 0) break;
                n6 = this.gapStart;
                n5 = 0;
            }
            this.dataGapEnd -= this.dataGapStart - n;
            this.dataGapStart = n;
        } else {
            n6 = n3 < 0 ? this.findInsertIndex(n, true) : 0;
        }
        this.dataGapStart += n3;
        this.dataGapLineCount -= n4;
        if (n3 < 0) {
            n5 = -1;
            int n9 = n6 >= this.gapEnd ? this.gapEnd : 0;
            int n10 = (n += n3) + (this.dataGapEnd - this.dataGapStart);
            int n11 = n2 + this.dataGapLineCount;
            while (true) {
                if (n6 > n9) {
                    Mark mark = this.marks[--n6];
                    if (mark.offset < n || mark.offset == n && mark.backwardBias) {
                        n9 = 0;
                    } else {
                        if (mark.backwardBias) {
                            mark.offset = n;
                            mark.line = n2;
                            if (n5 >= 0) continue;
                            n5 = n6;
                            continue;
                        }
                        mark.offset = n10;
                        mark.line = n11;
                        if (n5 < 0) continue;
                        this.marks[n6] = this.marks[n5];
                        this.marks[n5] = mark;
                        if (n5 == this.gapEnd) {
                            n5 = this.gapStart;
                        }
                        --n5;
                        continue;
                    }
                }
                if (n9 <= 0 || this.gapStart <= 0) break;
                n6 = this.gapStart;
                n9 = 0;
            }
        }
    }

    private void removeDisposedMarks() {
        Mark mark;
        int n = 0;
        int n2 = 0;
        while (n < this.gapStart) {
            mark = this.marks[n];
            if (!mark.valid) {
                mark.removeDisposed();
            } else if (n != n2) {
                this.marks[n2++] = mark;
            }
            ++n;
        }
        this.gapStart = n2;
        n = this.marksLengthM1;
        n2 = n + 1;
        while (n >= this.gapEnd) {
            mark = this.marks[n];
            if (!mark.valid) {
                mark.removeDisposed();
            } else if (n != --n2) {
                this.marks[n2] = mark;
            }
            --n;
        }
        this.gapEnd = n2;
    }

    synchronized int getOffset(Mark mark) {
        int n = mark.offset;
        return n <= this.dataGapStart ? n : n - (this.dataGapEnd - this.dataGapStart);
    }

    synchronized int getLine(Mark mark) {
        return mark.offset <= this.dataGapStart ? mark.line : mark.line - this.dataGapLineCount;
    }

    int findIndex(Mark mark) {
        int n = this.getOffset(mark);
        int n2 = this.findInsertIndex(n, mark.backwardBias);
        int n3 = n2 >= this.gapEnd ? this.gapEnd : 0;
        while (true) {
            if (n2 > n3) {
                if (this.marks[--n2] != mark) continue;
                return n2;
            }
            if (n3 <= 0 || this.gapStart <= 0) break;
            n2 = this.gapStart;
            n3 = 0;
        }
        return -1;
    }

    int findInsertIndex(int n, boolean bl) {
        int n2;
        int n3;
        boolean bl2;
        if (!bl) {
            ++n;
        }
        boolean bl3 = bl2 = this.gapStart > 0 && this.getOffset(this.marks[this.gapStart - 1]) >= n;
        if (bl2) {
            n3 = 0;
            n2 = this.gapStart - 1;
        } else {
            n3 = this.gapEnd;
            n2 = this.marksLengthM1;
        }
        while (n3 <= n2) {
            int n4 = (n3 + n2) / 2;
            Mark mark = this.marks[n4];
            int n5 = this.getOffset(mark);
            if (n5 < n) {
                n3 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n2 = n4 - 1;
                continue;
            }
            if (!bl) {
                int n6 = bl2 ? 0 : this.gapEnd;
                while (true) {
                    if (--n4 >= n6) {
                        mark = this.marks[n4];
                        if (this.getOffset(mark) >= n) continue;
                        n6 = 0;
                    }
                    if (n6 <= 0) break;
                    n6 = 0;
                    n4 = this.gapStart;
                }
                ++n4;
            } else if (!mark.backwardBias) {
                int n7 = bl2 ? 0 : this.gapEnd;
                while (true) {
                    if (--n4 >= n7) {
                        mark = this.marks[n4];
                        if (this.getOffset(mark) >= n && !mark.backwardBias) continue;
                        n7 = 0;
                    }
                    if (n7 <= 0) break;
                    n7 = 0;
                    n4 = this.gapStart;
                }
                ++n4;
            } else {
                int n8 = bl2 ? this.gapStart - 1 : this.marksLengthM1;
                while (true) {
                    if (++n4 <= n8) {
                        mark = this.marks[n4];
                        if (this.getOffset(mark) <= n && mark.backwardBias) continue;
                        n8 = Integer.MAX_VALUE;
                    }
                    if (n8 >= this.marksLengthM1) break;
                    n8 = this.marksLengthM1;
                    n4 = this.gapEnd - 1;
                }
            }
            if (n4 == this.gapEnd) {
                n4 = this.gapStart;
            }
            return n4;
        }
        if (!bl2 && n3 == this.gapEnd) {
            n3 = this.gapStart;
        }
        return n3;
    }

    synchronized Mark getLeftMark(int n, Class clazz) {
        Mark mark = null;
        boolean bl = false;
        if (n > 0) {
            int n2 = this.findInsertIndex(n - 1, false);
            if (n2 > this.marksLengthM1) {
                n2 = this.gapEnd <= this.marksLengthM1 ? --n2 : this.gapStart;
            }
            if (n2 == this.gapStart) {
                if (this.gapStart > 0) {
                    --n2;
                } else {
                    mark = clazz == null ? this.startMark : null;
                    bl = true;
                }
            } else {
                if (n2 == this.gapEnd) {
                    n2 = this.gapStart;
                }
                if (--n2 < 0) {
                    mark = clazz == null ? this.startMark : null;
                    bl = true;
                }
            }
            if (!bl) {
                int n3 = n2 <= this.gapStart ? 0 : this.gapEnd;
                while (true) {
                    if (n2 >= n3) {
                        Mark mark2 = this.marks[n2--];
                        if (clazz != null && !clazz.isInstance(mark2)) continue;
                        mark = mark2;
                        bl = true;
                        n3 = 0;
                    }
                    if (n3 <= 0) break;
                    n3 = 0;
                    n2 = this.gapStart - 1;
                }
            }
        }
        if (!bl) {
            Mark mark3 = mark = clazz == null ? this.startMark : null;
        }
        if (mark != null && !mark.valid) {
            throw new IllegalStateException("Invalid mark");
        }
        return mark;
    }

    synchronized Mark getOffsetMark(int n, Class clazz) {
        int n2 = this.findInsertIndex(n, false);
        int n3 = n2 <= this.gapStart ? 0 : this.gapEnd;
        while (true) {
            if (--n2 >= n3) {
                Mark mark = this.marks[n2];
                if (this.getOffset(mark) != n) {
                    return null;
                }
                if (clazz != null && !clazz.isInstance(mark)) continue;
                return mark;
            }
            if (n3 <= 0) break;
            n3 = 0;
            n2 = this.gapStart;
        }
        return null;
    }

    public synchronized void render(Renderer renderer) {
        renderer.marks = this;
        renderer.render();
        renderer.marks = null;
    }

    synchronized Mark getMarkFromLine(int n) {
        int n2;
        int n3;
        boolean bl;
        boolean bl2 = bl = this.gapEnd <= this.marksLengthM1 && this.getLine(this.marks[this.gapEnd]) <= n;
        if (!bl) {
            n3 = 0;
            n2 = this.gapStart - 1;
        } else {
            n3 = this.gapEnd;
            n2 = this.marksLengthM1;
        }
        while (n3 <= n2) {
            int n4 = (n3 + n2) / 2;
            Mark mark = this.marks[n4];
            int n5 = this.getLine(mark);
            if (n5 < n) {
                n3 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n2 = n4 - 1;
                continue;
            }
            return mark;
        }
        return n2 >= 0 ? this.marks[n2] : this.startMark;
    }

    void check() {
        int n = 0;
        int n2 = this.gapStart - 1;
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        while (true) {
            if (n <= n2) {
                Mark mark = this.marks[n++];
                if (mark.offset < n3 || mark.offset == n3 && mark.backwardBias && !bl) {
                    this.consistencyError(true, n - 1);
                }
                if (mark.line < n4) {
                    this.consistencyError(false, n - 1);
                }
                n3 = mark.offset;
                n4 = mark.line;
                bl = mark.backwardBias;
                continue;
            }
            if (n2 >= this.marksLengthM1) break;
            n2 = this.marksLengthM1;
            n = this.gapEnd;
        }
    }

    private void consistencyError(boolean bl, int n) {
        throw new IllegalStateException("DocMarks.check(): " + (bl ? "Offset" : "Line") + " inconsistency found at ind=" + n + ", mark=" + this.marks[n]);
    }

    public String toStringDetail() {
        return this.toStringDetail(null);
    }

    String toStringDetail(Map map) {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        stringBuffer.append('\n');
        boolean bl = true;
        do {
            int n = bl ? 0 : this.gapEnd;
            int n2 = bl ? this.gapStart : this.marks.length;
            stringBuffer.append("Marks ");
            stringBuffer.append(bl ? "before" : "after");
            stringBuffer.append(" gap:\n");
            while (n < n2) {
                Mark mark = this.marks[n];
                Mark mark2 = null;
                if (map != null && (mark2 = (Mark)map.get(mark)) == null) {
                    throw new IllegalStateException("No test mark for mark=" + mark);
                }
                try {
                    stringBuffer.append("[");
                    stringBuffer.append(n);
                    stringBuffer.append("]: (");
                    stringBuffer.append(mark.offset);
                    stringBuffer.append(", ");
                    stringBuffer.append(mark.line);
                    stringBuffer.append(", ");
                    stringBuffer.append(mark.backwardBias ? (char)'B' : 'F');
                    stringBuffer.append(") -> (");
                    stringBuffer.append(mark.getOffset());
                    stringBuffer.append(", ");
                    stringBuffer.append(mark.getLine());
                    stringBuffer.append(')');
                    if (mark2 != null) {
                        stringBuffer.append(" testMark: (");
                        stringBuffer.append(mark2.offset);
                        stringBuffer.append(", ");
                        stringBuffer.append(mark2.line);
                        stringBuffer.append(", ");
                        stringBuffer.append(mark2.backwardBias ? (char)'B' : 'F');
                        stringBuffer.append(')');
                    }
                    stringBuffer.append('\n');
                }
                catch (InvalidMarkException invalidMarkException) {
                    invalidMarkException.printStackTrace();
                    throw new IllegalStateException();
                }
                ++n;
            }
        } while (!(bl = !bl));
        return stringBuffer.toString();
    }

    public String toString() {
        return "marksCount=" + this.getMarksCount() + ", gapStart=" + this.gapStart + ", gapEnd=" + this.gapEnd + ", dataLen=" + (Integer.MAX_VALUE - (this.dataGapEnd - this.dataGapStart)) + ", dataGapStart=" + this.dataGapStart + ", dataGapEnd=" + this.dataGapEnd + ", dataGapLineCount=" + this.dataGapLineCount;
    }

    static abstract class Renderer {
        DocMarks marks;

        Renderer() {
        }

        DocMarks getMarks() {
            return this.marks;
        }

        Mark[] copyAllMarks() {
            Mark[] markArray = new Mark[this.marks.getMarksCount()];
            System.arraycopy(this.marks.marks, 0, markArray, 0, this.marks.gapStart);
            System.arraycopy(this.marks.marks, this.marks.gapEnd, markArray, this.marks.gapStart, this.marks.marks.length - this.marks.gapEnd);
            return markArray;
        }

        Mark[] getMarkArray() {
            return this.marks.marks;
        }

        int getMarkArrayLength() {
            return this.marks.marks.length;
        }

        int getMarkIndex(Mark mark) {
            if (!mark.valid) {
                throw new IllegalStateException();
            }
            return this.marks.findIndex(mark);
        }

        int getMarkOffset(Mark mark) {
            if (!mark.valid) {
                throw new IllegalStateException();
            }
            return this.marks.getOffset(mark);
        }

        int getNextIndex(int n) {
            if (++n == this.marks.gapStart) {
                n = this.marks.gapEnd;
            }
            return n;
        }

        abstract void render();
    }
}

