/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DocOp;

public class BaseDocumentEvent
extends AbstractDocument.DefaultDocumentEvent {
    private DocOp.ModifyUndoEdit modifyUndoEdit;
    private BaseDocumentEvent previous;
    private boolean inUndo;
    private boolean inRedo;
    private boolean hasBeenDone2 = true;
    private boolean alive2 = true;
    private boolean inProgress2 = true;
    private Hashtable changeLookup2;
    static final long serialVersionUID = -7624299835780414963L;
    static /* synthetic */ Class class$org$netbeans$editor$DocOp$ModifyUndoEdit;
    static /* synthetic */ Class class$org$netbeans$editor$BaseDocumentEvent$DrawLayerChange;

    public BaseDocumentEvent(BaseDocument baseDocument, int n, int n2, DocumentEvent.EventType eventType) {
        super(baseDocument, n, n2, eventType);
    }

    protected UndoableEdit findEdit(Class clazz) {
        int n = this.edits.size() - 1;
        while (n >= 0) {
            Object e = this.edits.get(n);
            if (clazz.isInstance(e)) {
                return (UndoableEdit)e;
            }
            --n;
        }
        return null;
    }

    private DocOp.ModifyUndoEdit getModifyUndoEdit() {
        if (this.getType() == DocumentEvent.EventType.CHANGE) {
            throw new IllegalStateException("Cannot be called for CHANGE events.");
        }
        if (this.modifyUndoEdit == null) {
            this.modifyUndoEdit = (DocOp.ModifyUndoEdit)this.findEdit(class$org$netbeans$editor$DocOp$ModifyUndoEdit == null ? (class$org$netbeans$editor$DocOp$ModifyUndoEdit = BaseDocumentEvent.class$("org.netbeans.editor.DocOp$ModifyUndoEdit")) : class$org$netbeans$editor$DocOp$ModifyUndoEdit);
        }
        return this.modifyUndoEdit;
    }

    public char[] getChars() {
        return this.getModifyUndoEdit() != null ? this.getModifyUndoEdit().getChars() : null;
    }

    public String getText() {
        return this.getModifyUndoEdit() != null ? this.getModifyUndoEdit().getText() : null;
    }

    public int getLine() {
        return this.getModifyUndoEdit() != null ? this.getModifyUndoEdit().getLine() : 0;
    }

    public int getLFCount() {
        return this.getModifyUndoEdit() != null ? this.getModifyUndoEdit().getLFCount() : 0;
    }

    public int getSyntaxUpdateOffset() {
        return this.getModifyUndoEdit() != null ? this.getModifyUndoEdit().getSyntaxUpdateOffset() : 0;
    }

    public String getDrawLayerName() {
        if (this.getType() != DocumentEvent.EventType.CHANGE) {
            throw new IllegalStateException("Can be called for CHANGE events only.");
        }
        DrawLayerChange drawLayerChange = (DrawLayerChange)this.findEdit(class$org$netbeans$editor$BaseDocumentEvent$DrawLayerChange == null ? (class$org$netbeans$editor$BaseDocumentEvent$DrawLayerChange = BaseDocumentEvent.class$("org.netbeans.editor.BaseDocumentEvent$DrawLayerChange")) : class$org$netbeans$editor$BaseDocumentEvent$DrawLayerChange);
        return drawLayerChange != null ? drawLayerChange.getDrawLayerName() : null;
    }

    public int getDrawLayerVisibility() {
        if (this.getType() != DocumentEvent.EventType.CHANGE) {
            throw new IllegalStateException("Can be called for CHANGE events only.");
        }
        DrawLayerChange drawLayerChange = (DrawLayerChange)this.findEdit(class$org$netbeans$editor$BaseDocumentEvent$DrawLayerChange == null ? (class$org$netbeans$editor$BaseDocumentEvent$DrawLayerChange = BaseDocumentEvent.class$("org.netbeans.editor.BaseDocumentEvent$DrawLayerChange")) : class$org$netbeans$editor$BaseDocumentEvent$DrawLayerChange);
        return drawLayerChange != null ? drawLayerChange.getDrawLayerVisibility() : -1;
    }

    public boolean isInUndo() {
        return this.inUndo;
    }

    public boolean isInRedo() {
        return this.inRedo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() throws CannotUndoException {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        this.inUndo = true;
        baseDocument.extWriteLock();
        try {
            if (!this.canUndo()) {
                throw new CannotUndoException();
            }
            this.hasBeenDone2 = false;
            baseDocument.lastModifyUndoEdit = null;
            int n = this.edits.size();
            while (n-- > 0) {
                UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n);
                undoableEdit.undo();
            }
            if (this.getType() == DocumentEvent.EventType.REMOVE) {
                baseDocument.fireInsertUpdate(this);
            } else if (this.getType() == DocumentEvent.EventType.INSERT) {
                baseDocument.fireRemoveUpdate(this);
            } else {
                baseDocument.fireChangedUpdate(this);
            }
            Object var5_4 = null;
            baseDocument.extWriteUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            baseDocument.extWriteUnlock();
            throw throwable;
        }
        if (this.previous != null) {
            this.previous.undo();
        }
        this.inUndo = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() throws CannotRedoException {
        this.inRedo = true;
        if (this.previous != null) {
            this.previous.redo();
        }
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        baseDocument.extWriteLock();
        try {
            if (!this.canRedo()) {
                throw new CannotRedoException();
            }
            this.hasBeenDone2 = true;
            Enumeration enumeration = this.edits.elements();
            while (enumeration.hasMoreElements()) {
                ((UndoableEdit)enumeration.nextElement()).redo();
            }
            if (this.getType() == DocumentEvent.EventType.INSERT) {
                baseDocument.fireInsertUpdate(this);
            } else if (this.getType() == DocumentEvent.EventType.REMOVE) {
                baseDocument.fireRemoveUpdate(this);
            } else {
                baseDocument.fireChangedUpdate(this);
            }
            Object var4_3 = null;
            baseDocument.extWriteUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            baseDocument.extWriteUnlock();
            throw throwable;
        }
        this.inRedo = false;
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (this.changeLookup2 == null && this.edits.size() > 10) {
            this.changeLookup2 = new Hashtable();
            int n = this.edits.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.edits.elementAt(n2);
                if (e instanceof DocumentEvent.ElementChange) {
                    DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)e;
                    this.changeLookup2.put(elementChange.getElement(), elementChange);
                }
                ++n2;
            }
        }
        if (this.changeLookup2 != null && undoableEdit instanceof DocumentEvent.ElementChange) {
            DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)((Object)undoableEdit);
            this.changeLookup2.put(elementChange.getElement(), elementChange);
        }
        if (!this.inProgress2) {
            return false;
        }
        UndoableEdit undoableEdit2 = this.lastEdit();
        if (undoableEdit2 == null) {
            this.edits.addElement(undoableEdit);
        } else if (!undoableEdit2.addEdit(undoableEdit)) {
            if (undoableEdit.replaceEdit(undoableEdit2)) {
                this.edits.removeElementAt(this.edits.size() - 1);
            }
            this.edits.addElement(undoableEdit);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLastModifyUndoEdit() {
        BaseDocument baseDocument;
        block4: {
            if (this.getType() == DocumentEvent.EventType.CHANGE) {
                return true;
            }
            baseDocument = (BaseDocument)this.getDocument();
            baseDocument.extWriteLock();
            try {
                if (baseDocument.lastModifyUndoEdit != null) break block4;
                boolean bl = true;
                Object var5_4 = null;
                baseDocument.extWriteUnlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                baseDocument.extWriteUnlock();
                throw throwable;
            }
        }
        DocOp.ModifyUndoEdit modifyUndoEdit = this.getModifyUndoEdit();
        boolean bl = modifyUndoEdit == baseDocument.lastModifyUndoEdit;
        Object var5_5 = null;
        baseDocument.extWriteUnlock();
        return bl;
    }

    public boolean canUndo() {
        return !this.inProgress2 && this.alive2 && this.hasBeenDone2 && this.isLastModifyUndoEdit();
    }

    public boolean canRedo() {
        return !this.inProgress2 && this.alive2 && !this.hasBeenDone2;
    }

    public boolean isInProgress() {
        return this.inProgress2;
    }

    public String getUndoPresentationName() {
        return "";
    }

    public String getRedoPresentationName() {
        return "";
    }

    protected final BaseDocumentEvent getPrevious() {
        return this.previous;
    }

    public boolean canMerge(BaseDocumentEvent baseDocumentEvent) {
        if (this.getType() == DocumentEvent.EventType.INSERT) {
            if (baseDocumentEvent.getType() == DocumentEvent.EventType.INSERT) {
                String string = this.getText();
                String string2 = baseDocumentEvent.getText();
                if ((this.getLength() == 1 || this.getLength() > 1 && Analyzer.isSpace(string)) && (baseDocumentEvent.getLength() == 1 || baseDocumentEvent.getLength() > 1 && Analyzer.isSpace(string2)) && baseDocumentEvent.getOffset() + baseDocumentEvent.getLength() == this.getOffset()) {
                    BaseDocument baseDocument = (BaseDocument)this.getDocument();
                    boolean bl = baseDocument.isIdentifierPart(string.charAt(0));
                    boolean bl2 = baseDocument.isIdentifierPart(string2.charAt(0));
                    if (bl && bl2) {
                        return true;
                    }
                    boolean bl3 = baseDocument.isWhitespace(string.charAt(0));
                    boolean bl4 = baseDocument.isWhitespace(string2.charAt(0));
                    if (bl4 && bl3 || !bl4 && !bl2 && !bl3 && !bl) {
                        return true;
                    }
                }
            }
        } else if (baseDocumentEvent.getType() == DocumentEvent.EventType.INSERT) {
            // empty if block
        }
        return false;
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        if (undoableEdit instanceof BaseDocumentEvent) {
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)undoableEdit;
            if (!baseDocument.undoMergeReset && this.canMerge(baseDocumentEvent)) {
                this.previous = baseDocumentEvent;
                return true;
            }
        }
        baseDocument.undoMergeReset = false;
        return false;
    }

    public void die() {
        int n = this.edits.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n2);
            undoableEdit.die();
            --n2;
        }
        this.alive2 = false;
        if (this.previous != null) {
            this.previous.die();
            this.previous = null;
        }
    }

    public void end() {
        this.inProgress2 = false;
    }

    public DocumentEvent.ElementChange getChange(Element element) {
        if (this.changeLookup2 != null) {
            return (DocumentEvent.ElementChange)this.changeLookup2.get(element);
        }
        int n = this.edits.size();
        int n2 = 0;
        while (n2 < n) {
            DocumentEvent.ElementChange elementChange;
            Object e = this.edits.elementAt(n2);
            if (e instanceof DocumentEvent.ElementChange && (elementChange = (DocumentEvent.ElementChange)e).getElement() == element) {
                return elementChange;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return System.identityHashCode(this) + " " + super.toString() + ", type=" + this.getType() + (this.getType() != DocumentEvent.EventType.CHANGE ? "text='" + this.getText() + "'" : "");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DrawLayerChange
    extends AbstractUndoableEdit {
        String drawLayerName;
        int drawLayerVisibility;

        DrawLayerChange(String string, int n) {
            this.drawLayerName = string;
            this.drawLayerVisibility = n;
        }

        public String getDrawLayerName() {
            return this.drawLayerName;
        }

        public int getDrawLayerVisibility() {
            return this.drawLayerVisibility;
        }
    }
}

