/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkChain;
import org.netbeans.editor.Utilities;

public class Annotations
implements DocumentListener {
    private HashMap lineAnnotationsByMark = new HashMap(30);
    private ArrayList lineAnnotationsArray = new ArrayList(20);
    private DrawLayerFactory.AnnotationLayer drawLayer = null;
    private BaseDocument doc;
    private EventListenerList listenerList = new EventListenerList();
    private PropertyChangeListener l;
    private PropertyChangeListener annoTypesListener;
    private boolean glyphColumn = false;
    private boolean glyphButtonColumn = false;
    static /* synthetic */ Class class$org$netbeans$editor$Annotations$AnnotationsListener;

    public Annotations(BaseDocument baseDocument) {
        this.doc = baseDocument;
        baseDocument.addLayer(new DrawLayerFactory.AnnotationLayer(baseDocument), 2100);
        this.doc.addDocumentListener(this);
        this.l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AnnotationDesc annotationDesc;
                if (propertyChangeEvent.getPropertyName() == "annotationType") {
                    annotationDesc = (AnnotationDesc)propertyChangeEvent.getSource();
                    LineAnnotations lineAnnotations = (LineAnnotations)Annotations.this.lineAnnotationsByMark.get(annotationDesc.getMark());
                    lineAnnotations.refreshAnnotations();
                    Annotations.this.refreshLine(lineAnnotations.getLine());
                }
                if (propertyChangeEvent.getPropertyName() == "moveToFront") {
                    annotationDesc = (AnnotationDesc)propertyChangeEvent.getSource();
                    Annotations.this.frontAnnotation(annotationDesc);
                }
            }
        };
        this.annoTypesListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LineAnnotations lineAnnotations;
                Iterator iterator;
                if (propertyChangeEvent.getPropertyName() == "combineGlyphs") {
                    iterator = Annotations.this.lineAnnotationsArray.iterator();
                    while (iterator.hasNext()) {
                        lineAnnotations = (LineAnnotations)iterator.next();
                        lineAnnotations.refreshAnnotations();
                    }
                }
                if (propertyChangeEvent.getPropertyName() == "annotationTypes") {
                    iterator = Annotations.this.lineAnnotationsArray.iterator();
                    while (iterator.hasNext()) {
                        lineAnnotations = (LineAnnotations)iterator.next();
                        Iterator iterator2 = lineAnnotations.getAnnotations();
                        while (iterator2.hasNext()) {
                            AnnotationDesc annotationDesc = (AnnotationDesc)iterator2.next();
                            annotationDesc.updateAnnotationType();
                        }
                    }
                }
                Annotations.this.fireChangedAll();
            }
        };
        AnnotationTypes.getTypes().addPropertyChangeListener(this.annoTypesListener);
    }

    public synchronized DrawLayerFactory.AnnotationLayer getLayer() {
        if (this.drawLayer == null) {
            this.drawLayer = (DrawLayerFactory.AnnotationLayer)this.doc.findLayer("annotation-layer");
        }
        return this.drawLayer;
    }

    public void addAnnotation(AnnotationDesc annotationDesc) {
        MarkChain markChain = this.getLayer().getMarkChain();
        try {
            markChain.addMark(annotationDesc.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        annotationDesc.setMark(markChain.getAddedMark());
        LineAnnotations lineAnnotations = this.getLineAnnotations(annotationDesc.getLine());
        if (lineAnnotations == null) {
            lineAnnotations = new LineAnnotations();
            lineAnnotations.addAnnotation(annotationDesc);
            this.lineAnnotationsByMark.put(annotationDesc.getMark(), lineAnnotations);
            boolean bl = false;
            int n = 0;
            while (n < this.lineAnnotationsArray.size()) {
                if (((LineAnnotations)this.lineAnnotationsArray.get(n)).getLine() > lineAnnotations.getLine()) {
                    this.lineAnnotationsArray.add(n, lineAnnotations);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.lineAnnotationsArray.add(lineAnnotations);
            }
        } else {
            lineAnnotations.addAnnotation(annotationDesc);
            if (this.lineAnnotationsByMark.get(annotationDesc.getMark()) == null) {
                this.lineAnnotationsByMark.put(annotationDesc.getMark(), lineAnnotations);
            }
        }
        annotationDesc.addPropertyChangeListener(this.l);
        if (annotationDesc.isVisible() && (!annotationDesc.isDefaultGlyph() || annotationDesc.isDefaultGlyph() && lineAnnotations.getCount() > 1)) {
            this.glyphColumn = true;
        }
        if (lineAnnotations.getCount() > 1) {
            this.glyphButtonColumn = true;
        }
        this.refreshLine(lineAnnotations.getLine());
    }

    public void removeAnnotation(AnnotationDesc annotationDesc) {
        LineAnnotations lineAnnotations = (LineAnnotations)this.lineAnnotationsByMark.get(annotationDesc.getMark());
        int n = lineAnnotations.getLine();
        lineAnnotations.removeAnnotation(annotationDesc);
        if (!lineAnnotations.isMarkStillReferenced(annotationDesc.getMark())) {
            this.lineAnnotationsByMark.remove(annotationDesc.getMark());
            MarkChain markChain = this.getLayer().getMarkChain();
            markChain.removeMark(annotationDesc.getOffset());
        }
        if (lineAnnotations.getCount() == 0) {
            this.lineAnnotationsArray.remove(this.lineAnnotationsArray.indexOf(lineAnnotations));
        }
        annotationDesc.setMark(null);
        annotationDesc.removePropertyChangeListener(this.l);
        this.refreshLine(n);
    }

    public AnnotationDesc getActiveAnnotation(Mark mark) {
        LineAnnotations lineAnnotations = (LineAnnotations)this.lineAnnotationsByMark.get(mark);
        if (lineAnnotations == null) {
            return null;
        }
        AnnotationDesc annotationDesc = lineAnnotations.getActive();
        if (annotationDesc.getMark() != mark) {
            return null;
        }
        return annotationDesc;
    }

    protected LineAnnotations getLineAnnotations(int n) {
        int n2 = 0;
        while (n2 < this.lineAnnotationsArray.size()) {
            LineAnnotations lineAnnotations = (LineAnnotations)this.lineAnnotationsArray.get(n2);
            if (lineAnnotations.getLine() == n) {
                return lineAnnotations;
            }
            ++n2;
        }
        return null;
    }

    public AnnotationDesc getActiveAnnotation(int n) {
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return null;
        }
        return lineAnnotations.getActive();
    }

    public void frontAnnotation(AnnotationDesc annotationDesc) {
        int n = annotationDesc.getLine();
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return;
        }
        lineAnnotations.activate(annotationDesc);
        this.refreshLine(n);
    }

    public AnnotationDesc activateNextAnnotation(int n) {
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return null;
        }
        AnnotationDesc annotationDesc = lineAnnotations.activateNext();
        this.refreshLine(n);
        return annotationDesc;
    }

    public int getNextLineWithAnnotation(int n) {
        int n2 = 0;
        while (n2 < this.lineAnnotationsArray.size()) {
            LineAnnotations lineAnnotations = (LineAnnotations)this.lineAnnotationsArray.get(n2);
            if (lineAnnotations.getLine() >= n) {
                return lineAnnotations.getLine();
            }
            ++n2;
        }
        return -1;
    }

    public AnnotationDesc getAnnotation(int n, String string) {
        return null;
    }

    public AnnotationDesc[] getPasiveAnnotations(int n) {
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return null;
        }
        if (lineAnnotations.getCount() <= 1) {
            return null;
        }
        return lineAnnotations.getPasive();
    }

    public int getNumberOfAnnotations(int n) {
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return 0;
        }
        return lineAnnotations.getCount();
    }

    protected void refreshLine(int n) {
        this.fireChangedLine(n);
        int n2 = Utilities.getRowStartFromLineOffset(this.doc, n);
        int n3 = Utilities.getRowStartFromLineOffset(this.doc, n + 1);
        if (n3 == -1) {
            n3 = this.doc.getLength();
        }
        this.doc.repaintBlock(n2, n3);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
        int n = baseDocumentEvent.getLFCount();
        if (n == 0) {
            return;
        }
        int n2 = baseDocumentEvent.getLine();
        int n3 = 0;
        while (n3 < this.lineAnnotationsArray.size()) {
            LineAnnotations lineAnnotations = (LineAnnotations)this.lineAnnotationsArray.get(n3);
            if (lineAnnotations.getLine() > n2 && lineAnnotations.getLine() < n2 + n) {
                lineAnnotations.setLine(n2);
            }
            if (lineAnnotations.getLine() > n2) {
                lineAnnotations.setLine(lineAnnotations.getLine() - n);
            }
            ++n3;
        }
        this.fireChangedAll();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
        int n = baseDocumentEvent.getLFCount();
        if (n == 0) {
            return;
        }
        int n2 = baseDocumentEvent.getLine();
        LineAnnotations lineAnnotations = null;
        int n3 = 0;
        while (n3 < this.lineAnnotationsArray.size()) {
            LineAnnotations lineAnnotations2 = (LineAnnotations)this.lineAnnotationsArray.get(n3);
            if (lineAnnotations2.getLine() == n2 && lineAnnotations2.getActive().getOffset() > documentEvent.getOffset()) {
                lineAnnotations = lineAnnotations2;
            }
            if (lineAnnotations2.getLine() > n2) {
                lineAnnotations2.setLine(lineAnnotations2.getLine() + n);
            }
            ++n3;
        }
        if (lineAnnotations != null) {
            lineAnnotations.setLine(lineAnnotations.getLine() + n);
        }
        this.fireChangedAll();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void addAnnotationsListener(AnnotationsListener annotationsListener) {
        this.listenerList.add(class$org$netbeans$editor$Annotations$AnnotationsListener == null ? (class$org$netbeans$editor$Annotations$AnnotationsListener = Annotations.class$("org.netbeans.editor.Annotations$AnnotationsListener")) : class$org$netbeans$editor$Annotations$AnnotationsListener, annotationsListener);
    }

    public void removeAnnotationsListener(AnnotationsListener annotationsListener) {
        this.listenerList.remove(class$org$netbeans$editor$Annotations$AnnotationsListener == null ? (class$org$netbeans$editor$Annotations$AnnotationsListener = Annotations.class$("org.netbeans.editor.Annotations$AnnotationsListener")) : class$org$netbeans$editor$Annotations$AnnotationsListener, annotationsListener);
    }

    protected void fireChangedLine(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$org$netbeans$editor$Annotations$AnnotationsListener == null ? Annotations.class$("org.netbeans.editor.Annotations$AnnotationsListener") : class$org$netbeans$editor$Annotations$AnnotationsListener)) {
                ((AnnotationsListener)objectArray[n2 + 1]).changedLine(n);
            }
            n2 -= 2;
        }
    }

    protected void fireChangedAll() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$netbeans$editor$Annotations$AnnotationsListener == null ? Annotations.class$("org.netbeans.editor.Annotations$AnnotationsListener") : class$org$netbeans$editor$Annotations$AnnotationsListener)) {
                ((AnnotationsListener)objectArray[n + 1]).changedAll();
            }
            n -= 2;
        }
    }

    public boolean isGlyphColumn() {
        return this.glyphColumn;
    }

    public boolean isGlyphButtonColumn() {
        return this.glyphButtonColumn;
    }

    private JMenuItem createMenuItem(Action action) {
        if (action instanceof BaseAction) {
            JMenuItem jMenuItem = new JMenuItem(((BaseAction)action).getPopupMenuText(null));
            jMenuItem.addActionListener(action);
            return jMenuItem;
        }
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"));
        jMenuItem.addActionListener(action);
        return jMenuItem;
    }

    public JPopupMenu createPopupMenu(BaseKit baseKit, int n) {
        return this.createMenu(baseKit, n).getPopupMenu();
    }

    public JMenu createMenu(BaseKit baseKit, int n) {
        JMenu jMenu;
        int n2;
        AnnotationDesc[] annotationDescArray;
        Action[] actionArray;
        Object object;
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        HashMap<String, String> hashMap = new HashMap<String, String>(AnnotationTypes.getTypes().getVisibleAnnotationTypeNamesCount() * 4 / 3);
        JMenu jMenu2 = new JMenu(LocaleSupport.getString("generate-gutter-popup"));
        boolean bl = false;
        boolean bl2 = false;
        if (lineAnnotations != null) {
            object = lineAnnotations.getActive();
            if (object != null && (actionArray = ((AnnotationDesc)object).getActions()) != null) {
                int n3 = 0;
                while (n3 < actionArray.length) {
                    jMenu2.add(this.createMenuItem(actionArray[n3]));
                    ++n3;
                }
                bl = true;
                hashMap.put(((AnnotationDesc)object).getAnnotationType(), ((AnnotationDesc)object).getAnnotationType());
            }
            annotationDescArray = lineAnnotations.getPasive();
            bl2 = false;
            if (annotationDescArray != null) {
                n2 = 0;
                while (n2 < annotationDescArray.length) {
                    actionArray = annotationDescArray[n2].getActions();
                    if (actionArray != null) {
                        jMenu = new JMenu(annotationDescArray[n2].getAnnotationTypeInstance().getDescription());
                        int n4 = 0;
                        while (n4 < actionArray.length) {
                            jMenu.add(this.createMenuItem(actionArray[n4]));
                            ++n4;
                        }
                        if (bl) {
                            bl = false;
                            jMenu2.addSeparator();
                        }
                        jMenu2.add(jMenu);
                        bl2 = true;
                        hashMap.put(annotationDescArray[n2].getAnnotationType(), annotationDescArray[n2].getAnnotationType());
                    }
                    ++n2;
                }
                if (bl2) {
                    bl = true;
                }
            }
        }
        bl2 = false;
        annotationDescArray = AnnotationTypes.getTypes().getAnnotationTypeNames();
        while (annotationDescArray.hasNext()) {
            object = AnnotationTypes.getTypes().getType((String)annotationDescArray.next());
            if (object == null || !((AnnotationType)object).isVisible() || hashMap.get(((AnnotationType)object).getName()) != null || (actionArray = ((AnnotationType)object).getActions()) == null) continue;
            jMenu = new JMenu(((AnnotationType)object).getDescription());
            n2 = 0;
            while (n2 < actionArray.length) {
                jMenu.add(this.createMenuItem(actionArray[n2]));
                ++n2;
            }
            if (bl) {
                bl = false;
                jMenu2.addSeparator();
            }
            jMenu2.add(jMenu);
            bl2 = true;
        }
        if (bl2) {
            bl = true;
        }
        if (bl) {
            jMenu2.addSeparator();
        }
        BaseAction baseAction = (BaseAction)baseKit.getActionByName("toggle-line-numbers");
        jMenu2.add(baseAction.getPopupMenuItem(null));
        return jMenu2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AnnotationCombination
    extends AnnotationDesc {
        private AnnotationDesc delegate;
        private String type;
        private LinkedList list;

        public AnnotationCombination(String string, AnnotationDesc annotationDesc) {
            super(annotationDesc.getOffset(), annotationDesc.getLength());
            this.delegate = annotationDesc;
            this.type = string;
            this.updateAnnotationType();
            this.list = new LinkedList();
            this.list.add(annotationDesc);
        }

        public int getOffset() {
            return this.delegate.getOffset();
        }

        public int getLine() {
            return this.delegate.getLine();
        }

        public String getShortDescription() {
            return this.getAnnotationTypeInstance().getDescription();
        }

        public String getAnnotationType() {
            return this.type;
        }

        public void addCombinedAnnotation(AnnotationDesc annotationDesc) {
            this.list.add(annotationDesc);
        }

        public boolean isAnnotationCombined(AnnotationDesc annotationDesc) {
            return this.list.indexOf(annotationDesc) != -1;
        }

        Mark getMark() {
            return this.delegate.getMark();
        }
    }

    public static interface AnnotationsListener
    extends EventListener {
        public void changedLine(int var1);

        public void changedAll();
    }

    public static class LineAnnotations {
        private LinkedList annos = new LinkedList();
        private LinkedList annosVisible = new LinkedList();
        private AnnotationDesc active;
        private int lineNumber = -1;

        protected LineAnnotations() {
        }

        public void addAnnotation(AnnotationDesc annotationDesc) {
            if (this.lineNumber == -1) {
                this.lineNumber = annotationDesc.getLine();
            }
            this.annos.add(annotationDesc);
            if (annotationDesc.isVisible()) {
                this.active = annotationDesc;
            }
            this.refreshAnnotations();
        }

        public void removeAnnotation(AnnotationDesc annotationDesc) {
            if (annotationDesc == this.active) {
                this.activateNext();
            }
            this.annos.remove(annotationDesc);
            if (this.active == annotationDesc) {
                this.active = null;
            }
            this.refreshAnnotations();
        }

        public AnnotationDesc getActive() {
            return this.active;
        }

        public int getLine() {
            return this.lineNumber;
        }

        public void setLine(int n) {
            this.lineNumber = n;
        }

        public AnnotationDesc[] getPasive() {
            int n;
            AnnotationDesc[] annotationDescArray = new AnnotationDesc[this.getCount() - 1];
            int n2 = n = this.annosVisible.indexOf(this.getActive());
            int n3 = 0;
            while (true) {
                if (++n2 >= this.annosVisible.size()) {
                    n2 = 0;
                }
                if (n2 == n) break;
                annotationDescArray[n3] = (AnnotationDesc)this.annosVisible.get(n2);
                ++n3;
            }
            return annotationDescArray;
        }

        public boolean activate(AnnotationDesc annotationDesc) {
            int n = this.annosVisible.indexOf(annotationDesc);
            if (n == -1) {
                int n2 = 0;
                while (n2 < this.annosVisible.size()) {
                    if (this.annosVisible.get(n2) instanceof AnnotationCombination && ((AnnotationCombination)this.annosVisible.get(n2)).isAnnotationCombined(annotationDesc)) {
                        n = n2;
                        annotationDesc = (AnnotationCombination)this.annosVisible.get(n2);
                        break;
                    }
                    ++n2;
                }
            }
            if (n == -1) {
                return false;
            }
            if (this.annosVisible.get(n) == null) {
                return false;
            }
            if (annotationDesc == this.active || !annotationDesc.isVisible()) {
                return false;
            }
            this.active = annotationDesc;
            return true;
        }

        public int getCount() {
            return this.annosVisible.size();
        }

        public AnnotationDesc activateNext() {
            if (this.getCount() <= 1) {
                return this.active;
            }
            int n = this.annosVisible.indexOf(this.active);
            if (++n >= this.getCount()) {
                n = 0;
            }
            this.active = (AnnotationDesc)this.annosVisible.get(n);
            return this.active;
        }

        private void fillInCombinationsAndOrderThem(LinkedList linkedList) {
            Iterator iterator = AnnotationTypes.getTypes().getAnnotationTypeNames();
            while (iterator.hasNext()) {
                AnnotationType.CombinationMember[] combinationMemberArray;
                AnnotationType annotationType = AnnotationTypes.getTypes().getType((String)iterator.next());
                if (annotationType == null || (combinationMemberArray = annotationType.getCombinations()) == null || !annotationType.isWholeLine() || combinationMemberArray.length < 2 && (combinationMemberArray.length != 1 || !combinationMemberArray[0].isAbsorbAll())) continue;
                if (annotationType.getCombinationOrder() == 0) {
                    linkedList.add(annotationType);
                    continue;
                }
                boolean bl = false;
                int n = 0;
                while (n < linkedList.size()) {
                    if (((AnnotationType)linkedList.get(n)).getCombinationOrder() > annotationType.getCombinationOrder()) {
                        linkedList.add(n, annotationType);
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) continue;
                linkedList.add(annotationType);
            }
        }

        private boolean combineType(AnnotationType annotationType, LinkedList linkedList) {
            int n = 0;
            int n2 = 0;
            LinkedList<AnnotationDesc> linkedList2 = new LinkedList<AnnotationDesc>();
            AnnotationType.CombinationMember[] combinationMemberArray = annotationType.getCombinations();
            boolean bl = true;
            int n3 = 0;
            while (n3 < combinationMemberArray.length) {
                AnnotationType.CombinationMember combinationMember = combinationMemberArray[n3];
                boolean bl2 = false;
                int n4 = 0;
                while (n4 < linkedList.size()) {
                    AnnotationDesc annotationDesc = (AnnotationDesc)linkedList.get(n4);
                    if (annotationDesc != null && combinationMember.getName().equals(annotationDesc.getAnnotationType())) {
                        ++n;
                        if (combinationMember.getMinimumCount() == 0) {
                            bl2 = true;
                            ++n;
                            linkedList2.add(annotationDesc);
                            if (!combinationMember.isAbsorbAll()) {
                                break;
                            }
                        } else {
                            int n5 = combinationMember.getMinimumCount() - 1;
                            int n6 = n4 + 1;
                            while (n6 < linkedList.size() && n5 > 0) {
                                if (linkedList.get(n6) != null && combinationMember.getName().equals(((AnnotationDesc)linkedList.get(n6)).getAnnotationType())) {
                                    --n5;
                                }
                                ++n6;
                            }
                            if (n5 != 0) break;
                            bl2 = true;
                            linkedList2.add(annotationDesc);
                            n6 = n4 + 1;
                            while (n6 < linkedList.size()) {
                                if (linkedList.get(n6) != null && combinationMember.getName().equals(((AnnotationDesc)linkedList.get(n6)).getAnnotationType())) {
                                    ++n;
                                    linkedList2.add((AnnotationDesc)linkedList.get(n6));
                                }
                                ++n6;
                            }
                            break;
                        }
                    }
                    ++n4;
                }
                if (bl2) {
                    if (combinationMember.isOptional()) {
                        ++n2;
                    }
                } else if (!combinationMember.isOptional()) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (annotationType.getMinimumOptionals() > n2) {
                bl = false;
            }
            AnnotationCombination annotationCombination = null;
            if (bl) {
                boolean bl3 = false;
                n3 = 0;
                while (n3 < linkedList2.size()) {
                    if (linkedList2.get(n3) == this.active) {
                        bl3 = true;
                    }
                    if (annotationCombination == null) {
                        annotationCombination = new AnnotationCombination(annotationType.getName(), (AnnotationDesc)linkedList2.get(n3));
                        linkedList.set(linkedList.indexOf(linkedList2.get(n3)), annotationCombination);
                    } else {
                        annotationCombination.addCombinedAnnotation((AnnotationDesc)linkedList2.get(n3));
                        linkedList.set(linkedList.indexOf(linkedList2.get(n3)), null);
                    }
                    ++n3;
                }
                if (bl3) {
                    this.active = annotationCombination;
                }
                return true;
            }
            return false;
        }

        public void refreshAnnotations() {
            if (!AnnotationTypes.getTypes().isCombineGlyphs().booleanValue()) {
                this.annosVisible = new LinkedList();
                int n = 0;
                while (n < this.annos.size()) {
                    if (((AnnotationDesc)this.annos.get(n)).isVisible()) {
                        this.annosVisible.add(this.annos.get(n));
                    }
                    ++n;
                }
            } else {
                LinkedList linkedList = (LinkedList)this.annos.clone();
                LinkedList linkedList2 = new LinkedList();
                this.fillInCombinationsAndOrderThem(linkedList2);
                int n = 0;
                while (n < linkedList2.size()) {
                    this.combineType((AnnotationType)linkedList2.get(n), linkedList);
                    ++n;
                }
                this.annosVisible = new LinkedList();
                int n2 = 0;
                while (n2 < linkedList.size()) {
                    if (linkedList.get(n2) != null && ((AnnotationDesc)linkedList.get(n2)).isVisible()) {
                        this.annosVisible.add(linkedList.get(n2));
                    }
                    ++n2;
                }
            }
            if (this.annosVisible.indexOf(this.active) == -1) {
                this.active = this.annosVisible.size() > 0 ? (AnnotationDesc)this.annosVisible.get(0) : null;
            }
        }

        public boolean isMarkStillReferenced(Mark mark) {
            ListIterator listIterator = this.annos.listIterator();
            while (listIterator.hasNext()) {
                AnnotationDesc annotationDesc = (AnnotationDesc)listIterator.next();
                if (annotationDesc.getMark() != mark) continue;
                return true;
            }
            return false;
        }

        public Iterator getAnnotations() {
            return this.annos.iterator();
        }
    }
}

