/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;

public class Abbrev
implements SettingsChangeListener,
PropertyChangeListener {
    private StringBuffer abbrevSB = new StringBuffer();
    private boolean checkDocText;
    private boolean checkTextDelimiter;
    protected EditorUI editorUI;
    private Acceptor doExpandAcceptor;
    private Acceptor addTypedAcceptor;
    private Acceptor resetAcceptor;
    private HashMap abbrevMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Abbrev(EditorUI editorUI, boolean bl, boolean bl2) {
        this.editorUI = editorUI;
        this.checkDocText = bl;
        this.checkTextDelimiter = bl2;
        Settings.addSettingsChangeListener(this);
        Object object = editorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = editorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(editorUI, "component", null, jTextComponent));
            }
            editorUI.addPropertyChangeListener(this);
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz = Utilities.getKitClass(this.editorUI.getComponent());
        if (clazz != null) {
            String string;
            String string2 = string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
            if (string == null || "abbrev-action-map".equals(string) || "abbrev-map".equals(string)) {
                Map.Entry entry;
                Object object;
                Object object2;
                this.abbrevMap = new HashMap();
                Map map = (Map)Settings.getValue(clazz, "abbrev-action-map");
                if (map != null) {
                    object2 = Utilities.getKit(this.editorUI.getComponent());
                    object = map.entrySet().iterator();
                    while (object.hasNext()) {
                        entry = object.next();
                        Object v = entry.getValue();
                        Action action = null;
                        if (v instanceof String) {
                            action = ((BaseKit)object2).getActionByName((String)v);
                        } else if (v instanceof Action) {
                            action = (Action)v;
                        }
                        if (action == null) continue;
                        this.abbrevMap.put(entry.getKey(), action);
                    }
                }
                if ((map = (Map)Settings.getValue(clazz, "abbrev-map")) != null) {
                    object2 = map.entrySet().iterator();
                    while (object2.hasNext()) {
                        object = (Map.Entry)object2.next();
                        entry = object.getValue();
                        if (entry == null) continue;
                        this.abbrevMap.put(object.getKey(), entry);
                    }
                }
            }
            if (string == null || "abbrev-expand-acceptor".equals(string)) {
                this.doExpandAcceptor = SettingsUtil.getAcceptor(clazz, "abbrev-expand-acceptor", AcceptorFactory.FALSE);
            }
            if (string == null || "abbrev-add-typed-char-acceptor".equals(string)) {
                this.addTypedAcceptor = SettingsUtil.getAcceptor(clazz, "abbrev-add-typed-char-acceptor", AcceptorFactory.FALSE);
            }
            if (string == null || "abbrev-reset-acceptor".equals(string)) {
                this.resetAcceptor = SettingsUtil.getAcceptor(clazz, "abbrev-reset-acceptor", AcceptorFactory.TRUE);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent;
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string) && (jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue()) != null) {
            this.settingsChange(null);
        }
    }

    public void reset() {
        this.abbrevSB.setLength(0);
    }

    public void addChar(char c) {
        this.abbrevSB.append(c);
    }

    public String getAbbrevString() {
        return this.abbrevSB.toString();
    }

    public Map getAbbrevMap() {
        return this.abbrevMap;
    }

    public Object translateAbbrev(String string) {
        String string2 = string != null ? string : this.abbrevSB.toString();
        return this.getAbbrevMap().get(string2);
    }

    public String getExpandString(char c) {
        return this.doExpandAcceptor.accept(c) ? this.getExpandString() : null;
    }

    public String getExpandString() {
        BaseDocument baseDocument = this.editorUI.getDocument();
        String string = this.getAbbrevString();
        int n = string.length();
        Object object = this.translateAbbrev(string);
        Caret caret = this.editorUI.getComponent().getCaret();
        int n2 = caret.getDot();
        if (string != null && object != null && n2 >= n && this.checkDocText) {
            try {
                String string2 = baseDocument.getText(n2 - n, n);
                if (string2.equals(string) && (!this.checkTextDelimiter || n2 == n || this.resetAcceptor.accept(baseDocument.getChars(n2 - n - 1, 1)[0]))) {
                    return string;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean doExpansion(int n, String string, ActionEvent actionEvent) throws BadLocationException {
        Object object = this.translateAbbrev(string);
        boolean bl = false;
        if (object instanceof String) {
            BaseDocument baseDocument = this.editorUI.getDocument();
            String string2 = (String)object;
            int n2 = string2.indexOf(124);
            if (n2 >= 0) {
                if (n2 > 0) {
                    baseDocument.insertString(n, string2.substring(0, n2), null);
                }
                if (n2 + 1 < string2.length()) {
                    baseDocument.insertString(n + n2, string2.substring(n2 + 1), null);
                }
                Caret caret = this.editorUI.getComponent().getCaret();
                caret.setDot(n + n2);
            } else {
                baseDocument.insertString(n, string2, null);
            }
            bl = true;
        } else if (object instanceof Action) {
            ((Action)object).actionPerformed(actionEvent);
            bl = true;
        }
        return bl;
    }

    public boolean expandString(char c, String string, ActionEvent actionEvent) throws BadLocationException {
        if (this.expandString(string, actionEvent)) {
            if (this.addTypedAcceptor.accept(c)) {
                int n = this.editorUI.getComponent().getCaret().getDot();
                this.editorUI.getDocument().insertString(n, String.valueOf(c), null);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expandString(String string, ActionEvent actionEvent) throws BadLocationException {
        boolean bl = false;
        BaseDocument baseDocument = this.editorUI.getDocument();
        baseDocument.atomicLock();
        try {
            Caret caret = this.editorUI.getComponent().getCaret();
            int n = caret.getDot() - string.length();
            if (string != null) {
                baseDocument.remove(n, string.length());
                bl = this.doExpansion(n, string, actionEvent);
            }
            Object var8_7 = null;
            if (bl) {
                this.reset();
            } else {
                baseDocument.breakAtomicLock();
            }
            baseDocument.atomicUnlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (bl) {
                this.reset();
            } else {
                baseDocument.breakAtomicLock();
            }
            baseDocument.atomicUnlock();
            throw throwable;
        }
        return bl;
    }

    public boolean checkReset(char c) {
        if (this.resetAcceptor.accept(c)) {
            this.reset();
            return true;
        }
        return false;
    }

    public boolean checkAndExpand(char c, ActionEvent actionEvent) throws BadLocationException {
        boolean bl = true;
        String string = this.getExpandString(c);
        if (string != null) {
            bl = false;
            this.expandString(c, string, actionEvent);
        } else {
            this.addChar(c);
        }
        this.checkReset(c);
        return bl;
    }

    public void checkAndExpand(ActionEvent actionEvent) throws BadLocationException {
        String string = this.getExpandString();
        if (string != null) {
            this.expandString(string, actionEvent);
        }
    }
}

