/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.scripting.navigation;

import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import org.netbeans.core.NbTopManager;
import org.netbeans.modules.scripting.navigation.NodeNavigation;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;

public class NodeNavigation {
    private static final ErrorManager ERR = TopManager.getDefault().getErrorManager();
    private Node node = TopManager.getDefault().getPlaces().nodes().repository();
    private Writer out;
    private Writer err;
    private String separator;

    public NodeNavigation() {
        this(new BufferedWriter(new OutputStreamWriter(System.out)), new BufferedWriter(new OutputStreamWriter(System.err)), null);
    }

    public NodeNavigation(Writer writer, Writer writer2, String string) {
        this.out = writer;
        this.err = writer2;
        this.separator = string != null ? string : System.getProperty("line.separator");
    }

    public final void setCurrent(Node node) {
        if (node == null) {
            NodeNavigation.setSelectedNodes(null);
            return;
        }
        this.node = node;
        NodeNavigation.setSelectedNodes(new Node[]{node});
    }

    public final Node getCurrent() {
        return this.node;
    }

    public final String ls(String string) throws IOException {
        Node node = this.getCurrent();
        if (string != null) {
            node = NodeNavigation.findPath(node, string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (node == null) {
            stringBuffer.append("Path not found" + this.separator);
        } else {
            Node[] nodeArray = NodeNavigation.findChildren(node);
            stringBuffer.append("Children of: " + node.getDisplayName() + this.separator);
            int n = 0;
            while (n < nodeArray.length) {
                stringBuffer.append("  " + nodeArray[n].getDisplayName() + this.separator);
                ++n;
            }
        }
        this.out.write(stringBuffer.toString());
        this.out.flush();
        return stringBuffer.toString();
    }

    public final String ls() throws IOException {
        return this.ls(null);
    }

    public final Node cd(String string) {
        Node node = NodeNavigation.findPath(this.getCurrent(), string);
        if (node != null) {
            this.setCurrent(node);
        }
        return node;
    }

    public final String pwd() throws IOException {
        String string = this.getCurrent().getDisplayName() + this.separator;
        this.out.write(string);
        this.out.flush();
        return string;
    }

    public final String commands() throws IOException {
        Enumeration enumeration = NodeNavigation.findActions();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Action action = (Action)enumeration.nextElement();
            String string = (String)action.getValue("Name");
            stringBuffer.append("  " + string + this.separator);
        }
        this.out.write(stringBuffer.toString());
        this.out.flush();
        return stringBuffer.toString();
    }

    public final void invoke(String string) {
        ActionComparator actionComparator = new ActionComparator();
        int n = 0;
        while (n < 4) {
            actionComparator.state = n++;
            final Action action = (Action)NodeNavigation.scanEnum(NodeNavigation.findActions(), string, actionComparator);
            if (action == null) continue;
            final ExplorerManager explorerManager = new ExplorerManager();
            NbTopManager.get().attachExplorer(new Runnable(){

                public void run() {
                    try {
                        Node[] nodeArray = new Node[]{NodeNavigation.this.node};
                        Node node = NodeNavigation.this.node;
                        while (node.getParentNode() != null) {
                            node = node.getParentNode();
                        }
                        explorerManager.setRootContext(node);
                        explorerManager.setSelectedNodes(nodeArray);
                        action.actionPerformed(new ActionEvent(NodeNavigation.this, 0, null));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        ERR.notify((Throwable)propertyVetoException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ERR.notify((Throwable)illegalArgumentException);
                    }
                }
            }, explorerManager);
            return;
        }
    }

    public final void root(String string) {
        if (string.equalsIgnoreCase("controlPanel")) {
            this.setCurrent(TopManager.getDefault().getPlaces().nodes().controlPanel());
        } else if (string.equalsIgnoreCase("environment")) {
            this.setCurrent(TopManager.getDefault().getPlaces().nodes().environment());
        } else if (string.equalsIgnoreCase("loaderPool")) {
            this.setCurrent(TopManager.getDefault().getPlaces().nodes().loaderPool());
        } else if (string.equalsIgnoreCase("project")) {
            this.setCurrent(TopManager.getDefault().getPlaces().nodes().project());
        } else if (string.equalsIgnoreCase("projectDesktop")) {
            this.setCurrent(TopManager.getDefault().getPlaces().nodes().projectDesktop());
        } else if (string.equalsIgnoreCase("repository")) {
            this.setCurrent(TopManager.getDefault().getPlaces().nodes().repository());
        } else if (string.equalsIgnoreCase("repositorySettings")) {
            this.setCurrent(TopManager.getDefault().getPlaces().nodes().repositorySettings());
        } else if (string.equalsIgnoreCase("session")) {
            this.setCurrent(TopManager.getDefault().getPlaces().nodes().session());
        } else if (string.equalsIgnoreCase("workspaces")) {
            this.setCurrent(TopManager.getDefault().getPlaces().nodes().workspaces());
        }
    }

    private static Node findPath(Node node, String string) {
        String string2 = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        if (string2.startsWith("/")) {
            node = NodeNavigation.root(node);
            if (string2.length() == 1) {
                return node;
            }
        }
        Node node2 = node;
        boolean bl = false;
        while (node2 != null && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if ((node2 = NodeNavigation.findChild(node2, string3)) == null) continue;
            bl = true;
            node = node2;
        }
        if (!bl && (node2 = NodeNavigation.findChild(node, string2)) != null) {
            node = node2;
        }
        return node;
    }

    private static Node findChild(Node node, String string) {
        if ("..".equals(string)) {
            return node.getParentNode();
        }
        Object[] objectArray = NodeNavigation.findChildren(node);
        NodeComparator nodeComparator = new NodeComparator();
        int n = 0;
        while (n < 4) {
            nodeComparator.state = n++;
            Object object = NodeNavigation.scanEnum((Enumeration)new ArrayEnumeration(objectArray), string, nodeComparator);
            if (object == null) continue;
            return (Node)object;
        }
        return null;
    }

    private static Object scanEnum(Enumeration enumeration, Object object, Comparator comparator) {
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (comparator.compare(object, e) != 0) continue;
            return e;
        }
        return null;
    }

    private static Node root(Node node) {
        Node node2;
        while ((node2 = node.getParentNode()) != null) {
            node = node2;
        }
        return node;
    }

    private static Node[] findChildren(Node node) {
        Node[] nodeArray;
        class Collector
        extends NodeAdapter {
            private List ll;

            Collector() {
                this.ll = new LinkedList<E>();
            }

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                this.ll.add(nodeMemberEvent.getDelta());
            }
        }
        Collector collector = new Collector();
        try {
            node.addNodeListener((NodeListener)collector);
            Node[] nodeArray2 = node.getChildren().getNodes();
            Node node2 = node.getChildren().findChild(null);
            nodeArray = node.getChildren().getNodes();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            node.removeNodeListener((NodeListener)collector);
            throw throwable;
        }
        node.removeNodeListener((NodeListener)collector);
        return nodeArray;
    }

    private static final void setSelectedNodes(Node[] nodeArray) {
        if (nodeArray == null) {
            nodeArray = new Node[]{};
        }
        final Node[] nodeArray2 = nodeArray;
        final ExplorerManager explorerManager = new ExplorerManager();
        NbTopManager.get().attachExplorer(new Runnable(){

            public void run() {
                try {
                    Node node;
                    if (nodeArray2.length >= 1 && (node = nodeArray2[0]) != null) {
                        while (node.getParentNode() != null) {
                            node = node.getParentNode();
                        }
                        explorerManager.setRootContext(node);
                    }
                    explorerManager.setSelectedNodes(nodeArray2);
                }
                catch (PropertyVetoException propertyVetoException) {
                    ERR.notify((Throwable)propertyVetoException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ERR.notify((Throwable)illegalArgumentException);
                }
            }
        }, explorerManager);
    }

    private static Enumeration findActions() {
        DataFolder dataFolder = NodeNavigation.findActionsFolder();
        Enumeration enumeration = dataFolder.children(true);
        AlterEnumeration alterEnumeration = new AlterEnumeration(enumeration){
            static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

            protected Object alter(Object object) {
                DataObject dataObject = (DataObject)object;
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = 3.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                if (instanceCookie == null) {
                    return null;
                }
                try {
                    Action action;
                    Object object2 = instanceCookie.instanceCreate();
                    if (object2 instanceof Action && (action = (Action)object2).isEnabled()) {
                        return object2;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager errorManager = ERR;
                    ERR;
                    errorManager.notify(1, (Throwable)classNotFoundException);
                }
                catch (IOException iOException) {
                    ErrorManager errorManager = ERR;
                    ERR;
                    errorManager.notify(1, (Throwable)iOException);
                }
                return null;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        return new FilterEnumeration((Enumeration)alterEnumeration){

            protected boolean accept(Object object) {
                return object != null;
            }
        };
    }

    private static DataFolder findActionsFolder() {
        FileObject fileObject = null;
        fileObject = TopManager.getDefault().getRepository().findResource("ScriptActions");
        if (fileObject == null) {
            fileObject = (FileObject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().actions();
                        FileObject fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().getRoot().createFolder("tmp");
                        FileLock fileLock = fileObject.lock();
                        DataObject dataObject = dataFolder.copy(DataFolder.findFolder((FileObject)fileObject));
                        dataObject.rename("ScriptActions");
                        dataObject.move(DataFolder.findFolder((FileObject)TopManager.getDefault().getRepository().getDefaultFileSystem().getRoot()));
                        fileObject.delete(fileLock);
                        return dataObject.getPrimaryFile();
                    }
                    catch (Exception exception) {
                        TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
                        return null;
                    }
                }
            });
        }
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        return dataFolder;
    }

    private static class ActionComparator
    implements Comparator {
        public static final int STATES = 4;
        public int state;

        private ActionComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            Action action = (Action)object2;
            switch (this.state) {
                case 0: {
                    return string.equals(action.getClass().getName()) ? 0 : 1;
                }
                case 1: {
                    return string.equals(action.getValue("Name")) ? 0 : 1;
                }
                case 2: {
                    String string2 = action.getClass().getName();
                    return string2 != null && string2.indexOf(string) >= 0 ? 0 : 1;
                }
                case 3: {
                    String string3 = (String)action.getValue("Name");
                    return string3 != null && string3.indexOf(string) >= 0 ? 0 : 1;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class NodeComparator
    implements Comparator {
        public static final int STATES = 4;
        public int state;

        private NodeComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            Node node = (Node)object2;
            switch (this.state) {
                case 0: {
                    return string.equals(node.getName()) ? 0 : 1;
                }
                case 1: {
                    return string.equals(node.getDisplayName()) ? 0 : 1;
                }
                case 2: {
                    String string2 = node.getName();
                    return string2 != null && string2.indexOf(string) >= 0 ? 0 : 1;
                }
                case 3: {
                    String string3 = node.getDisplayName();
                    return string3 != null && string3.indexOf(string) >= 0 ? 0 : 1;
                }
            }
            throw new IllegalStateException();
        }
    }
}

