/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.StreamPool;
import org.openide.util.RequestProcessor;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.EmptyEnumeration;

public class JarFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Info,
AbstractFileSystem.Change,
AbstractFileSystem.Attr {
    static final long serialVersionUID = -98124752801761145L;
    private static final String JAR_FS = "JAR_FS ";
    private transient JarFile jar;
    private transient Manifest manifest;
    private File root = new File(".");
    private static RequestProcessor req = new RequestProcessor("JarFs - modification watcher");
    private transient RequestProcessor.Task watcherTask = null;
    private transient long lastModification = 0L;
    private transient Object closeSync = new Object();
    private static final int REFRESH_TIME = Integer.getInteger("org.openide.filesystems.JarFileSystem.REFRESH_TIME", 15000);
    private transient ReferenceQueue refQueue = new ReferenceQueue();
    private transient long aliveCount = 0L;
    private transient EntryCache rootOfCache = null;
    private transient long cacheLastAccess = 0L;

    public JarFileSystem() {
        Impl impl = new Impl(this);
        this.list = impl;
        this.info = impl;
        this.change = impl;
        this.attr = impl;
    }

    public JarFileSystem(FileSystemCapability fileSystemCapability) {
        this();
        this.setCapability(fileSystemCapability);
    }

    protected Reference createReference(FileObject fileObject) {
        ++this.aliveCount;
        if (REFRESH_TIME > 0 && this.watcherTask == null) {
            this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
        }
        return new WeakReference<FileObject>(fileObject, this.refQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                Object object = this.closeSync;
                synchronized (object) {
                    JarFile jarFile = this.reOpenJarFile();
                    this.manifest = jarFile == null ? null : jarFile.getManifest();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.manifest == null) {
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJarFile(File file) throws IOException, PropertyVetoException {
        FileObject fileObject = null;
        if (this.getRefreshTime() > 0) {
            this.setRefreshTime(0);
        }
        if (file == null) {
            FSException.io((String)"EXC_NotValidFile", (Object)file);
        }
        if (!file.exists()) {
            FSException.io((String)"EXC_FileNotExists", (Object)file.toString());
        }
        if (!file.canRead()) {
            FSException.io((String)"EXC_CanntRead", (Object)file.toString());
        }
        if (!file.isFile()) {
            FSException.io((String)"EXC_NotValidFile", (Object)file.toString());
        }
        if (file.equals(this.root)) {
            return;
        }
        String string = file.getCanonicalPath();
        string = string.intern();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string);
        }
        catch (ZipException zipException) {
            FSException.io((String)"EXC_NotValidJarFile");
        }
        Object object = this.closeSync;
        synchronized (object) {
            this.setSystemName(string);
            this.closeCurrentRoot();
            this.jar = jarFile;
            this.root = new File(string);
            this.rootOfCache = null;
            this.aliveCount = 0L;
            fileObject = this.refreshRoot();
            this.manifest = null;
            this.lastModification = 0L;
        }
        this.firePropertyChange("root", null, fileObject);
    }

    public File getJarFile() {
        return this.root;
    }

    public String getDisplayName() {
        if (this.root != null && this.root.isFile() && this.root.exists() && this.root.canRead()) {
            return this.root.getName();
        }
        return FileSystem.getString((String)"JAR_NotValidJarFileSystem");
    }

    public boolean isReadOnly() {
        return true;
    }

    public void removeNotify() {
        this.closeCurrentRoot();
    }

    public void addNotify() {
        super.addNotify();
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        if (this.root != null) {
            environment.addClassPath(this.root.toString());
        }
    }

    public String[] children(String string) {
        EntryCache entryCache = this.getCacheOfRoot();
        if (entryCache == null && (entryCache = this.parse(false)) == null) {
            return new String[0];
        }
        EntryCache entryCache2 = this.getCacheOfEntry(entryCache, string);
        if (entryCache2 == null) {
            return new String[0];
        }
        return entryCache2.getChildrenNames();
    }

    public void createFolder(String string) throws IOException {
        throw new IOException();
    }

    public void createData(String string) throws IOException {
        throw new IOException();
    }

    public void rename(String string, String string2) throws IOException {
        throw new IOException();
    }

    public void delete(String string) throws IOException {
        throw new IOException();
    }

    public Date lastModified(String string) {
        return new Date(this.getEntry(string).getTime());
    }

    public boolean folder(String string) {
        EntryCache entryCache;
        if ("".equals(string)) {
            return true;
        }
        EntryCache entryCache2 = this.getCacheOfRoot();
        if (entryCache2 == null) {
            entryCache2 = this.parse(false);
        }
        if ((entryCache = this.getCacheOfEntry(entryCache2, string)) == null) {
            return false;
        }
        return entryCache.isFolder();
    }

    public boolean readOnly(String string) {
        return true;
    }

    public String mimeType(String string) {
        return null;
    }

    public long size(String string) {
        long l = this.getEntry(string).getSize();
        return l == -1L ? 0L : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream inputStream(String string) throws FileNotFoundException {
        InputStream inputStream = null;
        AbstractFolder abstractFolder = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                JarEntry jarEntry;
                JarFile jarFile = this.reOpenJarFile();
                if (jarFile != null && (jarEntry = jarFile.getJarEntry(string)) != null && (inputStream = this.getInputStream4336753(jarFile, jarEntry)) != null) {
                    Reference reference = this.findReference(string);
                    if (reference != null) {
                        abstractFolder = (AbstractFolder)reference.get();
                    }
                    if (abstractFolder != null) {
                        inputStream = StreamPool.createInputStream((AbstractFolder)abstractFolder, (InputStream)inputStream);
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            throw new FileNotFoundException(runtimeException.getMessage());
        }
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        return inputStream;
    }

    private InputStream getInputStream4336753(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = null;
        while (inputStream == null) {
            try {
                inputStream = jarFile.getInputStream(jarEntry);
                break;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    public OutputStream outputStream(String string) throws IOException {
        throw new IOException();
    }

    public void lock(String string) throws IOException {
        FSException.io((String)"EXC_CannotLock", (Object)string, (Object)this.getDisplayName(), (Object)string);
    }

    public void unlock(String string) {
    }

    public void markUnimportant(String string) {
    }

    public Object readAttribute(String string, String string2) {
        Attributes attributes = this.getManifest().getAttributes(string);
        try {
            return attributes == null ? null : attributes.getValue(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public void writeAttribute(String string, String string2, Object object) throws IOException {
        throw new IOException();
    }

    public Enumeration attributes(String string) {
        Attributes attributes = this.getManifest().getAttributes(string);
        if (attributes != null) {
            return new AlterEnumeration(Collections.enumeration(attributes.keySet())){

                public Object alter(Object object) {
                    return object.toString();
                }
            };
        }
        return EmptyEnumeration.EMPTY;
    }

    public void renameAttributes(String string, String string2) {
    }

    public void deleteAttributes(String string) {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeCurrentRoot();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.closeSync = new Object();
        this.rootOfCache = null;
        this.cacheLastAccess = 0L;
        this.refQueue = new ReferenceQueue();
        this.aliveCount = 0L;
        try {
            this.setJarFile(this.root);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IOException(propertyVetoException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrentRoot() {
        Object object = this.closeSync;
        synchronized (object) {
            if (this.jar != null) {
                try {
                    block8: {
                        try {
                            StreamPool streamPool = StreamPool.find((FileSystem)this);
                            if (streamPool != null && (streamPool.isInputStreamOpen() || streamPool.isOutputStreamOpen())) break block8;
                            this.jar.close();
                        }
                        catch (Exception exception) {
                            ExternalUtil.exception((Exception)exception);
                            Object var4_5 = null;
                            this.jar = null;
                        }
                    }
                    Object var4_4 = null;
                    this.jar = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.jar = null;
                    throw throwable;
                }
            }
        }
    }

    private EntryCache getCacheOfRoot() {
        this.cacheLastAccess = System.currentTimeMillis();
        return this.rootOfCache;
    }

    private void setCacheOfRoot(EntryCache entryCache) {
        this.cacheLastAccess = System.currentTimeMillis();
        this.rootOfCache = entryCache;
    }

    private EntryCache getCacheOfEntry(EntryCache entryCache, String string) {
        EntryCache entryCache2 = entryCache;
        if (entryCache2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements() && entryCache2 != null) {
            entryCache2 = entryCache2.getChild((String)stringTokenizer.nextElement());
        }
        return entryCache2;
    }

    private void refreshExistingFileObjects(EntryCache entryCache) {
        EntryCache entryCache2 = entryCache;
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        while (enumeration.hasMoreElements()) {
            EntryCache entryCache3;
            AbstractFolder abstractFolder = (AbstractFolder)enumeration.nextElement();
            if (abstractFolder.isFolder() && !abstractFolder.isInitialized() || (entryCache3 = this.getCacheOfEntry(entryCache2, abstractFolder.getPackageNameExt('/', '.'))) == null) continue;
            abstractFolder.refresh(null, null, true, true, entryCache3.getChildrenNames());
        }
    }

    private boolean isInUse() {
        Reference reference;
        while ((reference = this.refQueue.poll()) != null) {
            --this.aliveCount;
        }
        return this.aliveCount != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EntryCache parse(boolean bl) {
        EntryCache entryCache;
        block20: {
            EntryCache entryCache2 = new EntryCache("", true);
            JarFile jarFile = null;
            this.beginAtomicAction();
            try {
                Object object = this.closeSync;
                synchronized (object) {
                    long l = System.currentTimeMillis();
                    this.lastModification = 0L;
                    this.closeCurrentRoot();
                    int n = 0;
                    while (n <= 2) {
                        try {
                            jarFile = this.reOpenJarFile();
                            break;
                        }
                        catch (IOException iOException) {
                            if (n >= 2) {
                                EntryCache entryCache3 = null;
                                // MONITOREXIT @DISABLED, blocks:[0, 19, 6, 7, 10] lbl18 : MonitorExitStatement: MONITOREXIT : var7_4
                                Object var13_14 = null;
                                if (bl) {
                                    this.refreshExistingFileObjects(entryCache2);
                                }
                                if (REFRESH_TIME > 0 && this.watcherTask == null) {
                                    this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
                                }
                                this.finishAtomicAction();
                                return entryCache3;
                            }
                            ++n;
                        }
                    }
                    try {
                        Enumeration<JarEntry> enumeration = jarFile.entries();
                        while (enumeration.hasMoreElements()) {
                            JarEntry jarEntry = enumeration.nextElement();
                            String string = jarEntry.getName();
                            this.addFile(string, entryCache2);
                        }
                    }
                    catch (Throwable throwable) {
                        EntryCache entryCache4 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 8] lbl39 : MonitorExitStatement: MONITOREXIT : var7_4
                        Object var13_15 = null;
                        if (bl) {
                            this.refreshExistingFileObjects(entryCache2);
                        }
                        if (REFRESH_TIME > 0 && this.watcherTask == null) {
                            this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
                        }
                        this.finishAtomicAction();
                        return entryCache4;
                    }
                    this.lastModification = this.root.lastModified();
                    this.setCacheOfRoot(entryCache2);
                }
                entryCache = entryCache2;
                Object var13_16 = null;
                if (bl) {
                    this.refreshExistingFileObjects(entryCache2);
                }
                if (REFRESH_TIME <= 0 || this.watcherTask != null) break block20;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (bl) {
                    this.refreshExistingFileObjects(entryCache2);
                }
                if (REFRESH_TIME > 0 && this.watcherTask == null) {
                    this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
                }
                this.finishAtomicAction();
                throw throwable;
            }
            this.watcherTask = req.post(this.watcherTask(), REFRESH_TIME);
        }
        this.finishAtomicAction();
        return entryCache;
    }

    private void addFile(String string, EntryCache entryCache) {
        EntryCache entryCache2 = entryCache;
        boolean bl = false;
        String string2 = string;
        if ((string = string.replace('\\', '/')).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 <= string.length()) {
            n = string.indexOf(47, n2);
            if (n < 0) {
                n = string.length();
            }
            String string3 = string.substring(n2, n);
            if (bl || n != string.length()) {
                entryCache2 = entryCache2.addChild(string3, new EntryCache(string3, true));
            } else {
                entryCache2.addChild(string3, new EntryCache(string3, false));
            }
            n2 = ++n;
        }
    }

    private Runnable watcherTask() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                try {
                                    if (JarFileSystem.this.root == null) {
                                        Object var2_1 = null;
                                        break block7;
                                    }
                                    if (!JarFileSystem.this.isInUse()) {
                                        if (JarFileSystem.this.watcherTask != null) {
                                            JarFileSystem.this.watcherTask.cancel();
                                            JarFileSystem.this.watcherTask = null;
                                            JarFileSystem.this.rootOfCache = null;
                                            JarFileSystem.this.closeCurrentRoot();
                                        }
                                        break block8;
                                    }
                                    if (JarFileSystem.this.root.lastModified() != JarFileSystem.this.lastModification) {
                                        JarFileSystem.this.parse(true);
                                        break block9;
                                    }
                                    if (JarFileSystem.this.rootOfCache != null && System.currentTimeMillis() - JarFileSystem.this.cacheLastAccess > (long)REFRESH_TIME) {
                                        JarFileSystem.this.rootOfCache = null;
                                    }
                                    break block10;
                                }
                                catch (Throwable throwable) {
                                    Object var2_5 = null;
                                    if (JarFileSystem.this.watcherTask == null) throw throwable;
                                    JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
                                    throw throwable;
                                }
                            }
                            if (JarFileSystem.this.watcherTask == null) return;
                            JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
                            return;
                        }
                        Object var2_2 = null;
                        if (JarFileSystem.this.watcherTask == null) return;
                        JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
                        return;
                    }
                    Object var2_3 = null;
                    if (JarFileSystem.this.watcherTask == null) return;
                    JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
                    return;
                }
                Object var2_4 = null;
                if (JarFileSystem.this.watcherTask == null) return;
                JarFileSystem.this.watcherTask.schedule(REFRESH_TIME);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JarEntry getEntry(String string) {
        JarFile jarFile = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                block6: {
                    jarFile = this.reOpenJarFile();
                    JarEntry jarEntry = jarFile.getJarEntry(string);
                    if (jarEntry == null) break block6;
                    JarEntry jarEntry2 = jarEntry;
                    return jarEntry2;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new JarEntry(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarFile reOpenJarFile() throws IOException {
        JarFile jarFile = this.jar;
        if (jarFile != null) {
            return jarFile;
        }
        Object object = this.closeSync;
        synchronized (object) {
            if (this.jar == null && this.root != null) {
                this.jar = new JarFile(this.root);
            }
            JarFile jarFile2 = this.jar;
            return jarFile2;
        }
    }

    private static class EntryCache {
        String name;
        Map children;
        EntryCache parent;
        boolean folder;

        public EntryCache(String string, boolean bl) {
            this.name = string;
            this.parent = null;
            this.folder = bl;
        }

        EntryCache addChild(String string, EntryCache entryCache) {
            EntryCache entryCache2;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((entryCache2 = this.children.put(string, entryCache)) != null) {
                entryCache = entryCache2;
                this.children.put(string, entryCache);
            }
            entryCache.parent = this;
            return entryCache;
        }

        EntryCache[] getChildren() {
            if (this.children == null) {
                return new EntryCache[0];
            }
            EntryCache[] entryCacheArray = new EntryCache[this.children.size()];
            this.children.values().toArray(entryCacheArray);
            return entryCacheArray;
        }

        String[] getChildrenNames() {
            if (this.children == null) {
                return new String[0];
            }
            String[] stringArray = new String[this.children.size()];
            this.children.keySet().toArray(stringArray);
            return stringArray;
        }

        String getName() {
            return this.name;
        }

        boolean isFolder() {
            return this.folder;
        }

        EntryCache getChild(String string) {
            if (this.children == null) {
                return null;
            }
            return (EntryCache)this.children.get(string);
        }

        EntryCache getParent() {
            return this.parent;
        }
    }

    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change,
    AbstractFileSystem.Attr {
        static final long serialVersionUID = -67233308132567232L;
        private JarFileSystem fs;

        public Impl(JarFileSystem jarFileSystem) {
            this.fs = jarFileSystem;
        }

        public String[] children(String string) {
            return this.fs.children(string);
        }

        public void createFolder(String string) throws IOException {
            this.fs.createFolder(string);
        }

        public void createData(String string) throws IOException {
            this.fs.createData(string);
        }

        public void rename(String string, String string2) throws IOException {
            this.fs.rename(string, string2);
        }

        public void delete(String string) throws IOException {
            this.fs.delete(string);
        }

        public Date lastModified(String string) {
            return this.fs.lastModified(string);
        }

        public boolean folder(String string) {
            return this.fs.folder(string);
        }

        public boolean readOnly(String string) {
            return this.fs.readOnly(string);
        }

        public String mimeType(String string) {
            return this.fs.mimeType(string);
        }

        public long size(String string) {
            return this.fs.size(string);
        }

        public InputStream inputStream(String string) throws FileNotFoundException {
            return this.fs.inputStream(string);
        }

        public OutputStream outputStream(String string) throws IOException {
            return this.fs.outputStream(string);
        }

        public void lock(String string) throws IOException {
            this.fs.lock(string);
        }

        public void unlock(String string) {
            this.fs.unlock(string);
        }

        public void markUnimportant(String string) {
            this.fs.markUnimportant(string);
        }

        public Object readAttribute(String string, String string2) {
            return this.fs.readAttribute(string, string2);
        }

        public void writeAttribute(String string, String string2, Object object) throws IOException {
            this.fs.writeAttribute(string, string2, object);
        }

        public Enumeration attributes(String string) {
            return this.fs.attributes(string);
        }

        public void renameAttributes(String string, String string2) {
            this.fs.renameAttributes(string, string2);
        }

        public void deleteAttributes(String string) {
            this.fs.deleteAttributes(string);
        }
    }
}

