/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.tools.ElementFilter;
import org.netbeans.modules.java.ui.wizard.InheritanceChildren;
import org.netbeans.modules.java.ui.wizard.JavaPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardData;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.util.HelpCtx;

public class OverridePanel
extends JPanel
implements JavaPanel {
    private JavaWizardData wizardData;
    private PropertyChangeListener managerListener;
    private JLabel headLabel;
    private JLabel avaliableMethodsLabel;
    private JLabel overridenMethodsLabel;
    private JCheckBox inheritedCheckBox;
    private JCheckBox abstractCheckBox;
    private JCheckBox superCheckBox;
    private JPanel jPanel1;
    private JButton addButton;
    private JButton removeButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private ListView listView;
    private BeanTreeView beanTreeView;
    private ExPanel treeExplorerPanel;
    private ExPanel listExplorerPanel;
    static /* synthetic */ Class class$org$openide$src$MemberElement;
    static /* synthetic */ Class class$org$openide$src$MethodElement;

    public void initialize(JavaWizardData javaWizardData) {
        this.wizardData = javaWizardData;
        this.initComponents();
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(3));
        InheritanceChildren inheritanceChildren = new InheritanceChildren(javaWizardData.getInheritance(), new ClassComparator(), new MethodComparator(), this.getAvailableMethodsFilter(true, false));
        AbstractNode abstractNode = new AbstractNode((Children)inheritanceChildren);
        this.treeExplorerPanel = new ExPanel();
        this.treeExplorerPanel.setLayout(new BorderLayout());
        this.treeExplorerPanel.getExplorerManager().setRootContext((Node)abstractNode);
        this.beanTreeView = new BeanTreeView();
        this.beanTreeView.setRootVisible(false);
        this.beanTreeView.setPopupAllowed(false);
        this.treeExplorerPanel.add("Center", (Component)this.beanTreeView);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeExplorerPanel, gridBagConstraints);
        InheritanceChildren.OverridenMethods overridenMethods = new InheritanceChildren.OverridenMethods(javaWizardData.getCustomizedClass(), javaWizardData.getInheritance(), new MethodComparator());
        AbstractNode abstractNode2 = new AbstractNode((Children)overridenMethods);
        this.listExplorerPanel = new ExPanel();
        this.listExplorerPanel.setLayout(new BorderLayout());
        this.listExplorerPanel.getExplorerManager().setRootContext((Node)abstractNode2);
        this.listView = new ListView();
        this.listView.setPopupAllowed(false);
        this.listExplorerPanel.add("Center", (Component)this.listView);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listExplorerPanel, gridBagConstraints);
        this.avaliableMethodsLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Available_superclass_Mnemonic").charAt(0));
        this.avaliableMethodsLabel.setLabelFor((Component)this.beanTreeView);
        this.overridenMethodsLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Methods_overridden_Mnemonic").charAt(0));
        this.overridenMethodsLabel.setLabelFor((Component)this.listView);
        this.inheritedCheckBox.setMnemonic(JavaWizardIterator.getString("LBL_Show_inherited_Mnemonic").charAt(0));
        this.abstractCheckBox.setMnemonic(JavaWizardIterator.getString("LBL_Only_show_abstract_Mnemonic").charAt(0));
        this.addButton.setMnemonic(JavaWizardIterator.getString("LBL_Add_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(JavaWizardIterator.getString("LBL_Remove_Mnemonic").charAt(0));
        this.addAllButton.setMnemonic(JavaWizardIterator.getString("LBL_Add_All_Mnemonic").charAt(0));
        this.removeAllButton.setMnemonic(JavaWizardIterator.getString("LBL_Remove_All_Mnemonic").charAt(0));
        this.superCheckBox.setMnemonic(JavaWizardIterator.getString("LBL_Generate_super_calls_Mnemonic").charAt(0));
        this.initAccessibility();
        this.updateButtons();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_OverridePanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_OverridePanelA11yDesc"));
        this.headLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Select_methodsA11yDesc"));
        this.avaliableMethodsLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Available_superclassA11yDesc"));
        this.overridenMethodsLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Methods_overriddenA11yDesc"));
    }

    public boolean requestDefaultFocus() {
        return this.treeExplorerPanel.requestDefaultFocus();
    }

    private void initComponents() {
        this.headLabel = new JLabel();
        this.avaliableMethodsLabel = new JLabel();
        this.overridenMethodsLabel = new JLabel();
        this.inheritedCheckBox = new JCheckBox();
        this.abstractCheckBox = new JCheckBox();
        this.superCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setName(JavaWizardIterator.getString("TIT_OverrideWizardPanel"));
        this.headLabel.setText(JavaWizardIterator.getString("LBL_Select_methods"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.headLabel, gridBagConstraints);
        this.avaliableMethodsLabel.setText(JavaWizardIterator.getString("LBL_Available_superclass"));
        this.avaliableMethodsLabel.setLabelFor((Component)this.beanTreeView);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.avaliableMethodsLabel, gridBagConstraints);
        this.overridenMethodsLabel.setText(JavaWizardIterator.getString("LBL_Methods_overridden"));
        this.overridenMethodsLabel.setLabelFor((Component)this.listView);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.overridenMethodsLabel, gridBagConstraints);
        this.inheritedCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_Show_inheritedA11yDesc"));
        this.inheritedCheckBox.setText(JavaWizardIterator.getString("LBL_Show_inherited"));
        this.inheritedCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanel.this.inheritedCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.inheritedCheckBox, gridBagConstraints);
        this.abstractCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_Only_show_abstractA11yDesc"));
        this.abstractCheckBox.setText(JavaWizardIterator.getString("LBL_Only_show_abstract"));
        this.abstractCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanel.this.abstractCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.abstractCheckBox, gridBagConstraints);
        this.superCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_Generate_super_callsA11yDesc"));
        this.superCheckBox.setText(JavaWizardIterator.getString("LBL_Generate_super_calls"));
        this.superCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanel.this.superCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.superCheckBox, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.addButton.setToolTipText(JavaWizardIterator.getString("ACS_AddA11yDesc"));
        this.addButton.setText(JavaWizardIterator.getString("LBL_Add"));
        this.addButton.setMargin(new Insets(2, 8, 2, 8));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.addButton, gridBagConstraints2);
        this.removeButton.setToolTipText(JavaWizardIterator.getString("ACS_RemoveA11yDesc"));
        this.removeButton.setText(JavaWizardIterator.getString("LBL_Remove"));
        this.removeButton.setMargin(new Insets(2, 8, 2, 8));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 11, 0);
        this.jPanel1.add((Component)this.removeButton, gridBagConstraints2);
        this.addAllButton.setToolTipText(JavaWizardIterator.getString("ACS_Add_AllA11yDesc"));
        this.addAllButton.setText(JavaWizardIterator.getString("LBL_Add_All"));
        this.addAllButton.setMargin(new Insets(2, 8, 2, 8));
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanel.this.addAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.addAllButton, gridBagConstraints2);
        this.removeAllButton.setToolTipText(JavaWizardIterator.getString("ACS_Remove_AllA11yDesc"));
        this.removeAllButton.setText(JavaWizardIterator.getString("LBL_Remove_All"));
        this.removeAllButton.setMargin(new Insets(2, 8, 2, 8));
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverridePanel.this.removeAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        this.jPanel1.add((Component)this.removeAllButton, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        gridBagConstraints.anchor = 11;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void superCheckBoxActionPerformed(ActionEvent actionEvent) {
        Collection collection = this.collectMethodsToOverride(new Node[]{this.listExplorerPanel.getExplorerManager().getRootContext()});
        this.undoOverrideMethods(collection);
        this.overrideMethods(collection);
    }

    private void removeAllButtonActionPerformed(ActionEvent actionEvent) {
        this.undoOverrideMethods(this.collectMethodsToOverride(new Node[]{this.listExplorerPanel.getExplorerManager().getRootContext()}));
        this.updateButtons();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.undoOverrideMethods(this.collectMethodsToOverride(this.listExplorerPanel.getExplorerManager().getSelectedNodes()));
        this.updateButtons();
    }

    private void addAllButtonActionPerformed(ActionEvent actionEvent) {
        this.overrideMethods(this.collectMethodsToOverride(new Node[]{this.treeExplorerPanel.getExplorerManager().getRootContext()}));
        this.updateButtons();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.overrideMethods(this.collectMethodsToOverride(this.treeExplorerPanel.getExplorerManager().getSelectedNodes()));
        this.updateButtons();
    }

    private void abstractCheckBoxActionPerformed(ActionEvent actionEvent) {
        InheritanceChildren inheritanceChildren = (InheritanceChildren)this.treeExplorerPanel.getExplorerManager().getRootContext().getChildren();
        inheritanceChildren.setFilter(this.getAvailableMethodsFilter(true, this.abstractCheckBox.isSelected()));
        this.updateButtons();
    }

    private void inheritedCheckBoxActionPerformed(ActionEvent actionEvent) {
        InheritanceChildren inheritanceChildren = (InheritanceChildren)this.treeExplorerPanel.getExplorerManager().getRootContext().getChildren();
        inheritanceChildren.setMethodsOnly(this.inheritedCheckBox.isSelected());
        this.updateButtons();
    }

    private void undoOverrideMethods(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MethodElement methodElement = (MethodElement)iterator.next();
            try {
                if (this.containsOriginal(methodElement)) continue;
                this.wizardData.getInheritance().getSourceClass().removeMethod(methodElement);
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
        }
    }

    private void overrideMethods(Collection collection) {
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MethodElement methodElement = (MethodElement)iterator.next();
            try {
                arrayList.add(this.wizardData.getInheritance().overrideMethod(methodElement, this.superCheckBox.isSelected()));
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
        }
    }

    private Collection collectMethodsToOverride(Node[] nodeArray) {
        ArrayList<MemberElement> arrayList = new ArrayList<MemberElement>();
        int n = 0;
        while (n < nodeArray.length) {
            if (!nodeArray[n].isLeaf()) {
                arrayList.addAll(this.collectMethodsToOverride(nodeArray[n].getChildren().getNodes()));
            } else {
                MemberElement memberElement = (MemberElement)nodeArray[n].getCookie(class$org$openide$src$MemberElement == null ? OverridePanel.class$("org.openide.src.MemberElement") : class$org$openide$src$MemberElement);
                if (memberElement instanceof MethodElement) {
                    arrayList.add(memberElement);
                }
            }
            ++n;
        }
        return arrayList;
    }

    private void updateButtons() {
        Node[] nodeArray = this.treeExplorerPanel.getExplorerManager().getSelectedNodes();
        Node[] nodeArray2 = this.listExplorerPanel.getExplorerManager().getSelectedNodes();
        Node[] nodeArray3 = this.treeExplorerPanel.getExplorerManager().getRootContext().getChildren().getNodes();
        Node[] nodeArray4 = this.listExplorerPanel.getExplorerManager().getRootContext().getChildren().getNodes();
        this.addButton.setEnabled(nodeArray.length > 0);
        this.addAllButton.setEnabled(nodeArray3.length > 0);
        this.removeAllButton.setEnabled(nodeArray4.length > 0);
        try {
            Node[] nodeArray5;
            if (nodeArray3.length > 0 && nodeArray.length == 0) {
                nodeArray5 = new Node[]{nodeArray3[0]};
                this.treeExplorerPanel.getExplorerManager().setSelectedNodes(nodeArray5);
            }
            if (nodeArray4.length > 0 && nodeArray2.length == 0) {
                nodeArray5 = new Node[]{nodeArray4[0]};
                this.listExplorerPanel.getExplorerManager().setSelectedNodes(nodeArray5);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        boolean bl = false;
        int n = 0;
        while (n < nodeArray2.length) {
            if (!this.containsOriginal((MethodElement)nodeArray2[n].getCookie(class$org$openide$src$MethodElement == null ? OverridePanel.class$("org.openide.src.MethodElement") : class$org$openide$src$MethodElement))) {
                bl = true;
                break;
            }
            ++n;
        }
        this.removeButton.setEnabled(bl);
    }

    private boolean containsOriginal(MethodElement methodElement) {
        MethodElement[] methodElementArray = this.wizardData.getOriginalClass().getMethods();
        int n = 0;
        while (n < methodElementArray.length) {
            if (this.elementEquals((MemberElement)methodElement, (MemberElement)methodElementArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean elementEquals(MemberElement memberElement, MemberElement memberElement2) {
        MethodElement.Key key = new MethodElement.Key((MethodElement)memberElement);
        MethodElement.Key key2 = new MethodElement.Key((MethodElement)memberElement2);
        return key.equals((Object)key2);
    }

    public void addNotify() {
        super.addNotify();
        if (this.managerListener == null) {
            this.managerListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                        OverridePanel.this.updateButtons();
                    }
                }
            };
        }
        this.treeExplorerPanel.getExplorerManager().addPropertyChangeListener(this.managerListener);
        this.listExplorerPanel.getExplorerManager().addPropertyChangeListener(this.managerListener);
        ((InheritanceChildren.OverridenMethods)this.listExplorerPanel.getExplorerManager().getExploredContext().getChildren()).refreshKeys();
    }

    public void removeNotify() {
        super.removeNotify();
        this.treeExplorerPanel.getExplorerManager().removePropertyChangeListener(this.managerListener);
        this.listExplorerPanel.getExplorerManager().removePropertyChangeListener(this.managerListener);
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.java.wizard.OverrideMethods");
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public Component getComponent() {
        return this;
    }

    protected ElementFilter.Method getAvailableMethodsFilter(boolean bl, final boolean bl2) {
        if (bl) {
            return new ElementFilter.Method(){

                public boolean accept(MethodElement methodElement) {
                    boolean bl = OverridePanel.this.wizardData.getInheritance().isOverridable(methodElement);
                    if (bl2) {
                        bl &= Modifier.isAbstract(methodElement.getModifiers());
                    }
                    return bl;
                }
            };
        }
        return new ElementFilter.Method(){

            public boolean accept(MethodElement methodElement) {
                boolean bl = OverridePanel.this.wizardData.getInheritance().isOverridable(methodElement);
                if (bl2) {
                    bl &= Modifier.isAbstract(methodElement.getModifiers());
                }
                return bl;
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MethodComparator
    implements Comparator {
        private MethodComparator() {
        }

        public int compare(Object object, Object object2) {
            MethodElement methodElement = (MethodElement)object;
            MethodElement methodElement2 = (MethodElement)object2;
            if (methodElement == methodElement2) {
                return 0;
            }
            int n = methodElement.getName().getSourceName().compareTo(methodElement2.getName().getSourceName());
            if (n != 0) {
                return n;
            }
            n = methodElement.getParameters().length - methodElement2.getParameters().length;
            if (n != 0) {
                return n;
            }
            MethodParameter[] methodParameterArray = methodElement.getParameters();
            MethodParameter[] methodParameterArray2 = methodElement2.getParameters();
            int n2 = 0;
            while (n2 < methodParameterArray.length) {
                n = methodParameterArray[n2].getFullString().compareTo(methodParameterArray2[n2].getFullString());
                if (n != 0) {
                    return n;
                }
                ++n2;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return object instanceof MethodComparator;
        }
    }

    private static class ExPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager;

        private ExPanel() {
        }

        public ExplorerManager getExplorerManager() {
            if (this.manager == null) {
                this.manager = new ExplorerManager();
            }
            return this.manager;
        }

        public Dimension getPreferredSize() {
            return new Dimension(235, 0);
        }
    }

    private class ClassComparator
    implements Comparator {
        private ClassComparator() {
        }

        public int compare(Object object, Object object2) {
            ClassElement classElement = (ClassElement)object;
            ClassElement classElement2 = (ClassElement)object2;
            if (classElement.isClassOrInterface() != classElement2.isClassOrInterface()) {
                return classElement.isClassOrInterface() ? -1 : 1;
            }
            if (classElement.isClassOrInterface()) {
                String string = classElement2.getName().getFullName();
                while (classElement.getSuperclass() != null) {
                    if (classElement.getSuperclass().getFullName().equals(string)) {
                        return 1;
                    }
                    classElement = OverridePanel.this.wizardData.getInheritance().getClass(classElement.getSuperclass(), true);
                }
                return -1;
            }
            return classElement.getName().getFullName().compareTo(classElement2.getName().getFullName());
        }

        public boolean equals(Object object) {
            return object instanceof ClassComparator;
        }
    }
}

