/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.JavaPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardData;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.src.ClassElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JavaWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1987345873459L;
    private transient WizardDescriptor.Panel[] panels;
    private static String[] panelNames;
    private static final int PANEL_COUNT = 5;
    private static final int METHODS_PANEL = 4;
    private static final int FIELDS_PANEL = 2;
    private static JavaWizardIterator instance;
    private transient int panelIndex = 0;
    private transient JavaWizardData myData;
    private transient TemplateWizard wizardInstance;
    private transient Dimension prefSize;
    private transient boolean initialized;
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$ClassPanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$FieldsPanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$OverridePanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$MethodsPanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$JavaWizardIterator;

    public static synchronized JavaWizardIterator singleton() {
        if (instance == null) {
            instance = new JavaWizardIterator();
        }
        JavaWizardIterator.instance.initialized = false;
        return instance;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException, IllegalArgumentException {
        ClassElement classElement;
        ClassElement classElement2;
        if (!this.initialized) {
            this.initializeTemplateData(templateWizard.getTemplate());
            this.initializeTargetData(templateWizard.getTemplate(), templateWizard.getTargetFolder(), templateWizard.getTargetName());
        } else {
            this.updateTargetData(templateWizard.getTemplate(), templateWizard.getTargetFolder(), templateWizard.getTargetName());
        }
        DataObject dataObject = this.instantiateTemplate(templateWizard.getTemplate(), templateWizard.getTargetFolder());
        SourceCookie sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = JavaWizardIterator.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
        if (sourceCookie == null) {
            return Collections.singleton(dataObject);
        }
        ClassElement[] classElementArray = sourceCookie.getSource().getClasses();
        try {
            if (classElementArray == null || classElementArray.length == 0) {
                classElement2 = new ClassElement();
                classElement2.setName(this.myData.getCustomizedClass().getName());
                sourceCookie.getSource().addClass(classElement2);
                classElement = sourceCookie.getSource().getClasses()[0];
            } else {
                classElement = classElementArray[0];
            }
            this.myData.applyChanges(classElement);
        }
        catch (SourceException sourceException) {
            dataObject.delete();
            throw new IOException(sourceException.getLocalizedMessage());
        }
        classElement = dataObject.getNodeDelegate();
        classElement2 = classElement.getDefaultAction();
        if (classElement2 != null) {
            classElement2.actionPerformed(new ActionEvent(classElement, 1001, ""));
        }
        return Collections.singleton(dataObject);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.panelIndex < 4;
    }

    public boolean hasPrevious() {
        return this.panelIndex > 0;
    }

    public void nextPanel() {
        this.panelIndex = this.panelIndex == 2 && !this.myData.getCustomizedClass().isClassOrInterface() ? (this.panelIndex += 2) : ++this.panelIndex;
    }

    public void previousPanel() {
        this.panelIndex = this.panelIndex == 4 && !this.myData.getCustomizedClass().isClassOrInterface() ? (this.panelIndex -= 2) : --this.panelIndex;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizardInstance = templateWizard;
        if (this.panels == null) {
            this.myData = new JavaWizardData();
            this.initializeTemplateData(templateWizard.getTemplate());
            this.initialize();
            Component component = templateWizard.targetChooser().getComponent();
            JavaWizardIterator.panelNames[0] = component.getName();
            if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("WizardPanel_contentData", panelNames);
            }
            this.panels = new WizardDescriptor.Panel[]{this.wizardInstance.targetChooser(), new DelegatingPanel(class$org$netbeans$modules$java$ui$wizard$ClassPanel == null ? (class$org$netbeans$modules$java$ui$wizard$ClassPanel = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.ClassPanel")) : class$org$netbeans$modules$java$ui$wizard$ClassPanel, true), new DelegatingPanel(class$org$netbeans$modules$java$ui$wizard$FieldsPanel == null ? (class$org$netbeans$modules$java$ui$wizard$FieldsPanel = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.FieldsPanel")) : class$org$netbeans$modules$java$ui$wizard$FieldsPanel, false), new DelegatingPanel(class$org$netbeans$modules$java$ui$wizard$OverridePanel == null ? (class$org$netbeans$modules$java$ui$wizard$OverridePanel = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.OverridePanel")) : class$org$netbeans$modules$java$ui$wizard$OverridePanel, false), new DelegatingPanel(class$org$netbeans$modules$java$ui$wizard$MethodsPanel == null ? (class$org$netbeans$modules$java$ui$wizard$MethodsPanel = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.MethodsPanel")) : class$org$netbeans$modules$java$ui$wizard$MethodsPanel, false)};
        }
        this.reset();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
        this.myData = null;
        this.initialized = false;
    }

    private Object readResolve() {
        this.initialize();
        this.reset();
        return this;
    }

    private DataObject instantiateTemplate(DataObject dataObject, DataFolder dataFolder) throws IOException {
        String string = this.myData.getCustomizedClass().getName().getName();
        String string2 = dataFolder.getPrimaryFile().getPackageNameExt('.', '.');
        this.checkValidPackageName(dataFolder);
        this.checkTargetName(dataFolder, string);
        return dataObject.createFromTemplate(dataFolder, string);
    }

    protected void reset() {
        this.panelIndex = 0;
    }

    protected void initialize() {
        if (this.myData.getCustomizedClass().isClassOrInterface()) {
            panelNames = new String[5];
            JavaWizardIterator.panelNames[3] = JavaWizardIterator.getString("TIT_OverrideWizardPanel");
            JavaWizardIterator.panelNames[4] = JavaWizardIterator.getString("TIT_AddMethodsWizardPanel");
        } else {
            panelNames = new String[4];
            JavaWizardIterator.panelNames[3] = JavaWizardIterator.getString("TIT_AddMethodsWizardPanel");
        }
        JavaWizardIterator.panelNames[0] = "";
        JavaWizardIterator.panelNames[1] = JavaWizardIterator.getString("TIT_InheritanceWizardPanel");
        JavaWizardIterator.panelNames[2] = JavaWizardIterator.getString("TIT_AddFieldsWizardPanel");
    }

    private boolean isValidPackageName(String string) {
        if ("".equals(string)) {
            return true;
        }
        try {
            Type type = Type.parse((String)string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private void checkValidPackageName(DataFolder dataFolder) throws IllegalStateException {
        FileObject fileObject = dataFolder.getPrimaryFile();
        String string = fileObject.getPackageNameExt('.', '.');
        if (!this.isValidPackageName(string)) {
            String string2 = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalFolderName"), fileObject.getPackageNameExt('/', '.'), string);
            throw (IllegalStateException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IllegalStateException(string2), 256, null, string2, null, null);
        }
    }

    private void checkTargetName(DataFolder dataFolder, String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            String string2 = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalTargetName"), string);
            IllegalStateException illegalStateException = (IllegalStateException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IllegalStateException(string2), 256, null, string2, null, null);
            throw illegalStateException;
        }
        FileObject fileObject = dataFolder.getPrimaryFile();
        if (fileObject.getFileObject(string, "java") != null) {
            String string3 = MessageFormat.format(JavaWizardIterator.getString("FMTERR_TargetExists"), string);
            throw new IllegalStateException(string3);
        }
    }

    private void initializeTemplateData(DataObject dataObject) throws IllegalStateException {
        if (dataObject == null) {
            throw new IllegalStateException("Expected template, got null");
        }
        this.myData.setTemplate(dataObject);
    }

    private void initializeTargetData(DataObject dataObject, DataFolder dataFolder, String string) throws IllegalStateException {
        if (dataObject == null || dataFolder == null) {
            throw new IllegalStateException("Expected template & target folder, got null(s)");
        }
        this.updateTargetData(dataObject, dataFolder, string);
        this.prefSize = this.panels[4].getComponent().getPreferredSize();
        this.initialized = true;
    }

    private void updateTargetData(DataObject dataObject, DataFolder dataFolder, String string) throws IllegalStateException {
        FileObject fileObject = dataFolder.getPrimaryFile();
        this.checkValidPackageName(dataFolder);
        if (string == null) {
            String string2 = fileObject.getPackageNameExt('.', '.');
            string = FileUtil.findFreeFileName((FileObject)fileObject, (String)dataObject.getName(), (String)"java");
        } else {
            this.checkTargetName(dataFolder, string);
        }
        this.myData.setTarget(fileObject, string);
    }

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$java$ui$wizard$JavaWizardIterator == null ? (class$org$netbeans$modules$java$ui$wizard$JavaWizardIterator = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.JavaWizardIterator")) : class$org$netbeans$modules$java$ui$wizard$JavaWizardIterator));
        }
        return bundle.getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DelegatingPanel
    implements WizardDescriptor.Panel,
    WizardDescriptor.FinishPanel {
        private Class panelClass;
        private boolean init;
        private WizardDescriptor.Panel instance;

        DelegatingPanel(Class clazz, boolean bl) {
            this.panelClass = clazz;
            this.init = bl;
        }

        private WizardDescriptor.Panel getInstance() {
            if (this.instance != null) {
                return this.instance;
            }
            try {
                this.instance = (WizardDescriptor.Panel)this.panelClass.newInstance();
                if (this.instance instanceof JavaPanel) {
                    ((JavaPanel)this.instance).initialize(JavaWizardIterator.this.myData);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this.instance;
        }

        public HelpCtx getHelp() {
            return this.getInstance().getHelp();
        }

        public void storeSettings(Object object) {
            this.getInstance().storeSettings(object);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.getInstance().addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.getInstance().removeChangeListener(changeListener);
        }

        public boolean isValid() {
            return this.getInstance().isValid();
        }

        public Component getComponent() {
            ((JComponent)this.getInstance()).setPreferredSize(JavaWizardIterator.this.prefSize);
            if (JavaWizardIterator.this.panelIndex == panelNames.length) {
                ((JComponent)this.getInstance()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(panelNames.length - 1));
            }
            return this.getInstance().getComponent();
        }

        public void readSettings(Object object) {
            if (!this.init || !(object instanceof TemplateWizard)) {
                return;
            }
            TemplateWizard templateWizard = (TemplateWizard)object;
            DataFolder dataFolder = null;
            DataObject dataObject = null;
            try {
                dataFolder = templateWizard.getTargetFolder();
                dataObject = templateWizard.getTemplate();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Illegal settings");
            }
            JavaWizardIterator.this.initializeTargetData(dataObject, dataFolder, templateWizard.getTargetName());
            this.getInstance().readSettings(object);
        }
    }
}

