/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.netbeans.modules.java.tools.ElementFilter;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.netbeans.modules.java.ui.wizard.MethodsChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.MethodElement;
import org.openide.src.nodes.MethodElementNode;
import org.openide.util.Task;
import org.openide.util.TaskListener;

class InheritanceChildren
extends Children.Keys
implements InheritanceSupport.HierarchyListener {
    private static final Object WAIT = new Object();
    private static final String WAIT_STRING = "wait";
    private InheritanceSupport support;
    private Comparator comparator;
    private Comparator methodComp;
    private ElementFilter.Method filter;
    private boolean methodsOnly = false;
    private InheritanceSupport.HierarchyListener listener;

    public InheritanceChildren(InheritanceSupport inheritanceSupport, Comparator comparator, Comparator comparator2, ElementFilter.Method method) {
        this.support = inheritanceSupport;
        this.comparator = comparator;
        this.methodComp = comparator2;
        this.filter = method;
        this.setWaitNode();
        this.listener = this;
    }

    public void addNotify() {
        this.support.addHierarchyListener(this.listener);
        this.support.prepareHierarchy().addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                InheritanceChildren.this.refreshData();
                InheritanceChildren.this.support.addHierarchyListener(InheritanceChildren.this.listener);
            }
        });
        this.refreshData();
    }

    public void removeNotify() {
        this.support.removeHierarchyListener(this.listener);
        this.setKeys(Collections.EMPTY_SET);
    }

    public void setMethodsOnly(boolean bl) {
        if (this.methodsOnly != bl) {
            this.methodsOnly = bl;
            this.refreshData();
        }
    }

    public boolean isMethodsOnly() {
        return this.methodsOnly;
    }

    public void setFilter(ElementFilter.Method method) {
        if (this.filter != method) {
            this.filter = method;
            if (this.methodsOnly) {
                this.refreshData();
            } else {
                Node[] nodeArray = this.getNodes();
                int n = 0;
                while (n < nodeArray.length) {
                    ((Methods)nodeArray[n].getChildren()).refreshKeys();
                    ++n;
                }
            }
        }
    }

    public ElementFilter.Method getFilter() {
        return this.filter;
    }

    private void refreshData() {
        Collection collection;
        Comparator comparator;
        Collection collection2;
        if (this.methodsOnly) {
            collection2 = this.support.createMethodMap(this.support.getInheritedClasses(), false, this.filter).values();
            comparator = this.methodComp;
        } else {
            collection2 = this.support.getInheritedClasses();
            comparator = this.comparator;
        }
        if (comparator == null) {
            collection = collection2;
        } else {
            collection = new TreeSet(comparator);
            collection.addAll(collection2);
        }
        this.setKeys(collection);
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof ClassElement) {
            return new Node[]{this.support.createClassElementNode((ClassElement)object, (Children)new Methods((ClassElement)object), false)};
        }
        if (object instanceof MethodElement) {
            MethodElementNode methodElementNode = new MethodElementNode((MethodElement)object, false);
            methodElementNode.setElementFormat(MethodsChildren.METHOD_FORMAT);
            return new Node[]{methodElementNode};
        }
        if (object == WAIT) {
            return new Node[]{new AbstractNode(Children.LEAF){

                public String getDisplayName() {
                    return InheritanceChildren.WAIT_STRING;
                }
            }};
        }
        throw new IllegalArgumentException(object.getClass().toString());
    }

    private final void setWaitNode() {
        this.setKeys(new Object[]{WAIT});
    }

    public void inheritanceChanged() {
        this.setWaitNode();
    }

    public void inheritedClassesComputed(Map map) {
        this.refreshData();
    }

    public void inheritedMethodsComputed(Collection collection) {
    }

    static class OverridenMethods
    extends Children.Keys
    implements PropertyChangeListener {
        ClassElement classElement;
        InheritanceSupport support;
        Comparator comparator;

        public OverridenMethods(ClassElement classElement, InheritanceSupport inheritanceSupport, Comparator comparator) {
            this.classElement = classElement;
            this.support = inheritanceSupport;
            this.comparator = comparator;
        }

        protected void addNotify() {
            this.classElement.addPropertyChangeListener((PropertyChangeListener)this);
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.classElement.removePropertyChangeListener((PropertyChangeListener)this);
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof MethodElement) {
                MethodElementNode methodElementNode = new MethodElementNode((MethodElement)object, false);
                methodElementNode.setElementFormat(MethodsChildren.METHOD_FORMAT);
                return new Node[]{methodElementNode};
            }
            throw new IllegalArgumentException(object.getClass().toString());
        }

        void refreshKeys() {
            ArrayList arrayList = new ArrayList(this.support.getOverridingMethods());
            Collections.sort(arrayList, this.comparator);
            this.setKeys(arrayList);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("methods".equals(propertyChangeEvent.getPropertyName())) {
                this.refreshKeys();
            }
        }
    }

    class Methods
    extends Children.Keys {
        protected ClassElement classElement;

        public Methods(ClassElement classElement) {
            this.classElement = classElement;
        }

        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof MethodElement) {
                MethodElementNode methodElementNode = new MethodElementNode((MethodElement)object, false);
                methodElementNode.setElementFormat(MethodsChildren.METHOD_FORMAT);
                return new Node[]{methodElementNode};
            }
            throw new IllegalArgumentException(object.getClass().toString());
        }

        void refreshKeys() {
            ArrayList<ClassElement> arrayList = new ArrayList<ClassElement>();
            arrayList.add(this.classElement);
            TreeSet treeSet = new TreeSet(InheritanceChildren.this.methodComp);
            treeSet.addAll(InheritanceChildren.this.support.createMethodMap(arrayList, false, InheritanceChildren.this.filter).values());
            this.setKeys(treeSet);
        }
    }
}

