/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

class NameNavigator
extends KeyAdapter {
    private static final long KEY_TRESHOLD = 500L;
    ExplorerManager manager;
    private String nodeName = null;
    private long lastEvent = 0L;

    public NameNavigator(ExplorerManager explorerManager) {
        this.manager = explorerManager;
    }

    public void keyTyped(KeyEvent keyEvent) {
        long l = keyEvent.getWhen();
        if (this.lastEvent > 0L && l - this.lastEvent > 500L) {
            this.resetNameBuffer();
        }
        this.lastEvent = l;
        this.navigateBy(keyEvent.getKeyChar());
    }

    protected void checkTimeout() {
        if (System.currentTimeMillis() - this.lastEvent > 500L) {
            this.resetNameBuffer();
        }
    }

    protected void resetNameBuffer() {
        this.nodeName = null;
    }

    public String getPartialName() {
        return this.nodeName != null ? this.nodeName : "";
    }

    public void navigateBy(char c) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        Node node = nodeArray == null || nodeArray.length == 0 ? null : nodeArray[nodeArray.length - 1];
        this.navigate(node, c);
    }

    public Node navigate(Node node, char c) {
        boolean bl = this.nodeName == null;
        this.nodeName = bl ? new String(new char[]{c}) : this.nodeName + c;
        Node node2 = this.findNode(bl, node, this.nodeName);
        return node2;
    }

    protected Node findNode(boolean bl, Node node, String string) {
        Node node2 = null;
        if (node != null) {
            if (!bl) {
                node2 = this.findSibling(node, this.nodeName);
            }
            if (node2 == null) {
                this.findChild(node, string, null);
            }
        }
        if (node2 == null) {
            Node node3 = node;
            if (node != null) {
                node = node.getParentNode();
            }
            if (node == null) {
                node = this.manager.getExploredContext();
            }
            node2 = this.findChild(node, this.nodeName, node3);
        }
        return node2;
    }

    protected Node findNodeStartingWith(Node node, Node node2, String string) {
        Children children = node.getChildren();
        if (children == null || children == Children.LEAF) {
            return null;
        }
        Node[] nodeArray = children.getNodes();
        if (nodeArray == null) {
            return null;
        }
        if (nodeArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < nodeArray.length) {
            if (this.getNodeName(nodeArray[n]).startsWith(this.nodeName) && nodeArray[n] != node2) {
                return nodeArray[n];
            }
            ++n;
        }
        return null;
    }

    protected String getNodeName(Node node) {
        return node.getName();
    }

    private Node findChild(Node node, String string, Node node2) {
        return this.findNodeStartingWith(node, node2, string);
    }

    private Node findSibling(Node node, String string) {
        return this.findNodeStartingWith(node.getParentNode(), null, string);
    }
}

