/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.nodes.Index;

public abstract class IndexedPropertyChildren
extends Index.KeysChildren {
    private PropertyModel model;
    private PropertyChangeListener beanListener;
    boolean ignoreBeanChanges;

    public IndexedPropertyChildren(Object object, String string) {
        this((PropertyModel)new DefaultPropertyModel(object, string));
    }

    public IndexedPropertyChildren(PropertyModel propertyModel) {
        super(new LinkedList());
        this.model = propertyModel;
        if (!propertyModel.getPropertyType().isArray()) {
            throw new IllegalArgumentException("Property of array type expected.");
        }
    }

    protected void addNotify() {
        this.model.addPropertyChangeListener(this.getBeanListener());
        this.refreshData();
    }

    protected void removeNotify() {
        this.model.removePropertyChangeListener(this.getBeanListener());
    }

    protected final PropertyChangeListener getBeanListener() {
        if (this.beanListener != null) {
            return this.beanListener;
        }
        this.beanListener = this.createBeanListener();
        return this.beanListener;
    }

    protected PropertyChangeListener createBeanListener() {
        return new SourceListener();
    }

    protected final void refreshData() {
        List<Object> list;
        try {
            list = Arrays.asList((Object[])this.model.getValue());
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        this.list.clear();
        this.list.addAll(list);
        this.update();
    }

    protected Object[] createValue(Collection collection) {
        Class<?> clazz = this.model.getPropertyType().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, collection.size());
        return collection.toArray(objectArray);
    }

    protected void reorder(int[] nArray) {
        super.reorder(nArray);
        try {
            try {
                this.ignoreBeanChanges = true;
                Object[] objectArray = this.createValue(this.list);
                this.model.setValue((Object)objectArray);
                Object var4_4 = null;
                this.ignoreBeanChanges = false;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.ignoreBeanChanges = false;
                throw throwable;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleReorderException(invocationTargetException);
        }
    }

    protected void handleReorderException(InvocationTargetException invocationTargetException) {
        this.refreshData();
    }

    private class SourceListener
    implements PropertyChangeListener {
        private SourceListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("value".equals(propertyChangeEvent.getPropertyName())) {
                IndexedPropertyChildren.this.refreshData();
            }
        }
    }
}

