/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.netbeans.modules.java.tools.OverrideAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.util.Task;
import org.openide.util.TaskListener;

class InheritanceChildren
extends Children.Keys
implements InheritanceSupport.HierarchyListener {
    private static final Object WAIT = new Object();
    private static final String WAIT_STRING = OverrideAction.getString("MSG_InheritanceWait");
    private InheritanceSupport data;
    private Comparator comparator;
    private InheritanceSupport.HierarchyListener listener;

    public InheritanceChildren(InheritanceSupport inheritanceSupport, Comparator comparator) {
        this.data = inheritanceSupport;
        this.comparator = comparator;
        this.setWaitNode();
        this.listener = this;
    }

    public void addNotify() {
        this.data.addHierarchyListener(this.listener);
        this.data.prepareHierarchy().addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                InheritanceChildren.this.refreshData();
                InheritanceChildren.this.data.addHierarchyListener(InheritanceChildren.this.listener);
            }
        });
    }

    public void removeNotify() {
        this.data.removeHierarchyListener(this.listener);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.refreshData();
    }

    private void refreshData() {
        TreeSet treeSet;
        TreeSet treeSet2 = this.data.getInheritedClasses();
        if (this.comparator == null) {
            treeSet = treeSet2;
        } else {
            treeSet = new TreeSet(this.comparator);
            treeSet.addAll(treeSet2);
        }
        this.setKeys(treeSet);
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof ClassElement) {
            return new Node[]{this.data.createClassElementNode((ClassElement)object, Children.LEAF, false)};
        }
        if (object == WAIT) {
            return new Node[]{new AbstractNode(Children.LEAF){

                public String getDisplayName() {
                    return WAIT_STRING;
                }
            }};
        }
        throw new IllegalArgumentException(object.getClass().toString());
    }

    private final void setWaitNode() {
        this.setKeys(new Object[]{WAIT});
    }

    public void inheritanceChanged() {
        this.setWaitNode();
    }

    public void inheritedClassesComputed(Map map) {
        this.refreshData();
    }

    public void inheritedMethodsComputed(Collection collection) {
    }
}

