/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.parser.BaseElementInfo;
import org.netbeans.modules.java.parser.ElementMatch;
import org.openide.src.Element;
import org.openide.src.SourceException;

public class ChildCollection {
    Collection children;
    ElementMatch.Finder[] finders;
    int[] ids;
    int[] results;
    int idIndex;
    Class componentClass;
    private static final int MIN_IDS = 15;

    public ChildCollection(ElementMatch.Finder[] finderArray, Class clazz) {
        this.finders = finderArray;
        this.componentClass = clazz;
    }

    public int[] getIDs() {
        return this.ids;
    }

    public int[] getResultMap() {
        return this.results;
    }

    protected Element[] createArray(int n) {
        return (Element[])Array.newInstance(this.componentClass, n);
    }

    public void addChild(BaseElementInfo baseElementInfo, int n) {
        if (this.children == null) {
            this.children = new LinkedList();
            if (n != -1) {
                this.ids = new int[15];
            }
        }
        this.children.add(baseElementInfo);
        if (this.ids != null) {
            if (this.ids.length == this.idIndex) {
                int[] nArray = new int[this.ids.length * 2];
                System.arraycopy(this.ids, 0, nArray, 0, this.ids.length);
                this.ids = nArray;
            }
            this.ids[this.idIndex++] = n;
        }
    }

    private Element[] createAllChildren(Element element, LangModel.Updater updater) throws SourceException {
        Element[] elementArray = this.createArray(this.children.size());
        int n = 0;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            BaseElementInfo baseElementInfo = (BaseElementInfo)iterator.next();
            elementArray[n] = baseElementInfo.createModelElement(element, updater);
            ++n;
        }
        return elementArray;
    }

    public Element[] updateChildren(Element element, LangModel.Updater updater, Element[] elementArray) throws SourceException {
        if (elementArray.length == 0) {
            return this.createAllChildren(element, updater);
        }
        ElementMatch elementMatch = new ElementMatch(elementArray, this.children);
        int n = 0;
        while (n < this.finders.length) {
            elementMatch.reset();
            this.finders[n].findMatches(elementMatch);
            ++n;
        }
        int[] nArray = elementMatch.getResultMap();
        Element[] elementArray2 = elementMatch.getOldElements();
        Element[] elementArray3 = this.createArray(this.children.size());
        Collection collection = elementMatch.getInfos();
        Iterator iterator = collection.iterator();
        this.results = nArray;
        int n2 = 0;
        while (iterator.hasNext()) {
            BaseElementInfo baseElementInfo = (BaseElementInfo)iterator.next();
            if (nArray == null || nArray[n2] == -1) {
                elementArray3[n2] = baseElementInfo.createModelElement(element, updater);
            } else {
                elementArray3[n2] = elementArray2[nArray[n2]];
                baseElementInfo.updateElement(updater, elementArray3[n2]);
            }
            ++n2;
        }
        return elementArray3;
    }

    public void mapChildren(Element[] elementArray, Element[] elementArray2) {
        int n = 0;
        while (n < elementArray.length) {
            elementArray2[this.ids[n]] = elementArray[n];
            ++n;
        }
    }

    public Collection getChildren() {
        return this.children;
    }
}

