/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.codegen.DocumentBinding;
import org.netbeans.modules.java.codegen.TextBinding;
import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.parser.ElementMatch;
import org.openide.nodes.Node;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.text.PositionBounds;

public abstract class BaseElementInfo
implements ElementFactory.Item {
    ElementFactory.Item parent;
    String name;
    int modifiers;
    String docText;
    Element el;
    TextBinding binding;
    String bodyContent;
    PositionBounds wholeBounds;
    PositionBounds bodyBounds;
    PositionBounds headerBounds;
    PositionBounds docBounds;
    static /* synthetic */ Class class$org$openide$src$MemberElement$Impl;

    BaseElementInfo(String string, int n) {
        this.name = string;
        this.modifiers = n;
    }

    public Element createModelElement(Element element, LangModel.Updater updater) throws SourceException {
        Element element2 = this.createModelImpl(updater, element);
        this.updateElement(updater, element2);
        this.el = element2;
        return this.el;
    }

    public int comparePositionTo(TextBinding textBinding) {
        if (textBinding == null) {
            return -1;
        }
        PositionBounds positionBounds = textBinding.getElementRange(false);
        int n = this.wholeBounds.getBegin().getOffset();
        int n2 = positionBounds.getBegin().getOffset();
        int n3 = this.wholeBounds.getEnd().getOffset();
        int n4 = positionBounds.getEnd().getOffset();
        if (n2 == n4) {
            return -1;
        }
        if (n < n4 && n3 > n2) {
            return 0;
        }
        if (n3 == n2) {
            return -1;
        }
        return n3 - n2;
    }

    protected Identifier createName() {
        return Identifier.create((String)this.name);
    }

    public Node.Cookie getCookie(Class clazz) {
        return null;
    }

    protected abstract Element createModelImpl(LangModel.Updater var1, Element var2);

    protected Identifier[] mapIdentifiers(LangModel.Updater updater, Identifier[] identifierArray, Element element) {
        if (identifierArray.length == 0) {
            return identifierArray;
        }
        Identifier[] identifierArray2 = new Identifier[identifierArray.length];
        int n = 0;
        while (n < identifierArray2.length) {
            identifierArray2[n] = this.createContextID(updater, element, identifierArray[n]);
            ++n;
        }
        return identifierArray2;
    }

    protected Identifier createContextID(LangModel.Updater updater, Element element, Identifier identifier) {
        return updater.createLocalIdentifier(element, identifier, identifier.getResolutionStatus());
    }

    protected Type createContextType(LangModel.Updater updater, Element element, Type type) {
        if (type.isPrimitive()) {
            return type;
        }
        Type type2 = type;
        int n = 0;
        while (type2.isArray()) {
            type2 = type2.getElementType();
            ++n;
        }
        if (type2.isPrimitive()) {
            return type;
        }
        Identifier identifier = type2.getTypeIdentifier();
        Identifier identifier2 = updater.createLocalIdentifier(element, identifier, identifier.getResolutionStatus());
        type2 = Type.createClass((Identifier)identifier2);
        while (n-- > 0) {
            type2 = Type.createArray((Type)type2);
        }
        return type2;
    }

    public void updateElement(LangModel.Updater updater, Element element) throws SourceException {
        this.el = element;
        this.binding = (TextBinding)updater.getElementBinding(element);
    }

    public void updateBindings(DocumentBinding documentBinding) {
        this.updateBinding(documentBinding, this.binding);
    }

    public void updateBinding(DocumentBinding documentBinding, TextBinding textBinding) {
        textBinding.updateBounds(0, this.wholeBounds);
        textBinding.updateBounds(2, this.headerBounds);
        textBinding.updateBounds(3, this.bodyBounds);
        textBinding.updateBounds(1, this.docBounds);
    }

    protected static void updateChildren(DocumentBinding documentBinding, Collection collection, TextBinding.Container container) {
        ArrayList<TextBinding> arrayList = new ArrayList<TextBinding>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BaseElementInfo baseElementInfo = (BaseElementInfo)iterator.next();
            baseElementInfo.updateBindings(documentBinding);
            arrayList.add(baseElementInfo.binding);
        }
        container.updateChildren(arrayList);
    }

    protected void updateBase(Element element) throws SourceException {
        this.el = element;
        MemberElement.Impl impl = (MemberElement.Impl)element.getCookie(class$org$openide$src$MemberElement$Impl == null ? (class$org$openide$src$MemberElement$Impl = BaseElementInfo.class$("org.openide.src.MemberElement$Impl")) : class$org$openide$src$MemberElement$Impl);
        impl.setModifiers(this.modifiers);
        impl.setName(this.createName());
    }

    protected void updateJavaDoc(JavaDoc javaDoc) throws SourceException {
        javaDoc.setRawText(this.docText);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NameFinder
    extends ElementMatch.AbstractFinder {
        protected boolean matches(BaseElementInfo baseElementInfo, Element element) {
            MemberElement memberElement = (MemberElement)element;
            return baseElementInfo.name.equals(memberElement.getName().getSourceName());
        }
    }
}

