/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.zip.CRC32;
import org.netbeans.modules.java.model.Binding;
import org.netbeans.modules.java.model.DefaultLangModel;
import org.netbeans.modules.java.model.ElementImpl;
import org.netbeans.modules.java.model.FlyweightIndexedProperty;
import org.netbeans.modules.java.model.IdentifierArrayProperty;
import org.netbeans.modules.java.model.JavaDocImpl;
import org.netbeans.modules.java.model.MemberElementImpl;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MethodParameter;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceException;
import org.openide.src.Type;

abstract class CallableImpl
extends MemberElementImpl
implements ConstructorElement.Impl {
    private static final boolean DEBUG = false;
    static final MethodParameter[] NO_PARAMETERS = new MethodParameter[0];
    private MethodParameter[] parameters = NO_PARAMETERS;
    private Identifier[] exceptions = IdentifierArrayProperty.EMPTY;
    private static IdentifierArrayProperty exceptionSupport;
    private static MethodParamSupport paramSupport;
    private String cachedBody;
    private transient long bodyHash = -1L;
    static /* synthetic */ Class class$org$netbeans$modules$java$model$CallableImpl;

    CallableImpl(DefaultLangModel defaultLangModel) {
        super(defaultLangModel);
        if (paramSupport == null) {
            paramSupport = new MethodParamSupport();
            exceptionSupport = new ExceptionSupport();
        }
        this.javadoc = new JavaDocImpl.Method(null, this);
    }

    public JavaDoc.Method getJavaDoc() {
        return (JavaDoc.Method)this.javadoc;
    }

    protected void copyBody(String string) {
        this.cachedBody = string;
    }

    void updateBody(String string) {
        if (string == null) {
            this.bodyHash = -1L;
            return;
        }
        long l = this.computeHash(string);
        if (l == this.bodyHash) {
            return;
        }
        if (this.bodyHash != -1L) {
            this.addPropertyChange(new PropertyChangeEvent(this.getElement(), "body", null, null));
        }
        this.bodyHash = l;
    }

    public final MethodParameter[] getParameters() {
        if (this.parameters == NO_PARAMETERS) {
            return this.parameters;
        }
        MethodParameter[] methodParameterArray = new MethodParameter[this.parameters.length];
        int n = 0;
        while (n < this.parameters.length) {
            MethodParameter methodParameter = this.parameters[n];
            methodParameterArray[n] = new MethodParameter(methodParameter.getName(), methodParameter.getType(), methodParameter.isFinal());
            ++n;
        }
        return methodParameterArray;
    }

    public final Identifier[] getExceptions() {
        if (this.exceptions == IdentifierArrayProperty.EMPTY) {
            return this.exceptions;
        }
        return (Identifier[])this.exceptions.clone();
    }

    public final String getBody() {
        try {
            if (this.cachedBody != null) {
                return this.cachedBody;
            }
            return this.getMethodBinding().getBodyContent();
        }
        catch (SourceException sourceException) {
            return null;
        }
    }

    protected void notifyCreate() {
        super.notifyCreate();
        if (this.cachedBody != null) {
            this.cachedBody = null;
            String string = this.getBody();
            if (string != null) {
                this.bodyHash = this.computeHash(string);
            }
        }
    }

    private long computeHash(String string) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        return cRC32.getValue();
    }

    protected void createFromModel(Element element) throws SourceException {
        super.createFromModel(element);
        ConstructorElement constructorElement = (ConstructorElement)element;
        this.setParameters(constructorElement.getParameters());
        this.setExceptions(constructorElement.getExceptions());
        this.copyBody(constructorElement.getBody());
        this.setJavaDocText(constructorElement.getJavaDoc().getRawText(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameters(MethodParameter[] methodParameterArray) throws SourceException {
        Object object;
        block5: {
            block4: {
                object = this.takeLock();
                try {
                    if (!this.isCreated()) {
                        methodParameterArray = this.resolveParams(methodParameterArray);
                        MultiPropertyChangeEvent multiPropertyChangeEvent = paramSupport.createChangeEvent(this.getElement(), this.parameters == null ? NO_PARAMETERS : this.parameters, methodParameterArray);
                        if (multiPropertyChangeEvent == null) {
                            Object var5_4 = null;
                            break block4;
                        }
                        this.checkVetoablePropertyChange((PropertyChangeEvent)multiPropertyChangeEvent);
                        this.getMethodBinding().changeParameters(methodParameterArray);
                        this.fireOwnPropertyChange((PropertyChangeEvent)multiPropertyChangeEvent);
                    }
                    this.parameters = methodParameterArray;
                    this.commit();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.releaseLock(object);
                    throw throwable;
                }
            }
            this.releaseLock(object);
            return;
        }
        Object var5_5 = null;
        this.releaseLock(object);
    }

    private MethodParameter resolveParameter(MethodParameter methodParameter) {
        Type type = this.resolveType(methodParameter.getType());
        if (type == methodParameter.getType()) {
            return methodParameter;
        }
        return new MethodParameter(methodParameter.getName(), type, methodParameter.isFinal());
    }

    private MethodParameter[] resolveParams(MethodParameter[] methodParameterArray) {
        if (!this.isConstrained()) {
            return methodParameterArray;
        }
        int[] nArray = paramSupport.pairItems(this.parameters, methodParameterArray);
        MethodParameter[] methodParameterArray2 = null;
        int n = 0;
        while (n < nArray.length) {
            MethodParameter methodParameter;
            if (nArray[n] == -1 && (methodParameter = this.resolveParameter(methodParameterArray[n])) != methodParameterArray[n]) {
                if (methodParameterArray2 == null) {
                    methodParameterArray2 = new MethodParameter[methodParameterArray.length];
                    System.arraycopy(methodParameterArray, 0, methodParameterArray2, 0, methodParameterArray.length);
                }
                methodParameterArray2[n] = methodParameter;
            }
            ++n;
        }
        return methodParameterArray2 == null ? methodParameterArray : methodParameterArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setExceptions(Identifier[] identifierArray) throws SourceException {
        Object object;
        block5: {
            block4: {
                object = this.takeLock();
                try {
                    if (!this.isCreated()) {
                        identifierArray = this.resolveIdentifiers(identifierArray);
                        MultiPropertyChangeEvent multiPropertyChangeEvent = exceptionSupport.createChangeEvent(this.getElement(), this.exceptions == null ? IdentifierArrayProperty.EMPTY : this.exceptions, identifierArray);
                        if (multiPropertyChangeEvent == null) {
                            Object var5_4 = null;
                            break block4;
                        }
                        this.checkVetoablePropertyChange((PropertyChangeEvent)multiPropertyChangeEvent);
                        this.getMethodBinding().changeExceptions(identifierArray);
                        this.fireOwnPropertyChange((PropertyChangeEvent)multiPropertyChangeEvent);
                    }
                    this.exceptions = identifierArray;
                    this.commit();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.releaseLock(object);
                    throw throwable;
                }
            }
            this.releaseLock(object);
            return;
        }
        Object var5_5 = null;
        this.releaseLock(object);
    }

    public final void setBody(String string) throws SourceException {
        String string2;
        Object object = this.takeLock();
        try {
            block10: {
                if (this.isCreated()) break block9;
                string2 = this.getMethodBinding().getBodyContent();
                if (string2 == string) break block10;
                if (string2 == null || string == null || !string2.equals(string)) break block11;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseLock(object);
            throw throwable;
        }
        this.releaseLock(object);
        {
            block9: {
                block11: {
                    return;
                }
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.getElement(), "body", string2, string);
                this.checkVetoablePropertyChange(propertyChangeEvent);
                if (string == null) {
                    this.getMethodBinding().makeAbstract();
                } else if (string2 == null) {
                    this.getMethodBinding().createBody(string);
                } else {
                    this.getMethodBinding().changeBody(string);
                }
                string = this.getBody();
                propertyChangeEvent = new PropertyChangeEvent(this.getElement(), "body", string2, string);
                this.addPropertyChange(propertyChangeEvent);
            }
            this.bodyHash = this.computeHash(string);
            this.commit();
        }
        Object var6_5 = null;
        this.releaseLock(object);
    }

    protected void initializeListenerSupport() {
        Class clazz;
        if (exceptionSupport == null) {
            clazz = class$org$netbeans$modules$java$model$CallableImpl == null ? (class$org$netbeans$modules$java$model$CallableImpl = CallableImpl.class$("org.netbeans.modules.java.model.CallableImpl")) : class$org$netbeans$modules$java$model$CallableImpl;
            synchronized (clazz) {
                if (exceptionSupport == null) {
                    exceptionSupport = new ExceptionSupport();
                }
            }
        }
        if (paramSupport == null) {
            clazz = class$org$netbeans$modules$java$model$CallableImpl == null ? (class$org$netbeans$modules$java$model$CallableImpl = CallableImpl.class$("org.netbeans.modules.java.model.CallableImpl")) : class$org$netbeans$modules$java$model$CallableImpl;
            synchronized (clazz) {
                if (paramSupport == null) {
                    paramSupport = new MethodParamSupport();
                }
            }
        }
    }

    protected final Binding.Method getMethodBinding() {
        return (Binding.Method)this.getBinding();
    }

    protected void copyCallableProperties(ConstructorElement constructorElement) {
        try {
            constructorElement.setName(this.getName());
            constructorElement.setModifiers(this.getModifiers());
            constructorElement.setParameters(this.getParameters());
            constructorElement.setExceptions(this.getExceptions());
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ExceptionSupport
    extends IdentifierArrayProperty {
        ExceptionSupport() {
            super("exceptions");
        }

        public Object[] getAsArray(ElementImpl elementImpl) {
            return ((CallableImpl)elementImpl).exceptions;
        }

        protected final Object[] getValue(ElementImpl elementImpl) {
            return ((CallableImpl)elementImpl).exceptions;
        }

        public boolean compareValues(Object object, Object object2) {
            return MemberElementImpl.compareSourceIdentifiers((Identifier)object, (Identifier)object2);
        }
    }

    private static final class MethodParamSupport
    extends FlyweightIndexedProperty {
        MethodParamSupport() {
            super("parameters");
        }

        protected final Object[] createEmpty() {
            return NO_PARAMETERS;
        }

        protected final Object[] createValue(int n) {
            if (n == 0) {
                return this.createEmpty();
            }
            return new MethodParameter[n];
        }

        protected boolean compareValues(Object object, Object object2) {
            MethodParameter methodParameter = (MethodParameter)object;
            MethodParameter methodParameter2 = (MethodParameter)object2;
            Type type = methodParameter.getType();
            Type type2 = methodParameter2.getType();
            if (!methodParameter.getName().equals(methodParameter2.getName())) {
                return false;
            }
            if (methodParameter.isFinal() != methodParameter2.isFinal()) {
                return false;
            }
            return MemberElementImpl.compareSourceTypes(type, type2);
        }

        protected final Object[] getValue(ElementImpl elementImpl) {
            return ((CallableImpl)elementImpl).parameters;
        }
    }
}

