/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.environment;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class Utilities {
    private static final char PATH_SEPARATOR = File.pathSeparatorChar;
    private static File userHome = Utilities.findDirectory(System.getProperty("netbeans.user"));
    private static File systemHome = Utilities.findDirectory(System.getProperty("netbeans.home"));
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$org$netbeans$modules$java$environment$Utilities;

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$java$environment$Utilities == null ? (class$org$netbeans$modules$java$environment$Utilities = Utilities.class$("org.netbeans.modules.java.environment.Utilities")) : class$org$netbeans$modules$java$environment$Utilities));
        }
        return bundle.getString(string);
    }

    public static NbClassPath createClassPath(Enumeration enumeration) throws IOException, IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        FSEnvironment fSEnvironment = null;
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e = enumeration.nextElement();
            if (e instanceof FileSystem) {
                object = (FileSystem)e;
                if (fSEnvironment == null) {
                    fSEnvironment = new FSEnvironment();
                }
                try {
                    object.prepareEnvironment(fSEnvironment);
                }
                catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                    throw new IOException(environmentNotSupportedException.getMessage());
                }
                Utilities.addClassPathItem(stringBuffer, fSEnvironment.classPathItem);
                continue;
            }
            if (e instanceof File) {
                object = (File)e;
                Utilities.addClassPathItem(stringBuffer, ((File)object).getAbsolutePath());
                continue;
            }
            if (e instanceof NbClassPath) {
                object = ((NbClassPath)e).getClassPath();
                if (((String)object).length() == 0) continue;
                if (((String)object).charAt(0) == '\"') {
                    Utilities.addClassPathItem(stringBuffer, ((String)object).substring(1, ((String)object).length() - 1));
                    continue;
                }
                Utilities.addClassPathItem(stringBuffer, (String)object);
                continue;
            }
            throw new IllegalArgumentException("Illegal item on classpath");
        }
        return new NbClassPath(stringBuffer.toString());
    }

    public static File findInstalledFile(String string) {
        File file;
        if (userHome != null && (file = new File(userHome, string)).exists()) {
            return file;
        }
        if (systemHome != null && (file = new File(systemHome, string)).exists()) {
            return file;
        }
        return null;
    }

    static final File findDirectory(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    private static void addClassPathItem(StringBuffer stringBuffer, String string) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(PATH_SEPARATOR);
        }
        stringBuffer.append(string);
    }

    public static File getUserHome() {
        return userHome;
    }

    public static File getSystemHome() {
        return systemHome;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FSEnvironment
    extends FileSystem.Environment {
        String classPathItem;

        private FSEnvironment() {
        }

        public void addClassPath(String string) {
            this.classPathItem = string;
        }
    }
}

