/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.netbeans.modules.java.BogusCompiler;
import org.netbeans.modules.java.CleanCompiler;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.Util;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.compiler.Compilable;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerType;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryAdapter;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import sun.tools.java.Constants;

public abstract class JavaCompilerType
extends CompilerType
implements Constants,
Cloneable {
    static final long serialVersionUID = -1426544702124944362L;
    protected static final int currentVersion = 1;
    protected int version;
    public static final Object COMPILE = class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = JavaCompilerType.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile;
    public static final Object BUILD = class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = JavaCompilerType.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build;
    public static final Object CLEAN = class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = JavaCompilerType.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean;
    private static ResourceBundle bundle;
    public static final String PROP_F_DEPRECATION = "deprecation";
    public static final String PROP_F_DEBUG = "debug";
    public static final String PROP_F_OPTIMIZE = "optimize";
    public static final String PROP_F_WARNINGS = "warnings";
    public static final String PROP_CHAR_ENCODING = "charEncoding";
    public static final String PROP_FLAGS = "flag";
    public static final String PROP_TARGET_FILESYSTEM = "targetFileSystem";
    private static final String INVALID_TARGET_NAME = "InvalidTarget";
    private static final String DEFAULT_ENCODING = "null";
    public static final String PROP_CLASSPATH = "classPath";
    public static final String PROP_BOOTCLASSPATH = "bootClassPath";
    public static final FileSystem TARGET_INVALID;
    private int flag = 274436;
    private String charEncoding;
    private transient FileSystem targetFileSystem;
    private transient boolean listenerRegistered;
    private String targetFSName;
    private NbClassPath classPath;
    private NbClassPath bootClassPath;
    private transient NbClassPath defaultBootClassPath;
    private transient NbClassPath defaultClassPath;
    private transient R repoL;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;
    static /* synthetic */ Class class$org$openide$ServiceType;
    static /* synthetic */ Class class$org$openide$filesystems$Repository;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaCompilerType;

    public Object clone() throws CloneNotSupportedException {
        JavaCompilerType javaCompilerType = (JavaCompilerType)super.clone();
        try {
            Field field = (class$org$openide$ServiceType == null ? (class$org$openide$ServiceType = JavaCompilerType.class$("org.openide.ServiceType")) : class$org$openide$ServiceType).getDeclaredField("supp");
            ((AccessibleObject)field).setAccessible(true);
            field.set(javaCompilerType, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throwCloneException(illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.throwCloneException(noSuchFieldException);
        }
        javaCompilerType.setName("");
        return javaCompilerType;
    }

    public NbClassPath getClassPath() {
        NbClassPath nbClassPath = this.classPath;
        if (nbClassPath != null) {
            return nbClassPath;
        }
        return this.createDefaultClassPath();
    }

    protected NbClassPath createDefaultClassPath() {
        if (this.defaultClassPath != null) {
            return this.defaultClassPath;
        }
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (this.defaultClassPath == null) {
                this.defaultClassPath = new NbClassPath("");
            }
        }
        return this.defaultClassPath;
    }

    public void setClassPath(NbClassPath nbClassPath) {
        NbClassPath nbClassPath2;
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (nbClassPath == this.getClassPath() || nbClassPath != null && nbClassPath.equals((Object)this.getClassPath())) {
                return;
            }
            nbClassPath2 = this.classPath;
            this.classPath = nbClassPath;
        }
        this.firePropertyChange(PROP_CLASSPATH, nbClassPath2, nbClassPath);
    }

    public NbClassPath getBootClassPath() {
        NbClassPath nbClassPath = this.bootClassPath;
        if (nbClassPath != null) {
            return nbClassPath;
        }
        return this.bootClassPath == null ? this.getDefaultBootClassPath() : this.bootClassPath;
    }

    protected NbClassPath getDefaultBootClassPath() {
        if (this.defaultBootClassPath != null) {
            return this.defaultBootClassPath;
        }
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (this.defaultBootClassPath != null) {
                NbClassPath nbClassPath = this.defaultBootClassPath;
                return nbClassPath;
            }
        }
        this.defaultBootClassPath = new NbClassPath("");
        return this.defaultBootClassPath;
    }

    public void setBootClassPath(NbClassPath nbClassPath) {
        NbClassPath nbClassPath2;
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (nbClassPath == this.getBootClassPath() || nbClassPath != null && nbClassPath.equals((Object)this.getBootClassPath())) {
                return;
            }
            nbClassPath2 = this.bootClassPath;
            this.bootClassPath = nbClassPath;
        }
        this.firePropertyChange(PROP_BOOTCLASSPATH, nbClassPath2, nbClassPath);
    }

    public static boolean isUpToDate(FileObject fileObject, FileSystem fileSystem) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject.isModified()) {
                return false;
            }
            FileObject fileObject2 = dataObject.getPrimaryFile();
            FileObject fileObject3 = fileObject2.getParent();
            if (fileSystem != null && (fileObject3 = fileSystem.find(fileObject3.getPackageName('.'), null, null)) == null) {
                return false;
            }
            FileObject fileObject4 = fileObject3.getFileObject(fileObject2.getName(), "class");
            if (fileObject4 != null) {
                fileObject4.refresh();
                if (fileObject4.getSize() > 0L && fileObject4.lastModified().compareTo(fileObject2.lastModified()) >= 0) {
                    return true;
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private void throwCloneException(Throwable throwable) throws CloneNotSupportedException {
        ErrorManager errorManager = TopManager.getDefault().getErrorManager();
        CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException();
        errorManager.copyAnnotation((Throwable)cloneNotSupportedException, throwable);
        throw cloneNotSupportedException;
    }

    public int flag() {
        return this.flag;
    }

    private void orFlag(int n) {
        int n2 = this.flag;
        this.flag |= n;
        this.firePropertyChange(PROP_FLAGS, new Integer(n2), new Integer(this.flag));
    }

    private void andFlag(int n) {
        int n2 = this.flag;
        this.flag &= n;
        this.firePropertyChange(PROP_FLAGS, new Integer(n2), new Integer(this.flag));
    }

    public void setWarnings(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.flag & 4) != 0;
        if (bl) {
            if (!bl2) {
                this.orFlag(4);
            }
        } else if (bl2) {
            this.andFlag(-5);
        }
        if (bl != bl2) {
            this.firePropertyChange(PROP_F_WARNINGS, new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean getWarnings() {
        return (this.flag & 4) != 0;
    }

    public void setDebug(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.flag & 0x43000) != 0;
        if (bl) {
            if (!bl2) {
                this.orFlag(274432);
            }
        } else if (bl2) {
            this.andFlag(-274433);
        }
        if (bl != bl2) {
            this.firePropertyChange(PROP_F_DEBUG, new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean getDebug() {
        return (this.flag & 0x43000) != 0;
    }

    public void setOptimize(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.flag & 0xC000) != 0;
        if (bl) {
            if (!bl2) {
                this.orFlag(49152);
            }
        } else if (bl2) {
            this.andFlag(-49153);
        }
        if (bl != bl2) {
            this.firePropertyChange(PROP_F_OPTIMIZE, new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean getOptimize() {
        return (this.flag & 0xC000) != 0;
    }

    public void setDeprecation(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.flag & 0x200) != 0;
        if (bl) {
            if (!bl2) {
                this.orFlag(512);
            }
        } else if (bl2) {
            this.andFlag(-513);
        }
        if (bl != bl2) {
            this.firePropertyChange(PROP_F_DEPRECATION, new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean getDeprecation() {
        return (this.flag & 0x200) != 0;
    }

    public void setDependencies(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.flag & 0x20) != 0;
        if (bl) {
            if (!bl2) {
                this.orFlag(32);
            }
        } else if (bl2) {
            this.andFlag(-33);
        }
        if (bl != bl2) {
            this.firePropertyChange("dependencies", new Boolean(bl2), new Boolean(bl));
        }
    }

    public boolean getDependencies() {
        return (this.flag & 0x20) != 0;
    }

    public void setCharEncoding(String string) {
        if (string != null) {
            if ((string = string.trim()).equals("")) {
                string = null;
            } else if (DEFAULT_ENCODING.equalsIgnoreCase(string)) {
                string = null;
            }
        }
        String string2 = this.charEncoding;
        this.charEncoding = string;
        this.firePropertyChange(PROP_CHAR_ENCODING, string2, this.charEncoding);
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setTargetFileSystem(FileSystem fileSystem) {
        FileSystem fileSystem2;
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            fileSystem2 = this.getTargetFileSystem();
            if (fileSystem == fileSystem2 || fileSystem != null && fileSystem2 != null && fileSystem.equals(fileSystem2)) {
                return;
            }
            this.targetFSName = fileSystem != null ? fileSystem.getSystemName() : null;
            this.targetFileSystem = fileSystem;
        }
        this.firePropertyChange(PROP_TARGET_FILESYSTEM, fileSystem2, fileSystem);
    }

    public void assureValidTargetFS() throws IOException {
        Object object;
        FileSystem fileSystem = this.getTargetFileSystem();
        if (fileSystem == null) {
            return;
        }
        String string = null;
        if (fileSystem == TARGET_INVALID) {
            string = "MSG_FS_Invalid";
        } else {
            object = TopManager.getDefault().getRepository().fileSystems();
            boolean bl = false;
            while (object.hasMoreElements()) {
                FileSystem fileSystem2 = (FileSystem)object.nextElement();
                if (fileSystem2 != fileSystem) continue;
                bl = true;
                break;
            }
            if (!bl) {
                string = "MSG_FS_NotMounted";
            }
        }
        if (string == null) {
            if (fileSystem.isReadOnly()) {
                string = "MSG_FS_ReadOnly";
            } else {
                return;
            }
        }
        object = MessageFormat.format(JavaCompilerType.getString(string), fileSystem.getDisplayName());
        throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException((String)object), 256, null, (String)object, null, null);
    }

    public FileSystem getTargetFileSystem() {
        if (this.targetFSName == null) {
            return null;
        }
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (this.targetFileSystem != null) {
                FileSystem fileSystem = this.targetFileSystem;
                return fileSystem;
            }
            FileSystem fileSystem = this.findFileSystem();
            this.targetFileSystem = fileSystem == null ? TARGET_INVALID : fileSystem;
            FileSystem fileSystem2 = this.targetFileSystem;
            return fileSystem2;
        }
    }

    private FileSystem findFileSystem() {
        Repository repository = (Repository)Lookup.getDefault().lookup(class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = JavaCompilerType.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository);
        Enumeration enumeration = repository.fileSystems();
        FileSystem fileSystem = null;
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem2 = (FileSystem)enumeration.nextElement();
            if (!fileSystem2.getSystemName().equals(this.targetFSName)) continue;
            fileSystem = fileSystem2;
            break;
        }
        if (!this.listenerRegistered) {
            this.repoL = new R();
            repository.addRepositoryListener(WeakListener.repository((RepositoryListener)this.repoL, (Object)repository));
            this.listenerRegistered = true;
        }
        return fileSystem;
    }

    public boolean isCrossCompile() {
        return this.targetFileSystem != null;
    }

    public void prepareJob(CompilerJob compilerJob, Class clazz, DataObject dataObject) {
        Compiler compiler;
        if (dataObject instanceof JavaDataObject) {
            JavaDataObject javaDataObject = (JavaDataObject)dataObject;
            if (clazz == CLEAN) {
                new CleanCompiler(compilerJob, javaDataObject, this.getTargetFileSystem());
                return;
            }
            FileObject fileObject = javaDataObject.getPrimaryFile();
            try {
                compiler = this.createCompiler(clazz, fileObject);
                if (clazz == BUILD) {
                    compiler.dependsOn((Compilable)new CleanCompiler(compilerJob, javaDataObject, this.getTargetFileSystem()));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                compiler = new BogusCompiler(fileObject, illegalArgumentException);
            }
        } else {
            String string = MessageFormat.format(Util.getString("MSG_InvalidCompiler"), this.getName(), dataObject.getPrimaryFile().toString());
            Throwable throwable = TopManager.getDefault().getErrorManager().annotate((Throwable)new IllegalArgumentException("Invalid compiler"), 256, null, string, null, null);
            compiler = new BogusCompiler(dataObject.getPrimaryFile(), throwable);
        }
        compilerJob.add(compiler);
    }

    public void prepareJobForFileObject(CompilerJob compilerJob, Class clazz, FileObject fileObject) {
        if (clazz == CLEAN) {
            throw new IllegalArgumentException();
        }
        Compiler compiler = this.createCompiler(clazz, fileObject);
        compilerJob.add(compiler);
    }

    public IndirectCompiler prepareIndirectCompiler(Class clazz, FileSystem fileSystem, String string) {
        return new IndirectCompiler(clazz, fileSystem, string);
    }

    public IndirectCompiler prepareIndirectCompiler(Class clazz, String string) {
        return new IndirectCompiler(clazz, null, string);
    }

    protected abstract Class getCompilerGroupClass();

    protected abstract Compiler createCompiler(Class var1, FileObject var2);

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$java$JavaCompilerType == null ? (class$org$netbeans$modules$java$JavaCompilerType = JavaCompilerType.class$("org.netbeans.modules.java.JavaCompilerType")) : class$org$netbeans$modules$java$JavaCompilerType));
        }
        return bundle.getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TARGET_INVALID = new LocalFileSystem();
    }

    public final class IndirectCompiler
    extends Compiler {
        private final FileSystem dir;
        private final String res;
        private final Class type;
        private FileObject resolvedResource;

        public IndirectCompiler(Class clazz, FileSystem fileSystem, String string) {
            this.dir = fileSystem;
            this.type = clazz;
            if (string != null && File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            this.res = string;
        }

        public boolean isUpToDate() {
            return false;
        }

        public Class compilerGroupClass() {
            return JavaCompilerType.this.getCompilerGroupClass();
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return this.res == null ? 4371234 : this.res.hashCode();
        }

        public Compiler getCompiler() {
            FileObject fileObject = this.getResolved();
            if (fileObject == null) {
                return null;
            }
            return JavaCompilerType.this.createCompiler(this.type, fileObject);
        }

        public FileObject getResolved() {
            if (this.resolvedResource == null && this.res != null) {
                this.resolvedResource = this.dir == null ? FileSystemCapability.COMPILE.findResource(this.res) : this.dir.findResource(this.res);
            }
            return this.resolvedResource;
        }

        public void setResolved(FileObject fileObject) {
            this.resolvedResource = fileObject;
        }
    }

    private class R
    extends RepositoryAdapter {
        private R() {
        }

        public void fileSystemAdded(RepositoryEvent repositoryEvent) {
            String string = JavaCompilerType.this.targetFSName;
            if (string == null || JavaCompilerType.this.targetFileSystem != TARGET_INVALID) {
                return;
            }
            FileSystem fileSystem = repositoryEvent.getFileSystem();
            if (fileSystem.getSystemName().equals(string)) {
                JavaCompilerType.this.setTargetFileSystem(fileSystem);
            }
        }

        public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
            if (repositoryEvent.getFileSystem() != JavaCompilerType.this.targetFileSystem) {
                return;
            }
            JavaCompilerType.this.setTargetFileSystem(TARGET_INVALID);
        }
    }
}

