/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.java.FastJavacCompilerType;
import org.netbeans.modules.java.JExternalCompiler;
import org.netbeans.modules.java.JavaCompilerType;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaExternalCompilerType;
import org.netbeans.modules.java.Util;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.ErrorEvent;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;

public class JExternalCompilerGroup
extends ExternalCompilerGroup {
    private final HashSet indirectCompilers = new HashSet(7);
    private final HashSet directCompilers = new HashSet(7);
    private JavaExternalCompilerType jext;
    private Set refreshPackages;
    private FileSystem targetFS;
    private String encoding;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaDataObject;

    public void add(Compiler compiler) {
        if (compiler instanceof JavaCompilerType.IndirectCompiler) {
            this.indirectCompilers.add(compiler);
        } else {
            this.checkAndAdd((JExternalCompiler)compiler);
        }
    }

    private void checkAndAdd(JExternalCompiler jExternalCompiler) {
        if (jExternalCompiler.isUpToDate()) {
            return;
        }
        if (this.directCompilers.add(jExternalCompiler)) {
            if (this.jext == null) {
                this.initializeOptions((Compiler)jExternalCompiler);
            }
            if (this.refreshPackages != null) {
                FileObject fileObject = jExternalCompiler.getFileObject0();
                FileObject fileObject2 = fileObject.getParent();
                this.addPackage(fileObject2);
            }
            super.add((Compiler)jExternalCompiler);
        }
    }

    private void addPackage(FileObject fileObject) {
        if (!this.jext.isCrossCompile()) {
            return;
        }
        this.refreshPackages.add(fileObject.getPackageName('.'));
    }

    public boolean start() {
        Object object;
        int n;
        JavaCompilerType.IndirectCompiler[] indirectCompilerArray;
        if (this.indirectCompilers.size() > 0) {
            indirectCompilerArray = new JavaCompilerType.IndirectCompiler[this.indirectCompilers.size()];
            indirectCompilerArray = ((AbstractCollection)this.indirectCompilers).toArray(indirectCompilerArray);
            n = 0;
            while (n < indirectCompilerArray.length) {
                object = indirectCompilerArray[n].getCompiler();
                if (object != null) {
                    this.checkAndAdd((JExternalCompiler)((Object)object));
                }
                ++n;
            }
        }
        try {
            if (this.jext == null) {
                return true;
            }
            this.jext.assureValidTargetFS();
        }
        catch (IOException iOException) {
            String string = MessageFormat.format(JavaCompilerType.getString("MSG_CompilerFatal"), iOException.getLocalizedMessage());
            this.fireErrorEvent(new ErrorEvent((CompilerGroup)this, null, 0, 0, string, null));
            return false;
        }
        indirectCompilerArray = this.getAllCompilers();
        n = 0;
        while (n < indirectCompilerArray.length) {
            object = (JExternalCompiler)((Object)indirectCompilerArray[n]);
            try {
                DataObject dataObject = DataObject.find((FileObject)((JExternalCompiler)((Object)object)).getFileObject0());
                JavaDataObject javaDataObject = (JavaDataObject)dataObject.getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? JExternalCompilerGroup.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject);
                if (javaDataObject != null) {
                    javaDataObject.clearProducts(this.targetFS);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
        boolean bl = super.start();
        if (this.refreshPackages != null) {
            this.refreshTargets();
        }
        this.refreshDistant();
        return bl;
    }

    void initializeOptions(Compiler compiler) {
        this.jext = ((JExternalCompiler)compiler).getMyType();
        this.encoding = ((JExternalCompiler)compiler).myEncoding;
        if (this.jext.isCrossCompile()) {
            this.targetFS = this.jext.getTargetFileSystem();
            this.refreshPackages = new HashSet(17);
        }
    }

    void refreshDistant() {
        ExternalCompiler[] externalCompilerArray = this.getAllCompilers();
        int n = 0;
        while (n < externalCompilerArray.length) {
            JExternalCompiler jExternalCompiler = (JExternalCompiler)externalCompilerArray[n];
            JavaDataObject javaDataObject = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)jExternalCompiler.getFileObject0());
                javaDataObject = (JavaDataObject)dataObject.getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? JExternalCompilerGroup.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject);
                if (javaDataObject != null && this.targetFS != null) {
                    javaDataObject.refreshDistantChildren(this.targetFS);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
    }

    void refreshTargets() {
        Iterator iterator = this.refreshPackages.iterator();
        FileObject fileObject = this.targetFS.getRoot();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            FileObject fileObject2 = fileObject;
            while (fileObject2 != null && stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                FileObject fileObject3 = fileObject2.getFileObject(string2);
                if (fileObject3 == null) {
                    fileObject2.refresh();
                    if (stringTokenizer.hasMoreTokens()) {
                        fileObject3 = fileObject2.getFileObject(string2);
                    }
                }
                fileObject2 = fileObject3;
            }
            if (fileObject2 == null) continue;
            this.refreshPackage(fileObject2);
        }
    }

    private void refreshPackage(FileObject fileObject) {
        fileObject.refresh();
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            FileObject fileObject2 = fileObjectArray[n];
            if ("class".equals(fileObject2.getExt())) {
                fileObject2.refresh();
            }
            ++n;
        }
    }

    protected Process createProcess(NbProcessDescriptor nbProcessDescriptor, String[] stringArray) throws IOException {
        return nbProcessDescriptor.exec((Format)((Object)new JFormat(stringArray, this.jext, nbProcessDescriptor, this.encoding)), this.jext.getEnvironmentVariables(), this.jext.getWorkingDirectory());
    }

    static String getMsgFile(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("lib");
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("fastjavac.messages");
        String string2 = stringBuffer.toString();
        if (string2.indexOf(32) >= 0) {
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class JFormat
    extends ExternalCompilerGroup.Format {
        public static final String TAG_OPTIMIZE = "optimize";
        public static final String TAG_DEBUGINFO = "debuginfo";
        public static final String TAG_DEPRECATION = "deprecation";
        public static final String TAG_ENCODING = "encoding";
        public static final String TAG_OUTDIR = "outputdir";
        public static final String TAG_IDEHOME = "ide.home";
        public static final String TAG_NBHOME = "netbeans.home";
        public static final String TAG_FORTEHOME = "forte.home";
        public static final String TAG_MSGFILE = Util.getString("TAG_Msgfile");
        public static final String TAG_FASTJAVAC_BINARY_FULL = "fastjavacBinary";
        public static final String TAG_FASTJAVAC_BINARY = "fastjavac.wired";
        public static final String TAG_OPTION_BOOTCLASSPATH = "bootclasspath.opt";
        public static final String TAG_QUOTE = "q";
        public static final String TAG_SYSTEMBOOTCLASSPATH = "sun.boot.class.path";
        public static final String TAG_SOURCE = "source.opt";
        static final long serialVersionUID = -8630048324703405233L;
        private NbProcessDescriptor descriptor;

        public JFormat(String[] stringArray, JavaExternalCompilerType javaExternalCompilerType, NbProcessDescriptor nbProcessDescriptor, String string) throws IOException {
            super(stringArray, javaExternalCompilerType.getClassPath(), javaExternalCompilerType.getBootClassPath(), javaExternalCompilerType.getRepositoryPath(), javaExternalCompilerType.getLibraryPath());
            this.descriptor = nbProcessDescriptor;
            Map map = this.getMap();
            map.put(TAG_OPTIMIZE, javaExternalCompilerType.getOptimize() ? javaExternalCompilerType.getOptimizeReplace() : "");
            map.put(TAG_DEBUGINFO, javaExternalCompilerType.getDebug() ? javaExternalCompilerType.getDebuginfoReplace() : "");
            map.put(TAG_DEPRECATION, javaExternalCompilerType.getDeprecation() ? javaExternalCompilerType.getDeprecationReplace() : "");
            map.put(TAG_OUTDIR, JFormat.createOutputReplace(javaExternalCompilerType));
            map.put(TAG_ENCODING, this.createEncodingReplace(javaExternalCompilerType, string));
            map.put(TAG_QUOTE, "\"");
            String string2 = System.getProperty(TAG_NBHOME);
            String string3 = FastJavacCompilerType.getWiredName();
            String string4 = FastJavacCompilerType.getWiredFullName();
            string2 = new File(string2).getCanonicalPath();
            map.put(TAG_FORTEHOME, string2);
            map.put(TAG_NBHOME, string2);
            map.put(TAG_IDEHOME, string2);
            map.put(TAG_MSGFILE, JExternalCompilerGroup.getMsgFile(string2));
            map.put(TAG_FASTJAVAC_BINARY_FULL, string4);
            map.put(TAG_FASTJAVAC_BINARY, string3);
            map.put(TAG_OPTION_BOOTCLASSPATH, this.createBootClassPathReplace(javaExternalCompilerType));
            map.put(TAG_SYSTEMBOOTCLASSPATH, JFormat.createSystemBootClassPath());
            map.put(TAG_SOURCE, this.createSourceReplace(javaExternalCompilerType));
        }

        public JFormat(String[] stringArray, JavaExternalCompilerType javaExternalCompilerType, NbProcessDescriptor nbProcessDescriptor) throws IOException {
            this(stringArray, javaExternalCompilerType, nbProcessDescriptor, javaExternalCompilerType.getCharEncoding());
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            StringBuffer stringBuffer2 = super.format(object, stringBuffer, fieldPosition);
            String string = stringBuffer2.toString();
            int n = string.indexOf("-classpath");
            if (n < 0) {
                return stringBuffer2;
            }
            if ((n += 11) >= string.length()) {
                return stringBuffer2;
            }
            int n2 = JFormat.getClassPathEntriesEnd(n, string);
            if (n2 <= n) {
                return stringBuffer2;
            }
            String string2 = stringBuffer2.substring(n, n2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            StringBuffer stringBuffer3 = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (hashMap.put(string3, string3) != null) continue;
                stringBuffer3.append(string3);
                stringBuffer3.append(File.pathSeparator);
            }
            hashMap = null;
            stringBuffer3.insert(0, string.substring(0, n));
            stringBuffer3.append(string.substring(n2));
            return stringBuffer3;
        }

        private String createSourceReplace(JavaExternalCompilerType javaExternalCompilerType) {
            if (!javaExternalCompilerType.getSource14Enable()) {
                return "";
            }
            return "-source 1.4 ";
        }

        protected String createBootClassPathReplace(JavaExternalCompilerType javaExternalCompilerType) {
            NbClassPath nbClassPath = javaExternalCompilerType.getBootClassPath();
            if (nbClassPath == null) {
                return "";
            }
            String string = nbClassPath.getClassPath();
            if (!"".equals(string)) {
                return javaExternalCompilerType.getBootClassPathReplace();
            }
            return "";
        }

        private static int getClassPathEntriesEnd(int n, String string) {
            boolean bl = false;
            boolean bl2 = false;
            int n2 = string.length();
            int n3 = n;
            while (n3 < n2) {
                switch (string.charAt(n3)) {
                    case ' ': {
                        if (bl2) break;
                        return n3;
                    }
                    case '\\': {
                        bl = !bl;
                        break;
                    }
                    case '\"': {
                        if (!bl) {
                            bl2 = !bl2;
                        }
                    }
                    default: {
                        bl = false;
                    }
                }
                ++n3;
            }
            return -1;
        }

        String createEncodingReplace(JavaExternalCompilerType javaExternalCompilerType, String string) {
            if (string == null || "".equals(string)) {
                return "";
            }
            return javaExternalCompilerType.getEncodingReplace() + " " + string;
        }

        static String createOutputReplace(JavaExternalCompilerType javaExternalCompilerType) {
            boolean bl;
            if (!javaExternalCompilerType.isCrossCompile()) {
                return "";
            }
            FileSystem fileSystem = javaExternalCompilerType.getTargetFileSystem();
            if (fileSystem == JavaCompilerType.TARGET_INVALID) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(fileSystem.getSystemName().length() + 4);
            File file = NbClassPath.toFile((FileObject)fileSystem.getRoot());
            stringBuffer.append(javaExternalCompilerType.getDReplace());
            String string = file.toString();
            boolean bl2 = bl = string.indexOf(32) > -1;
            if (bl) {
                stringBuffer.append(" \"");
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append('\"');
            }
            return stringBuffer.toString();
        }

        static String createSystemBootClassPath() {
            String string = System.getProperty(TAG_SYSTEMBOOTCLASSPATH);
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            boolean bl2 = true;
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if (!file.exists()) continue;
                if (string2.indexOf(32) > -1) {
                    bl = true;
                }
                if (!bl2) {
                    stringBuffer.append(File.pathSeparatorChar);
                }
                stringBuffer.append(string2);
                bl2 = false;
            }
            if (stringBuffer.length() == 0) {
                return "\"\"";
            }
            if (bl) {
                stringBuffer.insert(0, '\"');
                stringBuffer.append('\"');
            }
            return stringBuffer.toString();
        }
    }
}

